/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Set;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryFunctionType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryUnknown;

public class BinaryFieldImpl
implements BinaryObject {
    static /* synthetic */ Class class$visad$FieldImpl;

    public static final int computeBytes(FieldImpl fld) {
        try {
            return BinaryFieldImpl.processDependentData(null, null, fld.getDomainSet(), fld, BinaryObject.SAVE_DEPEND);
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public static final int processDependentData(BinaryWriter writer, FunctionType ft, Set set, FieldImpl fld, Object token) throws IOException {
        int numSamples;
        if (!(fld.getClass().equals(class$visad$FieldImpl == null ? (class$visad$FieldImpl = BinaryFieldImpl.class$("visad.FieldImpl")) : class$visad$FieldImpl) || fld instanceof FieldImpl && fld instanceof Saveable)) {
            return 0;
        }
        Object dependToken = token == BinaryObject.SAVE_DEPEND_BIG ? token : BinaryObject.SAVE_DEPEND;
        int numBytes = 5;
        if (writer != null) {
            BinaryFunctionType.write(writer, ft, BinaryObject.SAVE_DATA);
        }
        numBytes += 5;
        if (set != null) {
            int setBytes;
            if (writer != null) {
                BinaryGeneric.write(writer, set, dependToken);
            }
            if ((setBytes = BinaryGeneric.computeBytes(set)) > 0) {
                numBytes += 1 + setBytes;
            }
        }
        int n = numSamples = fld.isMissing() ? 0 : fld.getLength();
        if (numSamples > 0) {
            ++numBytes;
            boolean metadataOnly = token == BinaryObject.SAVE_DEPEND_BIG;
            int i = 0;
            while (i < numSamples) {
                block10: {
                    DataImpl sample;
                    try {
                        sample = (DataImpl)fld.getSample(i, metadataOnly);
                    }
                    catch (VisADException ve) {
                        break block10;
                    }
                    if (writer != null) {
                        BinaryGeneric.write(writer, sample, dependToken);
                    }
                    numBytes += BinaryGeneric.computeBytes(sample);
                }
                ++i;
            }
        }
        return numBytes;
    }

    public static final FieldImpl read(BinaryReader reader) throws IOException, VisADException {
        FieldImpl fld;
        int i;
        BinaryObjectCache cache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int typeIndex = file.readInt();
        FunctionType ft = (FunctionType)cache.get(typeIndex);
        Set set = null;
        Data[] samples = null;
        boolean reading = true;
        block7: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 12: {
                    set = (Set)BinaryGeneric.read(reader);
                    break;
                }
                case 8: {
                    int numSamples = file.readInt();
                    if (numSamples <= 0) {
                        throw new IOException("Corrupted file (bad Field sample length " + numSamples + ")");
                    }
                    samples = new Data[numSamples];
                    i = 0;
                    while (i < numSamples) {
                        samples[i] = BinaryGeneric.read(reader);
                        ++i;
                    }
                    continue block7;
                }
                case 80: {
                    reading = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown FieldImpl directive " + directive);
                }
            }
        }
        if (ft == null) {
            throw new IOException("No FunctionType found for FieldImpl");
        }
        FieldImpl fieldImpl = fld = set == null ? new FieldImpl(ft) : new FieldImpl(ft, set);
        if (samples != null) {
            int len = samples.length;
            i = 0;
            while (i < len) {
                fld.setSample(i, samples[i]);
                ++i;
            }
        }
        return fld;
    }

    public static final int writeDependentData(BinaryWriter writer, FunctionType ft, Set set, FieldImpl fld, Object token) throws IOException {
        return BinaryFieldImpl.processDependentData(writer, ft, set, fld, token);
    }

    public static final void write(BinaryWriter writer, FunctionType ft, Set set, FieldImpl fld, Object token) throws IOException {
        int numSamples;
        int objLen = BinaryFieldImpl.writeDependentData(writer, ft, set, fld, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(fld.getClass().equals(class$visad$FieldImpl == null ? (class$visad$FieldImpl = BinaryFieldImpl.class$("visad.FieldImpl")) : class$visad$FieldImpl) || fld instanceof FieldImpl && fld instanceof Saveable)) {
            BinaryUnknown.write(writer, fld, token);
            return;
        }
        int typeIndex = writer.getTypeCache().getIndex(ft);
        if (typeIndex < 0) {
            throw new IOException("FunctionType " + ft + " not cached");
        }
        DataOutput file = writer.getOutput();
        file.writeByte(2);
        file.writeInt(objLen);
        file.writeByte(20);
        file.writeInt(typeIndex);
        if (set != null) {
            file.writeByte(12);
            BinaryGeneric.write(writer, set, token);
        }
        int n = numSamples = fld.isMissing() ? 0 : fld.getLength();
        if (numSamples > 0) {
            file.writeByte(8);
            file.writeInt(numSamples);
            int i = 0;
            while (i < numSamples) {
                block8: {
                    DataImpl sample;
                    try {
                        sample = (DataImpl)fld.getSample(i);
                    }
                    catch (VisADException ve) {
                        writer.getOutput().writeByte(60);
                        break block8;
                    }
                    BinaryGeneric.write(writer, sample, token);
                }
                ++i;
            }
        }
        file.writeByte(80);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

