/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryDoubleMatrix
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    public static final int computeBytes(double[][] matrix) {
        if (matrix == null) {
            return 4;
        }
        int len = 4;
        int i = 0;
        while (i < matrix.length) {
            len += 4 + matrix[i].length * 8;
            ++i;
        }
        return len;
    }

    public static final double[][] read(BinaryReader reader) throws IOException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 0) {
            return null;
        }
        double[][] matrix = new double[len][];
        int i = 0;
        while (i < len) {
            int len2 = file.readInt();
            matrix[i] = new double[len2];
            int j = 0;
            while (j < len2) {
                matrix[i][j] = file.readDouble();
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static final void write(BinaryWriter writer, double[][] matrix, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        if (matrix == null) {
            file.writeInt(-1);
        } else {
            byte[] buf = new byte[BinaryDoubleMatrix.computeBytes(matrix)];
            int bufIdx = 0;
            int b = 3;
            int l = matrix.length;
            while (b >= 0) {
                buf[bufIdx + b] = (byte)(l & 0xFF);
                l >>= 8;
                --b;
            }
            bufIdx += 4;
            int i = 0;
            while (i < matrix.length) {
                int len = matrix[i].length;
                int b2 = 3;
                int l2 = len;
                while (b2 >= 0) {
                    buf[bufIdx + b2] = (byte)(l2 & 0xFF);
                    l2 >>= 8;
                    --b2;
                }
                bufIdx += 4;
                int j = 0;
                while (j < len) {
                    long x = Double.doubleToLongBits(matrix[i][j]);
                    int b3 = 7;
                    while (b3 >= 0) {
                        buf[bufIdx + b3] = (byte)(x & 0xFFL);
                        x >>= 8;
                        --b3;
                    }
                    bufIdx += 8;
                    ++j;
                }
                ++i;
            }
            if (bufIdx < buf.length) {
                System.err.println("BinaryDoubleMatrix: Missing " + (buf.length - bufIdx) + " bytes");
            }
            file.write(buf);
        }
    }
}

