/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;

public class BinaryDataArray
implements BinaryObject {
    public static final int computeBytes(Data[] array) {
        int len = 4;
        int i = 0;
        while (i < array.length) {
            len += BinaryGeneric.computeBytes((DataImpl)array[i]);
            ++i;
        }
        return len;
    }

    public static final Data[] read(BinaryReader reader) throws IOException, VisADException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad Data array length " + len + ")");
        }
        long t = 0L;
        Data[] array = new Data[len];
        int i = 0;
        while (i < len) {
            array[i] = BinaryGeneric.read(reader);
            ++i;
        }
        return array;
    }

    private static final void writeDependentData(BinaryWriter writer, Data[] array, Object token) throws IOException {
        if (token != BinaryObject.SAVE_DEPEND_BIG) {
            token = BinaryObject.SAVE_DEPEND;
        }
        if (array != null) {
            int i = 0;
            while (i < array.length) {
                BinaryGeneric.write(writer, (DataImpl)array[i], token);
                ++i;
            }
        }
    }

    public static final void write(BinaryWriter writer, Data[] array, Object token) throws IOException {
        BinaryDataArray.writeDependentData(writer, array, token);
        if (token == BinaryObject.SAVE_DEPEND || token == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        DataOutput file = writer.getOutput();
        file.writeInt(array.length);
        int i = 0;
        while (i < array.length) {
            BinaryGeneric.write(writer, (DataImpl)array[i], token);
            ++i;
        }
    }
}

