/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.DerivedUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;
import visad.data.units.DefaultUnitsDB;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.SimpleCharStream;
import visad.data.units.Token;
import visad.data.units.UnitParserConstants;
import visad.data.units.UnitParserTokenManager;
import visad.data.units.UnitsDB;

public class UnitParser
implements UnitParserConstants {
    protected static UnitsDB unitsDB = null;
    protected static final Unit second;
    protected boolean isTime;
    protected static final long julianDayOrigin;
    public UnitParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[24];
    private final int[] jj_la1_0 = new int[]{2048, 41959568, 58741136, 0x1800100, 58741136, 0x1800100, 0x2004000, 0x8000000, 0x8000010, 41959568, 16, 0x800000, 0x800090, 41943184, 41943184, 8392848, 8392848, 0x2040000, 256, 0x400010, 256, 0x404010, 0x404110, 0x400110};
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static long julianDay(int year, int month, int day) {
        int jm;
        int jy;
        long igreg = 588829L;
        if (year == 0) {
            year = 1;
        }
        int iy = year;
        if (year < 0) {
            ++iy;
        }
        if (month > 2) {
            jy = iy;
            jm = month + 1;
        } else {
            jy = iy - 1;
            jm = month + 13;
        }
        long julday = day + (int)(30.6001 * (double)jm);
        if (jy >= 0) {
            julday += (long)(365 * jy);
            julday = (long)((double)julday + 0.25 * (double)jy);
        } else {
            double xi = 365.25 * (double)jy;
            if ((double)((int)xi) != xi) {
                xi -= 1.0;
            }
            julday += (long)((int)xi);
        }
        julday += 1720995L;
        if ((long)(day + 31 * (month + 12 * iy)) >= igreg) {
            int ja = jy / 100;
            julday -= (long)ja;
            julday += 2L;
            julday += (long)(ja / 4);
        }
        return julday;
    }

    public static double encodeTimestamp(int year, int month, int day, int hour, int minute, float second, int zone) {
        return (double)(UnitParser.julianDay(year, month, day) - julianDayOrigin) * 86400.0 + (double)((hour * 60 + minute - zone) * 60) + (double)second;
    }

    public static void main(String[] args) throws Exception {
        UnitParser parser = new UnitParser(System.in);
        LineNumberReader lineInput = new LineNumberReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("Enter a unit specification or ^D to quit: ");
            String spec = lineInput.readLine();
            if (spec == null) break;
            if ((spec = spec.trim()).length() <= 0) continue;
            parser.ReInit(new ByteArrayInputStream(spec.getBytes()));
            try {
                Unit unit = parser.unitSpec();
                System.out.println("unit = " + unit);
                System.out.println("definition = " + unit.getDefinition());
            }
            catch (ParseException e) {
                System.out.println(e.getMessage());
            }
        }
        System.out.println("");
    }

    public final Unit unitSpec() throws ParseException {
        Unit unit = null;
        double origin = 0.0;
        boolean originSpecified = false;
        this.isTime = false;
        block1 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 7: 
            case 14: 
            case 23: 
            case 25: {
                unit = this.unitProductList();
                this.isTime = Unit.canConvert(unit, second);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        origin = this.shiftExpression();
                        originSpecified = true;
                        break block1;
                    }
                }
                this.jj_la1[0] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
        try {
            if (unit == null) {
                unit = new DerivedUnit();
            }
            if (originSpecified && this.isTime) {
                unit = unit.shift(unit.toThis(origin, second));
            } else if (origin != 0.0) {
                unit = unit.shift(origin);
            }
            return unit;
        }
        catch (UnitException e) {
            throw new ParseException("Invalid unit specification: " + e.getMessage());
        }
    }

    public final Unit unitProductList() throws ParseException {
        Unit unit1;
        block15: {
            unit1 = this.powerExpression();
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 14: 
                    case 23: 
                    case 24: 
                    case 25: {
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        break block15;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 7: 
                    case 8: 
                    case 14: 
                    case 23: 
                    case 24: 
                    case 25: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: 
                            case 23: 
                            case 24: {
                                this.multiply();
                                break;
                            }
                            default: {
                                this.jj_la1[3] = this.jj_gen;
                            }
                        }
                        Unit unit2 = this.powerExpression();
                        try {
                            unit1 = unit1.multiply(unit2);
                            continue block14;
                        }
                        catch (UnitException e) {
                            throw new ParseException("Couldn't multiply units");
                        }
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        Unit unit2 = this.powerExpression();
                        try {
                            unit1 = unit1.divide(unit2);
                        }
                        catch (UnitException e) {
                            throw new ParseException("Couldn't divide units");
                        }
                    }
                    continue block14;
                }
                break;
            }
            this.jj_la1[4] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return unit1;
    }

    public final void multiply() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Unit powerExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 7: 
            case 23: {
                double value = this.numberExpression();
                return new ScaledUnit(value);
            }
            case 14: 
            case 25: {
                Unit unit;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        unit = this.nameExpression();
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        unit = this.unitProductList();
                        this.jj_consume_token(26);
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 27: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 27: {
                                this.jj_consume_token(27);
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                            }
                        }
                        Token t = this.jj_consume_token(4);
                        try {
                            return unit.pow(Integer.parseInt(t.image));
                        }
                        catch (UnitException e) {
                            throw new ParseException("Couldn't raise unit to a power");
                        }
                    }
                }
                this.jj_la1[8] = this.jj_gen;
                return unit;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Unit nameExpression() throws ParseException {
        Token t = this.jj_consume_token(14);
        Unit unit = unitsDB.get(t.image);
        if (unit == null) {
            throw new NoSuchUnitException("Unit not in database");
        }
        return unit;
    }

    public final double numberExpression() throws ParseException {
        double value;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                Token t = this.jj_consume_token(4);
                value = Integer.parseInt(t.image);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        this.jj_consume_token(23);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 4: {
                                t = this.jj_consume_token(4);
                                value += new Double("." + t.image).doubleValue();
                                if (!(value < 0.0)) break block0;
                                throw new ParseException("negative sign follows decimal point");
                            }
                            default: {
                                this.jj_la1[10] = this.jj_gen;
                                break;
                            }
                        }
                        break block0;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                Token t = this.jj_consume_token(4);
                value = new Double("." + t.image);
                if (!(value < 0.0)) break;
                throw new ParseException("negative sign follows decimal point");
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                value = new Double(t.image);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final double shiftExpression() throws ParseException {
        this.jj_consume_token(11);
        if (this.jj_2_1(3)) {
            double origin = this.timestampExpression();
            if (!this.isTime) {
                throw new ParseException("non-time unit with timestamp");
            }
            return origin;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 7: 
            case 23: 
            case 25: {
                double origin = this.valueExpression();
                return origin;
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double valueExpression() throws ParseException {
        double value;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 7: 
            case 23: {
                value = this.numericalTerm();
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                value = this.valueExpression();
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final double numericalTerm() throws ParseException {
        double value1;
        block8: {
            value1 = this.numberExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 7: 
                    case 12: 
                    case 23: {
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 7: 
                    case 23: {
                        double value2 = this.numberExpression();
                        value1 *= value2;
                        continue block7;
                    }
                    case 12: {
                        this.jj_consume_token(12);
                        double value2 = this.numberExpression();
                        value1 /= value2;
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[16] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return value1;
    }

    public final double timestampExpression() throws ParseException {
        double value;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                value = this.timestampTerm();
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                value = this.timestampExpression();
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final double timestampTerm() throws ParseException {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int zone = 0;
        float second = 0.0f;
        double when = 0.0;
        Token t = this.jj_consume_token(18);
        StringTokenizer dateSpec = new StringTokenizer(t.image, "-");
        year = Integer.parseInt(dateSpec.nextToken());
        month = Integer.parseInt(dateSpec.nextToken());
        day = Integer.parseInt(dateSpec.nextToken());
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: 
            case 8: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: {
                        t = this.jj_consume_token(4);
                        hour = Integer.parseInt(t.image);
                        break;
                    }
                    case 22: {
                        t = this.jj_consume_token(22);
                        StringTokenizer timeSpec = new StringTokenizer(t.image, ":");
                        hour = Integer.parseInt(timeSpec.nextToken());
                        minute = Integer.parseInt(timeSpec.nextToken());
                        if (!timeSpec.hasMoreTokens()) break;
                        second = new Float(timeSpec.nextToken()).floatValue();
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 4: 
                    case 8: 
                    case 14: 
                    case 22: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 8: {
                                this.jj_consume_token(8);
                                break;
                            }
                            default: {
                                this.jj_la1[20] = this.jj_gen;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 4: {
                                t = this.jj_consume_token(4);
                                int zoneMinute = 0;
                                int zoneHour = Integer.parseInt(t.image);
                                if (zoneHour <= -100 || zoneHour >= 100) {
                                    zoneMinute = zoneHour % 100;
                                    zoneHour /= 100;
                                }
                                zone = zoneHour * 60 + zoneMinute;
                                break block10;
                            }
                            case 22: {
                                t = this.jj_consume_token(22);
                                StringTokenizer zoneSpec = new StringTokenizer(t.image, ":");
                                int sign = t.image.startsWith("-") ? -1 : 1;
                                int zoneHour = (int)Float.parseFloat(zoneSpec.nextToken());
                                int zoneMinute = Integer.parseInt(zoneSpec.nextToken());
                                zone = zoneHour * 60 + zoneMinute * sign;
                                break block10;
                            }
                            case 14: {
                                t = this.jj_consume_token(14);
                                if (t.image.equals("UTC") || t.image.equals("GMT")) break block0;
                                throw new ParseException("invalid time zone");
                            }
                            default: {
                                this.jj_la1[21] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break;
                    }
                }
                break;
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
            }
        }
        if (month < 1 || month > 12 || day < 1 || day > 31 || hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0.0f || second > 61.0f || zone < -1440 || zone > 1440) {
            throw new ParseException("invalid timestamp");
        }
        return UnitParser.encodeTimestamp(year, month, day, hour, minute, second, zone);
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_3R_14() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_8() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_12()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_14()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_15()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_8()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_9()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_10()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_11()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_3()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_5() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_3()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_15() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_4() {
        if (this.jj_3R_6()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_10() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_13() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_6() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_7()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_9() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_5()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public UnitParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new UnitParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 24) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 24) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public UnitParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new UnitParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 24) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 24) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public UnitParser(UnitParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 24) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(UnitParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 24) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[28];
        int i = 0;
        while (i < 28) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 24) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 28) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, UnitParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        try {
            unitsDB = DefaultUnitsDB.instance();
        }
        catch (UnitException e) {
            // empty catch block
        }
        second = SI.second;
        julianDayOrigin = UnitParser.julianDay(2001, 1, 1);
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

