/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import ucar.netcdf.Variable;
import visad.Real;
import visad.RealType;
import visad.Scalar;
import visad.SimpleSet;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.Vetter;
import visad.data.netcdf.in.VirtualScalar;

public class VirtualReal
extends VirtualScalar {
    private SimpleSet rangeSet;
    private final Unit unit;
    private final Vetter vetter;
    private final int[] lengths;

    public VirtualReal(RealType type, Variable var, SimpleSet rangeSet, Unit unit, Vetter vetter) {
        super(type, var);
        this.rangeSet = rangeSet;
        this.unit = unit;
        this.vetter = vetter;
        this.lengths = var.getLengths();
    }

    public SimpleSet getRangeSet() {
        return this.rangeSet;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Vetter getVetter() {
        return this.vetter;
    }

    protected Scalar getScalar(Context context) throws VisADException, InvalidContextException, IOException {
        double[] values = this.getDoubles(context);
        if (values.length != 1) {
            throw new InvalidContextException(context);
        }
        return new Real((RealType)this.getScalarType(), values[0], this.getUnit());
    }

    public double[] getDoubles(Context context) throws IOException, VisADException {
        int rank = this.lengths.length;
        int[] ioOrigin = new int[rank];
        int[] ioShape = new int[rank];
        int[] ioContext = context.getContext();
        System.arraycopy(ioContext, 0, ioOrigin, 0, ioContext.length);
        int i = 0;
        while (i < ioContext.length) {
            ioShape[i] = 1;
            ++i;
        }
        int total = 1;
        int i2 = ioContext.length;
        while (i2 < rank) {
            ioOrigin[i2] = 0;
            ioShape[i2] = this.lengths[i2];
            total *= this.lengths[i2];
            ++i2;
        }
        double[] values = new double[total];
        VirtualScalar.toArray(this.getVariable(), values, ioOrigin, ioShape);
        this.vetter.vet(values);
        return values;
    }

    public boolean isReal() {
        return true;
    }

    public Object clone() {
        return new VirtualReal((RealType)this.getScalarType(), this.getVariable(), this.rangeSet, this.unit, this.vetter);
    }
}

