/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.Netcdf;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.CoordinateSystem;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FloatSet;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.RealType;
import visad.SI;
import visad.ScalarType;
import visad.SimpleSet;
import visad.TextType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.in.ArithProg;
import visad.data.in.LonArithProg;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.in.CfView;
import visad.data.netcdf.in.DefaultView;
import visad.data.netcdf.in.Vetter;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualReal;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualText;
import visad.data.netcdf.in.VirtualTuple;
import visad.data.units.Parser;

public abstract class View {
    private final Netcdf netcdf;
    private final QuantityDB quantityDB;
    private final boolean charToText;
    private final Map varToRealType;
    private final Map varToTextType;
    private final Map varToUnit;
    private final Map dimToSet;
    private final Map dimToRealType;
    private final Quantity longitude;
    private final Quantity latitude;
    private static int nameCount;
    private Set factorNameSet = null;

    protected View(Netcdf netcdf, QuantityDB quantityDB) {
        this(netcdf, quantityDB, false);
    }

    protected View(Netcdf netcdf, QuantityDB quantityDB, boolean charToText) {
        this.netcdf = netcdf;
        this.quantityDB = quantityDB;
        this.charToText = charToText;
        this.varToUnit = new WeakHashMap();
        this.dimToSet = new WeakHashMap();
        this.varToRealType = new WeakHashMap();
        this.varToTextType = new WeakHashMap();
        this.dimToRealType = new WeakHashMap();
        this.longitude = quantityDB.get("longitude");
        this.latitude = quantityDB.get("latitude");
    }

    public static View getInstance(Netcdf netcdf, QuantityDB db) {
        return View.getInstance(netcdf, db, false);
    }

    public static View getInstance(Netcdf netcdf, QuantityDB db, boolean charToText) {
        View view;
        block7: {
            String conventions = View.getConventionsString(netcdf);
            if (conventions == null) {
                view = new DefaultView(netcdf, db, charToText);
            } else {
                try {
                    if (conventions.equals("CF-1.0")) {
                        view = new CfView(netcdf, db, charToText);
                        break block7;
                    }
                    if (conventions.equals("COARDS")) {
                        view = new CfView(netcdf, db);
                        break block7;
                    }
                    if (conventions.equals("COARDS/CF-1.0")) {
                        view = new CfView(netcdf, db, charToText);
                        break block7;
                    }
                    System.err.println("Unknown netCDF conventions attribute (" + conventions + ").  Using default view...");
                    view = new DefaultView(netcdf, db, charToText);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("netCDF dataset doesn't follow stated conventions (" + conventions + "): " + e.getMessage() + "\nUsing default view...");
                    view = new DefaultView(netcdf, db, charToText);
                }
            }
        }
        return view;
    }

    public boolean isCharToText() {
        return this.charToText;
    }

    public Netcdf getNetcdf() {
        return this.netcdf;
    }

    protected static String getConventionsString(Netcdf netcdf) {
        Attribute attr = netcdf.getAttribute("Conventions");
        try {
            return attr != null ? attr.getStringValue() : null;
        }
        catch (ClassCastException e) {
            System.err.println("The \"Conventions\" attribute (" + attr + ") isn't a string");
            return null;
        }
    }

    protected Variable getVariable(String name) {
        return this.netcdf.get(name);
    }

    protected boolean isNumeric(String name) {
        Variable var = this.netcdf.get(name);
        if (var == null) {
            return false;
        }
        return this.isNumeric(var);
    }

    protected boolean isNumeric(Variable var) {
        return !var.getComponentType().equals(Character.TYPE);
    }

    protected boolean isLongitude(Variable var) throws VisADException {
        RealType type = this.getRealType(var);
        return type != null && type.equals(this.longitude);
    }

    protected boolean isLongitude(RealType type) {
        return type != null && type.equals(this.longitude);
    }

    protected boolean isLatitude(RealType type) {
        return type != null && type.equals(this.latitude);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RealType getRealType(Dimension dim) throws TypeException {
        RealType type;
        Variable var = this.getCoordinateVariable(dim);
        if (var != null) {
            type = this.getRealType(var);
        } else {
            Map map = this.dimToRealType;
            synchronized (map) {
                type = (RealType)this.dimToRealType.get(dim);
                if (type == null) {
                    String name = dim.getName();
                    type = this.quantityDB.get(name);
                    if (type == null) {
                        type = RealType.getRealType(name);
                    }
                    if (type == null) {
                        throw new TypeException("Couldn't create RealType for " + dim.getName());
                    }
                    this.dimToRealType.put(dim, type);
                }
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RealType getRealType(Variable var) throws TypeException {
        RealType type;
        if (var == null) {
            throw new NullPointerException();
        }
        Map map = this.varToRealType;
        synchronized (map) {
            type = (RealType)this.varToRealType.get(var);
            if (type == null) {
                type = this.getRealTypeFromLongName(var);
                if (type == null) {
                    type = this.getRealTypeFromName(var);
                }
                this.varToRealType.put(var, type);
            }
        }
        return type;
    }

    protected RealType getRealTypeFromLongName(Variable var) {
        RealType type;
        String name = this.getLongName(var);
        if (name == null) {
            type = null;
        } else {
            Unit unit;
            type = this.quantityDB.get(name);
            if (type != null && !Unit.canConvert(unit = this.getUnitFromAttribute(var), type.getDefaultUnit())) {
                String newName = this.newName(var);
                System.err.println("The unit attribute (" + unit + ") " + "of variable \"" + var.getName() + "\" " + "is incompatible with the unit (" + type.getDefaultUnit() + ") " + "of the quantity referenced by the long_name attribute " + "(" + name + ").  " + "Attempting to create new quantity \"" + newName + "\".");
                type = RealType.getRealType(newName, unit);
            }
        }
        return type;
    }

    protected RealType getRealTypeFromName(Variable var) throws TypeException {
        String name = var.getName();
        Unit unit = this.getUnitFromAttribute(var);
        RealType type = this.quantityDB.get(name);
        if (type != null) {
            if (!Unit.canConvert(unit, type.getDefaultUnit())) {
                type = this.newQuantity(var, unit, type.getDefaultUnit());
            }
        } else if (unit == null) {
            type = RealType.getRealType(name);
        } else {
            type = RealType.getRealType(name, unit);
            if (type == null) {
                type = this.newQuantity(var, unit, RealType.getRealTypeByName(name).getDefaultUnit());
            }
        }
        return type;
    }

    private RealType newQuantity(Variable var, Unit wantUnit, Unit haveUnit) throws TypeException {
        String newName = this.newName(var);
        System.err.println("The unit attribute (" + wantUnit + ") " + "of variable \"" + var.getName() + "\" " + "is incompatible with the unit (" + haveUnit + ") of the RealType of the same name.  " + "Attempting to create new RealType \"" + newName + "\".");
        RealType type = RealType.getRealType(newName, wantUnit);
        if (type == null) {
            throw new TypeException(newName);
        }
        return type;
    }

    protected String newName(Variable var) {
        return var.getName() + "_" + nameCount++;
    }

    protected ScalarType getScalarType(Variable var) throws TypeException, VisADException {
        return this.isNumeric(var) ? this.getRealType(var) : this.getTextType(var);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextType getTextType(Variable var) throws VisADException {
        TextType type;
        if (var == null) {
            throw new NullPointerException();
        }
        if (this.isNumeric(var)) {
            throw new IllegalArgumentException(var.toString());
        }
        Map map = this.varToTextType;
        synchronized (map) {
            type = (TextType)this.varToTextType.get(var);
            if (type == null) {
                type = TextType.getTextType(var.getName());
                this.varToTextType.put(var, type);
            }
        }
        return type;
    }

    protected SimpleSet getRangeSet(Variable var) throws TypeException, VisADException {
        SimpleSet set;
        Class cl = var.getComponentType();
        if (cl.equals(Character.TYPE)) {
            set = null;
        } else {
            RealType type = this.getRealType(var);
            if (cl.equals(Byte.TYPE)) {
                set = new Linear1DSet((MathType)type, -127.0, 127.0, 255);
            } else if (cl.equals(Short.TYPE)) {
                set = new Linear1DSet((MathType)type, -32767.0, 32767.0, 65535);
            } else if (cl.equals(Integer.TYPE)) {
                Vetter vetter = this.getVetter(var);
                long minValid = (long)vetter.minValid();
                long maxValid = (long)vetter.maxValid();
                long length = maxValid - minValid + 1L;
                set = length <= Integer.MAX_VALUE ? new Linear1DSet((MathType)type, minValid, maxValid, (int)length) : new FloatSet(type, null, new Unit[]{this.getUnitFromAttribute(var)});
            } else {
                set = cl.equals(Float.TYPE) ? new FloatSet(type, null, new Unit[]{this.getUnitFromAttribute(var)}) : new DoubleSet(type, null, new Unit[]{this.getUnitFromAttribute(var)});
            }
        }
        return set;
    }

    protected String getAttributeString(String name) {
        return this.getAttributeString(null, name);
    }

    protected String getAttributeString(Variable var, String name) {
        Attribute attr = var == null ? this.netcdf.getAttribute(name) : var.getAttribute(name);
        try {
            return attr != null ? attr.getStringValue() : null;
        }
        catch (ClassCastException e) {
            System.err.println("Non-string attribute: " + var.getName() + ":" + name);
            return null;
        }
    }

    protected String getLongName(Variable var) {
        return this.getAttributeString(var, "long_name");
    }

    protected String getUnitString(Variable var) {
        String str = this.getAttributeString(var, "units");
        if (str == null) {
            str = this.getAttributeString(var, "unit");
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Unit getUnitFromAttribute(Variable var) {
        Unit unit;
        Map map = this.varToUnit;
        synchronized (map) {
            unit = (Unit)this.varToUnit.get(var);
            if (!this.varToUnit.containsKey(var)) {
                String spec = this.getUnitString(var);
                if (spec != null) {
                    try {
                        unit = Parser.parse(spec);
                    }
                    catch (Exception e) {
                        System.err.println("Couldn't decode unit attribute (" + spec + ")" + " of variable \"" + var.getName() + "\": " + e.getMessage());
                    }
                }
                this.varToUnit.put(var, unit);
            }
        }
        return unit;
    }

    protected Vetter getVetter(Variable var) {
        return new Vetter(var);
    }

    protected Gridded1DSet getDomainSet(Dimension dim) throws VisADException, IOException {
        Gridded1DSet set = (Gridded1DSet)this.dimToSet.get(dim);
        if (set == null) {
            Variable coordVar = this.getCoordinateVariable(dim);
            if (coordVar == null) {
                set = new Integer1DSet((MathType)this.getRealType(dim), dim.getLength());
            } else {
                Object coordValues;
                ArithProg ap = this.isLongitude(coordVar) ? new LonArithProg() : new ArithProg();
                Class varType = coordVar.getComponentType();
                boolean isDouble = varType.equals(Double.TYPE);
                if (isDouble) {
                    coordValues = coordVar.toArray();
                    ap.accumulate((double[])coordValues);
                } else if (varType.equals(Float.TYPE)) {
                    coordValues = coordVar.toArray();
                    ap.accumulate((float[])coordValues);
                } else {
                    int length = 1;
                    int[] lengths = coordVar.getLengths();
                    int i = 0;
                    while (i < lengths.length) {
                        length *= lengths[i];
                        ++i;
                    }
                    float[] floatVals = new float[length];
                    if (varType.equals(Integer.TYPE)) {
                        int[] values = (int[])coordVar.toArray();
                        int i2 = 0;
                        while (i2 < values.length) {
                            floatVals[i2] = values[i2];
                            ++i2;
                        }
                    } else if (varType.equals(Short.TYPE)) {
                        short[] values = (short[])coordVar.toArray();
                        int i3 = 0;
                        while (i3 < values.length) {
                            floatVals[i3] = values[i3];
                            ++i3;
                        }
                    } else {
                        byte[] values = (byte[])coordVar.toArray();
                        int i4 = 0;
                        while (i4 < values.length) {
                            floatVals[i4] = values[i4];
                            ++i4;
                        }
                    }
                    ap.accumulate(floatVals);
                    coordValues = floatVals;
                }
                set = ap.isConsistent() ? new Linear1DSet((MathType)this.getRealType(dim), ap.getFirst(), ap.getLast(), (int)ap.getNumber(), (CoordinateSystem)null, new Unit[]{this.getUnitFromAttribute(coordVar)}, null) : (isDouble ? new Gridded1DDoubleSet((MathType)this.getRealType(dim), new double[][]{(double[])coordValues}, dim.getLength(), (CoordinateSystem)null, new Unit[]{this.getUnitFromAttribute(coordVar)}, (ErrorEstimate[])null) : new Gridded1DSet((MathType)this.getRealType(dim), (float[][])new float[][]{(float[])coordValues}, dim.getLength(), (CoordinateSystem)null, new Unit[]{this.getUnitFromAttribute(coordVar)}, (ErrorEstimate[])null));
            }
            this.dimToSet.put(dim, set);
        }
        return set;
    }

    protected Variable getCoordinateVariable(Dimension dim) {
        Variable var = this.netcdf.get(dim.getName());
        if (!(var == null || var.getRank() == 1 && this.isNumeric(var))) {
            var = null;
        }
        return var;
    }

    public void setOuterDimensionNameSet(Set nameSet) {
        this.factorNameSet = nameSet;
    }

    public Set getOuterDimensionNameSet() {
        return this.factorNameSet;
    }

    protected boolean isTime(Dimension dim) throws VisADException, IOException {
        RealType rt = this.getRealType(dim);
        if (this.factorNameSet != null && this.factorNameSet.contains(rt.getName())) {
            return true;
        }
        return this.isTime(rt.getDefaultUnit());
    }

    protected boolean isTime(Unit unit) {
        return unit != null && SI.second.isConvertible(unit.getAbsoluteUnit());
    }

    protected Dimension[] getDimensions(Variable var) {
        int rank = var.getRank();
        Dimension[] dims = new Dimension[rank];
        DimensionIterator iter = var.getDimensionIterator();
        int i = 0;
        while (i < rank) {
            dims[i] = iter.next();
            ++i;
        }
        return dims;
    }

    protected boolean isCoordinateVariable(Variable var) {
        if (var.getRank() != 1 || !this.isNumeric(var)) {
            return false;
        }
        return this.getDimensions(var)[0].getName().equals(var.getName());
    }

    public VirtualDataIterator getVirtualDataIterator() {
        return new DataIterator();
    }

    protected abstract boolean isIgnorable(Variable var1);

    protected abstract Domain getDomain(Variable var1) throws TypeException, IOException;

    public VirtualData getData(String name) throws TypeException, VisADException, IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.getData(this.netcdf.get(name));
    }

    protected VirtualData getData(Variable var) throws TypeException, VisADException, IOException {
        VirtualScalar scalar = this.isNumeric(var) ? new VirtualReal(this.getRealType(var), var, this.getRangeSet(var), this.getUnitFromAttribute(var), this.getVetter(var)) : new VirtualText(this.getTextType(var), var);
        return var.getRank() == 0 || !this.isNumeric(var) && var.getRank() == 1 ? scalar : this.getDomain(var).getVirtualField(new VirtualTuple(scalar));
    }

    protected abstract class Domain {
        protected Domain(Variable var) {
            if (var.getRank() == 0) {
                throw new IllegalArgumentException(var.toString());
            }
        }

        protected abstract VirtualField getVirtualField(VirtualTuple var1) throws VisADException, IOException;

        public abstract boolean equals(Object var1);

        public abstract int hashCode();
    }

    protected class DataIterator
    extends VirtualDataIterator {
        private final VariableIterator varIter;

        DataIterator() {
            super(View.this);
            this.varIter = View.this.getNetcdf().iterator();
        }

        protected VirtualData getData() throws TypeException, VisADException, IOException {
            while (this.varIter.hasNext()) {
                Variable var = this.varIter.next();
                if (!View.this.isNumeric(var) && (!View.this.isCharToText() || var.getRank() > 2) || View.this.isIgnorable(var)) continue;
                return View.this.getData(var);
            }
            return null;
        }
    }
}

