/*
 * Decompiled with CFR 0.152.
 */
package visad.data.in;

import java.util.Arrays;
import visad.data.in.DoubleValueVetter;
import visad.data.in.MultipleValueVetter;
import visad.data.in.SingleValueVetter;
import visad.data.in.ValueProcessor;

public abstract class ValueVetter
extends ValueProcessor {
    private static final ValueVetter trivialVetter = new ValueVetter(){

        public float process(float value) {
            return value;
        }

        public double process(double value) {
            return value;
        }

        public float[] process(float[] values) {
            return values;
        }

        public double[] process(double[] values) {
            return values;
        }
    };

    protected ValueVetter() {
    }

    public static ValueVetter valueVetter(double[] values) {
        ValueVetter vetter;
        if (values == null || values.length == 0) {
            vetter = trivialVetter;
        } else {
            int count = 0;
            double prev = Double.NaN;
            Arrays.sort(values);
            int i = 0;
            while (i < values.length) {
                double value = values[i];
                if (value == value && value != prev) {
                    ++count;
                    prev = value;
                }
                ++i;
            }
            if (count == 0) {
                vetter = trivialVetter;
            } else {
                if (count != values.length) {
                    double[] vals = new double[count];
                    count = 0;
                    prev = Double.NaN;
                    int i2 = 0;
                    while (i2 < values.length) {
                        double value = values[i2];
                        if (value == value && value != prev) {
                            vals[count++] = value;
                            prev = value;
                        }
                        ++i2;
                    }
                    values = vals;
                }
                vetter = values.length == 1 ? SingleValueVetter.singleValueVetter(values[0]) : (values.length == 2 ? DoubleValueVetter.doubleValueVetter(values[0], values[1]) : MultipleValueVetter.multipleValueVetter(values));
            }
        }
        return vetter;
    }
}

