/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.DimensionSet;
import visad.data.hdfeos.Variable;
import visad.data.hdfeos.VariableSet;

public class Shape {
    private DimensionSet dimSet;
    private VariableSet varSet = new VariableSet();

    public Shape(Variable var) {
        this.varSet.add(var);
        this.dimSet = var.getDimSet();
    }

    public void addVariable(Variable var) {
        this.varSet.add(var);
    }

    public DimensionSet getShape() {
        return this.dimSet;
    }

    public VariableSet getVariables() {
        return this.varSet;
    }

    public int getNumberOfVars() {
        return this.varSet.getSize();
    }

    public Variable getVariable(int index) {
        return this.varSet.getElement(index);
    }

    public boolean memberOf(Variable var) {
        DimensionSet d_set = var.getDimSet();
        return this.dimSet.sameSetSameOrder(d_set);
    }

    public Variable isCoordVar(int index) {
        if (this.dimSet.getSize() == 1) {
            return this.varSet.isCoordVar(index);
        }
        return null;
    }

    public String toString() {
        String str = this.dimSet.toString() + "  Variables: \n";
        int ii = 0;
        while (ii < this.varSet.getSize()) {
            str = str + "       " + this.varSet.getElement(ii).getName() + "\n";
            ++ii;
        }
        str = str + "- - - - - - - - - - - - - - - - - - - \n";
        return str;
    }
}

