/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;

public class LambertAzimuthalEqualArea
extends CoordinateSystem {
    double R;
    double lon_center;
    double lat_center;
    double false_easting;
    double false_northing;
    double sin_lat_o;
    double cos_lat_o;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};

    public LambertAzimuthalEqualArea(RealTupleType reference, double R, double lon_center, double lat_center, double false_easting, double false_northing) throws VisADException {
        super(reference, coordinate_system_units);
        this.R = R;
        this.lon_center = lon_center;
        this.lat_center = lat_center;
        this.false_easting = false_easting;
        this.false_northing = false_northing;
        this.sin_lat_o = Math.sin(lat_center);
        this.cos_lat_o = Math.cos(lat_center);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        double[] dum_1 = new double[1];
        double[] dum_2 = new double[1];
        double[] dum = new double[1];
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("LambertAzimuthalEqualArea: tuple dim != 2");
        }
        double[][] t_tuples = new double[2][n_tuples];
        int ii = 0;
        while (ii < n_tuples) {
            double lat;
            double z;
            double x = tuples[0][ii] - this.false_easting;
            double y = tuples[0][ii] - this.false_northing;
            double Rh = Math.sqrt(x * x + y * y);
            double temp = Rh / (2.0 * this.R);
            if (temp > 1.0) {
                // empty if block
            }
            dum[0] = z = 2.0 * GctpFunction.asinz(temp);
            GctpFunction.sincos(dum, dum_1, dum_2);
            double sin_z = dum_1[0];
            double cos_z = dum_2[0];
            double lon = this.lon_center;
            if (Math.abs(Rh) > 1.0E-10) {
                lat = GctpFunction.asinz(this.sin_lat_o * cos_z + this.cos_lat_o * sin_z * y / Rh);
                temp = Math.abs(this.lat_center) - 1.5707963267948966;
                if (Math.abs(temp) > 1.0E-10) {
                    temp = cos_z - this.sin_lat_o * Math.sin(lat);
                    if (temp != 0.0) {
                        lon = GctpFunction.adjust_lon(this.lon_center + Math.atan2(x * sin_z * this.cos_lat_o, temp * Rh));
                    }
                } else {
                    lon = this.lat_center < 0.0 ? GctpFunction.adjust_lon(this.lon_center - Math.atan2(-x, y)) : GctpFunction.adjust_lon(this.lon_center + Math.atan2(x, -y));
                }
            } else {
                lat = this.lat_center;
            }
            t_tuples[0][ii] = lat;
            t_tuples[1][ii] = lon;
            ++ii;
        }
        return t_tuples;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("LambertAzimuthalEqualArea: tuple dim != 2");
        }
        double[][] t_tuples = new double[2][n_tuples];
        double[] delta_lon = new double[n_tuples];
        double[] sin_lat = new double[n_tuples];
        double[] cos_lat = new double[n_tuples];
        double[] sin_delta_lon = new double[n_tuples];
        double[] cos_delta_lon = new double[n_tuples];
        int ii = 0;
        while (ii < n_tuples) {
            delta_lon[ii] = tuples[1][ii] - this.lon_center;
            ++ii;
        }
        GctpFunction.adjust_lon(delta_lon);
        GctpFunction.sincos(tuples[0], sin_lat, cos_lat);
        GctpFunction.sincos(delta_lon, sin_delta_lon, cos_delta_lon);
        int ii2 = 0;
        while (ii2 < n_tuples) {
            double g = this.sin_lat_o * sin_lat[ii2] + this.cos_lat_o * cos_lat[ii2] * cos_delta_lon[ii2];
            if (g == -1.0) {
                throw new VisADException("Point projects to a circle of radius = " + 2.0 * this.R);
            }
            double ksp = this.R * Math.sqrt(2.0 / (1.0 + g));
            t_tuples[0][ii2] = ksp * cos_lat[ii2] * sin_delta_lon[ii2] + this.false_easting;
            t_tuples[1][ii2] = ksp * (this.cos_lat_o * sin_lat[ii2] - this.sin_lat_o * cos_lat[ii2] * cos_delta_lon[ii2]) + this.false_northing;
            ++ii2;
        }
        delta_lon = null;
        sin_lat = null;
        cos_lat = null;
        sin_delta_lon = null;
        cos_delta_lon = null;
        return t_tuples;
    }

    public boolean equals(Object cs) {
        return cs instanceof LambertAzimuthalEqualArea;
    }

    public static void main(String[] args) throws VisADException {
        CoordinateSystem coord_cs1 = null;
        Object value_in = new double[][]{{0.0, 0.5236, 1.0472, 1.5708}, {1.0, 1.0, 1.0, 1.0}};
        double[][] value_out = new double[2][4];
        RealType real1 = RealType.getRealType("Theta", SI.radian);
        RealType real2 = RealType.getRealType("radius", SI.meter);
        RealType[] reals = new RealType[]{real1, real2};
        RealTupleType Reference2 = new RealTupleType(reals);
        RealTupleType tuple1 = new RealTupleType(reals, coord_cs1, null);
        value_out = tuple1.getCoordinateSystem().fromReference((double[][])value_in);
        int i = 0;
        while (i < value_out[0].length) {
            System.out.println(value_out[0][i] + ",  " + value_out[1][i]);
            ++i;
        }
        value_in = tuple1.getCoordinateSystem().toReference(value_out);
        int i2 = 0;
        while (i2 < value_in[0].length) {
            System.out.println(value_in[0][i2] + ",  " + value_in[1][i2]);
            ++i2;
        }
        ScaledUnit kilometer = new ScaledUnit(1000.0, SI.meter);
    }
}

