/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.data.hdfeos.Calibration;

class CalibrationDefault
extends Calibration {
    private static String scaleFactorName = "scale_factor";
    private static String offsetName = "add_offset";
    private static String fillValueName = "_FillValue";
    private static String validRange = "valid_range";
    private static String[] names = new String[4];
    double scale_factor;
    double offset;
    double fillvalue;
    double v_range_low;
    double v_range_high;

    CalibrationDefault(double[][] constants) {
        this.scale_factor = constants[0][0];
        this.offset = constants[1][0];
        this.fillvalue = constants[2][0];
        if (constants[3][0] < constants[3][1]) {
            this.v_range_low = constants[3][0];
            this.v_range_high = constants[3][1];
        } else {
            this.v_range_low = constants[3][1];
            this.v_range_high = constants[3][0];
        }
    }

    public static String[] getNames() {
        return names;
    }

    public void fromCalibration(short[] values, double[] out) {
        int ii = 0;
        while (ii < values.length) {
            double d_value = values[ii];
            d_value = d_value == this.fillvalue ? Double.NaN : (d_value < this.v_range_low && d_value > this.v_range_high ? Double.NaN : ((double)values[ii] - this.offset) * this.scale_factor);
            out[ii] = d_value;
            ++ii;
        }
    }

    public void fromCalibration(short[] values, float[] out) {
        float offset = (float)this.offset;
        float scale_factor = (float)this.scale_factor;
        float v_range_low = (float)this.v_range_low;
        float v_range_high = (float)this.v_range_high;
        int ii = 0;
        while (ii < values.length) {
            float f_value = values[ii];
            f_value = f_value == (float)this.fillvalue ? Float.NaN : (f_value < v_range_low && f_value > v_range_high ? Float.NaN : ((float)values[ii] - offset) * scale_factor);
            out[ii] = f_value;
            ++ii;
        }
    }

    public void fromCalibration(byte[] values, float[] out) {
        float offset = (float)this.offset;
        float scale_factor = (float)this.scale_factor;
        float v_range_low = (float)this.v_range_low;
        float v_range_high = (float)this.v_range_high;
        int ii = 0;
        while (ii < values.length) {
            float f_value = values[ii];
            f_value = f_value == (float)this.fillvalue ? Float.NaN : (f_value < v_range_low && f_value > v_range_high ? Float.NaN : ((float)values[ii] - offset) * scale_factor);
            out[ii] = f_value;
            ++ii;
        }
    }

    static {
        CalibrationDefault.names[0] = scaleFactorName;
        CalibrationDefault.names[1] = offsetName;
        CalibrationDefault.names[2] = fillValueName;
        CalibrationDefault.names[3] = validRange;
    }
}

