/*
 * Decompiled with CFR 0.152.
 */
package visad.data.fits;

import visad.FlatField;
import visad.GriddedSet;
import visad.Set;
import visad.VisADException;
import visad.data.fits.ConvertArray;

public class ConvertDoubleArray
extends ConvertArray {
    private double[][] values;

    public ConvertDoubleArray(FlatField fld) throws VisADException {
        Set set = fld.getDomainSet();
        if (!(set instanceof GriddedSet)) {
            throw new VisADException("Cannot convert non-GriddedSet FlatField");
        }
        this.lengths = ((GriddedSet)set).getLengths();
        this.values = fld.getValues();
    }

    public ConvertDoubleArray(int[] lengths, double[][] values) throws VisADException {
        this.lengths = lengths;
        this.values = values;
    }

    int analyzeArray() {
        double max = this.values[0][0];
        double min = this.values[0][0];
        boolean integral = true;
        int i = 0;
        while (i < this.values.length) {
            int j = 0;
            while (j < this.values[i].length) {
                double v = this.values[i][j];
                if (v > max) {
                    max = v;
                }
                if (v < min) {
                    min = v;
                }
                if (v >= -9.223372036854776E18 && v <= 9.223372036854776E18) {
                    if (v % 1.0 > 0.0) {
                        integral = false;
                    }
                } else {
                    integral = false;
                }
                ++j;
            }
            ++i;
        }
        return this.getArrayType(min, max, integral);
    }
}

