/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.BaseType;
import dods.dap.DAS;
import dods.dap.DArray;
import dods.dap.DGrid;
import dods.dap.NoSuchVariableException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.dods.Adapter;
import visad.data.dods.ArrayVariableAdapter;
import visad.data.dods.GridVariableMapAdapter;
import visad.data.dods.VariableAdapter;
import visad.data.dods.VariableAdapterFactory;

public class GridVariableAdapter
extends VariableAdapter {
    private ArrayVariableAdapter arrayAdapter;
    private FunctionType funcType;
    private boolean isFlat;
    private GridVariableMapAdapter[] domainAdapters;
    private static RealTupleType latLonType;
    private static RealTupleType lonLatType;

    private GridVariableAdapter(GridVariableMapAdapter[] domainAdapters, ArrayVariableAdapter arrayAdapter) throws BadFormException, VisADException, RemoteException {
        MathType rangeType = arrayAdapter.getFunctionType().getRange();
        this.funcType = new FunctionType(VariableAdapter.mathType(domainAdapters), rangeType);
        this.arrayAdapter = arrayAdapter;
        this.isFlat = Adapter.isFlat(rangeType);
        this.domainAdapters = domainAdapters;
    }

    public static GridVariableAdapter gridVariableAdapter(DGrid grid, DAS das, VariableAdapterFactory factory) throws VisADException, RemoteException {
        GridVariableMapAdapter[] domainAdapters;
        ArrayVariableAdapter arrayAdapter;
        try {
            DArray array = (DArray)grid.getVar(0);
            int rank = array.numDimensions();
            arrayAdapter = factory.arrayVariableAdapter(array, das);
            domainAdapters = new GridVariableMapAdapter[rank];
            int i = 1;
            while (i <= rank) {
                array = (DArray)grid.getVar(i);
                BaseType template = array.getPrimitiveVector().getTemplate();
                domainAdapters[rank - i] = factory.gridVariableMapAdapter(array, das);
                ++i;
            }
        }
        catch (NoSuchVariableException e) {
            throw new BadFormException("visad.data.dods.GridVariableAdapter.gridVariableAdapter(...): No such variable: " + e);
        }
        return new GridVariableAdapter(domainAdapters, arrayAdapter);
    }

    public MathType getMathType() {
        return this.funcType;
    }

    public SimpleSet[] getRepresentationalSets(boolean copy) {
        return this.arrayAdapter.getRepresentationalSets(copy);
    }

    public DataImpl data(DGrid grid, boolean copy) throws VisADException, RemoteException {
        FieldImpl field;
        try {
            SampledSet domain;
            int rank = this.domainAdapters.length;
            if (rank == 1) {
                domain = (SampledSet)this.domainAdapters[0].data((DArray)grid.getVar(1), copy);
            } else {
                Gridded1DSet[] domainSets = new Gridded1DSet[rank];
                int i = 0;
                while (i < rank) {
                    domainSets[i] = (Gridded1DSet)this.domainAdapters[i].data((DArray)grid.getVar(rank - i), copy);
                    ++i;
                }
                ArrayList<Object> griddedSets = new ArrayList<Object>(rank);
                int start = 0;
                while (start < rank) {
                    if (!(domainSets[start] instanceof LinearSet)) {
                        griddedSets.add(domainSets[start++]);
                        continue;
                    }
                    int stop = start + 1;
                    while (stop < rank && domainSets[stop] instanceof LinearSet) {
                        ++stop;
                    }
                    int n = stop - start;
                    if (n == 1) {
                        griddedSets.add(domainSets[start]);
                    } else {
                        RealType[] rTypes = new RealType[n];
                        double[] firsts = new double[n];
                        double[] lasts = new double[n];
                        int[] lengths = new int[n];
                        int i2 = 0;
                        while (i2 < n) {
                            Linear1DSet lin1D = (Linear1DSet)domainSets[start + i2];
                            rTypes[i2] = (RealType)((SetType)lin1D.getType()).getDomain().getComponent(0);
                            firsts[i2] = lin1D.getFirst();
                            lasts[i2] = lin1D.getLast();
                            lengths[i2] = lin1D.getLength();
                            ++i2;
                        }
                        griddedSets.add(LinearNDSet.create(new RealTupleType(rTypes), firsts, lasts, lengths));
                    }
                    start = stop;
                }
                domain = griddedSets.size() == 1 ? (GriddedSet)griddedSets.get(0) : new ProductSet((MathType)this.funcType.getDomain(), griddedSets.toArray(new GriddedSet[0]));
            }
            DArray array = (DArray)grid.getVar(0);
            if (this.isFlat) {
                field = new FileFlatField(new GridAccessor(domain, array), this.getCacheStrategy());
            } else {
                field = new FieldImpl(this.funcType, domain);
                this.arrayAdapter.setField(array, field, copy);
            }
        }
        catch (NoSuchVariableException e) {
            throw new BadFormException(this.getClass().getName() + ".data(...): " + "No such variable: " + e);
        }
        return field;
    }

    static {
        try {
            latLonType = new RealTupleType(RealType.Latitude, RealType.Longitude);
            lonLatType = new RealTupleType(RealType.Longitude, RealType.Latitude);
        }
        catch (Exception e) {
            throw new VisADError("visad.data.dods.GridVariableAdapter.<clinit>: Couldn't initialize class: " + e);
        }
    }

    protected class GridAccessor
    extends FileAccessor {
        private final SampledSet domain;
        private final DArray array;

        public GridAccessor(SampledSet domain, DArray array) {
            this.domain = domain;
            this.array = array;
        }

        public FunctionType getFunctionType() {
            return GridVariableAdapter.this.funcType;
        }

        public FlatField getFlatField() throws VisADException, RemoteException {
            FlatField field = new FlatField(GridVariableAdapter.this.funcType, (Set)this.domain, (CoordinateSystem[])null, (Set[])GridVariableAdapter.this.arrayAdapter.getRepresentationalSets(false), (Unit[])null);
            GridVariableAdapter.this.arrayAdapter.setField(this.array, field, false);
            return field;
        }

        public void writeFlatField(double[][] values, FlatField template, int[] fileLocation) {
            throw new VisADError(this.getClass().getName() + ".writeFlatField(...): " + "Unimplemented method");
        }

        public double[][] readFlatField(FlatField template, int[] fileLocation) {
            throw new VisADError(this.getClass().getName() + ".readFlatField(...): " + "Unimplemented method");
        }

        public void writeFile(int[] fileLocation, Data range) {
            throw new VisADError(this.getClass().getName() + ".writeFile(...): " + "Unimplemented method");
        }
    }
}

