/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import dods.dap.AttributeTable;
import dods.dap.BaseType;
import dods.dap.DAS;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.units.Parser;

public abstract class Adapter {
    private static final CacheStrategy cacheStrategy = new CacheStrategy();

    protected static String scalarName(String name) {
        return name.replace('.', '-').replace(' ', '_').replace('(', '<').replace(')', '>');
    }

    protected static boolean isFlat(MathType mathType) {
        return mathType instanceof RealType || mathType instanceof RealTupleType || mathType instanceof TupleType && ((TupleType)mathType).getFlat();
    }

    protected static RealType realType(BaseType variable, DAS das) {
        return Adapter.realType(variable.getName(), Adapter.attributeTable(das, variable));
    }

    protected static RealType realType(BaseType variable, AttributeTable table) {
        return Adapter.realType(variable.getName(), table);
    }

    protected static RealType realType(String name, DAS das) {
        return Adapter.realType(name, Adapter.attributeTable(das, name));
    }

    protected static RealType realType(String name, AttributeTable table) {
        Unit unit;
        if (table == null) {
            unit = null;
        } else {
            Attribute attr = table.getAttribute("units");
            if (attr == null && (attr = table.getAttribute("unit")) == null && (attr = table.getAttribute("UNITS")) == null) {
                attr = table.getAttribute("UNIT");
            }
            if (attr == null) {
                unit = null;
            } else if (attr.getType() != 10) {
                unit = null;
            } else {
                String unitSpec = attr.getValueAt(0);
                if (unitSpec.startsWith("\"") && unitSpec.endsWith("\"")) {
                    unitSpec = unitSpec.substring(1, unitSpec.length() - 1);
                }
                try {
                    Parser.instance();
                    unit = Parser.parse(unitSpec);
                }
                catch (Exception e) {
                    System.err.println("visad.data.dods.Adapter.realType(String,...): Ignoring non-decodable unit-specification \"" + unitSpec + "\" of variable \"" + name + "\"");
                    unit = null;
                }
            }
        }
        return RealType.getRealType(Adapter.scalarName(name), unit);
    }

    protected static AttributeTable attributeTable(DAS das, BaseType baseType) {
        return das.getAttributeTable(baseType.getName());
    }

    protected static AttributeTable attributeTable(DAS das, String name) {
        return das.getAttributeTable(name);
    }

    protected static MathType mathType(MathType[] mathTypes) throws VisADException {
        MathType mathType;
        if (mathTypes.length == 0) {
            mathType = null;
        } else if (mathTypes.length == 1) {
            mathType = mathTypes[0];
        } else {
            boolean allReals = true;
            int i = 0;
            while (i < mathTypes.length && allReals) {
                allReals &= mathTypes[i] instanceof RealType;
                ++i;
            }
            if (allReals) {
                RealType[] realTypes = new RealType[mathTypes.length];
                int i2 = 0;
                while (i2 < realTypes.length) {
                    realTypes[i2] = (RealType)mathTypes[i2];
                    ++i2;
                }
                mathType = new RealTupleType(realTypes);
            } else {
                mathType = new TupleType(mathTypes);
            }
        }
        return mathType;
    }

    protected CacheStrategy getCacheStrategy() {
        return cacheStrategy;
    }
}

