/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;

public class FluoviewTiffForm
extends Form
implements FormFileInformer,
FormProgressInformer,
FormBlockReader {
    private static int num = 0;
    private RealType frame;
    private RealType row;
    private RealType column;
    private RealType pixel;
    private FunctionType func_rc_p;
    private FunctionType func_t_range;
    private RealTupleType domain_tuple;
    private Set pixelSet;
    private Set timeSet;
    private FlatField frame_ff;
    private FieldImpl timeField;
    private DataReferenceImpl data_ref;
    private DisplayImpl display;
    private ScalarMap timeAnimMap;
    private ScalarMap timeZMap;
    private ScalarMap lenXMap;
    private ScalarMap ampYMap;
    private ScalarMap ampRGBMap;
    private RandomAccessFile readin;
    private String current_id;
    private double percent;

    public FluoviewTiffForm() {
        super("FluoviewTiffForm" + num++);
    }

    public boolean isThisType(String name) {
        if (!name.toLowerCase().endsWith(".tif") && !name.toLowerCase().endsWith(".tiff")) {
            return false;
        }
        long len = new File(name).length();
        int num = len < 16384L ? (int)len : 16384;
        byte[] buf = new byte[num];
        try {
            FileInputStream fin = new FileInputStream(name);
            int r = 0;
            while (r < num) {
                r += fin.read(buf, r, num - r);
            }
            fin.close();
            return this.isThisType(buf);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 3 || block[2] != 42) {
            return false;
        }
        String test = new String(block);
        return (test = test.toLowerCase()).indexOf("fluoview") != -1;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"tif", "tiff"};
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("FluoviewTiffForm.save");
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("FluoviewTiffForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.readin = new RandomAccessFile(id, "r");
            this.current_id = id;
        }
        this.percent = 0.0;
        this.frame = RealType.getRealType("frame");
        this.row = RealType.getRealType("row");
        this.column = RealType.getRealType("column");
        this.domain_tuple = new RealTupleType(this.row, this.column);
        this.pixel = RealType.getRealType("intensity");
        this.func_rc_p = new FunctionType(this.domain_tuple, this.pixel);
        this.func_t_range = new FunctionType(this.frame, this.func_rc_p);
        int[] dimensions = this.getFTIFFDimensions();
        int xdim = dimensions[0];
        int ydim = dimensions[1];
        this.pixelSet = new Linear2DSet((MathType)this.domain_tuple, 0.0, (double)(xdim - 1), xdim, ydim - 1, 0.0, ydim);
        this.timeSet = new Integer1DSet((MathType)this.frame, dimensions[2]);
        this.frame_ff = new FlatField(this.func_rc_p, this.pixelSet);
        this.timeField = new FieldImpl(this.func_t_range, this.timeSet);
        int framecount = 0;
        while (framecount < dimensions[2]) {
            this.percent = framecount / dimensions[2];
            float[][] flat_samples = new float[][]{this.getFrame(framecount + 1)};
            this.frame_ff.setSamples(flat_samples);
            this.timeField.setSample(framecount, (Data)this.frame_ff);
            ++framecount;
        }
        this.percent = -1.0;
        return this.timeField;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new UnimplementedException("FluoviewTiffForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.readin = new RandomAccessFile(id, "r");
            this.current_id = id;
        }
        this.frame = RealType.getRealType("frame");
        this.row = RealType.getRealType("row");
        this.column = RealType.getRealType("column");
        this.domain_tuple = new RealTupleType(this.row, this.column);
        this.pixel = RealType.getRealType("intensity");
        this.func_rc_p = new FunctionType(this.domain_tuple, this.pixel);
        this.func_t_range = new FunctionType(this.frame, this.func_rc_p);
        int[] dimensions = this.getFTIFFDimensions();
        int xdim = dimensions[0];
        int ydim = dimensions[1];
        this.pixelSet = new Linear2DSet((MathType)this.domain_tuple, 0.0, (double)(xdim - 1), xdim, ydim - 1, 0.0, ydim);
        this.timeSet = new Integer1DSet((MathType)this.frame, dimensions[2]);
        this.frame_ff = new FlatField(this.func_rc_p, this.pixelSet);
        float[][] flat_samples = new float[][]{this.getFrame(block_number + 1)};
        this.frame_ff.setSamples(flat_samples);
        return this.frame_ff;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.readin = new RandomAccessFile(id, "r");
            this.current_id = id;
        }
        int[] dimensions = this.getFTIFFDimensions();
        return dimensions[2];
    }

    public void close() {
        try {
            this.readin.close();
        }
        catch (Exception e) {}
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private Hashtable getIFDHash(int framecount) throws IOException {
        int numentries;
        byte[] bytearray = new byte[4];
        this.readin.seek(4L);
        this.readin.read(bytearray);
        int nextoffset = this.batoi(bytearray);
        Hashtable<Integer, Serializable> IFDentries = new Hashtable<Integer, Serializable>();
        int frames = 1;
        while (nextoffset != 0 && frames != framecount) {
            ++frames;
            this.readin.seek(nextoffset);
            bytearray = new byte[2];
            this.readin.read(bytearray);
            numentries = this.batoi(bytearray);
            this.readin.skipBytes(12 * numentries);
            bytearray = new byte[4];
            this.readin.read(bytearray);
            nextoffset = this.batoi(bytearray);
        }
        this.readin.seek(nextoffset);
        bytearray = new byte[2];
        this.readin.read(bytearray);
        numentries = this.batoi(bytearray);
        int i = 0;
        while (i < numentries) {
            bytearray = new byte[2];
            this.readin.read(bytearray);
            Integer entrytag = new Integer(this.batoi(bytearray));
            this.readin.read(bytearray);
            Integer entrytype = new Integer(this.batoi(bytearray));
            bytearray = new byte[4];
            this.readin.read(bytearray);
            Integer entrycount = new Integer(this.batoi(bytearray));
            this.readin.read(bytearray);
            Integer entryoffset = new Integer(this.batoi(bytearray));
            Vector<Integer> entrydata = new Vector<Integer>();
            entrydata.add(entrytype);
            entrydata.add(entrycount);
            entrydata.add(entryoffset);
            IFDentries.put(entrytag, entrydata);
            ++i;
        }
        this.readin.read(bytearray);
        nextoffset = this.batoi(bytearray);
        IFDentries.put(new Integer(424242), new Integer(nextoffset));
        return IFDentries;
    }

    private int[] getFTIFFDimensions() throws IOException {
        int frames = 1;
        Hashtable IFDentries = this.getIFDHash(1);
        int nextoffset = (Integer)IFDentries.get(new Integer(424242));
        while (nextoffset != 0) {
            ++frames;
            try {
                this.readin.seek(nextoffset);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            byte[] bytearray = new byte[2];
            this.readin.read(bytearray);
            int numentries = this.batoi(bytearray);
            this.readin.skipBytes(12 * numentries);
            bytearray = new byte[4];
            this.readin.read(bytearray);
            nextoffset = this.batoi(bytearray);
        }
        Vector entrydata = (Vector)IFDentries.get(new Integer(256));
        Integer width = (Integer)entrydata.get(2);
        entrydata = (Vector)IFDentries.get(new Integer(257));
        Integer length = (Integer)entrydata.get(2);
        return new int[]{width, length, frames};
    }

    public float[] getFrame(int framecount) throws IOException {
        int current;
        int i;
        byte[] bytearray;
        Hashtable IFDentries = this.getIFDHash(framecount);
        Vector entrydata = (Vector)IFDentries.get(new Integer(273));
        int stripoffsetcount = (Integer)entrydata.get(1);
        int stripoffsets = (Integer)entrydata.get(2);
        entrydata = (Vector)IFDentries.get(new Integer(279));
        int stripbytes = (Integer)entrydata.get(2);
        int[][] stripinfo = new int[stripoffsetcount][2];
        int total = 0;
        if (stripoffsetcount == 1) {
            stripinfo[0][0] = stripoffsets;
            stripinfo[0][1] = stripbytes;
            total = stripbytes;
        } else {
            this.readin.seek(stripoffsets);
            bytearray = new byte[4];
            i = 0;
            while (i < stripoffsetcount) {
                this.readin.read(bytearray);
                stripinfo[i][0] = this.batoi(bytearray);
                ++i;
            }
            this.readin.seek(stripbytes);
            int i2 = 0;
            while (i2 < stripoffsetcount) {
                this.readin.read(bytearray);
                stripinfo[i2][1] = current = this.batoi(bytearray);
                total += current;
                ++i2;
            }
        }
        float[] toreturn = new float[total / 2];
        current = 0;
        i = 0;
        while (i < stripoffsetcount) {
            this.readin.seek(stripinfo[i][0]);
            bytearray = new byte[stripinfo[i][1]];
            this.readin.read(bytearray);
            int j = 0;
            while (j < bytearray.length) {
                toreturn[current] = (float)(bytearray[j] < 0 ? 256 + bytearray[j] : bytearray[j]) + (float)((bytearray[j + 1] < 0 ? 256 + bytearray[j + 1] : bytearray[j + 1]) << 8);
                ++current;
                j += 2;
            }
            ++i;
        }
        return toreturn;
    }

    private int batoi(byte[] inp) {
        int len = inp.length > 4 ? 4 : inp.length;
        int total = 0;
        int i = 0;
        while (i < len) {
            total += (inp[i] < 0 ? 256 + inp[i] : inp[i]) << i * 8;
            ++i;
        }
        return total;
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to Fluoview TIFF, run:");
            System.out.println("  java visad.data.bio.FluoviewTiffForm in_file out_file");
            System.out.println("To test read a Fluoview TIFF file, run:");
            System.out.println("  java visad.data.bio.FluoviewTiffForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            FluoviewTiffForm form = new FluoviewTiffForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            FluoviewTiffForm form = new FluoviewTiffForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }
}

