/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.DataOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Data;
import visad.DataImpl;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SI;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.bio.BioRadForm;

public class BioRadNote {
    public static final Unit micron = SI.meter.pow(-6);
    public static final Unit second = SI.second;
    public static final int NO_INFORMATION = 0;
    public static final int METADATA = 1;
    public static final int HORIZ_UNIT = 2;
    public static final int VERT_UNIT = 3;
    public static final int INVALID_NOTE = -1;
    static final int NOTE_TYPE_LIVE = 1;
    static final int NOTE_TYPE_FILE1 = 2;
    static final int NOTE_TYPE_NUMBER = 3;
    static final int NOTE_TYPE_USER = 4;
    static final int NOTE_TYPE_LINE = 5;
    static final int NOTE_TYPE_COLLECT = 6;
    static final int NOTE_TYPE_FILE2 = 7;
    static final int NOTE_TYPE_SCALEBAR = 8;
    static final int NOTE_TYPE_MERGE = 9;
    static final int NOTE_TYPE_THRUVIEW = 10;
    static final int NOTE_TYPE_ARROW = 11;
    static final int NOTE_TYPE_VARIABLE = 20;
    static final int NOTE_TYPE_STRUCTURE = 21;
    static final String[] noteNames = new String[]{"0", "LIVE", "FILE1", "NUMBER", "USER", "LINE", "COLLECT", "FILE2", "SCALEBAR", "MERGE", "THRUVIEW", "ARROW", "12", "13", "14", "15", "16", "17", "18", "19", "VARIABLE", "STRUCTURE"};
    static final int NOTE_STATUS_ALL = 256;
    static final int NOTE_STATUS_DISPLAY = 512;
    static final int NOTE_STATUS_POSITION = 1024;
    private static final int axt_D = 1;
    private static final int axt_T = 2;
    private static final int axt_A = 3;
    private static final int axt_I = 4;
    private static final int axt_M4 = 5;
    private static final int axt_R = 6;
    private static final int axt_LR = 7;
    private static final int axt_P = 8;
    private static final int axt_C = 9;
    private static final int axt_PHOTON = 10;
    private static final int axt_RGB = 11;
    private static final int axt_SEQ = 12;
    private static final int axt_6D = 13;
    private static final int axt_TC = 14;
    private static final int axt_S = 15;
    private static final int axt_LS = 16;
    private static final int axt_MASK = 255;
    private static final int axt_XY = 256;
    private static final int axt_WORD = 512;
    private static final RealType rt_level = RealType.getRealType("biorad_level");
    private static final RealType rt_num = RealType.getRealType("biorad_num");
    private static final RealType rt_status = RealType.getRealType("biorad_status");
    private static final RealType rt_type = RealType.getRealType("biorad_type");
    private static final RealType rt_x = RealType.getRealType("biorad_x");
    private static final RealType rt_y = RealType.getRealType("biorad_y");
    private static final TextType tt_text = TextType.getTextType("biorad_text");
    static final TupleType noteTuple = BioRadNote.makeNoteTuple();
    int level;
    int num;
    int status;
    int type;
    int x;
    int y;
    String text;
    Data metadata;
    double origin;
    double step;
    boolean time;

    private static TupleType makeNoteTuple() {
        try {
            if (rt_level == null) {
                System.out.println("level is null");
            }
            if (rt_num == null) {
                System.out.println("num is null");
            }
            if (rt_status == null) {
                System.out.println("status is null");
            }
            if (rt_type == null) {
                System.out.println("type is null");
            }
            if (rt_x == null) {
                System.out.println("x is null");
            }
            if (rt_y == null) {
                System.out.println("y is null");
            }
            if (tt_text == null) {
                System.out.println("text is null");
            }
            return new TupleType(new MathType[]{rt_level, rt_num, rt_status, rt_type, rt_x, rt_y, tt_text});
        }
        catch (VisADException exc) {
            return null;
        }
    }

    public BioRadNote(int level, int num, int status, int type, int x, int y, String text) {
        this.level = level;
        this.num = num;
        this.status = status;
        this.type = type;
        this.x = x;
        this.y = y;
        this.text = text;
    }

    public DataImpl getNoteData() {
        try {
            Data[] d = new DataImpl[]{new Real(rt_level, (double)this.level), new Real(rt_num, (double)this.num), new Real(rt_status, (double)this.status), new Real(rt_type, (double)this.type), new Real(rt_x, (double)this.x), new Real(rt_y, (double)this.y), new Text(tt_text, this.text)};
            return new Tuple(noteTuple, d, false);
        }
        catch (VisADException exc) {
        }
        catch (RemoteException exc) {
        }
        return null;
    }

    public boolean hasUnitInfo() {
        int sp;
        if (this.type == 20 && (sp = this.text.indexOf(" ")) >= 0) {
            String v = this.text.substring(0, sp).trim();
            String value = this.text.substring(sp + 1).trim();
            if (v.equals("AXIS_2") || v.equals("AXIS_3")) {
                return true;
            }
        }
        return false;
    }

    public int analyze() {
        if (this.type == 8) {
            StringTokenizer st = new StringTokenizer(this.text);
            if (st.countTokens() != 4) {
                this.warn();
                return -1;
            }
            String v = st.nextToken();
            String eq = st.nextToken();
            int length = -1;
            int angle = -1;
            try {
                length = Integer.parseInt(st.nextToken());
                angle = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            if (!v.equals("SCALEBAR") || !eq.equals("=") || length < 0 || angle < 0) {
                this.warn();
                return -1;
            }
            return 0;
        }
        if (this.type == 10) {
            return -1;
        }
        if (this.type == 11) {
            StringTokenizer st = new StringTokenizer(this.text);
            if (st.countTokens() != 6) {
                this.warn();
                return -1;
            }
            String v = st.nextToken();
            String eq = st.nextToken();
            int lx = -1;
            int ly = -1;
            int angle = -1;
            try {
                lx = Integer.parseInt(st.nextToken());
                ly = Integer.parseInt(st.nextToken());
                angle = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
            String fill_type = st.nextToken();
            if (!v.equals("ARROW") || !eq.equals("=") || lx < 0 || ly < 0 || angle < 0 || !fill_type.equals("Fill") && !fill_type.equals("Outline")) {
                this.warn(v);
                return -1;
            }
            return 0;
        }
        if (this.type == 20) {
            int sp = this.text.indexOf(" ");
            if (sp < 0) {
                this.warn();
                return -1;
            }
            String v = this.text.substring(0, sp).trim();
            String value = this.text.substring(sp + 1).trim();
            if (v.equals("SCALE_FACTOR") || v.equals("LENS_MAGNIFICATION") || v.equals("RAMP_GAMMA1") || v.equals("RAMP_GAMMA2") || v.equals("RAMP_GAMMA3") || v.equals("RAMP1_MIN") || v.equals("RAMP2_MIN") || v.equals("RAMP3_MIN") || v.equals("RAMP1_MAX") || v.equals("RAMP2_MAX") || v.equals("RAMP3_MAX") || v.equals("PIC_FF_VERSION") || v.equals("Z_CORRECT_FACTOR") || v.equals("AXIS_0") || v.equals("AXIS_1") || v.equals("AXIS_4") || v.equals("AXIS_5") || v.equals("AXIS_6") || v.equals("AXIS_7") || v.equals("AXIS_8") || v.equals("AXIS_9") || v.equals("AXIS_21")) {
                double dv;
                try {
                    dv = Double.parseDouble(value);
                }
                catch (NumberFormatException exc) {
                    this.warn();
                    return -1;
                }
                this.metadata = new Real(RealType.getRealType(v), dv);
                return 1;
            }
            if (v.equals("AXIS_2")) {
                StringTokenizer st = new StringTokenizer(value);
                if (st.countTokens() != 4) {
                    this.warn(v);
                    return -1;
                }
                int type = -1;
                int origin = -1;
                int inc = -1;
                try {
                    type = Integer.parseInt(st.nextToken());
                    origin = Integer.parseInt(st.nextToken());
                    inc = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (type < 0 || origin < 0 || inc < 0) {
                    this.warn(v);
                    return -1;
                }
                String label = st.nextToken();
                if (type != 1) {
                    this.warn(v);
                    return -1;
                }
                this.origin = origin;
                this.step = inc;
                this.time = false;
                return 2;
            }
            if (v.equals("AXIS_3")) {
                StringTokenizer st = new StringTokenizer(value);
                if (st.countTokens() != 4) {
                    this.warn(v);
                    return -1;
                }
                int type = -1;
                int origin = -1;
                int inc = -1;
                try {
                    type = Integer.parseInt(st.nextToken());
                    origin = Integer.parseInt(st.nextToken());
                    inc = Integer.parseInt(st.nextToken());
                }
                catch (NumberFormatException exc) {
                    // empty catch block
                }
                if (type < 0 || origin < 0 || inc < 0) {
                    this.warn(v);
                    return -1;
                }
                String label = st.nextToken();
                if (type == 1) {
                    this.origin = origin;
                    this.step = inc;
                    this.time = false;
                    return 3;
                }
                if (type == 2) {
                    this.origin = origin;
                    this.step = inc;
                    this.time = true;
                    return 3;
                }
                this.warn();
                return -1;
            }
            this.warn(v);
            return -1;
        }
        if (this.type == 21) {
            return 0;
        }
        return 0;
    }

    public void write(DataOutputStream out, boolean more) throws IOException {
        BioRadForm.writeShort(out, this.level);
        BioRadForm.writeInt(out, more ? 1 : 0);
        BioRadForm.writeShort(out, this.num);
        BioRadForm.writeShort(out, this.status);
        BioRadForm.writeShort(out, this.type);
        BioRadForm.writeShort(out, this.x);
        BioRadForm.writeShort(out, this.y);
        BioRadForm.writeString(out, this.text, 80);
    }

    private void warn() {
        this.warn(null);
    }

    private void warn(String subType) {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        boolean a = (this.status & 0x100) != 0;
        boolean d = (this.status & 0x200) != 0;
        boolean p = (this.status & 0x400) != 0;
        sb.append("Note: level=" + this.level + ", num=" + this.num + ", status=");
        boolean first = true;
        if (a) {
            sb.append("NOTE_STATUS_ALL");
            first = false;
        }
        if (d) {
            if (!first) {
                sb.append("|");
            }
            sb.append("NOTE_STATUS_DISPLAY");
            first = false;
        }
        if (p) {
            if (!first) {
                sb.append("|");
            }
            sb.append("NOTE_STATUS_POSITION");
            first = false;
        }
        if (first) {
            sb.append("NONE");
        }
        sb.append(", type=" + noteNames[this.type] + ", x=" + this.x + ", y=" + this.y + ", text=" + (this.text == null ? "null" : this.text.trim()));
        return sb.toString();
    }

    public static BioRadNote getUnitNote(Unit u, Linear1DSet set, boolean xAxis) {
        double inc;
        double origin;
        if (u == null || set == null) {
            return null;
        }
        boolean time = u.isConvertible(second);
        if (!time && !u.isConvertible(micron)) {
            return null;
        }
        int axis_type = time ? 2 : 1;
        try {
            origin = u.toThat(set.getFirst(), time ? second : micron);
            inc = u.toThat(set.getStep(), time ? second : micron);
        }
        catch (UnitException exc) {
            return null;
        }
        String label = "Calibration unknown";
        int level = 1;
        int num = 0;
        int status = 1280;
        int type = 20;
        int x = 0;
        int y = 0;
        String text = "AXIS_" + (xAxis ? "2" : "3") + " " + axis_type + " " + origin + " " + inc + " " + label;
        return new BioRadNote(level, num, status, type, x, y, text);
    }
}

