/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.CacheStrategy;
import visad.data.DefaultFamily;
import visad.data.FileAccessor;
import visad.data.FileFlatField;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.data.bio.BioRadNote;

public class BioRadForm
extends Form
implements FormFileInformer,
FormProgressInformer,
FormBlockReader {
    static final boolean DEBUG = false;
    static final int DEBUG_LEVEL = 1;
    private static final int PIC_FILE_ID = 12345;
    private static final int MERGE_OFF = 0;
    private static final int MERGE_16 = 1;
    private static final int MERGE_ALTERNATE = 2;
    private static final int MERGE_COLUMN = 3;
    private static final int MERGE_ROW = 4;
    private static final int MERGE_MAXIMUM = 5;
    private static final int MERGE_OPT12 = 6;
    private static final int MERGE_OPT12_V2 = 7;
    private static final String[] mergeNames = new String[]{"MERGE_OFF", "MERGE_16", "MERGE_ALTERNATE", "MERGE_COLUMN", "MERGE_ROW", "MERGE_MAXIMUM", "MERGE_OPT12", "MERGE_OPT12_V2"};
    private static final int RED_LUT = 1;
    private static final int GREEN_LUT = 2;
    private static final int BLUE_LUT = 4;
    private static final RealType noteIndex = RealType.getRealType("NoteIndex");
    private static final RealType rt_ramp1_min = RealType.getRealType("ramp1_min");
    private static final RealType rt_ramp1_max = RealType.getRealType("ramp1_max");
    private static final RealType rt_byte_format = RealType.getRealType("byte_format");
    private static final TextType tt_name = TextType.getTextType("name");
    private static final RealType rt_ramp2_min = RealType.getRealType("ramp2_min");
    private static final RealType rt_ramp2_max = RealType.getRealType("ramp2_max");
    private static final RealType rt_lens = RealType.getRealType("lens");
    private static final RealType rt_mag_factor = RealType.getRealType("mag_factor");
    private static final String[] noteVarNames = new String[]{"SCALE_FACTOR", "LENS_MAGNIFICATION", "RAMP_GAMMA1", "RAMP_GAMMA2", "RAMP_GAMMA3", "RAMP1_MIN", "RAMP2_MIN", "RAMP3_MIN", "RAMP1_MAX", "RAMP2_MAX", "RAMP3_MAX", "PIC_FF_VERSION", "Z_CORRECT_FACTOR"};
    private static CacheStrategy strategy = new CacheStrategy();
    private static int num = 0;
    private static MathType image;
    private static MathType imageSequence;
    private static MathType table;
    private static MathType tableSequence;
    private static FunctionType noteFunction;
    private String current_id;
    private RandomAccessFile in;
    private int nx;
    private int ny;
    private int npic;
    private int ramp1_min;
    private int ramp1_max;
    private String name;
    private int ramp2_min;
    private int ramp2_max;
    private int lens;
    private float mag_factor;
    private boolean notes;
    private boolean byte_format;
    private double percent;

    public BioRadForm() {
        super("BioRadForm" + num++);
    }

    public boolean isThisType(String name) {
        return name.toLowerCase().endsWith(".pic");
    }

    public boolean isThisType(byte[] block) {
        if (block.length < 56) {
            return false;
        }
        return BioRadForm.getUnsignedShort(block[54], block[55]) == 12345;
    }

    public String[] getDefaultSuffixes() {
        return new String[]{"pic"};
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        int index;
        int j;
        double[] samp;
        double[][] samples;
        FlatField d;
        int i;
        byte[] imageBytes;
        float mag_factor;
        int numTables;
        FlatField d2;
        Set set;
        data = data.local();
        Vector<Data> v = new Vector<Data>();
        if (data instanceof Tuple) {
            Tuple t = (Tuple)data;
            int i2 = 0;
            while (i2 < t.getDimension()) {
                v.add(t.getComponent(i2));
                ++i2;
            }
        } else {
            v.add(data);
        }
        Vector<Data> v_images = new Vector<Data>();
        Vector<Data> v_tables = new Vector<Data>();
        Vector<BioRadNote> v_notes = new Vector<BioRadNote>();
        Real r_ramp1_min = null;
        Real r_ramp1_max = null;
        Real r_byte_format = null;
        Text t_name = null;
        Real r_ramp2_min = null;
        Real r_ramp2_max = null;
        Real r_lens = null;
        Real r_mag_factor = null;
        boolean hasNoteTuple = false;
        int len = v.size();
        int i3 = 0;
        while (i3 < len) {
            DataImpl d3 = (DataImpl)v.elementAt(i3);
            MathType mt = d3.getType();
            if (mt.equalsExceptName(image)) {
                v_images.add(d3);
            } else if (mt.equalsExceptName(imageSequence)) {
                FieldImpl f = (FieldImpl)d3;
                int flen = f.getLength();
                int j2 = 0;
                while (j2 < flen) {
                    v_images.add(f.getSample(j2));
                    ++j2;
                }
            } else if (mt.equalsExceptName(table)) {
                v_tables.add(d3);
            } else if (mt.equalsExceptName(tableSequence)) {
                FieldImpl f = (FieldImpl)d3;
                int flen = f.getLength();
                int j3 = 0;
                while (j3 < flen) {
                    v_tables.add(f.getSample(j3));
                    ++j3;
                }
            } else if (mt.equalsExceptName(noteFunction)) {
                v_notes.removeAllElements();
                FieldImpl f = (FieldImpl)d3;
                int flen = f.getLength();
                int j4 = 0;
                while (j4 < flen) {
                    Tuple t = (Tuple)f.getSample(j4);
                    Real r_level = (Real)t.getComponent(0);
                    Real r_num = (Real)t.getComponent(1);
                    Real r_status = (Real)t.getComponent(2);
                    Real r_type = (Real)t.getComponent(3);
                    Real r_x = (Real)t.getComponent(4);
                    Real r_y = (Real)t.getComponent(5);
                    Text t_text = (Text)t.getComponent(6);
                    int level = (int)r_level.getValue();
                    int num = (int)r_num.getValue();
                    int status = (int)r_status.getValue();
                    int type = (int)r_type.getValue();
                    int x = (int)r_x.getValue();
                    int y = (int)r_y.getValue();
                    String text = t_text.getValue();
                    BioRadNote note = new BioRadNote(level, num, status, type, x, y, text);
                    v_notes.add(note);
                    ++j4;
                }
                hasNoteTuple = true;
            } else if (mt.equals(rt_ramp1_min)) {
                r_ramp1_min = (Real)d3;
            } else if (mt.equals(rt_ramp1_max)) {
                r_ramp1_max = (Real)d3;
            } else if (mt.equals(rt_byte_format)) {
                r_byte_format = (Real)d3;
            } else if (mt.equals(tt_name)) {
                t_name = (Text)d3;
            } else if (mt.equals(rt_ramp2_min)) {
                r_ramp2_min = (Real)d3;
            } else if (mt.equals(rt_ramp2_max)) {
                r_ramp2_max = (Real)d3;
            } else if (mt.equals(rt_lens)) {
                r_lens = (Real)d3;
            } else if (mt.equals(rt_mag_factor)) {
                r_mag_factor = (Real)d3;
            } else {
                boolean ok = false;
                if (mt instanceof RealType) {
                    if (hasNoteTuple) {
                        ok = true;
                    } else {
                        RealType rt = (RealType)mt;
                        String rtName = rt.getName();
                        int j5 = 0;
                        while (j5 < noteVarNames.length) {
                            if (rtName.equals(noteVarNames[j5])) {
                                BioRadNote note = new BioRadNote(1, 0, 1280, 20, 0, 0, rtName + " " + ((Real)d3).getValue());
                                v_notes.add(note);
                                ok = true;
                            }
                            ++j5;
                        }
                    }
                }
                if (!ok) {
                    throw new BadFormException("Unsupported data object");
                }
            }
            ++i3;
        }
        int xlen = -1;
        int ylen = -1;
        int numImages = v_images.size();
        int i4 = 0;
        while (i4 < numImages) {
            Object o = v_images.elementAt(i4);
            if (!(o instanceof FlatField)) {
                throw new BadFormException("Invalid image data");
            }
            FlatField d4 = (FlatField)o;
            Set set2 = d4.getDomainSet();
            if (!(set2 instanceof GriddedSet)) {
                throw new BadFormException("Invalid image set");
            }
            GriddedSet gset = (GriddedSet)set2;
            if (gset.getDimension() != 2) {
                throw new BadFormException("Invalid domain dimension");
            }
            if (gset.getManifoldDimension() != 2) {
                throw new BadFormException("Invalid manifold dimension");
            }
            int[] l = gset.getLengths();
            if (xlen < 0) {
                xlen = l[0];
                ylen = l[1];
            } else if (xlen != l[0] || ylen != l[1]) {
                throw new BadFormException("All images must have same width and height");
            }
            double[][] samples2 = d4.getValues(false);
            if (samples2.length != 1 || samples2[0].length != xlen * ylen) {
                throw new BadFormException("Invalid image samples");
            }
            ++i4;
        }
        if (!hasNoteTuple && (set = (d2 = (FlatField)v_images.elementAt(0)).getDomainSet()) instanceof Linear2DSet) {
            Linear2DSet lset = (Linear2DSet)set;
            Linear1DSet xset = lset.getX();
            Linear1DSet yset = lset.getY();
            Unit[] u = set.getSetUnits();
            Unit xu = u[0];
            Unit yu = u[1];
            BioRadNote xNote = BioRadNote.getUnitNote(xu, xset, true);
            BioRadNote yNote = BioRadNote.getUnitNote(yu, yset, false);
            if (xNote != null) {
                v_notes.add(xNote);
            }
            if (yNote != null) {
                v_notes.add(yNote);
            }
        }
        if ((numTables = v_tables.size()) > 3) {
            throw new BadFormException("Too many color tables");
        }
        int i5 = 0;
        while (i5 < numTables) {
            Object o = v_tables.elementAt(i5);
            if (!(o instanceof FlatField)) {
                throw new BadFormException("Invalid color table data");
            }
            FlatField d5 = (FlatField)o;
            Set set3 = d5.getDomainSet();
            if (!(set3 instanceof Gridded1DSet)) {
                throw new BadFormException("Invalid color table set");
            }
            Gridded1DSet gset = (Gridded1DSet)set3;
            int[] l = gset.getLengths();
            if (l[0] != 256) {
                throw new BadFormException("Invalid color table length");
            }
            ++i5;
        }
        int nx = xlen;
        int ny = ylen;
        int npic = numImages;
        int ramp1_min = r_ramp1_min == null ? 0 : (int)r_ramp1_min.getValue();
        int ramp1_max = r_ramp1_max == null ? 255 : (int)r_ramp1_max.getValue();
        int notes = v_notes.size();
        int byte_format = r_byte_format == null ? 1 : (int)r_byte_format.getValue();
        int image_number = 0;
        String name = t_name == null ? id : t_name.getValue();
        int merged = 0;
        int color1 = 7;
        int file_id = 12345;
        int ramp2_min = r_ramp2_min == null ? 0 : (int)r_ramp2_min.getValue();
        int ramp2_max = r_ramp2_max == null ? 255 : (int)r_ramp2_max.getValue();
        int color2 = 7;
        int edited = 1;
        int lens = r_lens == null ? 0 : (int)r_lens.getValue();
        float f = mag_factor = r_mag_factor == null ? 0.0f : (float)r_mag_factor.getValue();
        if (byte_format == 0) {
            imageBytes = new byte[2 * npic * nx * ny];
            i = 0;
            while (i < npic) {
                d = (FlatField)v_images.elementAt(i);
                samples = d.getValues(false);
                samp = samples[0];
                j = 0;
                while (j < samp.length) {
                    index = 2 * (samp.length * i + j);
                    int q = (int)samp[j];
                    int qhi = (0xFF00 & q) >> 8;
                    int qlo = 0xFF & q;
                    imageBytes[index] = (byte)qhi;
                    imageBytes[index + 1] = (byte)qlo;
                    ++j;
                }
                ++i;
            }
        } else {
            imageBytes = new byte[npic * nx * ny];
            i = 0;
            while (i < npic) {
                d = (FlatField)v_images.elementAt(i);
                samples = d.getValues(false);
                samp = samples[0];
                j = 0;
                while (j < samp.length) {
                    index = samp.length * i + j;
                    imageBytes[index] = (byte)samp[j];
                    ++j;
                }
                ++i;
            }
        }
        byte[] tableBytes = new byte[numTables * 768];
        int i6 = 0;
        while (i6 < numTables) {
            FlatField d6 = (FlatField)v_tables.elementAt(i6);
            double[][] samples3 = d6.getValues(false);
            double[] sr = samples3[0];
            double[] sg = samples3[1];
            double[] sb = samples3[2];
            int j6 = 0;
            while (j6 < 256) {
                int index2 = 768 * i6 + j6;
                tableBytes[index2] = (byte)sr[j6];
                tableBytes[index2 + 256] = (byte)sg[j6];
                tableBytes[index2 + 512] = (byte)sb[j6];
                ++j6;
            }
            ++i6;
        }
        DataOutputStream fout = new DataOutputStream(new FileOutputStream(id));
        BioRadForm.writeShort(fout, nx);
        BioRadForm.writeShort(fout, ny);
        BioRadForm.writeShort(fout, npic);
        BioRadForm.writeShort(fout, ramp1_min);
        BioRadForm.writeShort(fout, ramp1_max);
        BioRadForm.writeInt(fout, notes);
        BioRadForm.writeShort(fout, byte_format);
        BioRadForm.writeShort(fout, image_number);
        BioRadForm.writeString(fout, name, 32);
        BioRadForm.writeShort(fout, merged);
        BioRadForm.writeShort(fout, color1);
        BioRadForm.writeShort(fout, file_id);
        BioRadForm.writeShort(fout, ramp2_min);
        BioRadForm.writeShort(fout, ramp2_max);
        BioRadForm.writeShort(fout, color2);
        BioRadForm.writeShort(fout, edited);
        BioRadForm.writeShort(fout, lens);
        BioRadForm.writeFloat(fout, mag_factor);
        fout.write(new byte[]{0, 0, 0, 0, 0, 0}, 0, 6);
        fout.write(imageBytes, 0, imageBytes.length);
        int i7 = 0;
        while (i7 < notes) {
            BioRadNote note = (BioRadNote)v_notes.elementAt(i7);
            note.write(fout, i7 != notes - 1);
            ++i7;
        }
        fout.write(tableBytes, 0, tableBytes.length);
        fout.close();
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("BioRadForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        return this.open(new FileInputStream(id));
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        return this.open(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataImpl open(InputStream in) throws BadFormException, IOException, VisADException {
        DataImpl dataImpl;
        try {
            dataImpl = this.readFile(new DataInputStream(in), false);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                in.close();
            }
            catch (IOException ioe) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return dataImpl;
    }

    DataImpl readFile(DataInput fin, boolean isRandom) throws IOException, RemoteException, VisADException {
        float[][][] samples;
        long filePtr;
        this.initStream(fin);
        this.percent = 0.0;
        int image_len = this.nx * this.ny;
        if (isRandom) {
            filePtr = ((RandomAccessFile)fin).getFilePointer();
            fin.skipBytes(this.npic * image_len);
            samples = null;
            this.percent = 100.0;
        } else {
            filePtr = 0L;
            samples = new float[this.npic][1][image_len];
            if (this.byte_format) {
                byte[] buf = new byte[image_len];
                int i = 0;
                while (i < this.npic) {
                    fin.readFully(buf);
                    int l = 0;
                    while (l < image_len) {
                        int q = 0xFF & buf[l];
                        samples[i][0][l] = q;
                        ++l;
                    }
                    this.percent = (double)(i + 1) / (double)this.npic;
                    ++i;
                }
            } else {
                int data_len = 2 * image_len;
                byte[] buf = new byte[data_len];
                int i = 0;
                while (i < this.npic) {
                    fin.readFully(buf);
                    int l = 0;
                    while (l < data_len) {
                        int q = BioRadForm.getUnsignedShort(buf[l], buf[l + 1]);
                        samples[i][0][l / 2] = q;
                        l += 2;
                    }
                    this.percent = (double)(i + 1) / (double)this.npic;
                    ++i;
                }
            }
        }
        Vector<BioRadNote> noteList = new Vector<BioRadNote>();
        while (this.notes) {
            byte[] note = new byte[96];
            fin.readFully(note);
            int level = BioRadForm.getUnsignedShort(note[0], note[1]);
            this.notes = (note[2] | note[3] | note[4] | note[5]) != 0;
            int num = BioRadForm.getUnsignedShort(note[6], note[7]);
            int status = BioRadForm.getUnsignedShort(note[8], note[9]);
            int type = BioRadForm.getUnsignedShort(note[10], note[11]);
            int x = BioRadForm.getUnsignedShort(note[12], note[13]);
            int y = BioRadForm.getUnsignedShort(note[14], note[15]);
            String text = new String(note, 16, 80);
            noteList.add(new BioRadNote(level, num, status, type, x, y, text));
        }
        int numLuts = 0;
        byte[][] lut = new byte[3][768];
        boolean eof = false;
        while (!eof && numLuts < 3) {
            try {
                fin.readFully(lut[numLuts]);
                ++numLuts;
            }
            catch (IOException exc) {
                eof = true;
            }
        }
        int len = noteList.size();
        Data[] noteData = new DataImpl[len];
        int i = 0;
        while (i < len) {
            BioRadNote note = (BioRadNote)noteList.elementAt(i);
            noteData[i] = note.getNoteData();
            ++i;
        }
        FieldImpl noteField = null;
        if (len > 0) {
            Integer1DSet noteSet = new Integer1DSet(len);
            noteField = new FieldImpl(noteFunction, noteSet);
            noteField.setSamples(noteData, false);
        }
        double horizOffset = 0.0;
        double vertOffset = 0.0;
        double horizStep = 0.0;
        double vertStep = 0.0;
        Unit horizUnit = null;
        Unit vertUnit = null;
        int n = 0;
        while (n < noteList.size()) {
            BioRadNote note = (BioRadNote)noteList.elementAt(n);
            if (note.hasUnitInfo()) {
                int rval = note.analyze();
                if (rval == 2) {
                    if (horizStep == 0.0) {
                        horizOffset = note.origin;
                        horizStep = note.step;
                        horizUnit = BioRadNote.micron;
                    }
                    noteList.remove(n);
                    continue;
                }
                if (rval == 3) {
                    if (vertStep == 0.0) {
                        vertOffset = note.origin;
                        vertStep = note.step;
                        vertUnit = note.time ? BioRadNote.second : BioRadNote.micron;
                    }
                    noteList.remove(n);
                    continue;
                }
                if (rval == -1 || rval == 0) {
                    noteList.remove(n);
                    continue;
                }
                ++n;
                continue;
            }
            ++n;
        }
        if (horizStep == 0.0) {
            horizStep = 1.0;
        }
        if (vertStep == 0.0) {
            vertStep = 1.0;
        }
        float[][][] colors = new float[numLuts][3][256];
        int i2 = 0;
        while (i2 < numLuts) {
            int l = 0;
            while (l < 256) {
                int qr = 0xFF & lut[i2][l];
                int qg = 0xFF & lut[i2][l + 256];
                int qb = 0xFF & lut[i2][l + 512];
                colors[i2][0][l] = qr;
                colors[i2][1][l] = qg;
                colors[i2][2][l] = qb;
                ++l;
            }
            ++i2;
        }
        RealType index = RealType.getRealType("index");
        RealType x = RealType.getRealType("ImageElement", horizUnit);
        RealType y = RealType.getRealType("ImageLine", vertUnit);
        RealType value = RealType.getRealType("intensity");
        RealTupleType xy = new RealTupleType(x, y);
        FunctionType imageFunction = new FunctionType(xy, value);
        FunctionType stackFunction = new FunctionType(index, imageFunction);
        Linear2DSet imageSet = new Linear2DSet(xy, horizOffset, horizOffset + (double)(this.nx - 1) * horizStep, this.nx, vertOffset, vertOffset + (double)(this.ny - 1) * vertStep, this.ny, null, new Unit[]{horizUnit, vertUnit}, null);
        Integer1DSet stackSet = new Integer1DSet((MathType)index, this.npic);
        Data[] imageFields = new FlatField[this.npic];
        int i3 = 0;
        while (i3 < this.npic) {
            if (isRandom) {
                BioRadAccessor acc = new BioRadAccessor((RandomAccessFile)fin, filePtr, i3, imageFunction, imageSet, image_len, this.byte_format);
                imageFields[i3] = new FileFlatField(acc, strategy);
            } else {
                imageFields[i3] = new FlatField(imageFunction, imageSet);
                ((FlatField)imageFields[i3]).setSamples(samples[i3], false);
            }
            ++i3;
        }
        FieldImpl stackField = new FieldImpl(stackFunction, stackSet);
        stackField.setSamples(imageFields, false);
        FieldImpl colorField = null;
        if (numLuts > 0) {
            RealType tableNum = RealType.getRealType("TableNumber");
            RealType red = RealType.getRealType("Red");
            RealType green = RealType.getRealType("Green");
            RealType blue = RealType.getRealType("Blue");
            RealTupleType rgb = new RealTupleType(red, green, blue);
            FunctionType rgbFunction = new FunctionType(value, rgb);
            FunctionType colorFunction = new FunctionType(tableNum, rgbFunction);
            Integer1DSet rgbSet = new Integer1DSet(256);
            Integer1DSet colorSet = new Integer1DSet(numLuts);
            Data[] rgbFields = new FlatField[numLuts];
            int i4 = 0;
            while (i4 < numLuts) {
                rgbFields[i4] = new FlatField(rgbFunction, rgbSet);
                ((FlatField)rgbFields[i4]).setSamples(colors[i4], false);
                ++i4;
            }
            colorField = new FieldImpl(colorFunction, colorSet);
            colorField.setSamples(rgbFields, false);
        }
        Real r_ramp1_min = new Real(rt_ramp1_min, (double)this.ramp1_min);
        Real r_ramp1_max = new Real(rt_ramp1_max, (double)this.ramp1_max);
        Real r_byte_format = new Real(rt_byte_format, this.byte_format ? 1.0 : 0.0);
        Text t_name = new Text(tt_name, this.name);
        Real r_ramp2_min = new Real(rt_ramp2_min, (double)this.ramp2_min);
        Real r_ramp2_max = new Real(rt_ramp2_max, (double)this.ramp2_max);
        Real r_lens = new Real(rt_lens, (double)this.lens);
        Real r_mag_factor = new Real(rt_mag_factor, (double)this.mag_factor);
        Vector<Data> data = new Vector<Data>();
        data.add(stackField);
        if (colorField != null) {
            data.add(colorField);
        }
        if (noteField != null) {
            data.add(noteField);
        }
        data.add(r_ramp1_min);
        data.add(r_ramp1_max);
        data.add(r_byte_format);
        data.add(t_name);
        data.add(r_ramp2_min);
        data.add(r_ramp2_max);
        data.add(r_lens);
        data.add(r_mag_factor);
        len = noteList.size();
        int i5 = 0;
        while (i5 < len) {
            BioRadNote note = (BioRadNote)noteList.elementAt(i5);
            int rval = note.analyze();
            if (rval == 1) {
                data.add(note.metadata);
            }
            ++i5;
        }
        Object[] dataArray = new Data[data.size()];
        data.copyInto(dataArray);
        Tuple tuple = new Tuple((Data[])dataArray, false);
        this.percent = -1.0;
        return tuple;
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initStream(new RandomAccessFile(id, "r"));
            this.current_id = id;
        }
        if (block_number < 0 || block_number >= this.npic) {
            throw new BadFormException("Invalid image number: " + block_number);
        }
        int image_len = this.nx * this.ny;
        float[][] samples = new float[1][image_len];
        if (this.byte_format) {
            this.in.seek(block_number * image_len + 76);
            byte[] buf = new byte[image_len];
            this.in.readFully(buf);
            int l = 0;
            while (l < image_len) {
                int q = 0xFF & buf[l];
                samples[0][l] = q;
                ++l;
            }
        } else {
            this.in.seek(block_number * 2 * image_len + 76);
            int data_len = 2 * image_len;
            byte[] buf = new byte[data_len];
            this.in.readFully(buf);
            int l = 0;
            while (l < data_len) {
                int q = BioRadForm.getUnsignedShort(buf[l], buf[l + 1]);
                samples[0][l / 2] = q;
                l += 2;
            }
        }
        RealType index = RealType.getRealType("index");
        RealType x = RealType.getRealType("ImageElement");
        RealType y = RealType.getRealType("ImageLine");
        RealType value = RealType.getRealType("intensity");
        RealTupleType xy = new RealTupleType(x, y);
        FunctionType imageFunction = new FunctionType(xy, value);
        FunctionType stackFunction = new FunctionType(index, imageFunction);
        Integer2DSet imageSet = new Integer2DSet((MathType)xy, this.nx, this.ny);
        FlatField field = new FlatField(imageFunction, imageSet);
        field.setSamples(samples, false);
        return field;
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initStream(new RandomAccessFile(id, "r"));
            this.current_id = id;
        }
        return this.npic;
    }

    public void close() throws BadFormException, IOException, VisADException {
        if (this.current_id == null) {
            return;
        }
        this.in.close();
        this.current_id = null;
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private static int getUnsignedShort(byte b1, byte b2) {
        int i1 = 0xFF & b1;
        int i2 = 0xFF & b2;
        return i2 << 8 | i1;
    }

    private static float getFloat(byte b1, byte b2, byte b3, byte b4) {
        int i1 = 0xFF & b1;
        int i2 = 0xFF & b2;
        int i3 = 0xFF & b3;
        int i4 = 0xFF & b4;
        int bits = i4 << 24 | i3 << 16 | i2 << 8 | i1;
        return Float.intBitsToFloat(bits);
    }

    static void writeShort(DataOutputStream out, int val) throws IOException {
        int q0 = 0xFF & val;
        int q1 = (0xFF00 & val) >> 8;
        byte[] b = new byte[]{(byte)q0, (byte)q1};
        out.write(b, 0, 2);
    }

    static void writeInt(DataOutputStream out, int val) throws IOException {
        int q0 = 0xFF & val;
        int q1 = (0xFF00 & val) >> 8;
        int q2 = (0xFF0000 & val) >> 16;
        int q3 = (0xFF000000 & val) >> 24;
        byte[] b = new byte[]{(byte)q0, (byte)q1, (byte)q2, (byte)q3};
        out.write(b, 0, 4);
    }

    static void writeFloat(DataOutputStream out, float val) throws IOException {
        int q = Float.floatToIntBits(val);
        int q0 = (0xFF & q) << 24;
        int q1 = (0xFF00 & q) << 8;
        int q2 = (0xFF0000 & q) >> 8;
        int q3 = (0xFF000000 & q) >> 24;
        byte[] b = new byte[]{(byte)q0, (byte)q1, (byte)q2, (byte)q3};
        out.write(b, 0, 4);
    }

    static void writeString(DataOutputStream out, String s, int len) throws IOException {
        byte[] b = s.getBytes();
        byte[] bytes = new byte[len];
        System.arraycopy(b, 0, bytes, 0, b.length < len ? b.length : len);
        out.write(bytes, 0, len);
    }

    private void initStream(DataInput fin) throws BadFormException, IOException, VisADException {
        this.close();
        byte[] header = new byte[76];
        fin.readFully(header);
        this.nx = BioRadForm.getUnsignedShort(header[0], header[1]);
        this.ny = BioRadForm.getUnsignedShort(header[2], header[3]);
        this.npic = BioRadForm.getUnsignedShort(header[4], header[5]);
        this.ramp1_min = BioRadForm.getUnsignedShort(header[6], header[7]);
        this.ramp1_max = BioRadForm.getUnsignedShort(header[8], header[9]);
        this.notes = (header[10] | header[11] | header[12] | header[13]) != 0;
        this.byte_format = BioRadForm.getUnsignedShort(header[14], header[15]) != 0;
        int image_number = BioRadForm.getUnsignedShort(header[16], header[17]);
        this.name = new String(header, 18, 32);
        int merged = BioRadForm.getUnsignedShort(header[50], header[51]);
        int color1 = BioRadForm.getUnsignedShort(header[52], header[53]);
        int file_id = BioRadForm.getUnsignedShort(header[54], header[55]);
        this.ramp2_min = BioRadForm.getUnsignedShort(header[56], header[57]);
        this.ramp2_max = BioRadForm.getUnsignedShort(header[58], header[59]);
        int color2 = BioRadForm.getUnsignedShort(header[60], header[61]);
        int edited = BioRadForm.getUnsignedShort(header[62], header[63]);
        this.lens = BioRadForm.getUnsignedShort(header[64], header[65]);
        this.mag_factor = BioRadForm.getFloat(header[66], header[67], header[68], header[69]);
        if (file_id != 12345) {
            throw new BadFormException("Invalid file header: " + file_id);
        }
        if (fin instanceof RandomAccessFile) {
            this.in = (RandomAccessFile)fin;
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to Bio-Rad .PIC, run:");
            System.out.println("  java visad.data.bio.BioRadForm in_file out_file");
            System.out.println("To test read a Bio-Rad .PIC file, run:");
            System.out.println("  java visad.data.bio.BioRadForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            BioRadForm form = new BioRadForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            BioRadForm form = new BioRadForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }

    static {
        try {
            image = MathType.stringToType("((x, y) -> a)");
            imageSequence = MathType.stringToType("(t -> ((x, y) -> a))");
            table = MathType.stringToType("(value -> (r, g, b))");
            tableSequence = MathType.stringToType("(t -> (value -> (r, g, b)))");
            noteFunction = new FunctionType(noteIndex, BioRadNote.noteTuple);
        }
        catch (VisADException exc) {}
    }

    class BioRadAccessor
    extends FileAccessor {
        private final RandomAccessFile rdr;
        private final long filePtr;
        private final int imageNumber;
        private final FunctionType imageType;
        private final Linear2DSet imageSet;
        private final int imageLen;
        private final boolean byteFmt;

        public BioRadAccessor(RandomAccessFile rdr, long filePtr, int imageNumber, FunctionType imageType, Linear2DSet imageSet, int imageLen, boolean byteFmt) {
            this.rdr = rdr;
            this.filePtr = filePtr;
            this.imageNumber = imageNumber;
            this.imageType = imageType;
            this.imageSet = imageSet;
            this.imageLen = imageLen;
            this.byteFmt = byteFmt;
        }

        public FlatField getFlatField() throws RemoteException, VisADException {
            FlatField ff;
            byte[] buf = new byte[this.imageLen];
            float[][] samples = new float[1][this.imageLen];
            try {
                long curPtr = this.rdr.getFilePointer();
                this.rdr.seek(this.filePtr);
                if (this.imageNumber > 0) {
                    this.rdr.skipBytes(this.imageLen * this.imageNumber);
                }
                this.rdr.readFully(buf);
                if (this.byteFmt) {
                    int l = 0;
                    while (l < this.imageLen) {
                        samples[0][l] = 0xFF & buf[l];
                        ++l;
                    }
                } else {
                    int dataLen = 2 * this.imageLen;
                    int l = 0;
                    while (l < dataLen) {
                        samples[0][l / 2] = BioRadForm.getUnsignedShort(buf[l], buf[l + 1]);
                        l += 2;
                    }
                }
                ff = new FlatField(this.imageType, this.imageSet);
                ff.setSamples(samples, false);
            }
            catch (IOException ioe) {
                throw new VisADException(ioe.getClass().getName() + ": " + ioe.getMessage());
            }
            return ff;
        }

        public FunctionType getFunctionType() throws VisADException {
            return this.imageType;
        }

        public double[][] readFlatField(FlatField template, int[] fileLocations) {
            throw new RuntimeException("Unimplemented");
        }

        public void writeFile(int[] fileLocations, Data range) {
            throw new RuntimeException("Unimplemented");
        }

        public void writeFlatField(double[][] values, FlatField template, int[] fileLocations) {
            throw new RuntimeException("Unimplemented");
        }
    }
}

