/*
 * Decompiled with CFR 0.152.
 */
package visad.data.bio;

import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import ucar.netcdf.RandomAccessFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.bio.BioRadForm;

public class BioRadCachingForm
extends BioRadForm {
    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        return this.readFile(new RandomAccessFile(id, "r"), true);
    }

    public DataImpl open(URL url) throws BadFormException, VisADException, IOException {
        throw new VisADException("Cannot cache URL " + url);
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to BioRad .PIC, run:");
            System.out.println("  java visad.data.biorad.BioRadCachingForm in_file out_file");
            System.out.println("To test read a BioRad .PIC file, run:");
            System.out.println("  java visad.data.biorad.BioRadCachingForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            BioRadCachingForm form = new BioRadCachingForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            BioRadCachingForm form = new BioRadCachingForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }
}

