/*
 * Decompiled with CFR 0.152.
 */
package visad.data.avi;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.UnimplementedException;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormBlockReader;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.FormProgressInformer;
import visad.util.DataUtility;

public class AVIForm
extends Form
implements FormFileInformer,
FormBlockReader,
FormProgressInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"avi"};
    private String current_id;
    private int numImages;
    private double percent;
    private int frameRate;
    private RandomAccessFile raFile;

    public AVIForm() {
        super("AVIForm" + num++);
        this.setFrameRate(10);
    }

    public boolean isThisType(String name) {
        int i = 0;
        while (i < suffixes.length) {
            if (name.toLowerCase().endsWith(suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] s = new String[suffixes.length];
        System.arraycopy(suffixes, 0, s, 0, suffixes.length);
        return s;
    }

    public void setFrameRate(int fps) {
        this.frameRate = fps;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void save(String id, Data data, boolean replace) throws BadFormException, IOException, RemoteException, VisADException {
        int bytesPerPixel;
        this.percent = 0.0;
        FlatField[] fields = DataUtility.getImageFields(data);
        if (fields == null || fields.length < 1) {
            throw new BadFormException("Data type must be image or time sequence of images");
        }
        boolean resXUnit = false;
        boolean resYUnit = false;
        float xResol = 0.0f;
        float yResol = 0.0f;
        long biXPelsPerMeter = 0L;
        long biYPelsPerMeter = 0L;
        FunctionType ftype = (FunctionType)fields[0].getType();
        MathType range = ftype.getRange();
        if (range instanceof RealTupleType) {
            RealTupleType ttype = (RealTupleType)range;
            bytesPerPixel = ttype.getDimension();
        } else {
            bytesPerPixel = 1;
        }
        File file = new File(id);
        this.raFile = new RandomAccessFile(file, "rw");
        this.writeString("RIFF");
        long saveFileSize = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("AVI ");
        this.writeString("LIST");
        long saveLIST1Size = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("hdrl");
        this.writeString("avih");
        this.writeInt(56);
        int microSecPerFrame = (int)(1.0 / (double)this.frameRate * 1000000.0);
        this.writeInt(microSecPerFrame);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(16);
        int tDim = 1;
        int zDim = fields.length;
        Gridded2DSet set = (Gridded2DSet)fields[0].getDomainSet();
        int[] len = set.getLengths();
        int yDim = len[1];
        int xDim = len[0];
        int xPad = 0;
        int xMod = xDim % 4;
        if (xMod != 0) {
            xPad = 4 - xMod;
            xDim += xPad;
        }
        this.writeInt(zDim * tDim);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(0);
        this.writeInt(xDim - xPad);
        this.writeInt(yDim);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeString("LIST");
        long saveLIST1subSize = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeString("strl");
        this.writeString("strh");
        this.writeInt(56);
        this.writeString("vids");
        this.writeString("DIB ");
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(1);
        this.writeInt(this.frameRate);
        this.writeInt(0);
        this.writeInt(tDim * zDim);
        this.writeInt(0);
        this.writeInt(-1);
        this.writeInt(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeString("strf");
        long savestrfSize = this.raFile.getFilePointer();
        this.writeInt(0);
        this.writeInt(40);
        this.writeInt(xDim - xPad);
        this.writeInt(yDim);
        this.writeShort(1);
        int bitsPerPixel = bytesPerPixel * 8;
        this.writeShort((short)bitsPerPixel);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        if (bitsPerPixel == 8) {
            this.writeInt(256);
        } else {
            this.writeInt(0);
        }
        this.writeInt(0);
        if (bytesPerPixel == 1) {
            byte[] lutWrite = new byte[1024];
            int i = 0;
            while (i < 256) {
                lutWrite[4 * i] = (byte)i;
                lutWrite[4 * i + 1] = (byte)i;
                lutWrite[4 * i + 2] = (byte)i;
                lutWrite[4 * i + 3] = 0;
                ++i;
            }
            this.raFile.write(lutWrite);
        }
        long savestrnPos = this.raFile.getFilePointer();
        this.raFile.seek(savestrfSize);
        this.writeInt((int)(savestrnPos - (savestrfSize + 4L)));
        this.raFile.seek(savestrnPos);
        this.writeString("strn");
        this.writeInt(16);
        byte[] text = new byte[]{70, 105, 108, 101, 65, 118, 105, 32, 119, 114, 105, 116, 101, 32, 32, 0};
        this.raFile.write(text);
        long saveJUNKsignature = this.raFile.getFilePointer();
        this.raFile.seek(saveLIST1Size);
        this.writeInt((int)(saveJUNKsignature - (saveLIST1Size + 4L)));
        this.raFile.seek(saveLIST1subSize);
        this.writeInt((int)(saveJUNKsignature - (saveLIST1subSize + 4L)));
        this.raFile.seek(saveJUNKsignature);
        this.writeString("JUNK");
        int paddingBytes = (int)(4084L - (saveJUNKsignature + 8L));
        this.writeInt(paddingBytes);
        int i = 0;
        while (i < paddingBytes / 2) {
            this.writeShort(0);
            ++i;
        }
        this.writeString("LIST");
        long saveLIST2Size = this.raFile.getFilePointer();
        this.writeInt(0);
        long savemovi = this.raFile.getFilePointer();
        this.writeString("movi");
        long[] savedbLength = new long[tDim * zDim];
        long[] savedcLength = new long[tDim * zDim];
        int[] dcLength = new int[tDim * zDim];
        byte[] dataSignature = new byte[]{48, 48, 100, 98};
        byte[] buf = new byte[bytesPerPixel * xDim * yDim];
        int width = xDim - xPad;
        int z = 0;
        while (z < zDim) {
            this.percent = (double)z / (double)zDim;
            this.raFile.write(dataSignature);
            savedbLength[z] = this.raFile.getFilePointer();
            this.writeInt(bytesPerPixel * xDim * yDim);
            double[][] values = fields[z].getValues(false);
            int index = 0;
            int y = yDim - 1;
            while (y >= 0) {
                int x = 0;
                while (x < width) {
                    int ndx = width * y + x;
                    int q = bytesPerPixel - 1;
                    while (q >= 0) {
                        buf[index++] = (byte)values[q][ndx];
                        --q;
                    }
                    ++x;
                }
                int pad = bytesPerPixel * xPad % 4;
                int i2 = 0;
                while (i2 < pad) {
                    buf[index++] = 0;
                    ++i2;
                }
                --y;
            }
            this.raFile.write(buf);
            ++z;
        }
        long idx1Pos = this.raFile.getFilePointer();
        this.raFile.seek(saveLIST2Size);
        this.writeInt((int)(idx1Pos - (saveLIST2Size + 4L)));
        this.raFile.seek(idx1Pos);
        this.writeString("idx1");
        long saveidx1Length = this.raFile.getFilePointer();
        this.writeInt(0);
        z = 0;
        while (z < zDim) {
            this.raFile.write(dataSignature);
            if (z == 0) {
                this.writeInt(16);
            } else {
                this.writeInt(0);
            }
            this.writeInt((int)(savedbLength[z] - 4L - savemovi));
            this.writeInt(bytesPerPixel * xDim * yDim);
            ++z;
        }
        long endPos = this.raFile.getFilePointer();
        this.raFile.seek(saveFileSize);
        this.writeInt((int)(endPos - (saveFileSize + 4L)));
        this.raFile.seek(saveidx1Length);
        this.writeInt((int)(endPos - (saveidx1Length + 4L)));
        this.raFile.close();
        this.percent = -1.0;
    }

    public void add(String id, Data data, boolean replace) throws BadFormException {
        throw new BadFormException("AVIForm.add");
    }

    public DataImpl open(String id) throws BadFormException, IOException, VisADException {
        FieldImpl data;
        this.percent = 0.0;
        int nImages = this.getBlockCount(id);
        Data[] fields = new FieldImpl[nImages];
        int i = 0;
        while (i < nImages) {
            fields[i] = (FieldImpl)this.open(id, i);
            this.percent = (double)(i + 1) / (double)nImages;
            ++i;
        }
        if (nImages == 1) {
            data = fields[0];
        } else {
            RealType time = RealType.getRealType("time");
            FunctionType time_function = new FunctionType(time, fields[0].getType());
            Integer1DSet time_set = new Integer1DSet(nImages);
            FieldImpl time_field = new FieldImpl(time_function, time_set);
            time_field.setSamples(fields, false);
            data = time_field;
        }
        this.close();
        this.percent = -1.0;
        return data;
    }

    public DataImpl open(URL url) throws BadFormException, IOException, VisADException {
        throw new BadFormException("AVIForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public DataImpl open(String id, int block_number) throws BadFormException, IOException, VisADException {
        throw new UnimplementedException("AVIForm.open(String, int)");
    }

    public int getBlockCount(String id) throws BadFormException, IOException, VisADException {
        if (!id.equals(this.current_id)) {
            this.initFile(id);
        }
        return this.numImages;
    }

    public void close() throws BadFormException, IOException, VisADException {
    }

    public double getPercentComplete() {
        return this.percent;
    }

    private void initFile(String id) throws BadFormException, IOException, VisADException {
        throw new UnimplementedException("AVIForm.initFile(String)");
    }

    private void writeString(String s) throws IOException {
        byte[] bytes = s.getBytes("UTF-8");
        this.raFile.write(bytes);
    }

    private void writeInt(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
        this.raFile.write(v >>> 16 & 0xFF);
        this.raFile.write(v >>> 24 & 0xFF);
    }

    private void writeShort(int v) throws IOException {
        this.raFile.write(v & 0xFF);
        this.raFile.write(v >>> 8 & 0xFF);
    }

    public static void main(String[] args) throws VisADException, RemoteException, IOException {
        if (args == null || args.length < 1 || args.length > 2) {
            System.out.println("To convert a file to AVI, run:");
            System.out.println("  java visad.data.avi.AVIForm in_file out_file");
            System.out.println("To test read an AVI movie, run:");
            System.out.println("  java visad.data.avi.AVIForm in_file");
            System.exit(2);
        }
        if (args.length == 1) {
            AVIForm form = new AVIForm();
            System.out.print("Reading " + args[0] + " ");
            DataImpl data = form.open(args[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + data.getType().prettyString());
        } else if (args.length == 2) {
            System.out.print(args[0] + " -> " + args[1] + " ");
            DefaultFamily loader = new DefaultFamily("loader");
            DataImpl data = loader.open(args[0]);
            loader = null;
            AVIForm form = new AVIForm();
            form.save(args[1], data, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }
}

