/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import visad.data.amanda.Module;

public class ModuleList {
    private ArrayList list = null;
    private Module[] sortedArray = null;

    public void add(Module mod) {
        if (this.list == null) {
            this.list = new ArrayList();
        }
        this.list.add(mod);
    }

    public void dump(PrintStream out) {
        if (this.list != null && this.list.size() > 0) {
            this.sort();
        }
        if (this.sortedArray == null) {
            return;
        }
        int nMods = this.sortedArray.length;
        int i = 0;
        while (i < nMods) {
            out.println(this.sortedArray[i]);
            ++i;
        }
    }

    public Module find(int number) {
        int idx;
        if (this.list != null && this.list.size() > 0) {
            this.sort();
        }
        if (this.sortedArray != null && (idx = Arrays.binarySearch(this.sortedArray, new Module(number))) >= 0) {
            return this.sortedArray[idx];
        }
        return null;
    }

    public Module get(int i) {
        if (this.list != null && this.list.size() > 0) {
            this.sort();
        }
        if (i < 0 || this.sortedArray == null || i >= this.sortedArray.length) {
            return null;
        }
        return this.sortedArray[i];
    }

    public final boolean isInitialized() {
        return this.sortedArray != null || this.list != null && this.list.size() > 0;
    }

    public int size() {
        int len = 0;
        if (this.list != null) {
            len += this.list.size();
        }
        if (this.sortedArray != null) {
            len += this.sortedArray.length;
        }
        return len;
    }

    private void sort() {
        if (this.sortedArray != null) {
            int i = 0;
            while (i < this.sortedArray.length) {
                this.list.add(this.sortedArray[i]);
                ++i;
            }
        }
        this.sortedArray = this.list.toArray(new Module[this.list.size()]);
        Arrays.sort(this.sortedArray);
        this.list.clear();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("ModuleList[");
        boolean isEmpty = true;
        if (this.list != null && this.list.size() > 0) {
            buf.append("unsorted=");
            buf.append(this.list.size());
            isEmpty = false;
        }
        if (this.sortedArray != null) {
            buf.append("sorted=");
            buf.append(this.sortedArray.length);
            isEmpty = false;
        }
        if (isEmpty) {
            buf.append("empty");
        }
        buf.append(']');
        return buf.toString();
    }
}

