/*
 * Decompiled with CFR 0.152.
 */
package visad.data;

import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Delaunay;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.DataProcessor;

public abstract class BaseDataProcessor
implements DataProcessor {
    public void process(DataImpl di, Object token) throws VisADException {
        MathType mt = di.getType();
        boolean done = false;
        if (mt instanceof ScalarType) {
            try {
                if (mt instanceof TextType) {
                    Text t = (Text)di;
                    this.processText((TextType)t.getType(), t.getValue(), t.isMissing(), t, token);
                    done = true;
                } else if (mt instanceof RealType) {
                    Real r = (Real)di;
                    this.processReal((RealType)r.getType(), r.getValue(), r.getUnit(), r.getError(), r, token);
                    done = true;
                }
            }
            catch (UnimplementedException ue) {}
        } else if (mt instanceof TupleType) {
            TupleType tt = (TupleType)mt;
            Tuple ti = (Tuple)di;
            Data[] comps = ti.getComponents();
            if (tt instanceof RealTupleType) {
                RealTuple rti = (RealTuple)ti;
                RealTupleType rtt = (RealTupleType)tt;
                if (comps != null) {
                    Real[] reals = new Real[comps.length];
                    int i = 0;
                    while (i < comps.length) {
                        reals[i] = (Real)comps[i];
                        ++i;
                    }
                    try {
                        this.processRealTuple(rtt, reals, rti.getCoordinateSystem(), rti, token);
                        done = true;
                    }
                    catch (UnimplementedException ue) {
                        // empty catch block
                    }
                }
            }
            if (!done) {
                try {
                    this.processTuple(tt, comps, ti, token);
                    done = true;
                }
                catch (UnimplementedException ue) {}
            }
        } else if (mt instanceof SetType) {
            SetType st = (SetType)mt;
            try {
                if (di instanceof SampledSet) {
                    this.processSampledSet(st, (SampledSet)di, token);
                    done = true;
                } else if (di instanceof SimpleSet) {
                    this.processSimpleSet(st, (SimpleSet)di, token);
                    done = true;
                }
            }
            catch (UnimplementedException ue) {}
        } else if (mt instanceof FunctionType) {
            FunctionType ft = (FunctionType)mt;
            try {
                if (di instanceof FlatField) {
                    FlatField ff = (FlatField)di;
                    CoordinateSystem cs = null;
                    CoordinateSystem[] rangeCS = null;
                    if (ft.getReal()) {
                        cs = ff.getRangeCoordinateSystem()[0];
                    } else {
                        MathType rt = ft.getRange();
                        int dim = ((TupleType)ft.getRange()).getDimension();
                        rangeCS = new CoordinateSystem[dim];
                        int i = 0;
                        while (i < dim) {
                            rangeCS[i] = ff.getRangeCoordinateSystem(i)[0];
                            ++i;
                        }
                    }
                    this.processFlatField(ft, ff.getDomainSet(), cs, rangeCS, ff.getRangeSets(), ff.getDefaultRangeUnits(), ff, token);
                    done = true;
                } else if (di instanceof FieldImpl) {
                    FieldImpl fi = (FieldImpl)di;
                    this.processFieldImpl(ft, fi.getDomainSet(), fi, token);
                    done = true;
                }
            }
            catch (UnimplementedException ue) {
                // empty catch block
            }
        }
        if (!done) {
            try {
                this.processUnknownData(di, token);
            }
            catch (UnimplementedException ue) {
                throw new UnimplementedException("Couldn't process " + di.getClass().getName() + " in " + this.getClass().getName());
            }
        }
    }

    public abstract void processDoubleSet(SetType var1, CoordinateSystem var2, Unit[] var3, DoubleSet var4, Object var5) throws VisADException;

    public abstract void processFieldImpl(FunctionType var1, Set var2, FieldImpl var3, Object var4) throws VisADException;

    public abstract void processFlatField(FunctionType var1, Set var2, CoordinateSystem var3, CoordinateSystem[] var4, Set[] var5, Unit[] var6, FlatField var7, Object var8) throws VisADException;

    public abstract void processFloatSet(SetType var1, CoordinateSystem var2, Unit[] var3, FloatSet var4, Object var5) throws VisADException;

    public abstract void processGridded1DDoubleSet(SetType var1, double[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded1DDoubleSet var7, Object var8) throws VisADException;

    public abstract void processGridded2DDoubleSet(SetType var1, double[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded2DDoubleSet var7, Object var8) throws VisADException;

    public abstract void processGridded3DDoubleSet(SetType var1, double[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded3DDoubleSet var7, Object var8) throws VisADException;

    public abstract void processGridded1DSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded1DSet var7, Object var8) throws VisADException;

    private void processGridded1DSet(SetType st, Gridded1DSet set, Object token) throws VisADException {
        int[] lengths = set.getLengths();
        CoordinateSystem cs = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = set.getSetErrors();
        boolean done = false;
        try {
            if (set instanceof Gridded1DDoubleSet) {
                Gridded1DDoubleSet dset = (Gridded1DDoubleSet)set;
                this.processGridded1DDoubleSet(st, dset.getDoubles(), lengths, cs, units, errors, dset, token);
                done = true;
            } else if (set instanceof Integer1DSet) {
                this.processInteger1DSet(st, lengths, cs, units, errors, (Integer1DSet)set, token);
                done = true;
            } else if (set instanceof Linear1DSet) {
                Linear1DSet lset = (Linear1DSet)set;
                double[] firsts = new double[]{lset.getFirst()};
                double[] lasts = new double[]{lset.getLast()};
                this.processLinear1DSet(st, firsts, lasts, lengths, cs, units, errors, lset, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processGridded1DSet(st, set.getSamples(), set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processGridded2DSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded2DSet var7, Object var8) throws VisADException;

    private void processGridded2DSet(SetType st, Gridded2DSet set, Object token) throws VisADException {
        int[] lengths = set.getLengths();
        CoordinateSystem cs = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = set.getSetErrors();
        boolean done = false;
        try {
            if (set instanceof Gridded2DDoubleSet) {
                Gridded2DDoubleSet dset = (Gridded2DDoubleSet)set;
                this.processGridded2DDoubleSet(st, dset.getDoubles(), lengths, cs, units, errors, dset, token);
                done = true;
            } else if (set instanceof Integer2DSet) {
                this.processInteger2DSet(st, lengths, cs, units, errors, (Integer2DSet)set, token);
                done = true;
            } else if (set instanceof Linear2DSet) {
                Linear2DSet lset = (Linear2DSet)set;
                double[] firsts = new double[2];
                double[] lasts = new double[2];
                int i = 0;
                while (i < 2) {
                    Linear1DSet tmpSet = lset.getLinear1DComponent(i);
                    firsts[i] = tmpSet.getFirst();
                    lasts[i] = tmpSet.getLast();
                    ++i;
                }
                if (lset instanceof LinearLatLonSet) {
                    this.processLinearLatLonSet(st, firsts, lasts, lengths, cs, units, errors, (LinearLatLonSet)lset, token);
                } else {
                    this.processLinear2DSet(st, firsts, lasts, lengths, cs, units, errors, lset, token);
                }
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processGridded2DSet(st, set.getSamples(), set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processGridded3DSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, Gridded3DSet var7, Object var8) throws VisADException;

    private void processGridded3DSet(SetType st, Gridded3DSet set, Object token) throws VisADException {
        int[] lengths = set.getLengths();
        CoordinateSystem cs = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = set.getSetErrors();
        boolean done = false;
        try {
            if (set instanceof Gridded3DDoubleSet) {
                Gridded3DDoubleSet dset = (Gridded3DDoubleSet)set;
                this.processGridded3DDoubleSet(st, dset.getDoubles(), lengths, cs, units, errors, dset, token);
                done = true;
            } else if (set instanceof Integer3DSet) {
                this.processInteger3DSet(st, lengths, cs, units, errors, (Integer3DSet)set, token);
                done = true;
            } else if (set instanceof Linear3DSet) {
                Linear3DSet lset = (Linear3DSet)set;
                double[] firsts = new double[3];
                double[] lasts = new double[3];
                int i = 0;
                while (i < 3) {
                    Linear1DSet tmpSet = lset.getLinear1DComponent(i);
                    firsts[i] = tmpSet.getFirst();
                    lasts[i] = tmpSet.getLast();
                    ++i;
                }
                this.processLinear3DSet(st, firsts, lasts, lengths, cs, units, errors, lset, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processGridded3DSet(st, set.getSamples(), set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processGriddedSet(SetType var1, float[][] var2, int[] var3, CoordinateSystem var4, Unit[] var5, ErrorEstimate[] var6, GriddedSet var7, Object var8) throws VisADException;

    private void processGriddedSet(SetType st, GriddedSet set, Object token) throws VisADException {
        boolean done = false;
        try {
            if (set instanceof Gridded1DSet) {
                this.processGridded1DSet(st, (Gridded1DSet)set, token);
                done = true;
            } else if (set instanceof Gridded2DSet) {
                this.processGridded2DSet(st, (Gridded2DSet)set, token);
                done = true;
            } else if (set instanceof Gridded3DSet) {
                this.processGridded3DSet(st, (Gridded3DSet)set, token);
                done = true;
            } else if (set instanceof LinearNDSet) {
                this.processLinearNDSet(st, (LinearNDSet)set, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processGriddedSet(st, set.getSamples(), set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processInteger1DSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Integer1DSet var6, Object var7) throws VisADException;

    public abstract void processInteger2DSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Integer2DSet var6, Object var7) throws VisADException;

    public abstract void processInteger3DSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Integer3DSet var6, Object var7) throws VisADException;

    public abstract void processIntegerNDSet(SetType var1, int[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, IntegerNDSet var6, Object var7) throws VisADException;

    public abstract void processIrregular1DSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Irregular1DSet var6, Object var7) throws VisADException;

    public abstract void processIrregular2DSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Delaunay var6, Irregular2DSet var7, Object var8) throws VisADException;

    public abstract void processIrregular3DSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Delaunay var6, Irregular3DSet var7, Object var8) throws VisADException;

    public abstract void processIrregularSet(SetType var1, float[][] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, Delaunay var6, IrregularSet var7, Object var8) throws VisADException;

    private void processIrregularSet(SetType st, IrregularSet set, Object token) throws VisADException {
        float[][] samples = set.getSamples();
        CoordinateSystem cs = set.getCoordinateSystem();
        Unit[] units = set.getSetUnits();
        ErrorEstimate[] errors = set.getSetErrors();
        boolean done = false;
        try {
            if (set instanceof Irregular1DSet) {
                this.processIrregular1DSet(st, samples, cs, units, errors, (Irregular1DSet)set, token);
                done = true;
            } else if (set instanceof Irregular2DSet) {
                this.processIrregular2DSet(st, samples, cs, units, errors, set.Delan, (Irregular2DSet)set, token);
                done = true;
            } else if (set instanceof Irregular3DSet) {
                this.processIrregular3DSet(st, samples, cs, units, errors, set.Delan, (Irregular3DSet)set, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processIrregularSet(st, samples, cs, units, errors, set.Delan, set, token);
        }
    }

    public abstract void processLinear1DSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, Linear1DSet var8, Object var9) throws VisADException;

    public void processLinear1DSet(SetType st, Linear1DSet set, Object token) throws VisADException {
        this.processLinear1DSet(st, new double[]{set.getFirst()}, new double[]{set.getLast()}, set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
    }

    public abstract void processLinear2DSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, Linear2DSet var8, Object var9) throws VisADException;

    public abstract void processLinear3DSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, Linear3DSet var8, Object var9) throws VisADException;

    public abstract void processLinearLatLonSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, LinearLatLonSet var8, Object var9) throws VisADException;

    public abstract void processLinearNDSet(SetType var1, double[] var2, double[] var3, int[] var4, CoordinateSystem var5, Unit[] var6, ErrorEstimate[] var7, LinearNDSet var8, Object var9) throws VisADException;

    private void processLinearNDSet(SetType st, LinearNDSet set, Object token) throws VisADException {
        boolean done = false;
        try {
            if (set instanceof IntegerNDSet) {
                this.processIntegerNDSet(st, set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), (IntegerNDSet)set, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processLinearNDSet(st, set.getFirsts(), set.getLasts(), set.getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processList1DSet(SetType var1, float[] var2, CoordinateSystem var3, Unit[] var4, List1DSet var5, Object var6) throws VisADException;

    public abstract void processProductSet(SetType var1, SampledSet[] var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, ProductSet var6, Object var7) throws VisADException;

    public abstract void processReal(RealType var1, double var2, Unit var4, ErrorEstimate var5, Real var6, Object var7) throws VisADException;

    public abstract void processRealTuple(RealTupleType var1, Real[] var2, CoordinateSystem var3, RealTuple var4, Object var5) throws VisADException;

    public abstract void processSampledSet(SetType var1, int var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, SampledSet var6, Object var7) throws VisADException;

    private void processSampledSet(SetType st, SampledSet set, Object token) throws VisADException {
        boolean done = false;
        try {
            if (set instanceof GriddedSet) {
                this.processGriddedSet(st, (GriddedSet)set, token);
                done = true;
            } else if (set instanceof IrregularSet) {
                this.processIrregularSet(st, (IrregularSet)set, token);
                done = true;
            } else if (set instanceof ProductSet) {
                ProductSet ps = (ProductSet)set;
                this.processProductSet(st, ps.getSets(), ps.getCoordinateSystem(), ps.getSetUnits(), ps.getSetErrors(), ps, token);
                done = true;
            } else if (set instanceof SingletonSet) {
                SingletonSet ss = (SingletonSet)set;
                this.processSingletonSet(ss.getData(), ss.getCoordinateSystem(), ss.getSetUnits(), ss.getSetErrors(), ss, token);
                done = true;
            } else if (set instanceof UnionSet) {
                UnionSet us = (UnionSet)set;
                this.processUnionSet(st, us.getSets(), us, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processSampledSet(st, set.getManifoldDimension(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processSimpleSet(SetType var1, int var2, CoordinateSystem var3, Unit[] var4, ErrorEstimate[] var5, SimpleSet var6, Object var7) throws VisADException;

    private void processSimpleSet(SetType st, SimpleSet set, Object token) throws VisADException {
        boolean done = false;
        try {
            if (set instanceof DoubleSet) {
                DoubleSet ds = (DoubleSet)set;
                this.processDoubleSet(st, ds.getCoordinateSystem(), ds.getSetUnits(), ds, token);
                done = true;
            } else if (set instanceof FloatSet) {
                FloatSet fs = (FloatSet)set;
                this.processFloatSet(st, fs.getCoordinateSystem(), fs.getSetUnits(), fs, token);
                done = true;
            } else if (set instanceof List1DSet) {
                List1DSet ls = (List1DSet)set;
                float[][] samples = ls.getSamples();
                this.processList1DSet(st, samples[0], ls.getCoordinateSystem(), ls.getSetUnits(), ls, token);
                done = true;
            }
        }
        catch (UnimplementedException ue) {
            // empty catch block
        }
        if (!done) {
            this.processSimpleSet(st, set.getManifoldDimension(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors(), set, token);
        }
    }

    public abstract void processSingletonSet(RealTuple var1, CoordinateSystem var2, Unit[] var3, ErrorEstimate[] var4, SingletonSet var5, Object var6) throws VisADException;

    public abstract void processText(TextType var1, String var2, boolean var3, Text var4, Object var5) throws VisADException;

    public abstract void processTuple(TupleType var1, Data[] var2, Tuple var3, Object var4) throws VisADException;

    public abstract void processUnionSet(SetType var1, SampledSet[] var2, UnionSet var3, Object var4) throws VisADException;

    public abstract void processUnknownData(DataImpl var1, Object var2) throws VisADException;
}

