/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.rmi.RemoteException;
import visad.CellImpl;
import visad.Data;
import visad.DataImpl;
import visad.DataReferenceImpl;
import visad.DataShadow;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.ShadowType;
import visad.Tuple;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteNodeDataImpl;
import visad.cluster.RemoteNodeTuple;

public class RemoteNodeTupleImpl
extends RemoteNodeDataImpl
implements RemoteNodeTuple {
    private Tuple adaptedTuple = null;
    private DataReferenceImpl adaptedTupleRef = null;

    public RemoteNodeTupleImpl(Data[] datums) throws VisADException, RemoteException {
        if (datums == null) {
            throw new ClusterException("datums cannot be null");
        }
        int n = datums.length;
        if (n == 0) {
            throw new ClusterException("datums.length must be > 0");
        }
        int i = 0;
        while (i < n) {
            if (!(datums[i] instanceof DataImpl) && !(datums[i] instanceof RemoteNodeDataImpl)) {
                throw new ClusterException("datums must be DataImpl or RemoteNodeDataImpl");
            }
            ++i;
        }
        this.adaptedTuple = new Tuple(datums, false);
        boolean any_local = false;
        int i2 = 0;
        while (i2 < n) {
            if (datums[i2] instanceof RemoteNodeDataImpl) {
                ((RemoteNodeDataImpl)datums[i2]).setParent(this);
            } else {
                any_local = true;
            }
            ++i2;
        }
        if (any_local) {
            this.adaptedTupleRef = new DataReferenceImpl("adaptedTupleRef");
            this.adaptedTupleRef.setData(this.adaptedTuple);
            CellImpl adaptedTupleCell = new CellImpl(){

                public void doAction() throws VisADException, RemoteException {
                    RemoteNodeTupleImpl.this.notifyReferences();
                }
            };
            adaptedTupleCell.addReference(this.adaptedTupleRef);
        }
    }

    public MathType getType() throws VisADException, RemoteException {
        return this.adaptedTuple.getType();
    }

    public Real[] getRealComponents() throws VisADException, RemoteException {
        return this.adaptedTuple.getRealComponents();
    }

    public int getDimension() throws RemoteException {
        return this.adaptedTuple.getDimension();
    }

    public Data getComponent(int i) throws VisADException, RemoteException {
        return this.adaptedTuple.getComponent(i);
    }

    public boolean isMissing() throws RemoteException {
        return this.adaptedTuple.isMissing();
    }

    public DataShadow computeRanges(ShadowType type, DataShadow shadow) throws VisADException, RemoteException {
        return this.adaptedTuple.computeRanges(type, shadow);
    }

    public DataShadow computeRanges(ShadowType type, int n) throws VisADException, RemoteException {
        return this.adaptedTuple.computeRanges(type, n);
    }

    public double[][] computeRanges(RealType[] reals) throws VisADException, RemoteException {
        return this.adaptedTuple.computeRanges(reals);
    }

    public Data adjustSamplingError(Data error, int error_mode) throws VisADException, RemoteException {
        return this.adaptedTuple.adjustSamplingError(error, error_mode);
    }

    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    public String longString(String pre) throws VisADException, RemoteException {
        return pre + "RemoteNodeTupleImpl";
    }
}

