/*
 * Decompiled with CFR 0.152.
 */
package visad.cluster;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import visad.VisADException;
import visad.cluster.ClusterException;
import visad.cluster.RemoteAgentContact;
import visad.cluster.RemoteClientAgent;

public class RemoteClientAgentImpl
extends UnicastRemoteObject
implements RemoteClientAgent {
    private RemoteClientAgentImpl focus_agent;
    private int index = -1;
    private boolean not_all;
    Serializable[] responses = null;
    private long time_out = 10000L;

    public RemoteClientAgentImpl(RemoteClientAgentImpl fa, int ind) throws RemoteException {
        this(fa, ind, 10000L);
    }

    public RemoteClientAgentImpl(RemoteClientAgentImpl fa, int ind, long to) throws RemoteException {
        this.focus_agent = fa;
        this.index = ind;
        this.time_out = to;
    }

    public void sendToClient(Serializable message) throws RemoteException {
        if (this.focus_agent != null) {
            this.focus_agent.sendToClient(this.index, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToClient(int ind, Serializable message) throws RemoteException {
        if (0 <= ind && ind < this.responses.length) {
            this.responses[ind] = message;
            boolean all = true;
            int i = 0;
            while (i < this.responses.length) {
                if (this.responses[i] == null) {
                    all = false;
                }
                ++i;
            }
            if (all) {
                RemoteClientAgentImpl remoteClientAgentImpl = this;
                synchronized (remoteClientAgentImpl) {
                    this.not_all = false;
                    this.notify();
                }
            }
        }
    }

    public Serializable[] broadcastWithResponses(Serializable message, RemoteAgentContact[] contacts) throws VisADException, RemoteException {
        return this.broadcastWithResponses(new Serializable[]{message}, contacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable[] broadcastWithResponses(Serializable[] messages, RemoteAgentContact[] contacts) throws VisADException, RemoteException {
        int nagents = contacts.length;
        this.responses = new Serializable[nagents];
        this.not_all = true;
        int i = 0;
        while (i < nagents) {
            int im = messages.length == 1 ? 0 : i;
            Serializable message = messages[im];
            this.responses[i] = null;
            contacts[i].sendToNode(message);
            ++i;
        }
        long start_time = System.currentTimeMillis();
        while (this.not_all) {
            RemoteClientAgentImpl remoteClientAgentImpl = this;
            synchronized (remoteClientAgentImpl) {
                try {
                    this.wait(this.time_out);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                long time = System.currentTimeMillis();
                if (time > start_time + this.time_out) {
                    this.not_all = false;
                    System.out.println("RemoteClientAgentImpl.broadcastWithResponses time out");
                }
            }
        }
        int i2 = 0;
        while (i2 < this.responses.length) {
            if (this.responses[i2] instanceof String && ((String)((Object)this.responses[i2])).equals("error")) {
                throw new ClusterException("error from node " + i2);
            }
            ++i2;
        }
        return this.responses;
    }
}

