/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.AnimationControl;
import visad.CellImpl;
import visad.ConstantMap;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.DateTime;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.ShapeControl;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADTriangleArray;
import visad.bom.CollectiveBarbException;
import visad.bom.EndManipFTM;
import visad.java3d.DirectManipulationRendererJ3D;
import visad.java3d.DisplayImplJ3D;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.MouseBehaviorJ3D;
import visad.java3d.TwoDDisplayRendererJ3D;
import visad.util.AnimationWidget;
import visad.util.Util;

public class FlexibleTrackManipulation {
    private Object data_lock = new Object();
    private int ntimes = 0;
    private Tuple[] tuples;
    private boolean[] tuple_change;
    private int which_time = -1;
    private Set time_set = null;
    private double[] times;
    private float[] lats;
    private float[] lons;
    private float[] shapes;
    private float[] old_lats;
    private float[] old_lons;
    private DataReferenceImpl track_ref;
    private DataReferenceImpl[] track_refs;
    private DirectManipulationRendererJ3D[] direct_manipulation_renderers;
    private ConstantMap[][] constant_maps;
    private TrackMonitor[] track_monitors;
    private AnimationControl acontrol = null;
    private ShapeControl shape_control1 = null;
    private ShapeControl shape_control2 = null;
    private ProjectionControl pcontrol = null;
    private DisplayImplJ3D display;
    private FieldImpl storm_track;
    private FunctionType storm_track_type = null;
    private DataMonitor data_monitor = null;
    private int shape_index;
    private int lat_index;
    private int lon_index;
    private float[] shapeColour;
    private int last_time = -1;
    private boolean pfirst = true;
    private boolean afirst = true;
    private boolean direct_on = false;
    private static final int NTIMES = 8;
    static /* synthetic */ Class class$visad$AnimationControl;

    public FlexibleTrackManipulation(DataReferenceImpl tr, DisplayImplJ3D d, ScalarMap shape_map1, ScalarMap shape_map2, boolean need_monitor) throws VisADException, RemoteException {
        float size = 0.1f;
        int nv = 16;
        VisADGeometryArray[][] ga = FlexibleTrackManipulation.makeStormShapes(nv, 0.1f);
        this.shapeColour = new float[]{1.0f, 1.0f, 1.0f};
        this.init(tr, d, shape_map1, shape_map2, need_monitor, 0.1f, ga);
    }

    public FlexibleTrackManipulation(DataReferenceImpl tr, DisplayImplJ3D d, ScalarMap shape_map1, ScalarMap shape_map2, boolean need_monitor, float size) throws VisADException, RemoteException {
        int nv = 16;
        VisADGeometryArray[][] ga = FlexibleTrackManipulation.makeStormShapes(nv, size);
        this.shapeColour = new float[]{1.0f, 1.0f, 1.0f};
        this.init(tr, d, shape_map1, shape_map2, need_monitor, size, ga);
    }

    public FlexibleTrackManipulation(DataReferenceImpl tr, DisplayImplJ3D d, ScalarMap shape_map1, ScalarMap shape_map2, boolean need_monitor, float size, VisADGeometryArray[][] ga, float[] shapeColour) throws VisADException, RemoteException {
        this.shapeColour = shapeColour;
        this.init(tr, d, shape_map1, shape_map2, need_monitor, size, ga);
    }

    private void init(DataReferenceImpl tr, DisplayImplJ3D d, ScalarMap shape_map1, ScalarMap shape_map2, boolean need_monitor, float size, VisADGeometryArray[][] ga) throws VisADException, RemoteException {
        this.track_ref = tr;
        this.storm_track = (FlatField)this.track_ref.getData();
        this.display = d;
        this.pcontrol = this.display.getProjectionControl();
        ProjectionControlListener pcl = new ProjectionControlListener();
        this.pcontrol.addControlListener(pcl);
        this.acontrol = (AnimationControl)((Object)this.display.getControl(class$visad$AnimationControl == null ? (class$visad$AnimationControl = FlexibleTrackManipulation.class$("visad.AnimationControl")) : class$visad$AnimationControl));
        if (this.acontrol != null) {
            AnimationControlListener acl = new AnimationControlListener();
            this.acontrol.addControlListener(acl);
        }
        this.storm_track_type = (FunctionType)this.storm_track.getType();
        TupleType storm_type = null;
        try {
            RealType time = (RealType)this.storm_track_type.getDomain().getComponent(0);
            if (!RealType.Time.equals(time)) {
                throw new DisplayException("storm_track bad MathType: " + time + " must be RealType.Time");
            }
            storm_type = (TupleType)this.storm_track_type.getRange();
            if (!storm_type.getFlat()) {
                throw new DisplayException("storm_track bad MathType: " + storm_type + " must be flat");
            }
        }
        catch (ClassCastException e) {
            throw new DisplayException("storm_track bad MathType: " + this.storm_track_type);
        }
        this.shape_index = -1;
        this.lat_index = -1;
        this.lon_index = -1;
        Vector scalar_map_vector = this.display.getMapVector();
        int tuple_dim = storm_type.getDimension();
        RealType[] real_types = storm_type.getRealComponents();
        int i = 0;
        while (i < tuple_dim) {
            RealType real = real_types[i];
            if (RealType.Latitude.equals(real)) {
                this.lat_index = i;
            } else if (RealType.Longitude.equals(real)) {
                this.lon_index = i;
            } else {
                Enumeration enumeration = scalar_map_vector.elements();
                while (enumeration.hasMoreElements()) {
                    DisplayRealType dreal;
                    ScalarMap map = (ScalarMap)enumeration.nextElement();
                    if (!real.equals(map.getScalar()) || !Display.Shape.equals(dreal = map.getDisplayScalar())) continue;
                    this.shape_index = i;
                }
            }
            ++i;
        }
        if (this.lat_index < 0 || this.lon_index < 0 || this.shape_index < 0) {
            throw new DisplayException("storm track data must include Latitude and Longitude and a RealType mapped to Shape " + this.lat_index + " " + this.lon_index + " " + this.shape_index);
        }
        this.setupData(this.storm_track, true, true);
        this.shape_control1 = (ShapeControl)shape_map1.getControl();
        this.shape_control1.setShapeSet(new Integer1DSet(8));
        this.shape_control1.setShapes(ga[0]);
        this.shape_control2 = (ShapeControl)shape_map2.getControl();
        this.shape_control2.setShapeSet(new Integer1DSet(8));
        this.shape_control2.setShapes(ga[1]);
        this.which_time = -1;
        if (need_monitor) {
            this.data_monitor = new DataMonitor();
            this.data_monitor.addReference(this.track_ref);
        }
        if (this.acontrol != null) {
            this.acontrol.setCurrent(0);
            this.display.addReference(this.track_ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupData(FieldImpl storm_track, boolean length_change, boolean value_change) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            boolean special;
            if (this.storm_track_type == null) {
                this.storm_track_type = (FunctionType)storm_track.getType();
            } else if (!this.storm_track_type.equals(storm_track.getType())) {
                throw new DisplayException("storm track MathType changed");
            }
            boolean bl = special = length_change && !value_change;
            if (this.track_refs != null && !special) {
                int i = 0;
                while (i < this.track_refs.length) {
                    this.display.removeReference(this.track_refs[i]);
                    this.track_monitors[i].removeReference(this.track_refs[i]);
                    this.track_monitors[i].stop();
                    ++i;
                }
            }
            int old_ntimes = this.ntimes;
            try {
                this.ntimes = storm_track.getLength();
                this.tuples = new Tuple[this.ntimes];
                this.tuple_change = new boolean[this.ntimes];
                this.lats = new float[this.ntimes];
                this.lons = new float[this.ntimes];
                this.old_lats = new float[this.ntimes];
                this.old_lons = new float[this.ntimes];
                this.shapes = new float[this.ntimes];
                this.time_set = storm_track.getDomainSet();
                int j = 0;
                while (j < this.ntimes) {
                    this.tuples[j] = (Tuple)storm_track.getSample(j);
                    this.tuple_change[j] = false;
                    Real[] reals = this.tuples[j].getRealComponents();
                    this.lats[j] = (float)reals[this.lat_index].getValue();
                    this.lons[j] = (float)reals[this.lon_index].getValue();
                    this.old_lats[j] = this.lats[j];
                    this.old_lons[j] = this.lons[j];
                    this.shapes[j] = (float)reals[this.shape_index].getValue();
                    ++j;
                }
            }
            catch (ClassCastException e) {
                throw new DisplayException("storm track bad MathType: " + this.storm_track_type);
            }
            if (this.acontrol == null) {
                DataReferenceImpl[] old_track_refs = this.track_refs;
                DirectManipulationRendererJ3D[] old_direct_manipulation_renderers = this.direct_manipulation_renderers;
                TrackMonitor[] old_track_monitors = this.track_monitors;
                ConstantMap[][] old_constant_maps = this.constant_maps;
                this.track_refs = new DataReferenceImpl[this.ntimes];
                this.direct_manipulation_renderers = new DirectManipulationRendererJ3D[this.ntimes];
                this.track_monitors = new TrackMonitor[this.ntimes];
                this.constant_maps = new ConstantMap[this.ntimes][];
                int i = 0;
                while (i < this.ntimes) {
                    if (!special || i >= old_ntimes) {
                        this.track_refs[i] = new DataReferenceImpl("station_ref" + i);
                        this.track_refs[i].setData(this.tuples[i]);
                        this.direct_manipulation_renderers[i] = new FTMDirectManipulationRendererJ3D(this);
                        ConstantMap[] foo = new ConstantMap[]{new ConstantMap(this.shapeColour[0], Display.Red), new ConstantMap(this.shapeColour[1], Display.Green), new ConstantMap(this.shapeColour[2], Display.Blue)};
                        this.constant_maps[i] = foo;
                        this.display.addReferences((DataRenderer)this.direct_manipulation_renderers[i], this.track_refs[i], this.constant_maps[i]);
                        this.track_monitors[i] = new TrackMonitor(this.track_refs[i], i);
                        this.track_monitors[i].addReference(this.track_refs[i]);
                    } else {
                        this.track_refs[i] = old_track_refs[i];
                        this.direct_manipulation_renderers[i] = old_direct_manipulation_renderers[i];
                        this.constant_maps[i] = old_constant_maps[i];
                        this.track_monitors[i] = old_track_monitors[i];
                    }
                    ++i;
                }
            } else if (!special) {
                this.track_refs = new DataReferenceImpl[1];
                this.direct_manipulation_renderers = new DirectManipulationRendererJ3D[1];
                this.track_monitors = new TrackMonitor[1];
                this.constant_maps = new ConstantMap[1][];
                this.track_refs[0] = new DataReferenceImpl("station_ref");
                this.track_refs[0].setData(this.tuples[0]);
                this.direct_manipulation_renderers[0] = new FTMDirectManipulationRendererJ3D(this);
                this.constant_maps[0] = new ConstantMap[]{new ConstantMap(this.shapeColour[0], Display.Red), new ConstantMap(this.shapeColour[1], Display.Green), new ConstantMap(this.shapeColour[2], Display.Blue)};
                this.display.addReferences((DataRenderer)this.direct_manipulation_renderers[0], this.track_refs[0], this.constant_maps[0]);
                this.track_monitors[0] = new TrackMonitor(this.track_refs[0], 0);
                this.track_monitors[0].addReference(this.track_refs[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupTuples(FieldImpl storm_track) throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int j = 0;
            while (j < this.ntimes) {
                this.tuples[j] = (Tuple)storm_track.getSample(j);
                ++j;
            }
        }
    }

    public static VisADGeometryArray[][] makeStormShapes(int nv, float size) throws VisADException {
        VisADLineArray circle = new VisADLineArray();
        circle.vertexCount = 2 * nv;
        float[] coordinates = new float[3 * circle.vertexCount];
        int m = 0;
        int i = 0;
        while (i < nv) {
            double b = Math.PI * 2 * (double)i / (double)nv;
            coordinates[m++] = 0.5f * size * (float)Math.cos(b);
            coordinates[m++] = 0.5f * size * (float)Math.sin(b);
            coordinates[m++] = 0.0f;
            double c = Math.PI * 2 * (double)(i + 1) / (double)nv;
            coordinates[m++] = 0.5f * size * (float)Math.cos(c);
            coordinates[m++] = 0.5f * size * (float)Math.sin(c);
            coordinates[m++] = 0.0f;
            ++i;
        }
        circle.coordinates = coordinates;
        VisADTriangleArray filled_circle = new VisADTriangleArray();
        filled_circle.vertexCount = 3 * nv;
        coordinates = new float[3 * filled_circle.vertexCount];
        m = 0;
        int i2 = 0;
        while (i2 < nv) {
            coordinates[m++] = 0.0f;
            coordinates[m++] = 0.0f;
            coordinates[m++] = 0.0f;
            double b = Math.PI * 2 * (double)i2 / (double)nv;
            coordinates[m++] = 0.5f * size * (float)Math.cos(b);
            coordinates[m++] = 0.5f * size * (float)Math.sin(b);
            coordinates[m++] = 0.0f;
            double c = Math.PI * 2 * (double)(i2 + 1) / (double)nv;
            coordinates[m++] = 0.5f * size * (float)Math.cos(c);
            coordinates[m++] = 0.5f * size * (float)Math.sin(c);
            coordinates[m++] = 0.0f;
            ++i2;
        }
        filled_circle.coordinates = coordinates;
        float[] normals = new float[3 * filled_circle.vertexCount];
        m = 0;
        int i3 = 0;
        while (i3 < 3 * nv) {
            normals[m++] = 0.0f;
            normals[m++] = 0.0f;
            normals[m++] = 1.0f;
            ++i3;
        }
        filled_circle.normals = normals;
        VisADLineArray ell = new VisADLineArray();
        ell.vertexCount = 8;
        ell.coordinates = new float[]{-0.25f * size, 0.5f * size, 0.0f, 0.0f, 0.5f * size, 0.0f, -0.12f * size, 0.5f * size, 0.0f, -0.12f * size, -0.5f * size, 0.0f, -0.12f * size, -0.5f * size, 0.0f, 0.5f * size, -0.5f * size, 0.0f, 0.5f * size, -0.5f * size, 0.0f, 0.5f * size, -0.37f * size, 0.0f};
        VisADLineArray south = new VisADLineArray();
        south.vertexCount = 2 * nv;
        coordinates = new float[3 * south.vertexCount];
        m = 0;
        int i4 = 0;
        while (i4 < nv / 2) {
            double b = Math.PI * (double)i4 / (double)nv;
            coordinates[m++] = 0.5f * size * (float)Math.cos(b);
            coordinates[m++] = size * (float)Math.sin(b);
            coordinates[m++] = 0.0f;
            double c = Math.PI * (double)(i4 + 1) / (double)nv;
            coordinates[m++] = 0.5f * size * (float)Math.cos(c);
            coordinates[m++] = size * (float)Math.sin(c);
            coordinates[m++] = 0.0f;
            coordinates[m++] = -0.5f * size * (float)Math.cos(b);
            coordinates[m++] = -size * (float)Math.sin(b);
            coordinates[m++] = 0.0f;
            coordinates[m++] = -0.5f * size * (float)Math.cos(c);
            coordinates[m++] = -size * (float)Math.sin(c);
            coordinates[m++] = 0.0f;
            ++i4;
        }
        south.coordinates = coordinates;
        VisADLineArray north = new VisADLineArray();
        north.vertexCount = 2 * nv;
        coordinates = new float[3 * north.vertexCount];
        m = 0;
        int i5 = 0;
        while (i5 < nv / 2) {
            double b = Math.PI * (double)i5 / (double)nv;
            coordinates[m++] = -0.5f * size * (float)Math.cos(b);
            coordinates[m++] = size * (float)Math.sin(b);
            coordinates[m++] = 0.0f;
            double c = Math.PI * (double)(i5 + 1) / (double)nv;
            coordinates[m++] = -0.5f * size * (float)Math.cos(c);
            coordinates[m++] = size * (float)Math.sin(c);
            coordinates[m++] = 0.0f;
            coordinates[m++] = 0.5f * size * (float)Math.cos(b);
            coordinates[m++] = -size * (float)Math.sin(b);
            coordinates[m++] = 0.0f;
            coordinates[m++] = 0.5f * size * (float)Math.cos(c);
            coordinates[m++] = -size * (float)Math.sin(c);
            coordinates[m++] = 0.0f;
            ++i5;
        }
        north.coordinates = coordinates;
        VisADLineArray south_circle = VisADLineArray.merge(new VisADLineArray[]{circle, south});
        VisADLineArray north_circle = VisADLineArray.merge(new VisADLineArray[]{circle, north});
        VisADGeometryArray[][] ga = new VisADGeometryArray[][]{{null, ell, circle, null, south_circle, south, north_circle, north}, {null, null, null, filled_circle, null, filled_circle, null, filled_circle}};
        return ga;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endManipulation() throws VisADException, RemoteException {
        Object object = this.data_lock;
        synchronized (object) {
            int i = 0;
            while (i < this.track_refs.length) {
                this.display.removeReference(this.track_refs[i]);
                ++i;
            }
            this.display.addReference(this.track_ref);
        }
    }

    public DataRenderer[] getManipulationRenderers() {
        return this.direct_manipulation_renderers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.data_lock;
        synchronized (object) {
            try {
                int i = 0;
                while (i < this.ntimes) {
                    if (this.tuple_change[i]) {
                        this.tuple_change[i] = false;
                        this.storm_track.setSample(i, (Data)this.tuples[i]);
                    }
                    ++i;
                }
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
            this.direct_on = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.data_lock;
        synchronized (object) {
            this.direct_on = true;
        }
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        RealType shape = RealType.getRealType("shape");
        RealType time = RealType.Time;
        double start = new DateTime(1999, 122, 57060.0).getValue();
        Linear1DSet time_set = new Linear1DSet((MathType)time, start, start + 3000.0, 8);
        RealTupleType tuple_type = null;
        tuple_type = new RealTupleType(lon, lat, shape);
        FunctionType track_type = new FunctionType(time, tuple_type);
        DisplayImplJ3D display = new DisplayImplJ3D("display1", (DisplayRendererJ3D)new TwoDDisplayRendererJ3D());
        ScalarMap lonmap = new ScalarMap(lon, Display.XAxis);
        display.addMap(lonmap);
        lonmap.setRange(-10.0, 10.0);
        ScalarMap latmap = new ScalarMap(lat, Display.YAxis);
        display.addMap(latmap);
        latmap.setRange(-10.0, 10.0);
        ScalarMap shape_map1 = new ScalarMap(shape, Display.Shape);
        display.addMap(shape_map1);
        ScalarMap shape_map2 = new ScalarMap(shape, Display.Shape);
        display.addMap(shape_map2);
        ScalarMap amap = null;
        if (args.length > 0) {
            amap = new ScalarMap(time, Display.Animation);
            display.addMap(amap);
            AnimationControl acontrol = (AnimationControl)((Object)amap.getControl());
            acontrol.setStep(500);
        }
        FlatField ff = new FlatField(track_type, time_set);
        double[][] values = new double[3][8];
        int k = 0;
        while (k < 8) {
            values[0][k] = 2.0 * (double)k - 8.0;
            values[1][k] = 2.0 * (double)k - 8.0;
            int s = k % 8;
            if (4 <= s && s < 6) {
                if (values[1][k] >= 0.0) {
                    s += 2;
                }
            } else if (6 <= s && s < 8 && values[1][k] < 0.0) {
                s -= 2;
            }
            values[2][k] = s;
            ++k;
        }
        ff.setSamples(values);
        DataReferenceImpl track_ref = new DataReferenceImpl("track_ref");
        track_ref.setData(ff);
        JFrame frame = new JFrame("test FlexibleTrackManipulation");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        if (amap != null) {
            panel.add(new AnimationWidget(amap));
        }
        FlexibleTrackManipulation ftm = new FlexibleTrackManipulation(track_ref, display, shape_map1, shape_map2, true, 0.05f);
        JPanel button_panel = new JPanel();
        button_panel.setLayout(new BoxLayout(button_panel, 0));
        button_panel.setAlignmentY(0.0f);
        button_panel.setAlignmentX(0.0f);
        EndManipFTM emf = new EndManipFTM(ftm, track_ref);
        JButton end = new JButton("end manip");
        end.addActionListener(emf);
        end.setActionCommand("end");
        button_panel.add(end);
        JButton add = new JButton("add to track");
        add.addActionListener(emf);
        add.setActionCommand("add");
        button_panel.add(add);
        panel.add(button_panel);
        frame.setSize(500, 700);
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FTMDirectManipulationRendererJ3D
    extends DirectManipulationRendererJ3D {
        FlexibleTrackManipulation ftm;

        FTMDirectManipulationRendererJ3D(FlexibleTrackManipulation f) {
            this.ftm = f;
        }

        public void release_direct() {
            this.ftm.release();
        }

        public void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
            if (first) {
                this.ftm.start();
            }
            super.drag_direct(ray, first, mouseModifiers);
        }
    }

    class TrackMonitor
    extends CellImpl {
        DataReferenceImpl ref;
        int this_time;
        private static final float EPS = 0.01f;

        public TrackMonitor(DataReferenceImpl r, int t) {
            this.ref = r;
            this.this_time = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = FlexibleTrackManipulation.this.data_lock;
            synchronized (object) {
                int time_index = this.this_time;
                if (FlexibleTrackManipulation.this.acontrol != null) {
                    time_index = FlexibleTrackManipulation.this.which_time;
                }
                if (time_index < 0) {
                    return;
                }
                Tuple storm = (Tuple)this.ref.getData();
                Real[] reals = storm.getRealComponents();
                float new_lat = (float)reals[FlexibleTrackManipulation.this.lat_index].getValue();
                float new_lon = (float)reals[FlexibleTrackManipulation.this.lon_index].getValue();
                if (Util.isApproximatelyEqual(new_lat, FlexibleTrackManipulation.this.lats[time_index], 0.01f) && Util.isApproximatelyEqual(new_lon, FlexibleTrackManipulation.this.lons[time_index], 0.01f)) {
                    return;
                }
                if (FlexibleTrackManipulation.this.afirst) {
                    FlexibleTrackManipulation.this.afirst = false;
                    FlexibleTrackManipulation.this.display.removeReference(FlexibleTrackManipulation.this.track_ref);
                }
                if (FlexibleTrackManipulation.this.last_time != time_index) {
                    FlexibleTrackManipulation.this.last_time = time_index;
                    int j = 0;
                    while (j < FlexibleTrackManipulation.this.ntimes) {
                        ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).old_lats[j] = FlexibleTrackManipulation.this.lats[j];
                        ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).old_lons[j] = FlexibleTrackManipulation.this.lons[j];
                        ++j;
                    }
                }
                float diff_lat = new_lat - FlexibleTrackManipulation.this.old_lats[time_index];
                float diff_lon = new_lon - FlexibleTrackManipulation.this.old_lons[time_index];
                int mouseModifiers = FlexibleTrackManipulation.this.direct_manipulation_renderers[this.this_time].getLastMouseModifiers();
                int mctrl = mouseModifiers & 2;
                int high_time = mctrl != 0 ? FlexibleTrackManipulation.this.ntimes : time_index + 1;
                int j = time_index;
                while (j < high_time) {
                    Tuple old_storm;
                    double lat = FlexibleTrackManipulation.this.old_lats[j] + diff_lat;
                    double lon = FlexibleTrackManipulation.this.old_lons[j] + diff_lon;
                    int old_shape = (int)((double)FlexibleTrackManipulation.this.shapes[j] + 0.01);
                    double shape = old_shape;
                    if (4 <= old_shape && old_shape < 6) {
                        if (lat >= 0.0) {
                            shape = old_shape + 2;
                        }
                    } else if (6 <= old_shape && old_shape < 8 && lat < 0.0) {
                        shape = old_shape - 2;
                    }
                    if ((old_storm = FlexibleTrackManipulation.this.tuples[j]) instanceof RealTuple) {
                        reals = old_storm.getRealComponents();
                        reals[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lat_index] = reals[FlexibleTrackManipulation.this.lat_index].cloneButValue(lat);
                        reals[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lon_index] = reals[FlexibleTrackManipulation.this.lon_index].cloneButValue(lon);
                        reals[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).shape_index] = reals[FlexibleTrackManipulation.this.shape_index].cloneButValue(shape);
                        storm = new RealTuple((RealTupleType)old_storm.getType(), reals, ((RealTuple)old_storm).getCoordinateSystem());
                    } else {
                        int n = old_storm.getDimension();
                        int k = 0;
                        Data[] components = new Data[n];
                        int c = 0;
                        while (c < n) {
                            components[c] = old_storm.getComponent(c);
                            if (components[c] instanceof Real) {
                                if (k == FlexibleTrackManipulation.this.lat_index) {
                                    components[c] = ((Real)components[c]).cloneButValue(lat);
                                }
                                if (k == FlexibleTrackManipulation.this.lon_index) {
                                    components[c] = ((Real)components[c]).cloneButValue(lon);
                                }
                                if (k == FlexibleTrackManipulation.this.shape_index) {
                                    components[c] = ((Real)components[c]).cloneButValue(shape);
                                }
                                ++k;
                            } else {
                                int m = ((RealTuple)components[c]).getDimension();
                                if (k <= FlexibleTrackManipulation.this.lat_index && FlexibleTrackManipulation.this.lat_index < k + m || k <= FlexibleTrackManipulation.this.lon_index && FlexibleTrackManipulation.this.lon_index < k + m || k <= FlexibleTrackManipulation.this.shape_index && FlexibleTrackManipulation.this.shape_index < k + m) {
                                    reals = ((RealTuple)components[c]).getRealComponents();
                                    if (k <= FlexibleTrackManipulation.this.lat_index && FlexibleTrackManipulation.this.lat_index < k + m) {
                                        reals[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lat_index - k] = reals[FlexibleTrackManipulation.this.lat_index - k].cloneButValue(lat);
                                    }
                                    if (k <= FlexibleTrackManipulation.this.lon_index && FlexibleTrackManipulation.this.lon_index < k + m) {
                                        reals[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lon_index - k] = reals[FlexibleTrackManipulation.this.lon_index - k].cloneButValue(lon);
                                    }
                                    if (k <= FlexibleTrackManipulation.this.shape_index && FlexibleTrackManipulation.this.shape_index < k + m) {
                                        reals[((FlexibleTrackManipulation)FlexibleTrackManipulation.this).shape_index - k] = reals[FlexibleTrackManipulation.this.shape_index - k].cloneButValue(shape);
                                    }
                                    components[c] = new RealTuple((RealTupleType)components[c].getType(), reals, ((RealTuple)components[c]).getCoordinateSystem());
                                }
                                k += m;
                            }
                            ++c;
                        }
                        storm = new Tuple((TupleType)old_storm.getType(), components, false);
                    }
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lats[j] = (float)lat;
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).lons[j] = (float)lon;
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).shapes[j] = (float)shape;
                    ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).tuples[j] = storm;
                    if (FlexibleTrackManipulation.this.direct_on) {
                        ((FlexibleTrackManipulation)FlexibleTrackManipulation.this).tuple_change[j] = true;
                    } else {
                        FlexibleTrackManipulation.this.storm_track.setSample(j, (Data)FlexibleTrackManipulation.this.tuples[j]);
                    }
                    if (FlexibleTrackManipulation.this.acontrol == null) {
                        FlexibleTrackManipulation.this.track_refs[j].setData(FlexibleTrackManipulation.this.tuples[j]);
                    }
                    ++j;
                }
            }
        }
    }

    class AnimationControlListener
    implements ControlListener {
        AnimationControlListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            Object object = FlexibleTrackManipulation.this.data_lock;
            synchronized (object) {
                FlexibleTrackManipulation.this.which_time = -1;
                if (FlexibleTrackManipulation.this.direct_manipulation_renderers == null) {
                    return;
                }
                if (FlexibleTrackManipulation.this.direct_manipulation_renderers[0] == null) {
                    return;
                }
                FlexibleTrackManipulation.this.direct_manipulation_renderers[0].stop_direct();
                Set ts = FlexibleTrackManipulation.this.acontrol.getSet();
                if (ts == null) {
                    return;
                }
                if (!FlexibleTrackManipulation.this.time_set.equals(ts)) {
                    throw new CollectiveBarbException("time Set changed");
                }
                int current = FlexibleTrackManipulation.this.acontrol.getCurrent();
                if (current < 0) {
                    return;
                }
                FlexibleTrackManipulation.this.which_time = current;
                FlexibleTrackManipulation.this.track_refs[0].setData(FlexibleTrackManipulation.this.tuples[current]);
                if (FlexibleTrackManipulation.this.afirst) {
                    FlexibleTrackManipulation.this.afirst = false;
                    if (FlexibleTrackManipulation.this.acontrol != null) {
                        FlexibleTrackManipulation.this.display.removeReference(FlexibleTrackManipulation.this.track_ref);
                    }
                }
            }
        }
    }

    class ProjectionControlListener
    implements ControlListener {
        private double base_scale = 0.65;
        private float last_cscale = 1.0f;

        ProjectionControlListener() {
        }

        public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
            double[] matrix = FlexibleTrackManipulation.this.pcontrol.getMatrix();
            double[] rot = new double[3];
            double[] scale = new double[1];
            double[] trans = new double[3];
            MouseBehaviorJ3D.unmake_matrix(rot, scale, trans, matrix);
            float cscale = (float)(this.base_scale / scale[0]);
            float ratio = cscale / this.last_cscale;
            if (ratio < 0.95f || 1.05f < ratio) {
                this.last_cscale = cscale;
                if (FlexibleTrackManipulation.this.shape_control1 != null) {
                    FlexibleTrackManipulation.this.shape_control1.setScale(cscale);
                }
                if (FlexibleTrackManipulation.this.shape_control2 != null) {
                    FlexibleTrackManipulation.this.shape_control2.setScale(cscale);
                }
            }
        }
    }

    class DataMonitor
    extends CellImpl {
        DataMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() throws VisADException, RemoteException {
            Object object = FlexibleTrackManipulation.this.data_lock;
            synchronized (object) {
                FieldImpl st = (FieldImpl)FlexibleTrackManipulation.this.track_ref.getData();
                boolean length_change = false;
                boolean value_change = false;
                if (!FlexibleTrackManipulation.this.storm_track_type.equals(st.getType())) {
                    throw new VisADException("storm_track MathType may not change");
                }
                if (FlexibleTrackManipulation.this.ntimes != st.getLength()) {
                    length_change = true;
                }
                if (st.getLength() >= FlexibleTrackManipulation.this.ntimes) {
                    int j = 0;
                    while (j < FlexibleTrackManipulation.this.ntimes) {
                        Real[] reals = ((Tuple)st.getSample(j)).getRealComponents();
                        if (!(Util.isApproximatelyEqual(FlexibleTrackManipulation.this.lats[j], (float)reals[FlexibleTrackManipulation.this.lat_index].getValue()) && Util.isApproximatelyEqual(FlexibleTrackManipulation.this.lons[j], (float)reals[FlexibleTrackManipulation.this.lon_index].getValue()) && Util.isApproximatelyEqual(FlexibleTrackManipulation.this.shapes[j], (float)reals[FlexibleTrackManipulation.this.shape_index].getValue()))) {
                            value_change = true;
                            break;
                        }
                        ++j;
                    }
                } else {
                    value_change = true;
                }
                FlexibleTrackManipulation.this.storm_track = st;
                if (length_change || value_change) {
                    FlexibleTrackManipulation.this.setupData(FlexibleTrackManipulation.this.storm_track, length_change, value_change);
                } else {
                    FlexibleTrackManipulation.this.setupTuples(FlexibleTrackManipulation.this.storm_track);
                }
            }
        }
    }
}

