/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.EarthVectorType;
import visad.FlowControl;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.SetType;
import visad.ShadowRealType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.VisADRay;
import visad.bom.BarbRenderer;
import visad.bom.ShadowBarbFunctionTypeJ2D;
import visad.bom.ShadowBarbRealTupleTypeJ2D;
import visad.bom.ShadowBarbRealTypeJ2D;
import visad.bom.ShadowBarbSetTypeJ2D;
import visad.bom.ShadowBarbTupleTypeJ2D;
import visad.bom.WindGetterJ2D;
import visad.bom.WindPolarCoordinateSystem;
import visad.collab.CollabUtil;
import visad.java2d.DirectManipulationRendererJ2D;
import visad.java2d.DisplayImplJ2D;

public class BarbManipulationRendererJ2D
extends DirectManipulationRendererJ2D
implements BarbRenderer {
    private boolean knotsConvert = true;
    private String whyNotDirect = null;
    private static final String notFlatTupleType = "not Flat Tuple";
    private static final String multipleFlowTuples = "mappings to both Flow1 and Flow2";
    private static final String multipleFlowMapping = "RealType with multiple flow mappings";
    private static final String noFlow = "must be RealTypes mapped to flow X and flow Y";
    private static final String nonCartesian = "non-Cartesian spatial mapping";
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient MathType type = null;
    private transient ShadowTupleType shadow = null;
    private CoordinateSystem coord = null;
    private float point_x;
    private float point_y;
    private float point_z;
    private float line_x;
    private float line_y;
    private float line_z;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private int[] flowToComponent = new int[]{-1, -1, -1};
    private ScalarMap[] directMap = new ScalarMap[]{null, null, null};
    private float[] barbValues = null;
    private int which_barb = -1;
    private float[] data_flow = new float[]{0.0f, 0.0f, 0.0f};
    private float data_speed = 0.0f;
    private float display_speed = 0.0f;
    private static final float EPS = 0.2f;
    private boolean refirst = false;
    private boolean stop = false;
    private float offsetx = 0.0f;
    private float offsety = 0.0f;
    private float offsetz = 0.0f;
    private int offset_count = 0;
    private static final int OFFSET_COUNT_INIT = 30;
    static final int N = 5;

    public ShadowType makeShadowFunctionType(FunctionType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbFunctionTypeJ2D(type, link, parent);
    }

    public ShadowType makeShadowRealTupleType(RealTupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbRealTupleTypeJ2D(type, link, parent);
    }

    public ShadowType makeShadowRealType(RealType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbRealTypeJ2D(type, link, parent);
    }

    public ShadowType makeShadowSetType(SetType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbSetTypeJ2D(type, link, parent);
    }

    public ShadowType makeShadowTupleType(TupleType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        return new ShadowBarbTupleTypeJ2D(type, link, parent);
    }

    public float[] makeVector(boolean south, float x, float y, float z, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, float[] vz, int[] numv, float[] tx, float[] ty, float[] tz, int[] numt) {
        return null;
    }

    public void setKnotsConvert(boolean enable) {
        this.knotsConvert = enable;
    }

    public boolean getKnotsConvert() {
        return this.knotsConvert;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DisplayImpl display = this.getDisplay();
        DataDisplayLink[] Links = this.getLinks();
        if (Links == null || Links.length == 0) {
            this.link = null;
            return;
        }
        this.link = Links[0];
        this.ref = this.link.getDataReference();
        this.type = this.link.getType();
        if (!(this.type instanceof TupleType) || !((TupleType)this.type).getFlat()) {
            this.whyNotDirect = notFlatTupleType;
            return;
        }
        this.flowToComponent = new int[]{-1, -1, -1};
        this.directMap = new ScalarMap[]{null, null, null};
        this.shadow = (ShadowTupleType)this.link.getShadow().getAdaptedShadowType();
        DisplayTupleType[] tuples = new DisplayTupleType[]{null};
        this.whyNotDirect = this.findFlow(this.shadow, display, tuples, this.flowToComponent);
        if (this.whyNotDirect != null) {
            return;
        }
        if (this.coord == null) {
            if (tuples[0] == null || this.flowToComponent[0] < 0 || this.flowToComponent[1] < 0) {
                this.whyNotDirect = noFlow;
                return;
            }
        } else if (tuples[0] == null || this.flowToComponent[1] < 0 || this.flowToComponent[2] < 0) {
            this.whyNotDirect = noFlow;
            return;
        }
        ShadowRealType[] components = this.shadow.getRealComponents();
        int i = 0;
        while (i < components.length) {
            DisplayTupleType spatial_tuple = components[i].getDisplaySpatialTuple();
            if (spatial_tuple != null && !Display.DisplaySpatialCartesianTuple.equals(spatial_tuple)) {
                this.whyNotDirect = nonCartesian;
                return;
            }
            ++i;
        }
        this.setIsDirectManipulation(true);
    }

    private String findFlow(ShadowTupleType shadow, DisplayImpl display, DisplayTupleType[] tuples, int[] flowToComponent) {
        ShadowRealType[] components = shadow.getRealComponents();
        int i = 0;
        while (i < components.length) {
            int num_flow_per_real = 0;
            Enumeration maps = components[i].getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                int index;
                ScalarMap map = (ScalarMap)maps.nextElement();
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType tuple = dreal.getTuple();
                if (Display.DisplayFlow1Tuple.equals(tuple) || Display.DisplayFlow2Tuple.equals(tuple)) {
                    if (tuples[0] != null) {
                        if (!tuples[0].equals(tuple)) {
                            return multipleFlowTuples;
                        }
                    } else {
                        tuples[0] = tuple;
                    }
                    if (++num_flow_per_real > 1) {
                        return multipleFlowMapping;
                    }
                    index = dreal.getTupleIndex();
                    flowToComponent[index] = i;
                    this.directMap[index] = map;
                    continue;
                }
                if (!Display.DisplayFlow1SphericalTuple.equals(tuple) && !Display.DisplayFlow2SphericalTuple.equals(tuple)) continue;
                if (tuples[0] != null) {
                    if (!tuples[0].equals(tuple)) {
                        return multipleFlowTuples;
                    }
                } else {
                    tuples[0] = tuple;
                    this.coord = tuple.getCoordinateSystem();
                }
                if (++num_flow_per_real > 1) {
                    return multipleFlowMapping;
                }
                index = dreal.getTupleIndex();
                flowToComponent[index] = i;
                this.directMap[index] = map;
            }
            ++i;
        }
        return null;
    }

    public void addPoint(float[] x) throws VisADException {
    }

    public synchronized void setVectorSpatialValues(float[] mbarb, int which) {
        this.barbValues = mbarb;
        this.which_barb = which;
    }

    public synchronized void setSpatialValues(float[][] spatial_values) {
    }

    public synchronized float checkClose(double[] origin, double[] direction) {
        if (this.barbValues == null) {
            return Float.MAX_VALUE;
        }
        float o_x = (float)origin[0];
        float o_y = (float)origin[1];
        float o_z = (float)origin[2];
        float d_x = (float)direction[0];
        float d_y = (float)direction[1];
        float d_z = (float)direction[2];
        float x = this.barbValues[2] - o_x;
        float y = this.barbValues[3] - o_y;
        float z = 0.0f - o_z;
        float dot = x * d_x + y * d_y + z * d_z;
        this.offsetx = x -= dot * d_x;
        this.offsety = y -= dot * d_y;
        this.offsetz = z -= dot * d_z;
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public synchronized void release_direct() {
    }

    public void stop_direct() {
        this.stop = true;
    }

    public synchronized void drag_direct(VisADRay ray, boolean first, int mouseModifiers) {
        if (this.barbValues == null || this.ref == null || this.shadow == null) {
            return;
        }
        if (first) {
            this.stop = false;
        } else if (this.stop) {
            return;
        }
        int mshift = mouseModifiers & 1;
        int mctrl = mouseModifiers & 2;
        float o_x = (float)ray.position[0];
        float o_y = (float)ray.position[1];
        float o_z = (float)ray.position[2];
        float d_x = (float)ray.vector[0];
        float d_y = (float)ray.vector[1];
        float d_z = (float)ray.vector[2];
        if (this.pickCrawlToCursor) {
            if (first) {
                this.offset_count = 30;
            } else if (this.offset_count > 0) {
                --this.offset_count;
            }
            if (this.offset_count > 0) {
                float mult = (float)this.offset_count / 30.0f;
                o_x += mult * this.offsetx;
                o_y += mult * this.offsety;
                o_z += mult * this.offsetz;
            }
        }
        if (first || this.refirst) {
            this.point_x = this.barbValues[2];
            this.point_y = this.barbValues[3];
            this.point_z = 0.0f;
            this.line_x = 0.0f;
            this.line_y = 0.0f;
            this.line_z = 1.0f;
        }
        float[] x = new float[3];
        float dot = (this.point_x - o_x) * this.line_x + (this.point_y - o_y) * this.line_y + (this.point_z - o_z) * this.line_z;
        float dot2 = d_x * this.line_x + d_y * this.line_y + d_z * this.line_z;
        if ((double)dot2 == 0.0) {
            return;
        }
        x[0] = o_x + (dot /= dot2) * d_x;
        x[1] = o_y + dot * d_y;
        x[2] = o_z + dot * d_z;
        try {
            float ratio;
            int j;
            Tuple data;
            try {
                data = (Tuple)this.link.getData();
            }
            catch (RemoteException re) {
                if (CollabUtil.isDisconnectException(re)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    return;
                }
                throw re;
            }
            int n = ((TupleType)data.getType()).getNumberOfRealComponents();
            Real[] reals = new Real[n];
            int k = 0;
            int m = data.getDimension();
            int i = 0;
            while (i < m) {
                Data component = data.getComponent(i);
                if (component instanceof Real) {
                    reals[k++] = (Real)component;
                } else if (component instanceof RealTuple) {
                    j = 0;
                    while (j < ((RealTuple)component).getDimension()) {
                        reals[k++] = (Real)((RealTuple)component).getComponent(j);
                        ++j;
                    }
                }
                ++i;
            }
            if (first || this.refirst) {
                int i2 = 0;
                while (i2 < 3) {
                    j = this.flowToComponent[i2];
                    this.data_flow[i2] = j >= 0 ? (float)reals[j].getValue() : 0.0f;
                    ++i2;
                }
                if (this.coord != null) {
                    Object ds = new float[][]{{this.data_flow[0]}, {this.data_flow[1]}, {this.data_flow[2]}};
                    ds = this.coord.toReference((float[][])ds);
                    this.data_flow[0] = ds[0][0];
                    this.data_flow[1] = ds[1][0];
                    this.data_flow[2] = ds[2][0];
                }
                this.data_speed = (float)Math.sqrt(this.data_flow[0] * this.data_flow[0] + this.data_flow[1] * this.data_flow[1] + this.data_flow[2] * this.data_flow[2]);
                float barb0 = this.barbValues[2] - this.barbValues[0];
                float barb1 = this.barbValues[3] - this.barbValues[1];
            }
            if (this.getRealVectorTypes(this.which_barb) instanceof EarthVectorType) {
                float eps = 1.0E-4f;
                float[][] spatial_locs = new float[][]{{this.barbValues[0], this.barbValues[0] + eps * (x[0] - this.barbValues[0])}, {this.barbValues[1], this.barbValues[1] + eps * (x[1] - this.barbValues[1])}, {0.0f, 0.0f}};
                float[][] earth_locs = this.spatialToEarth(spatial_locs);
                if (earth_locs == null) {
                    return;
                }
                x[2] = 0.0f;
                x[0] = (earth_locs[1][1] - earth_locs[1][0]) * (float)Math.cos(Math.PI / 180 * (double)earth_locs[0][0]);
                x[1] = earth_locs[0][1] - earth_locs[0][0];
            } else {
                x[0] = x[0] - this.barbValues[0];
                x[1] = x[1] - this.barbValues[1];
                double[] ranges = this.getRanges();
                int i3 = 0;
                while (i3 < 3) {
                    int n2 = i3;
                    x[n2] = (float)((double)x[n2] / ranges[i3]);
                    ++i3;
                }
            }
            x[0] = -x[0];
            x[1] = -x[1];
            x[2] = -x[2];
            float x_speed = (float)Math.sqrt(x[0] * x[0] + x[1] * x[1] + x[2] * x[2]);
            if (x_speed < 1.0E-6f) {
                x_speed = 1.0E-6f;
            }
            if (first || this.refirst) {
                this.display_speed = x_speed;
            }
            this.refirst = false;
            if (mshift != 0) {
                ratio = this.data_speed / x_speed;
                x[0] = x[0] * ratio;
                x[1] = x[1] * ratio;
                x[2] = x[2] * ratio;
            } else if (mctrl != 0) {
                ratio = x_speed / this.display_speed;
                if (this.data_speed < 0.2f) {
                    this.data_flow[0] = 0.4f;
                    this.refirst = true;
                }
                x[0] = ratio * this.data_flow[0];
                x[1] = ratio * this.data_flow[1];
                x[2] = ratio * this.data_flow[2];
            } else {
                ratio = this.data_speed / this.display_speed;
                if (this.data_speed < 0.2f) {
                    this.data_flow[0] = 0.4f;
                    x[0] = this.data_flow[0];
                    x[1] = this.data_flow[1];
                    x[2] = this.data_flow[2];
                    this.refirst = true;
                } else {
                    x[0] = x[0] * ratio;
                    x[1] = x[1] * ratio;
                    x[2] = x[2] * ratio;
                }
            }
            if (this.coord != null) {
                Object xs = new float[][]{{x[0]}, {x[1]}, {x[2]}};
                xs = this.coord.fromReference((float[][])xs);
                x[0] = xs[0][0];
                x[1] = xs[1][0];
                x[2] = xs[2][0];
            }
            Vector<String> vect = new Vector<String>();
            int i4 = 0;
            while (i4 < 3) {
                int j2 = this.flowToComponent[i4];
                if (j2 >= 0) {
                    RealType rtype = (RealType)reals[j2].getType();
                    reals[j2] = new Real(rtype, (double)x[i4], rtype.getDefaultUnit(), null);
                    Real r = reals[j2];
                    Unit overrideUnit = this.directMap[i4].getOverrideUnit();
                    Unit rtunit = rtype.getDefaultUnit();
                    if (overrideUnit != null && !overrideUnit.equals(rtunit) && !RealType.Time.equals(rtype)) {
                        double d = (float)overrideUnit.toThis(x[0], rtunit);
                        r = new Real(rtype, d, overrideUnit);
                        String valueString = r.toValueString();
                        vect.addElement(rtype.getName() + " = " + valueString);
                    } else {
                        vect.addElement(rtype.getName() + " = " + x[i4]);
                    }
                }
                ++i4;
            }
            this.getDisplayRenderer().setCursorStringVector(vect);
            Tuple newData = null;
            if (data instanceof RealTuple) {
                newData = new RealTuple((RealTupleType)data.getType(), reals, ((RealTuple)data).getCoordinateSystem());
            } else {
                Data[] new_components = new Data[m];
                k = 0;
                int i5 = 0;
                while (i5 < m) {
                    Data component = data.getComponent(i5);
                    if (component instanceof Real) {
                        new_components[i5] = reals[k++];
                    } else if (component instanceof RealTuple) {
                        Real[] sub_reals = new Real[((RealTuple)component).getDimension()];
                        int j3 = 0;
                        while (j3 < ((RealTuple)component).getDimension()) {
                            sub_reals[j3] = reals[k++];
                            ++j3;
                        }
                        new_components[i5] = new RealTuple((RealTupleType)component.getType(), sub_reals, ((RealTuple)component).getCoordinateSystem());
                    }
                    ++i5;
                }
                newData = new Tuple(new_components, false);
            }
            this.ref.setData(newData);
        }
        catch (VisADException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
        catch (RemoteException e) {
            System.out.println("drag_direct " + e);
            e.printStackTrace();
        }
    }

    public Object clone() {
        return new BarbManipulationRendererJ2D();
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        FlowControl flow_control;
        RealType lat = RealType.Latitude;
        RealType lon = RealType.Longitude;
        RealType windx = RealType.getRealType("windx", CommonUnit.meterPerSecond);
        RealType windy = RealType.getRealType("windy", CommonUnit.meterPerSecond);
        RealType red = RealType.getRealType("red");
        RealType green = RealType.getRealType("green");
        EarthVectorType windxy = new EarthVectorType(windx, windy);
        RealType wind_dir = RealType.getRealType("wind_dir", CommonUnit.degree);
        RealType wind_speed = RealType.getRealType("wind_speed", CommonUnit.meterPerSecond);
        RealTupleType windds = null;
        if (args.length > 0) {
            System.out.println("polar winds");
            windds = new RealTupleType(new RealType[]{wind_dir, wind_speed}, (CoordinateSystem)new WindPolarCoordinateSystem(windxy), null);
        }
        DisplayImplJ2D display = new DisplayImplJ2D("display1");
        ScalarMap lonmap = new ScalarMap(lon, Display.XAxis);
        display.addMap(lonmap);
        ScalarMap latmap = new ScalarMap(lat, Display.YAxis);
        display.addMap(latmap);
        if (args.length > 0) {
            ScalarMap winds_map = new ScalarMap(wind_speed, Display.Flow1Radial);
            display.addMap(winds_map);
            winds_map.setRange(0.0, 1.0);
            ScalarMap windd_map = new ScalarMap(wind_dir, Display.Flow1Azimuth);
            display.addMap(windd_map);
            windd_map.setRange(0.0, 360.0);
            flow_control = (FlowControl)windd_map.getControl();
            flow_control.setFlowScale(0.15f);
        } else {
            ScalarMap windx_map = new ScalarMap(windx, Display.Flow1X);
            display.addMap(windx_map);
            windx_map.setRange(-1.0, 1.0);
            ScalarMap windy_map = new ScalarMap(windy, Display.Flow1Y);
            display.addMap(windy_map);
            windy_map.setRange(-1.0, 1.0);
            flow_control = (FlowControl)windy_map.getControl();
            flow_control.setFlowScale(0.15f);
        }
        display.addMap(new ScalarMap(red, Display.Red));
        display.addMap(new ScalarMap(green, Display.Green));
        display.addMap(new ConstantMap(1.0, Display.Blue));
        DataReferenceImpl[] refs = new DataReferenceImpl[25];
        int k = 0;
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 5) {
                Tuple tuple;
                double u = 2.0 * (double)i / 4.0 - 1.0;
                double v = 2.0 * (double)j / 4.0 - 1.0;
                double fx = 30.0 * u;
                double fy = 30.0 * v;
                if (args.length > 0) {
                    double fd = 57.29577951308232 * Math.atan2(-fx, -fy);
                    double fs = Math.sqrt(fx * fx + fy * fy);
                    tuple = new Tuple(new Data[]{new Real(lon, 10.0 * u), new Real(lat, 10.0 * v - 40.0), new RealTuple(windds, new double[]{fd, fs}), new Real(red, u), new Real(green, v)});
                } else {
                    tuple = new Tuple(new Data[]{new Real(lon, 10.0 * u), new Real(lat, 10.0 * v - 40.0), new RealTuple(windxy, new double[]{fx, fy}), new Real(red, u), new Real(green, v)});
                }
                refs[k] = new DataReferenceImpl("ref_" + k);
                refs[k].setData(tuple);
                BarbManipulationRendererJ2D renderer = new BarbManipulationRendererJ2D();
                renderer.setKnotsConvert(true);
                display.addReferences((DataRenderer)renderer, refs[k]);
                WindGetterJ2D cell = new WindGetterJ2D(refs[k]);
                cell.addReference(refs[k]);
                ++k;
                ++j;
            }
            ++i;
        }
        JFrame frame = new JFrame("test BarbManipulationRendererJ2D");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentY(0.0f);
        panel.setAlignmentX(0.0f);
        frame.getContentPane().add(panel);
        panel.add(display.getComponent());
        frame.setSize(500, 500);
        frame.setVisible(true);
    }
}

