/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import visad.BaseUnit;
import visad.CommonUnit;
import visad.DerivedUnit;
import visad.ErrorEstimate;
import visad.OffsetUnit;
import visad.PromiscuousUnit;
import visad.ScaledUnit;
import visad.UnitException;
import visad.UnitExistsException;
import visad.VisADException;

public abstract class Unit
implements Serializable {
    private final String identifier;
    private static final Map identifierMap = new WeakHashMap();
    transient boolean hashCodeSet = false;
    transient int hashCode = 0;

    public static double[][] convertTuple(double[][] value, Unit[] units_in, Unit[] units_out) throws UnitException, VisADException {
        return Unit.convertTuple(value, units_in, units_out, true);
    }

    public static double[][] convertTuple(double[][] value, Unit[] units_in, Unit[] units_out, boolean copy) throws UnitException, VisADException {
        if (Arrays.equals(units_in, units_out) && !copy) {
            return value;
        }
        double[][] new_value = new double[value.length][];
        int i = 0;
        while (i < value.length) {
            if (units_out[i] == null) {
                if (units_in[i] != null && !(units_in[i] instanceof PromiscuousUnit)) {
                    throw new UnitException("Unit.convertTuple: illegal Unit conversion");
                }
                new_value[i] = value[i];
            } else {
                new_value[i] = units_out[i].equals(units_in[i]) && !copy ? value[i] : units_out[i].toThis(value[i], units_in[i]);
            }
            ++i;
        }
        return new_value;
    }

    public static float[][] convertTuple(float[][] value, Unit[] units_in, Unit[] units_out) throws UnitException, VisADException {
        return Unit.convertTuple(value, units_in, units_out, true);
    }

    public static float[][] convertTuple(float[][] value, Unit[] units_in, Unit[] units_out, boolean copy) throws UnitException, VisADException {
        if (Arrays.equals(units_in, units_out) && !copy) {
            return value;
        }
        float[][] new_value = new float[value.length][];
        int i = 0;
        while (i < value.length) {
            if (units_out[i] == null) {
                if (units_in[i] != null && !(units_in[i] instanceof PromiscuousUnit)) {
                    throw new UnitException("Unit.convertTuple: illegal Unit conversion");
                }
                new_value[i] = value[i];
            } else {
                new_value[i] = units_out[i].equals(units_in[i]) && !copy ? value[i] : units_out[i].toThis(value[i], units_in[i]);
            }
            ++i;
        }
        return new_value;
    }

    public static boolean canConvert(Unit unita, Unit unitb) {
        if (CommonUnit.promiscuous.equals(unita)) {
            unita = null;
        }
        if (CommonUnit.promiscuous.equals(unitb)) {
            unitb = null;
        }
        if (unita == null && unitb == null) {
            return true;
        }
        if (unita == null || unitb == null) {
            return false;
        }
        return unita.isConvertible(unitb);
    }

    public abstract boolean isConvertible(Unit var1);

    public static boolean canConvertArray(Unit[] unita, Unit[] unitb) {
        int n;
        if (unita == null && unitb == null) {
            return true;
        }
        if (unita == null) {
            unita = new Unit[unitb.length];
        }
        if (unitb == null) {
            unitb = new Unit[unita.length];
        }
        if ((n = unita.length) != unitb.length) {
            return false;
        }
        int i = 0;
        while (i < n) {
            if (!Unit.canConvert(unita[i], unitb[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Unit[] copyUnitsArray(Unit[] units) {
        return units == null ? null : (Unit[])units.clone();
    }

    public boolean equals(Object that) {
        if (!(that instanceof Unit)) {
            return false;
        }
        return this.equals((Unit)that);
    }

    public abstract int hashCode();

    public abstract boolean equals(Unit var1);

    public static double[] transformUnits(Unit unit_out, ErrorEstimate[] errors_out, Unit unit_in, ErrorEstimate error_in, double[] value) throws UnitException, VisADException {
        if (unit_out == null || unit_in == null) {
            errors_out[0] = error_in;
            return value;
        }
        double[] val = unit_out.toThis(value, unit_in);
        if (error_in == null) {
            errors_out[0] = null;
        } else {
            double error = 0.5 * error_in.getErrorValue();
            double mean = error_in.getMean();
            double new_error = Math.abs(unit_out.toThis(mean + error, unit_in) - unit_out.toThis(mean - error, unit_in));
            errors_out[0] = new ErrorEstimate(val, new_error, unit_out);
        }
        return val;
    }

    public static float[] transformUnits(Unit unit_out, ErrorEstimate[] errors_out, Unit unit_in, ErrorEstimate error_in, float[] value) throws UnitException, VisADException {
        if (unit_out == null || unit_in == null) {
            errors_out[0] = error_in;
            return value;
        }
        float[] val = unit_out.toThis(value, unit_in);
        if (error_in == null) {
            errors_out[0] = null;
        } else {
            double error = 0.5 * error_in.getErrorValue();
            double mean = error_in.getMean();
            double new_error = Math.abs(unit_out.toThis(mean + error, unit_in) - unit_out.toThis(mean - error, unit_in));
            errors_out[0] = new ErrorEstimate(val, new_error, unit_out);
        }
        return val;
    }

    Unit scale(double amount, boolean b) {
        return new ScaledUnit(amount, (BaseUnit)this);
    }

    protected Unit() {
        this.identifier = null;
    }

    protected Unit(String identifier) {
        try {
            identifier = this.adjustCheckAndCache(identifier);
        }
        catch (UnitExistsException e) {
            System.err.println("WARNING: " + e);
        }
        this.identifier = identifier;
    }

    protected final String adjustCheckAndCache(String identifier) throws UnitExistsException {
        if (identifier != null && identifier.length() > 0) {
            identifier = identifier.replace(' ', '_');
        }
        return identifier;
    }

    public abstract boolean isDimensionless();

    public Unit clone(String identifier) throws UnitException {
        return this.protectedClone(this.adjustCheckAndCache(identifier));
    }

    protected abstract Unit protectedClone(String var1) throws UnitException;

    public abstract Unit pow(int var1) throws UnitException;

    public abstract Unit root(int var1) throws IllegalArgumentException, UnitException;

    public Unit sqrt() throws IllegalArgumentException, UnitException {
        return this.root(2);
    }

    public abstract Unit pow(double var1) throws UnitException, IllegalArgumentException;

    public Unit scale(double amount) throws UnitException {
        if (this instanceof BaseUnit) {
            return new ScaledUnit(amount, (BaseUnit)this);
        }
        if (this instanceof DerivedUnit) {
            return new ScaledUnit(amount, (DerivedUnit)this);
        }
        if (this instanceof ScaledUnit) {
            return new ScaledUnit(amount, (ScaledUnit)this);
        }
        if (this instanceof OffsetUnit) {
            return new OffsetUnit(((OffsetUnit)this).offset / amount, new ScaledUnit(amount, ((OffsetUnit)this).scaledUnit));
        }
        throw new UnitException("Unknown unit subclass: " + this);
    }

    public Unit shift(double offset) throws UnitException {
        OffsetUnit unit;
        if (this instanceof BaseUnit) {
            unit = new OffsetUnit(offset, (BaseUnit)this);
        } else if (this instanceof DerivedUnit) {
            unit = new OffsetUnit(offset, (DerivedUnit)this);
        } else if (this instanceof ScaledUnit) {
            unit = new OffsetUnit(offset, (ScaledUnit)this);
        } else if (this instanceof OffsetUnit) {
            unit = new OffsetUnit(offset, (OffsetUnit)this);
        } else {
            throw new UnitException("Unit.shift(): Unknown unit subclass: " + this);
        }
        return unit;
    }

    public abstract Unit multiply(Unit var1) throws UnitException;

    public abstract Unit divide(Unit var1) throws UnitException;

    protected abstract Unit divideInto(Unit var1) throws UnitException;

    public double toThis(double value, Unit that) throws UnitException {
        return this.toThis(new double[]{value}, that)[0];
    }

    public abstract double[] toThis(double[] var1, Unit var2) throws UnitException;

    public abstract float[] toThis(float[] var1, Unit var2) throws UnitException;

    public double toThat(double value, Unit that) throws UnitException {
        return this.toThat(new double[]{value}, that)[0];
    }

    public abstract double[] toThat(double[] var1, Unit var2) throws UnitException;

    public abstract float[] toThat(float[] var1, Unit var2) throws UnitException;

    public final String toString() {
        String s = this.getIdentifier();
        if (s == null) {
            s = this.getDefinition();
        }
        return s;
    }

    public final String getIdentifier() {
        return this.identifier;
    }

    public abstract String getDefinition();

    public Unit getAbsoluteUnit() {
        return this;
    }
}

