/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class SingletonSet
extends SampledSet {
    private RealTuple data;
    private static final int[] nilNeighbors = new int[0];

    public SingletonSet(RealTuple d) throws VisADException, RemoteException {
        this(d, d.getType(), null, d.getTupleUnits(), null);
    }

    public SingletonSet(RealTuple d, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException, RemoteException {
        this(d, d.getType(), coord_sys, units, errors);
    }

    private SingletonSet(RealTuple d, MathType type, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException, RemoteException {
        super(type, 0, coord_sys, units, errors);
        int dim = d.getDimension();
        float[][] samples = new float[dim][1];
        int k = 0;
        while (k < dim) {
            samples[k][0] = (float)((Real)d.getComponent(k)).getValue();
            ++k;
        }
        this.init_samples(samples);
        this.data = d;
        this.Length = 1;
        int j = 0;
        while (j < this.DomainDimension) {
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), ((Real)this.data.getComponent(j)).getValue(), 1L, this.SetErrors[j].getUnit());
            }
            ++j;
        }
    }

    public SingletonSet(RealTupleType type, double[] values, CoordinateSystem coordSys, Unit[] units, ErrorEstimate[] errors) throws VisADException, RemoteException {
        super(type, 0, coordSys, units, errors);
        int dim = type.getDimension();
        float[][] samples = new float[dim][1];
        Real[] reals = new Real[dim];
        units = this.getSetUnits();
        errors = this.getSetErrors();
        int k = 0;
        while (k < dim) {
            samples[k][0] = (float)values[k];
            reals[k] = new Real((RealType)type.getComponent(k), values[k], units[k], errors[k]);
            ++k;
        }
        this.init_samples(samples);
        this.data = new RealTuple(type, reals, coordSys);
        this.Length = 1;
    }

    public boolean isMissing() {
        return false;
    }

    public void getNeighbors(int[][] neighbors) {
        neighbors[0] = nilNeighbors;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(index));
    }

    public double[][] indexToDouble(int[] index) throws VisADException {
        int length = index.length;
        double[][] value = new double[this.DomainDimension][length];
        double[] v = new double[this.DomainDimension];
        int k = 0;
        while (k < this.DomainDimension) {
            try {
                v[k] = ((Real)this.data.getComponent(k)).getValue();
            }
            catch (RemoteException e) {
                v[k] = Double.NaN;
            }
            ++k;
        }
        int i = 0;
        while (i < length) {
            int k2;
            if (index[i] < 0 || index[i] >= this.Length) {
                k2 = 0;
                while (k2 < this.DomainDimension) {
                    value[k2][i] = Double.NaN;
                    ++k2;
                }
            } else {
                k2 = 0;
                while (k2 < this.DomainDimension) {
                    value[k2][i] = v[k2];
                    ++k2;
                }
            }
            ++i;
        }
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(value));
    }

    public int[] doubleToIndex(double[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("SingletonSet.doubleToIndex: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int length = value[0].length;
        int[] index = new int[length];
        int i = 0;
        while (i < length) {
            index[i] = 0;
            ++i;
        }
        return index;
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("SingletonSet.valueToInterp: bad dimension");
        }
        int length = value[0].length;
        if (indices.length != length || weights.length != length) {
            throw new SetException("SingletonSet.valueToInterp: lengths don't match");
        }
        int i = 0;
        while (i < length) {
            indices[i] = new int[1];
            weights[i] = new float[1];
            indices[i][0] = 0;
            weights[i][0] = 1.0f;
            ++i;
        }
    }

    public void doubleToInterp(double[][] value, int[][] indices, double[][] weights) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("SingletonSet.doubleToInterp: bad dimension");
        }
        int length = value[0].length;
        if (indices.length != length || weights.length != length) {
            throw new SetException("SingletonSet.doubleToInterp: lengths don't match");
        }
        int i = 0;
        while (i < length) {
            indices[i] = new int[1];
            weights[i] = new double[1];
            indices[i][0] = 0;
            weights[i][0] = 1.0;
            ++i;
        }
    }

    public double[][] getDoubles(boolean copy) throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            indices[i] = i;
            ++i;
        }
        return this.indexToDouble(indices);
    }

    public RealTuple getData() {
        return this.data;
    }

    public boolean equals(Object set) {
        if (!(set instanceof SingletonSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        if (this.DomainDimension != ((SingletonSet)set).getDimension()) {
            return false;
        }
        return this.data.equals(((SingletonSet)set).getData());
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.DomainDimension ^ this.data.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object cloneButType(MathType type) throws VisADException {
        try {
            return new SingletonSet(this.data, type, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (RemoteException e) {
            throw new VisADError("SingletonSet.cloneButType: " + e.toString());
        }
    }

    public String longString(String pre) throws VisADException {
        return pre + "SingletonSet: " + this.data;
    }
}

