/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Vector;
import visad.BadMappingException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowScalarType;
import visad.ShadowSetType;
import visad.ShadowTextType;
import visad.ShadowType;
import visad.Text;
import visad.TextControl;
import visad.TupleIface;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;

public class ShadowTupleType
extends ShadowType {
    ShadowType[] tupleComponents;
    private ShadowRealType[] RealComponents;
    private int[] inherited_values;
    private boolean Flat;

    public ShadowTupleType(MathType t, DataDisplayLink link, ShadowType parent, ShadowType[] tcs) throws VisADException, RemoteException {
        super(t, link, parent);
        this.tupleComponents = tcs;
        int n = this.tupleComponents.length;
        this.Flat = true;
        ShadowType[] components = new ShadowType[n];
        this.MultipleSpatialDisplayScalar = false;
        this.MultipleDisplayScalar = false;
        int i = 0;
        while (i < n) {
            ShadowType shadow = this.tupleComponents[i];
            this.MultipleSpatialDisplayScalar |= this.tupleComponents[i].getMultipleSpatialDisplayScalar();
            this.MultipleDisplayScalar |= this.tupleComponents[i].getMultipleDisplayScalar();
            boolean mappedComponent = this.tupleComponents[i].getMappedDisplayScalar();
            this.MappedDisplayScalar |= mappedComponent;
            if (shadow instanceof ShadowFunctionType || shadow instanceof ShadowSetType || shadow instanceof ShadowTupleType && !(shadow instanceof ShadowRealTupleType)) {
                if (mappedComponent) {
                    this.Flat = false;
                }
            } else if (shadow instanceof ShadowScalarType || shadow instanceof ShadowRealTupleType) {
                this.DisplayIndices = ShadowType.addIndices(this.DisplayIndices, shadow.getDisplayIndices());
                this.ValueIndices = ShadowType.addIndices(this.ValueIndices, shadow.getValueIndices());
            }
            ++i;
        }
        this.RealComponents = this.getComponents(this, true);
    }

    public ShadowRealType[] getRealComponents() {
        return this.RealComponents;
    }

    int[] sumIndices(int[] indices) {
        int[] local_indices = ShadowType.copyIndices(indices);
        int n = this.tupleComponents.length;
        int j = 0;
        while (j < n) {
            ShadowType shadow = this.tupleComponents[j];
            if (shadow instanceof ShadowScalarType) {
                ((ShadowScalarType)shadow).incrementIndices(local_indices);
            } else if (shadow instanceof ShadowRealTupleType) {
                local_indices = ((ShadowRealTupleType)shadow).sumIndices(local_indices);
            }
            ++j;
        }
        return local_indices;
    }

    int[] sumDisplayIndices(int[] display_indices) throws VisADException {
        return ShadowType.addIndices(display_indices, this.DisplayIndices);
    }

    int[] sumValueIndices(int[] value_indices) throws VisADException {
        return ShadowType.addIndices(value_indices, this.ValueIndices);
    }

    public int checkIndices(int[] indices, int[] display_indices, int[] value_indices, boolean[] isTransform, int levelOfDifficulty) throws VisADException, RemoteException {
        int[] local_indices = this.sumIndices(indices);
        int[] local_display_indices = this.sumDisplayIndices(display_indices);
        int[] local_value_indices = this.sumValueIndices(value_indices);
        this.anyContour = this.checkContour(local_display_indices);
        this.anyFlow = this.checkFlow(local_display_indices);
        this.anyShape = this.checkShape(local_display_indices);
        this.anyText = this.checkText(local_display_indices);
        this.markTransform(isTransform);
        this.inherited_values = ShadowType.copyIndices(value_indices);
        if (levelOfDifficulty == 6 && this.checkAny(this.DisplayIndices)) {
            levelOfDifficulty = 2;
        }
        if (this.Flat) {
            if (this.checkAnimationOrValue(this.DisplayIndices) > 0) {
                throw new BadMappingException("Animation and SelectValue may not occur in range: ShadowTupleType.checkIndices");
            }
            this.LevelOfDifficulty = this.testIndices(local_indices, local_display_indices, levelOfDifficulty);
            if (this.LevelOfDifficulty == 2) {
                this.LevelOfDifficulty = this.checkR2D2(this.DisplayIndices) ? 5 : 1;
            }
        } else {
            if (levelOfDifficulty == 2 && !this.checkNested(this.DisplayIndices)) {
                levelOfDifficulty = 1;
            }
            int minLevelOfDifficulty = 6;
            int j = 0;
            while (j < this.tupleComponents.length) {
                int level;
                ShadowType shadow = this.tupleComponents[j];
                if ((shadow instanceof ShadowFunctionType || shadow instanceof ShadowSetType || shadow instanceof ShadowTupleType && !(shadow instanceof ShadowRealTupleType)) && (level = shadow.checkIndices(local_indices, local_display_indices, local_value_indices, isTransform, levelOfDifficulty)) < minLevelOfDifficulty) {
                    minLevelOfDifficulty = level;
                }
                ++j;
            }
            this.LevelOfDifficulty = minLevelOfDifficulty;
        }
        return this.LevelOfDifficulty;
    }

    public int[] getInheritedValues() {
        return this.inherited_values;
    }

    public int getDimension() {
        return this.tupleComponents.length;
    }

    public ShadowType getComponent(int i) {
        return this.tupleComponents[i];
    }

    void markTransform(boolean[] isTransform) {
        int i = 0;
        while (i < this.tupleComponents.length) {
            this.tupleComponents[i].markTransform(isTransform);
            ++i;
        }
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        boolean[][] range_select;
        int i;
        if (data.isMissing()) {
            return false;
        }
        if (this.LevelOfDifficulty == 6) {
            return false;
        }
        if (!(data instanceof TupleIface)) {
            throw new DisplayException("data must be Tuple: ShadowTupleType.doTransform");
        }
        int valueArrayLength = this.display.getValueArrayLength();
        int[] valueToScalar = this.display.getValueToScalar();
        int[] valueToMap = this.display.getValueToMap();
        Vector MapVector = this.display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = this.getInheritedValues();
        int i2 = 0;
        while (i2 < valueArrayLength) {
            if (inherited_values[i2] > 0) {
                display_values[i2] = new float[1];
                display_values[i2][0] = value_array[i2];
            }
            ++i2;
        }
        TupleIface tuple = (TupleIface)data;
        RealType[] realComponents = ((TupleType)data.getType()).getRealComponents();
        int length = realComponents.length;
        if (length > 0) {
            int n;
            double[][] value = new double[length][1];
            Unit[] value_units = new Unit[length];
            int j = 0;
            i = 0;
            while (i < tuple.getDimension()) {
                Data component = tuple.getComponent(i);
                if (component instanceof Real) {
                    value_units[j] = realComponents[j].getDefaultUnit();
                    value[j][0] = ((Real)component).getValue(value_units[j]);
                    ++j;
                } else if (component instanceof RealTuple) {
                    int k = 0;
                    while (k < ((RealTuple)component).getDimension()) {
                        value_units[j] = realComponents[j].getDefaultUnit();
                        value[j][0] = ((Real)((RealTuple)component).getComponent(k)).getValue(value_units[j]);
                        ++j;
                        ++k;
                    }
                }
                ++i;
            }
            ShadowRealType[] RealComponents = this.getRealComponents();
            ShadowType.mapValues((float[][])display_values, value, RealComponents);
            int[] refToComponent = this.getRefToComponent();
            ShadowRealTupleType[] componentWithRef = this.getComponentWithRef();
            int[] componentIndex = this.getComponentIndex();
            if (refToComponent != null) {
                int i3 = 0;
                while (i3 < refToComponent.length) {
                    CoordinateSystem range_coord_sys;
                    Unit[] range_units;
                    n = componentWithRef[i3].getDimension();
                    int start = refToComponent[i3];
                    double[][] values = new double[n][];
                    j = 0;
                    while (j < n) {
                        values[j] = value[j + start];
                        ++j;
                    }
                    ShadowRealTupleType component_reference = componentWithRef[i3].getReference();
                    RealTupleType ref = (RealTupleType)component_reference.getType();
                    if (i3 == 0 && componentWithRef[i3].equals(this)) {
                        range_units = value_units;
                        range_coord_sys = ((RealTuple)data).getCoordinateSystem();
                    } else {
                        range_units = new Unit[n];
                        j = 0;
                        while (j < n) {
                            range_units[j] = value_units[j + start];
                            ++j;
                        }
                        range_coord_sys = ((RealTuple)((TupleIface)data).getComponent(componentIndex[i3])).getCoordinateSystem();
                    }
                    double[][] reference_values = CoordinateSystem.transformCoordinates(ref, null, ref.getDefaultUnits(), null, (RealTupleType)componentWithRef[i3].getType(), range_coord_sys, range_units, null, values);
                    renderer.setEarthSpatialData(componentWithRef[i3], component_reference, ref, ref.getDefaultUnits(), (RealTupleType)componentWithRef[i3].getType(), new CoordinateSystem[]{range_coord_sys}, range_units);
                    ShadowType.mapValues((float[][])display_values, reference_values, this.getComponents(component_reference, false));
                    reference_values = null;
                    values = null;
                    ++i3;
                }
            }
            if (this instanceof ShadowTupleType) {
                if (this instanceof ShadowRealTupleType) {
                    Unit[] range_units = value_units;
                    CoordinateSystem range_coord_sys = ((RealTuple)data).getCoordinateSystem();
                    ShadowRealTupleType component_reference = ((ShadowRealTupleType)this).getReference();
                    RealTupleType ref = component_reference == null ? null : (RealTupleType)component_reference.getType();
                    Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                    renderer.setEarthSpatialData((ShadowRealTupleType)this, component_reference, ref, ref_units, (RealTupleType)this.getType(), new CoordinateSystem[]{range_coord_sys}, range_units);
                } else {
                    int start = 0;
                    n = this.getDimension();
                    int i4 = 0;
                    while (i4 < n) {
                        ShadowType component = this.getComponent(i4);
                        if (component instanceof ShadowRealTupleType) {
                            int m = ((ShadowRealTupleType)component).getDimension();
                            Unit[] range_units = new Unit[m];
                            j = 0;
                            while (j < m) {
                                range_units[j] = value_units[j + start];
                                ++j;
                            }
                            CoordinateSystem range_coord_sys = ((RealTuple)((TupleIface)data).getComponent(i4)).getCoordinateSystem();
                            ShadowRealTupleType component_reference = ((ShadowRealTupleType)component).getReference();
                            RealTupleType ref = component_reference == null ? null : (RealTupleType)component_reference.getType();
                            Unit[] ref_units = ref == null ? null : ref.getDefaultUnits();
                            renderer.setEarthSpatialData((ShadowRealTupleType)component, component_reference, ref, ref_units, (RealTupleType)component.getType(), new CoordinateSystem[]{range_coord_sys}, range_units);
                            start += ((ShadowRealTupleType)component).getDimension();
                        } else if (component instanceof ShadowRealType) {
                            ++start;
                        }
                        ++i4;
                    }
                }
            }
        }
        String text_value = this.getParentText();
        TextControl text_control = this.getParentTextControl();
        boolean anyText = this.getAnyText();
        if (anyText && text_value == null) {
            i = 0;
            while (i < valueArrayLength) {
                if (display_values[i] != null) {
                    int displayScalarIndex = valueToScalar[i];
                    ScalarMap map = (ScalarMap)MapVector.elementAt(valueToMap[i]);
                    ScalarType real = map.getScalar();
                    DisplayRealType dreal = this.display.getDisplayScalar(displayScalarIndex);
                    if (dreal.equals(Display.Text) && real instanceof RealType) {
                        text_control = (TextControl)map.getControl();
                        NumberFormat format = text_control.getNumberFormat();
                        if (display_values[i][0] != display_values[i][0]) {
                            text_value = "";
                            break;
                        }
                        if (format == null) {
                            text_value = PlotText.shortString(display_values[i][0]);
                            break;
                        }
                        text_value = format.format(display_values[i][0]);
                        break;
                    }
                }
                ++i;
            }
            if (text_value == null) {
                int i5 = 0;
                while (i5 < tuple.getDimension()) {
                    ShadowTextType type;
                    Vector maps;
                    Data component = tuple.getComponent(i5);
                    if (component instanceof Text && !(maps = (type = (ShadowTextType)this.tupleComponents[i5]).getSelectedMapVector()).isEmpty()) {
                        text_value = ((Text)component).getValue();
                        ScalarMap map = (ScalarMap)maps.firstElement();
                        text_control = (TextControl)map.getControl();
                    }
                    ++i5;
                }
            }
        }
        if ((range_select = shadow_api.assembleSelect(display_values, 1, valueArrayLength, valueToScalar, this.display, shadow_api))[0] != null && !range_select[0][0]) {
            return false;
        }
        if (this.getIsTerminal()) {
            return this.terminalTupleOrScalar(group, display_values, text_value, text_control, valueArrayLength, valueToScalar, default_values, inherited_values, renderer, shadow_api);
        }
        boolean post = false;
        int i6 = 0;
        while (i6 < valueArrayLength) {
            if (display_values[i6] != null) {
                value_array[i6] = display_values[i6][0];
            }
            ++i6;
        }
        if (text_value != null && text_control != null) {
            this.setText(text_value, text_control);
        } else {
            this.setText(null, null);
        }
        int i7 = 0;
        while (i7 < tuple.getDimension()) {
            Data component = tuple.getComponent(i7);
            if (!(component instanceof Real) && !(component instanceof RealTuple)) {
                int[] lat_lon_indices = renderer.getLatLonIndices();
                post |= shadow_api.recurseComponent(i7, group, component, value_array, default_values, renderer);
                renderer.setLatLonIndices(lat_lon_indices);
            }
            ++i7;
        }
        return post;
    }

    public boolean isFlat() {
        return this.Flat;
    }
}

