/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.MathType;
import visad.PlotText;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.ShadowScalarType;
import visad.ShadowType;
import visad.TextControl;
import visad.VisADException;

public class ShadowRealType
extends ShadowScalarType {
    public ShadowRealType(MathType type, DataDisplayLink link, ShadowType parent) throws VisADException, RemoteException {
        super(type, link, parent);
    }

    public boolean doTransform(Object group, Data data, float[] value_array, float[] default_values, DataRenderer renderer, ShadowType shadow_api) throws VisADException, RemoteException {
        boolean[][] range_select;
        if (data.isMissing()) {
            return false;
        }
        if (this.LevelOfDifficulty == 6) {
            return false;
        }
        if (!(data instanceof Real)) {
            throw new DisplayException("data must be Real: ShadowRealType.doTransform");
        }
        int valueArrayLength = this.display.getValueArrayLength();
        int[] valueToScalar = this.display.getValueToScalar();
        int[] valueToMap = this.display.getValueToMap();
        Vector MapVector = this.display.getMapVector();
        float[][] display_values = new float[valueArrayLength][];
        int[] inherited_values = this.getInheritedValues();
        int i = 0;
        while (i < valueArrayLength) {
            if (inherited_values[i] > 0) {
                display_values[i] = new float[1];
                display_values[i][0] = value_array[i];
            }
            ++i;
        }
        Real real = (Real)data;
        RealType rtype = (RealType)this.getType();
        RealType[] realComponents = new RealType[]{rtype};
        double[][] value = new double[1][1];
        value[0][0] = real.getValue(rtype.getDefaultUnit());
        ShadowRealType[] RealComponents = new ShadowRealType[]{this};
        ShadowType.mapValues((float[][])display_values, value, RealComponents);
        String text_value = this.getParentText();
        TextControl text_control = this.getParentTextControl();
        if (this.getAnyText() && text_value == null) {
            Enumeration maps = this.getSelectedMapVector().elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                DisplayRealType dreal = map.getDisplayScalar();
                if (!dreal.equals(Display.Text)) continue;
                text_control = (TextControl)map.getControl();
                NumberFormat format = text_control.getNumberFormat();
                if (value[0][0] != value[0][0]) {
                    text_value = "";
                    break;
                }
                if (format == null) {
                    text_value = PlotText.shortString(value[0][0]);
                    break;
                }
                text_value = format.format(value[0][0]);
                break;
            }
        }
        if ((range_select = shadow_api.assembleSelect(display_values, 1, valueArrayLength, valueToScalar, this.display, shadow_api))[0] != null && !range_select[0][0]) {
            return false;
        }
        if (this.getIsTerminal()) {
            return this.terminalTupleOrScalar(group, display_values, text_value, text_control, valueArrayLength, valueToScalar, default_values, inherited_values, renderer, shadow_api);
        }
        return false;
    }
}

