/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class PolarCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.degree, null};

    public PolarCoordinateSystem(RealTupleType reference) throws VisADException {
        super(reference, coordinate_system_units);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[2][len];
        int i = 0;
        while (i < len) {
            if (tuples[1][i] < 0.0) {
                value[0][i] = Double.NaN;
                value[1][i] = Double.NaN;
            } else {
                double coslon = Math.cos(Math.PI / 180 * tuples[0][i]);
                double sinlon = Math.sin(Math.PI / 180 * tuples[0][i]);
                value[0][i] = tuples[1][i] * coslon;
                value[1][i] = tuples[1][i] * sinlon;
            }
            ++i;
        }
        return value;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        double[][] value = new double[2][len];
        int i = 0;
        while (i < len) {
            value[1][i] = Math.sqrt(tuples[0][i] * tuples[0][i] + tuples[1][i] * tuples[1][i]);
            value[0][i] = 57.29577951308232 * Math.atan2(tuples[1][i], tuples[0][i]);
            if (value[0][i] < 0.0) {
                double[] dArray = value[0];
                int n = i;
                dArray[n] = dArray[n] + 360.0;
            }
            ++i;
        }
        return value;
    }

    public float[][] toReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.toReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[2][len];
        int i = 0;
        while (i < len) {
            if ((double)tuples[1][i] < 0.0) {
                value[0][i] = Float.NaN;
                value[1][i] = Float.NaN;
            } else {
                float coslon = (float)Math.cos(Math.PI / 180 * (double)tuples[0][i]);
                float sinlon = (float)Math.sin(Math.PI / 180 * (double)tuples[0][i]);
                value[0][i] = tuples[1][i] * coslon;
                value[1][i] = tuples[1][i] * sinlon;
            }
            ++i;
        }
        return value;
    }

    public float[][] fromReference(float[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("PolarCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int len = tuples[0].length;
        float[][] value = new float[2][len];
        int i = 0;
        while (i < len) {
            value[1][i] = (float)Math.sqrt(tuples[0][i] * tuples[0][i] + tuples[1][i] * tuples[1][i]);
            value[0][i] = (float)(57.29577951308232 * Math.atan2(tuples[1][i], tuples[0][i]));
            if ((double)value[0][i] < 0.0) {
                float[] fArray = value[0];
                int n = i;
                fArray[n] = (float)((double)fArray[n] + 360.0);
            }
            ++i;
        }
        return value;
    }

    public boolean equals(Object cs) {
        return cs instanceof PolarCoordinateSystem;
    }
}

