/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RendererSourceListener;
import visad.VisADException;
import visad.VisADRay;
import visad.browser.Convert;
import visad.java2d.MouseBehaviorJ2D;

public class MouseHelper
implements RendererSourceListener {
    MouseBehavior behavior;
    DisplayRenderer display_renderer;
    DisplayImpl display;
    private ProjectionControl proj;
    private double xymul;
    DataRenderer direct_renderer = null;
    private double[] tstart;
    private int start_x;
    private int start_y;
    private double xmul;
    private double ymul;
    private double[] xtrans = new double[3];
    private double[] ytrans = new double[3];
    private boolean mouseEntered;
    private int mouseModifiers;
    private boolean mode2D;
    public static final int NONE = -1;
    public static final int ROTATE = 0;
    public static final int ZOOM = 1;
    public static final int TRANSLATE = 2;
    public static final int CURSOR_TRANSLATE = 3;
    public static final int CURSOR_ZOOM = 4;
    public static final int CURSOR_ROTATE = 5;
    public static final int DIRECT = 6;
    public static final int NFUNCTIONS = 7;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    boolean[] actual_button = new boolean[]{false, false, false};
    int virtual_button = -1;
    boolean[] function = new boolean[]{false, false, false, false, false, false, false};
    boolean[] old_function = new boolean[]{false, false, false, false, false, false, false};
    boolean enable_combos = true;
    int[][][] function_map = new int[][][]{new int[][]{{0, 1}, {2, -1}}, new int[][]{{3, 4}, {5, -1}}, new int[][]{{6, 6}, {6, 6}}};
    private boolean first = true;

    public MouseHelper(DisplayRenderer r, MouseBehavior b) {
        this.behavior = b;
        this.display_renderer = r;
        this.display = this.display_renderer.getDisplay();
        this.proj = this.display.getProjectionControl();
        this.mode2D = this.display_renderer.getMode2D();
        this.display.addRendererSourceListener(this);
        this.function = new boolean[]{false, false, false, false, false, false, false};
        this.enable_combos = true;
    }

    public void processEvent(AWTEvent event) {
        this.processEvent(event, 0);
    }

    public void processEvent(AWTEvent event, int remoteId) {
        block82: {
            boolean matrix;
            int event_id;
            MouseEvent mouse_event;
            block81: {
                int f;
                DisplayEvent e;
                if (this.behavior == null) {
                    return;
                }
                if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 501) {
                    this.start_x = 0;
                    this.start_y = 0;
                    VisADRay start_ray = this.behavior.findRay(this.start_x, this.start_y);
                    VisADRay start_ray_x = this.behavior.findRay(this.start_x + 1, this.start_y);
                    VisADRay start_ray_y = this.behavior.findRay(this.start_x, this.start_y + 1);
                    if (start_ray != null && start_ray_x != null && start_ray_y != null) {
                        double[] tstart = this.proj.getMatrix();
                        double[] rot = new double[3];
                        double[] scale = new double[1];
                        double[] trans = new double[3];
                        this.behavior.instance_unmake_matrix(rot, scale, trans, tstart);
                        double[] trot = this.behavior.make_matrix(rot[0], rot[1], rot[2], scale[0], 0.0, 0.0, 0.0);
                        double[] xmat = this.behavior.make_translate(start_ray_x.position[0] - start_ray.position[0], start_ray_x.position[1] - start_ray.position[1], start_ray_x.position[2] - start_ray.position[2]);
                        double[] ymat = this.behavior.make_translate(start_ray_y.position[0] - start_ray.position[0], start_ray_y.position[1] - start_ray.position[1], start_ray_y.position[2] - start_ray.position[2]);
                        double[] xmatmul = this.behavior.multiply_matrix(trot, xmat);
                        double[] ymatmul = this.behavior.multiply_matrix(trot, ymat);
                        this.behavior.instance_unmake_matrix(rot, scale, trans, xmatmul);
                        double xmul = trans[0];
                        this.behavior.instance_unmake_matrix(rot, scale, trans, ymatmul);
                        double ymul = trans[1];
                        this.xymul = Math.sqrt(xmul * xmul + ymul * ymul);
                        this.first = false;
                    }
                }
                if (!(event instanceof MouseEvent)) {
                    System.out.println("MouseHelper.processStimulus: non-MouseEvent");
                    return;
                }
                mouse_event = (MouseEvent)event;
                event_id = event.getID();
                if (event_id == 504) {
                    this.mouseEntered = true;
                    try {
                        e = new DisplayEvent((Display)this.display, 19, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e2) {
                    }
                    catch (RemoteException e3) {
                        // empty catch block
                    }
                    return;
                }
                if (event_id == 505) {
                    this.mouseEntered = false;
                    try {
                        e = new DisplayEvent((Display)this.display, 20, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e4) {
                    }
                    catch (RemoteException e5) {
                        // empty catch block
                    }
                    return;
                }
                if (event_id == 503) {
                    try {
                        e = new DisplayEvent((Display)this.display, 21, mouse_event, remoteId);
                        this.display.notifyListeners(e);
                    }
                    catch (VisADException e6) {
                    }
                    catch (RemoteException e7) {
                        // empty catch block
                    }
                    return;
                }
                if (event_id != 501 && event_id != 502) break block81;
                int m = ((InputEvent)event).getModifiers();
                int m1 = m & 0x10;
                int m2 = m & 8;
                int m3 = m & 4;
                int mctrl = m & 2;
                int mshift = m & 1;
                if (event_id == 501) {
                    this.display.updateBusyStatus();
                    if (m1 != 0) {
                        this.actual_button[0] = true;
                    }
                    if (m2 != 0) {
                        this.actual_button[1] = true;
                    }
                    if (m3 != 0) {
                        this.actual_button[2] = true;
                    }
                    this.mouseModifiers = m;
                } else {
                    this.display.updateBusyStatus();
                    if (m1 != 0) {
                        this.actual_button[0] = false;
                    }
                    if (m2 != 0) {
                        this.actual_button[1] = false;
                    }
                    if (m3 != 0) {
                        this.actual_button[2] = false;
                    }
                    this.mouseModifiers = 0;
                }
                int n = 0;
                int sum = 0;
                int i = 0;
                while (i < 3) {
                    if (this.actual_button[i]) {
                        ++n;
                        sum += i;
                    }
                    ++i;
                }
                this.virtual_button = n == 1 ? sum : (n == 2 && this.enable_combos ? 3 - sum : -1);
                int i2 = 0;
                while (i2 < 7) {
                    this.old_function[i2] = this.function[i2];
                    this.function[i2] = false;
                    ++i2;
                }
                int vctrl = mctrl == 0 ? 0 : 1;
                int vshift = mshift == 0 ? 0 : 1;
                int n2 = f = this.virtual_button < 0 ? -1 : this.function_map[this.virtual_button][vctrl][vshift];
                if (f >= 0) {
                    this.function[f] = true;
                }
                boolean cursor_off = this.enableFunctions((MouseEvent)event);
                if (event_id == 501) {
                    DisplayEvent e8;
                    try {
                        e8 = new DisplayEvent((Display)this.display, 1, mouse_event, remoteId);
                        this.display.notifyListeners(e8);
                    }
                    catch (VisADException e9) {
                    }
                    catch (RemoteException e10) {
                        // empty catch block
                    }
                    if (m1 != 0) {
                        try {
                            e8 = new DisplayEvent((Display)this.display, 5, mouse_event, remoteId);
                            this.display.notifyListeners(e8);
                        }
                        catch (VisADException e11) {
                        }
                        catch (RemoteException e12) {
                            // empty catch block
                        }
                    }
                    if (m2 != 0) {
                        try {
                            e8 = new DisplayEvent((Display)this.display, 4, mouse_event, remoteId);
                            this.display.notifyListeners(e8);
                        }
                        catch (VisADException e13) {
                        }
                        catch (RemoteException e14) {
                            // empty catch block
                        }
                    }
                    if (m3 != 0) {
                        try {
                            e8 = new DisplayEvent((Display)this.display, 6, mouse_event, remoteId);
                            this.display.notifyListeners(e8);
                        }
                        catch (VisADException e15) {
                        }
                        catch (RemoteException e16) {}
                    }
                } else {
                    DisplayEvent e17;
                    try {
                        e17 = new DisplayEvent((Display)this.display, 7, mouse_event, remoteId);
                        this.display.notifyListeners(e17);
                    }
                    catch (VisADException e18) {
                    }
                    catch (RemoteException e19) {
                        // empty catch block
                    }
                    if (m1 != 0) {
                        try {
                            e17 = new DisplayEvent((Display)this.display, 9, mouse_event, remoteId);
                            this.display.notifyListeners(e17);
                        }
                        catch (VisADException e20) {
                        }
                        catch (RemoteException e21) {
                            // empty catch block
                        }
                    }
                    if (m2 != 0) {
                        try {
                            e17 = new DisplayEvent((Display)this.display, 8, mouse_event, remoteId);
                            this.display.notifyListeners(e17);
                        }
                        catch (VisADException e22) {
                        }
                        catch (RemoteException e23) {
                            // empty catch block
                        }
                    }
                    if (m3 != 0) {
                        try {
                            e17 = new DisplayEvent((Display)this.display, 10, mouse_event, remoteId);
                            this.display.notifyListeners(e17);
                        }
                        catch (VisADException e24) {
                        }
                        catch (RemoteException e25) {
                            // empty catch block
                        }
                    }
                }
                if (!cursor_off) break block82;
                this.display_renderer.setCursorOn(false);
                break block82;
            }
            if (event_id != 506) break block82;
            boolean cursor = this.function[3] || this.function[4] || this.function[5];
            boolean bl = matrix = this.function[0] || this.function[1] || this.function[2];
            if (cursor || matrix || this.function[6]) {
                VisADRay direct_ray;
                VisADRay cursor_ray;
                this.display.updateBusyStatus();
                Dimension d = ((MouseEvent)event).getComponent().getSize();
                int current_x = ((MouseEvent)event).getX();
                int current_y = ((MouseEvent)event).getY();
                if (matrix) {
                    double[] t1 = null;
                    if (this.function[1]) {
                        double scale = Math.exp((double)(this.start_y - current_y) / (double)d.height);
                        t1 = this.behavior.make_matrix(0.0, 0.0, 0.0, scale, 0.0, 0.0, 0.0);
                    }
                    if (this.function[2]) {
                        double transx = this.xmul * (double)(this.start_x - current_x);
                        double transy = this.ymul * (double)(this.start_y - current_y);
                        t1 = this.behavior.make_translate(-transx, -transy);
                    }
                    if (this.function[0]) {
                        if (this.mode2D) {
                            double transx = this.xmul * (double)(this.start_x - current_x);
                            double transy = this.ymul * (double)(this.start_y - current_y);
                            t1 = this.behavior.make_translate(-transx, -transy);
                        } else {
                            double angley = (double)(-(current_x - this.start_x)) * 100.0 / (double)d.width;
                            double anglex = (double)(-(current_y - this.start_y)) * 100.0 / (double)d.height;
                            t1 = this.behavior.make_matrix(anglex, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                        }
                    }
                    if (t1 != null) {
                        t1 = this.behavior.multiply_matrix(t1, this.tstart);
                        try {
                            this.proj.setMatrix(t1);
                        }
                        catch (VisADException e) {
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                }
                if (this.function[4] && !this.mode2D) {
                    float diff = (float)(this.start_y - current_y) * 4.0f / (float)d.height;
                    this.display_renderer.drag_depth(diff);
                }
                if (this.function[5] && !this.mode2D) {
                    double angley = (double)(-(current_x - this.start_x)) * 100.0 / (double)d.width;
                    double anglex = (double)(-(current_y - this.start_y)) * 100.0 / (double)d.height;
                    double[] t1 = this.behavior.make_matrix(anglex, angley, 0.0, 1.0, 0.0, 0.0, 0.0);
                    t1 = this.behavior.multiply_matrix(t1, this.tstart);
                    try {
                        this.proj.setMatrix(t1);
                    }
                    catch (VisADException e) {
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                if (this.function[3] && (cursor_ray = this.behavior.findRay(current_x, current_y)) != null) {
                    this.display_renderer.drag_cursor(cursor_ray, false);
                }
                if (this.function[6] && this.direct_renderer != null && (direct_ray = this.behavior.findRay(current_x, current_y)) != null) {
                    this.direct_renderer.setLastMouseModifiers(this.mouseModifiers);
                    this.direct_renderer.drag_direct(direct_ray, false, this.mouseModifiers);
                }
            }
            try {
                DisplayEvent e = new DisplayEvent((Display)this.display, 18, mouse_event, remoteId);
                this.display.notifyListeners(e);
            }
            catch (VisADException e) {
            }
            catch (RemoteException e) {}
        }
    }

    private boolean enableFunctions(MouseEvent event) {
        int current_y;
        int current_x;
        VisADRay direct_ray;
        VisADRay cursor_ray;
        boolean old_matrix;
        boolean cursor_off = false;
        if (event == null) {
            int i = 0;
            while (i < 7) {
                this.old_function[i] = this.function[i];
                this.function[i] = false;
                ++i;
            }
        }
        boolean cursor = this.function[3] || this.function[4] || this.function[5];
        boolean old_cursor = this.old_function[3] || this.old_function[4] || this.old_function[5];
        boolean matrix = this.function[0] || this.function[1] || this.function[2];
        boolean bl = old_matrix = this.old_function[0] || this.old_function[1] || this.old_function[2];
        if (old_cursor && !cursor) {
            cursor_off = true;
        }
        if (this.old_function[6] && !this.function[6]) {
            this.display_renderer.setDirectOn(false);
            if (this.direct_renderer != null) {
                this.direct_renderer.release_direct();
                this.direct_renderer = null;
            }
        }
        if (matrix && !old_matrix) {
            this.start_x = event.getX();
            this.start_y = event.getY();
            VisADRay start_ray = this.behavior.findRay(this.start_x, this.start_y);
            VisADRay start_ray_x = this.behavior.findRay(this.start_x + 1, this.start_y);
            VisADRay start_ray_y = this.behavior.findRay(this.start_x, this.start_y + 1);
            this.tstart = this.proj.getMatrix();
            double[] rot = new double[3];
            double[] scale = new double[1];
            double[] trans = new double[3];
            this.behavior.instance_unmake_matrix(rot, scale, trans, this.tstart);
            double sts = scale[0];
            double[] trot = this.behavior.make_matrix(rot[0], rot[1], rot[2], scale[0], 0.0, 0.0, 0.0);
            double[] xmat = this.behavior.make_translate(start_ray_x.position[0] - start_ray.position[0], start_ray_x.position[1] - start_ray.position[1], start_ray_x.position[2] - start_ray.position[2]);
            double[] ymat = this.behavior.make_translate(start_ray_y.position[0] - start_ray.position[0], start_ray_y.position[1] - start_ray.position[1], start_ray_y.position[2] - start_ray.position[2]);
            double[] xmatmul = this.behavior.multiply_matrix(trot, xmat);
            double[] ymatmul = this.behavior.multiply_matrix(trot, ymat);
            this.behavior.instance_unmake_matrix(rot, scale, trans, xmatmul);
            this.xmul = trans[0];
            this.behavior.instance_unmake_matrix(rot, scale, trans, ymatmul);
            this.ymul = trans[1];
            if (this.behavior instanceof MouseBehaviorJ2D) {
                double factor = this.xymul / Math.sqrt(this.xmul * this.xmul + this.ymul * this.ymul);
                this.xmul *= factor;
                this.ymul *= factor;
                this.xmul = Math.abs(this.xmul);
                this.ymul = -Math.abs(this.ymul);
            }
        }
        if (cursor && !old_cursor) {
            this.display_renderer.setCursorOn(true);
            this.start_x = event.getX();
            this.start_y = event.getY();
            this.tstart = this.proj.getMatrix();
        }
        if (this.function[3] && !this.old_function[3] && (cursor_ray = this.behavior.findRay(this.start_x, this.start_y)) != null) {
            this.display_renderer.drag_cursor(cursor_ray, true);
        }
        if (this.function[4] && !this.old_function[4] && !this.mode2D) {
            cursor_ray = this.behavior.cursorRay(this.display_renderer.getCursor());
            this.display_renderer.depth_cursor(cursor_ray);
        }
        if (this.function[6] && !this.old_function[6] && this.display_renderer.anyDirects() && (direct_ray = this.behavior.findRay(current_x = event.getX(), current_y = event.getY())) != null) {
            this.direct_renderer = this.display_renderer.findDirect(direct_ray, this.mouseModifiers);
            if (this.direct_renderer != null) {
                this.display_renderer.setDirectOn(true);
                this.direct_renderer.setLastMouseModifiers(this.mouseModifiers);
                this.direct_renderer.drag_direct(direct_ray, true, this.mouseModifiers);
            }
        }
        return cursor_off;
    }

    public void setEnableCombos(boolean e) {
        this.enable_combos = e;
        this.enableFunctions(null);
    }

    public void setFunctionMap(int[][][] map) throws VisADException {
        if (map == null || map.length != 3) {
            throw new DisplayException("bad map array");
        }
        int i = 0;
        while (i < 3) {
            if (map[i] == null || map[i].length != 2) {
                throw new DisplayException("bad map array");
            }
            int j = 0;
            while (j < 2) {
                if (map[i][j] == null || map[i][j].length != 2) {
                    throw new DisplayException("bad map array");
                }
                int k = 0;
                while (k < 2) {
                    if (map[i][j][k] >= 7) {
                        throw new DisplayException("bad map array value" + map[i][j][k]);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 2) {
                int k = 0;
                while (k < 2) {
                    this.function_map[i2][j][k] = map[i2][j][k];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        this.enableFunctions(null);
    }

    public void print_matrix(String title, double[] m) {
        if (this.behavior == null) {
            return;
        }
        double[] rot = new double[3];
        double[] scale = new double[1];
        double[] trans = new double[3];
        this.behavior.instance_unmake_matrix(rot, scale, trans, m);
        System.out.println(title + " = (" + Convert.shortString(rot[0]) + ", " + Convert.shortString(rot[1]) + ", " + Convert.shortString(rot[2]) + "), " + Convert.shortString(scale[0]) + ", (" + Convert.shortString(trans[0]) + ", " + Convert.shortString(trans[1]) + ", " + Convert.shortString(trans[2]) + ")");
    }

    public void rendererDeleted(DataRenderer renderer) {
        if (this.direct_renderer != null && (this.direct_renderer == renderer || this.direct_renderer.equals(renderer))) {
            this.direct_renderer = null;
        }
    }
}

