/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class LinearNDSet
extends GriddedSet
implements LinearSet {
    Linear1DSet[] L;
    private boolean cacheSamples = false;

    public LinearNDSet(MathType type, Linear1DSet[] l) throws VisADException {
        this(type, l, null, null, null);
    }

    public LinearNDSet(MathType type, double[] firsts, double[] lasts, int[] lengths) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, null), null, null, null);
    }

    public LinearNDSet(MathType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, firsts, lasts, lengths, coord_sys, units, errors, false);
    }

    public LinearNDSet(MathType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, units), coord_sys, units, errors, cache);
    }

    public LinearNDSet(MathType type, Linear1DSet[] l, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, l, coord_sys, units, errors, false);
    }

    public LinearNDSet(MathType type, Linear1DSet[] l, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, null, LinearNDSet.get_lengths(l), coord_sys, LinearNDSet.units_array_linear1d(l, units), errors);
        if (this.DomainDimension != this.ManifoldDimension) {
            throw new SetException("LinearNDSet: DomainDimension != ManifoldDimension");
        }
        this.L = LinearNDSet.linear1d_array_units(l, units);
        int j = 0;
        while (j < this.DomainDimension) {
            this.Low[j] = this.L[j].getLowX();
            this.Hi[j] = this.L[j].getHiX();
            if (this.SetErrors[j] != null) {
                this.SetErrors[j] = new ErrorEstimate(this.SetErrors[j].getErrorValue(), (double)(this.Low[j] + this.Hi[j]) / 2.0, this.Length, this.SetErrors[j].getUnit());
            }
            ++j;
        }
        this.cacheSamples = cache;
    }

    private static int[] get_lengths(Linear1DSet[] l) throws VisADException {
        int[] lengths = new int[l.length];
        int j = 0;
        while (j < l.length) {
            lengths[j] = l[j].getLength();
            ++j;
        }
        return lengths;
    }

    public static LinearSet create(MathType type, double[] firsts, double[] lasts, int[] lengths) throws VisADException {
        return LinearNDSet.create(type, firsts, lasts, lengths, null, null, null);
    }

    public static LinearSet create(MathType type, double[] firsts, double[] lasts, int[] lengths, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        switch (firsts.length) {
            case 1: {
                return new Linear1DSet(type, firsts[0], lasts[0], lengths[0], coord_sys, units, errors);
            }
            case 2: {
                return new Linear2DSet(type, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], coord_sys, units, errors);
            }
            case 3: {
                return new Linear3DSet(type, firsts[0], lasts[0], lengths[0], firsts[1], lasts[1], lengths[1], firsts[2], lasts[2], lengths[2], coord_sys, units, errors);
            }
        }
        return new LinearNDSet(type, firsts, lasts, lengths, coord_sys, units, errors);
    }

    static Linear1DSet[] linear1d_array_units(Linear1DSet[] sets, Unit[] units) throws VisADException {
        if (units == null) {
            return sets;
        }
        int n = sets.length;
        if (units.length != n) {
            throw new SetException("units and sets lengths don't match");
        }
        Linear1DSet[] ss = new Linear1DSet[n];
        int i = 0;
        while (i < n) {
            Unit[] su = sets[i].getSetUnits();
            if (units[i] == null || units[i].equals(su[0])) {
                ss[i] = sets[i];
            } else {
                CoordinateSystem cs = sets[i].getCoordinateSystem();
                double first = sets[i].getFirst();
                double last = sets[i].getLast();
                if (su[0] != null) {
                    first = units[i].toThis(first, su[0]);
                    last = units[i].toThis(last, su[0]);
                }
                su = new Unit[]{units[i]};
                ss[i] = new Linear1DSet(sets[i].getType(), first, last, sets[i].getLength(), sets[i].getCoordinateSystem(), su, sets[i].getSetErrors());
            }
            ++i;
        }
        return ss;
    }

    static Unit[] units_array_linear1d(Linear1DSet[] sets, Unit[] units) throws VisADException {
        int n = sets.length;
        Unit[] newu = new Unit[n];
        if (units != null && units.length != n) {
            throw new SetException("units and sets lengths don't match");
        }
        int i = 0;
        while (i < n) {
            if (units != null && units[i] != null) {
                newu[i] = units[i];
            } else {
                Unit[] su = sets[i].getSetUnits();
                if (su != null) {
                    newu[i] = su[0];
                }
            }
            ++i;
        }
        return newu;
    }

    static Linear1DSet[] get_linear1d_array(MathType type, double[] firsts, double[] lasts, int[] lengths, Unit[] units) throws VisADException {
        type = Set.adjustType(type);
        int len = lengths.length;
        if (len != firsts.length || len != lasts.length) {
            throw new SetException("LinearNDSet: array dimensions don't match");
        }
        Linear1DSet[] l = new Linear1DSet[len];
        int j = 0;
        while (j < len) {
            RealType[] types = new RealType[]{(RealType)((SetType)type).getDomain().getComponent(j)};
            SetType set_type = new SetType(new RealTupleType(types));
            Unit[] us = new Unit[]{null};
            if (units != null && units.length > j) {
                us[0] = units[j];
            }
            l[j] = new Linear1DSet((MathType)set_type, firsts[j], lasts[j], lengths[j], null, us, null);
            ++j;
        }
        return l;
    }

    static Linear1DSet[] get_linear1d_array(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, Unit[] units) throws VisADException {
        double[] firsts = new double[]{first1, first2};
        double[] lasts = new double[]{last1, last2};
        int[] lengths = new int[]{length1, length2};
        return LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, units);
    }

    static Linear1DSet[] get_linear1d_array(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3, Unit[] units) throws VisADException {
        double[] firsts = new double[]{first1, first2, first3};
        double[] lasts = new double[]{last1, last2, last3};
        int[] lengths = new int[]{length1, length2, length3};
        return LinearNDSet.get_linear1d_array(type, firsts, lasts, lengths, units);
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int dim = this.getDimension();
        int length = index.length;
        int[][] indexN = new int[dim][length];
        float[][] values = new float[dim][];
        int[] lengthN = new int[dim];
        int j = 0;
        while (j < dim) {
            lengthN[j] = this.L[j].getLength();
            ++j;
        }
        int i = 0;
        while (i < length) {
            int j2;
            int k = index[i];
            if (0 <= k && k < this.Length) {
                j2 = 0;
                while (j2 < dim - 1) {
                    indexN[j2][i] = k % lengthN[j2];
                    k /= lengthN[j2];
                    ++j2;
                }
                indexN[dim - 1][i] = k;
            } else {
                j2 = 0;
                while (j2 < dim) {
                    indexN[j2][i] = -1;
                    ++j2;
                }
            }
            ++i;
        }
        int j3 = 0;
        while (j3 < dim) {
            float[][] vals = this.L[j3].indexToValue(indexN[j3]);
            values[j3] = vals[0];
            ++j3;
        }
        return values;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != this.DomainDimension) {
            throw new SetException("LinearNDSet.gridToValue: grid dimension " + grid.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int j = 0;
        while (j < this.DomainDimension) {
            if (this.Lengths[j] < 2) {
                throw new SetException("LinearNDSet.gridToValue: requires all grid dimensions to be > 1");
            }
            ++j;
        }
        int length = grid[0].length;
        float[][][] gridJ = new float[this.DomainDimension][1][];
        float[][][] valueJ = new float[this.DomainDimension][][];
        j = 0;
        while (j < this.DomainDimension) {
            gridJ[j][0] = grid[j];
            valueJ[j] = this.L[j].gridToValue(gridJ[j]);
            ++j;
        }
        float[][] value = new float[this.DomainDimension][];
        j = 0;
        while (j < this.DomainDimension) {
            value[j] = valueJ[j][0];
            ++j;
        }
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length != this.DomainDimension) {
            throw new SetException("LinearNDSet.valueToGrid: value dimension " + value.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int j = 0;
        while (j < this.DomainDimension) {
            if (this.Lengths[j] < 2) {
                throw new SetException("LinearNDSet.valueToGrid: requires all grid dimensions to be > 1");
            }
            ++j;
        }
        int length = value[0].length;
        float[][][] valueJ = new float[this.DomainDimension][1][];
        float[][][] gridJ = new float[this.DomainDimension][][];
        j = 0;
        while (j < this.DomainDimension) {
            valueJ[j][0] = value[j];
            gridJ[j] = this.L[j].valueToGrid(valueJ[j]);
            ++j;
        }
        float[][] grid = new float[this.DomainDimension][];
        j = 0;
        while (j < this.DomainDimension) {
            grid[j] = gridJ[j][0];
            ++j;
        }
        return grid;
    }

    public boolean isMissing() {
        return false;
    }

    public double[] getFirsts() throws VisADException {
        double[] firsts = new double[this.L.length];
        int j = 0;
        while (j < firsts.length) {
            firsts[j] = this.L[j].getFirst();
            ++j;
        }
        return firsts;
    }

    public double[] getLasts() throws VisADException {
        double[] lasts = new double[this.L.length];
        int j = 0;
        while (j < lasts.length) {
            lasts[j] = this.L[j].getLast();
            ++j;
        }
        return lasts;
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        if (this.Samples != null) {
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        float[][] samples = this.makeSamples();
        if (this.cacheSamples) {
            this.Samples = samples;
            return copy ? Set.copyFloats(this.Samples) : this.Samples;
        }
        return samples;
    }

    private float[][] makeSamples() throws VisADException {
        int n = this.getLength();
        int[] indices = new int[n];
        int i = 0;
        while (i < n) {
            indices[i] = i;
            ++i;
        }
        return this.indexToValue(indices);
    }

    public boolean equals(Object set) {
        if (!(set instanceof LinearNDSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        if (this.DomainDimension != ((LinearNDSet)set).getDimension()) {
            return false;
        }
        int j = 0;
        while (j < this.DomainDimension) {
            if (!this.L[j].equals(((LinearNDSet)set).getLinear1DComponent(j))) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            int i = 0;
            while (i < this.DomainDimension) {
                this.hashCode ^= this.L[i].hashCode();
                ++i;
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int i) {
        return this.L[i];
    }

    public Object cloneButType(MathType type) throws VisADException {
        Linear1DSet[] l = new Linear1DSet[this.DomainDimension];
        int j = 0;
        while (j < this.DomainDimension) {
            l[j] = (Linear1DSet)this.L[j].clone();
            ++j;
        }
        return new LinearNDSet(type, l, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.cacheSamples);
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "LinearNDSet: Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
        int j = 0;
        while (j < this.DomainDimension) {
            s = s + pre + "  Dimension " + j + ":" + " Length = " + this.L[j].getLength() + " Range = " + this.L[j].getFirst() + " to " + this.L[j].getLast() + "\n";
            ++j;
        }
        return s;
    }

    public static void main(String[] args) throws VisADException {
        RealTupleType type = new RealTupleType(RealType.Generic, RealType.Generic);
        double[] firsts = new double[]{0.0, 0.0};
        double[] lasts = new double[]{3.0, 3.0};
        int[] lengths = new int[]{4, 4};
        LinearNDSet set = new LinearNDSet((MathType)type, firsts, lasts, lengths);
        float[][] values = set.getSamples();
        int n = values.length;
        int m = values[0].length;
        int j = 0;
        while (j < m) {
            int i = 0;
            while (i < n) {
                System.out.println("values[" + i + "][" + j + "] = " + values[i][j]);
                ++i;
            }
            ++j;
        }
    }
}

