/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Enumeration;
import java.util.Vector;
import visad.DisplayException;
import visad.DisplayTupleType;
import visad.RealType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class DisplayRealType
extends RealType {
    private boolean range;
    private double LowValue;
    private double HiValue;
    private double DefaultValue;
    private DisplayTupleType tuple;
    private int tupleIndex;
    private boolean Single;
    private boolean system;
    private boolean text;
    private boolean circular;
    private static int Count = 0;
    private transient int Index;
    private static Vector DisplayRealTypeVector = new Vector();

    DisplayRealType(String name, boolean single, double def, boolean b) {
        this(name, single, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, def, null, b);
    }

    DisplayRealType(String name, boolean single, double low, double hi, double def, boolean b) {
        this(name, single, low, hi, def, null, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisplayRealType(String name, boolean single, double low, double hi, double def, Unit unit, boolean b) {
        super("Display" + name, unit, b);
        this.system = true;
        this.Single = single;
        this.LowValue = low;
        this.HiValue = hi;
        this.range = !Double.isInfinite(low) && !Double.isNaN(low) && !Double.isInfinite(hi) && !Double.isNaN(hi);
        this.DefaultValue = def;
        this.tuple = null;
        this.tupleIndex = -1;
        this.text = false;
        this.circular = false;
        Vector vector = DisplayRealTypeVector;
        synchronized (vector) {
            this.Index = ++Count;
            DisplayRealTypeVector.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisplayRealType(String name, boolean single, boolean b) {
        super("Display" + name, null, b);
        this.system = true;
        this.Single = single;
        this.text = true;
        this.circular = false;
        Vector vector = DisplayRealTypeVector;
        synchronized (vector) {
            this.Index = ++Count;
            DisplayRealTypeVector.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DisplayRealType(String name, boolean single, double low, double hi, double def, Unit unit) throws VisADException {
        super("Display" + name, unit, false);
        this.system = false;
        this.Single = single;
        this.LowValue = low;
        this.HiValue = hi;
        this.range = !Double.isInfinite(low) && !Double.isNaN(low) && !Double.isInfinite(hi) && !Double.isNaN(hi);
        this.DefaultValue = def;
        this.tuple = null;
        this.tupleIndex = -1;
        this.text = false;
        this.circular = false;
        Vector vector = DisplayRealTypeVector;
        synchronized (vector) {
            this.Index = ++Count;
            if (DisplayRealType.getDisplayRealTypeByName(this.getName()) != null) {
                throw new TypeException("DisplayRealType: name already used");
            }
            DisplayRealTypeVector.addElement(this);
        }
    }

    public DisplayRealType(String name, boolean single, double def, Unit unit) throws VisADException {
        this(name, single, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, def, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DisplayRealType getDisplayRealTypeByName(String name) {
        Vector vector = DisplayRealTypeVector;
        synchronized (vector) {
            Enumeration reals = DisplayRealTypeVector.elements();
            while (reals.hasMoreElements()) {
                DisplayRealType real = (DisplayRealType)reals.nextElement();
                if (!real.getName().equals(name)) continue;
                return real;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex() {
        if (this.Index <= 0) {
            Vector vector = DisplayRealTypeVector;
            synchronized (vector) {
                DisplayRealType real = DisplayRealType.getDisplayRealTypeByName(this.getName());
                if (real == null) {
                    this.Index = ++Count;
                    DisplayRealTypeVector.addElement(this);
                } else {
                    this.Index = real.getIndex();
                }
            }
        }
        return this.Index;
    }

    public static int getCount() {
        return Count;
    }

    public DisplayTupleType getTuple() {
        return this.tuple;
    }

    public int getTupleIndex() {
        return this.tupleIndex;
    }

    public void setTuple(DisplayTupleType t, int i, boolean c) throws VisADException {
        if (this.tuple != null) {
            throw new DisplayException("DisplayRealType " + this.getName() + " already has DisplayTupleType " + this.tuple);
        }
        this.tuple = t;
        this.tupleIndex = i;
        this.circular = c;
    }

    public boolean isSingle() {
        return this.Single;
    }

    public double getDefaultValue() {
        return this.DefaultValue;
    }

    public boolean getRange(double[] range_values) {
        if (this.range) {
            range_values[0] = this.LowValue;
            range_values[1] = this.HiValue;
        }
        return this.range;
    }

    public boolean getText() {
        return this.text;
    }

    public boolean getCircular() {
        return this.circular;
    }
}

