/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.GraphicsModeControl;
import visad.MathType;
import visad.ReferenceActionLink;
import visad.ScalarMap;
import visad.ShadowType;
import visad.UnimplementedException;
import visad.VisADException;

public class DataDisplayLink
extends ReferenceActionLink {
    private ShadowType shadow;
    private Data data;
    private Vector ConstantMapVector = new Vector();
    private DataRenderer renderer;
    private Vector SelectedMapVector = new Vector();
    private float[] defaultValues;
    boolean[] isTransform;
    public long start_time;
    public boolean time_flag;

    public DataDisplayLink(DataReference ref, DisplayImpl local_d, Display d, ConstantMap[] constant_maps, DataRenderer rend, long jd) throws VisADException, RemoteException {
        super(ref, local_d, d, jd);
        this.renderer = rend;
        if (constant_maps != null) {
            int i = 0;
            while (i < constant_maps.length) {
                Enumeration maps = ((Vector)this.ConstantMapVector.clone()).elements();
                while (maps.hasMoreElements()) {
                    ScalarMap map = (ScalarMap)maps.nextElement();
                    if (!map.getDisplayScalar().equals(constant_maps[i].getDisplayScalar())) continue;
                    throw new DisplayException("DataDisplayLink: two ConstantMaps have the same DisplayScalar");
                }
                if (constant_maps[i].getDisplay() != null && !ConstantMap.getAllowMultipleUseKludge()) {
                    throw new DisplayException(constant_maps[i] + " already has a display\n" + "If this Exception breaks an existing app add a call to:\n" + "ConstantMap.setAllowMultipleUseKludge(true) at the " + "start of your app \n  OR you can stop reusing ConstantMaps");
                }
                constant_maps[i].setDisplay(local_d);
                this.ConstantMapVector.addElement(constant_maps[i]);
                local_d.addDisplayScalar(constant_maps[i]);
                ++i;
            }
        }
    }

    public DisplayImpl getDisplay() {
        return (DisplayImpl)this.local_action;
    }

    public DataRenderer getRenderer() {
        return this.renderer;
    }

    public Vector getSelectedMapVector() {
        return (Vector)this.SelectedMapVector.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedMapVector(ScalarMap map) {
        if (this.renderer == null) {
            return;
        }
        Vector vector = this.SelectedMapVector;
        synchronized (vector) {
            if (!this.SelectedMapVector.contains(map)) {
                this.SelectedMapVector.addElement(map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaps() throws RemoteException, VisADException {
        Vector vector = this.ConstantMapVector;
        synchronized (vector) {
            Enumeration maps = this.ConstantMapVector.elements();
            while (maps.hasMoreElements()) {
                ConstantMap map = (ConstantMap)maps.nextElement();
                map.nullDisplay();
            }
            this.ConstantMapVector.removeAllElements();
            this.SelectedMapVector.removeAllElements();
            this.shadow = null;
            this.data = null;
            this.renderer = null;
        }
    }

    public boolean prepareData() throws VisADException, RemoteException {
        ConstantMap map;
        if (this.renderer == null) {
            return false;
        }
        this.data = ((DataReference)this.ref).getData();
        if (this.data == null) {
            this.renderer.clearExceptions();
            this.renderer.addException(new DisplayException("Data is null"));
            return false;
        }
        MathType type = this.data.getType();
        this.SelectedMapVector.removeAllElements();
        int n = ((DisplayImpl)this.local_action).getDisplayScalarCount();
        this.defaultValues = new float[n];
        GraphicsModeControl mode = ((DisplayImpl)this.local_action).getGraphicsModeControl();
        int i = 0;
        while (i < n) {
            DisplayRealType dreal = ((DisplayImpl)this.local_action).getDisplayScalar(i);
            this.defaultValues[i] = (float)dreal.getDefaultValue();
            if (Display.PointSize.equals(dreal)) {
                this.defaultValues[i] = mode.getPointSize();
            } else if (Display.LineWidth.equals(dreal)) {
                this.defaultValues[i] = mode.getLineWidth();
            } else if (Display.LineStyle.equals(dreal)) {
                this.defaultValues[i] = mode.getLineStyle();
            }
            ++i;
        }
        Vector temp = (Vector)((DisplayImpl)this.local_action).getConstantMapVector().clone();
        Enumeration maps = temp.elements();
        while (maps.hasMoreElements()) {
            map = (ConstantMap)maps.nextElement();
            this.defaultValues[map.getDisplayScalarIndex()] = (float)map.getConstant();
        }
        maps = ((Vector)this.ConstantMapVector.clone()).elements();
        while (maps.hasMoreElements()) {
            map = (ConstantMap)maps.nextElement();
            int index = map.getDisplayScalarIndex();
            if (index < 0) continue;
            this.defaultValues[index] = (float)map.getConstant();
        }
        try {
            this.renderer.clearExceptions();
            DisplayImpl local_dpy = (DisplayImpl)this.local_action;
            this.shadow = type.buildShadowType(this, null);
            ShadowType adaptedShadow = this.shadow.getAdaptedShadowType();
            int[] indices = ShadowType.zeroIndices(local_dpy.getScalarCount());
            int[] display_indices = ShadowType.zeroIndices(local_dpy.getDisplayScalarCount());
            int[] value_indices = ShadowType.zeroIndices(local_dpy.getValueArrayLength());
            int numControls = local_dpy.getNumberOfControls();
            this.isTransform = new boolean[numControls];
            int i2 = 0;
            while (i2 < numControls) {
                this.isTransform[i2] = false;
                ++i2;
            }
            int levelOfDifficulty = this.shadow.checkIndices(indices, display_indices, value_indices, this.isTransform, 6);
            if (levelOfDifficulty == 1) {
                int i3 = 0;
                while (i3 < numControls) {
                    this.isTransform[i3] = true;
                    ++i3;
                }
            }
            this.renderer.checkDirect();
        }
        catch (BadMappingException e) {
            this.data = null;
            this.renderer.addException(e);
            return false;
        }
        catch (UnimplementedException e) {
            this.data = null;
            this.renderer.addException(e);
            return false;
        }
        catch (RemoteException e) {
            this.data = null;
            this.renderer.addException(e);
            return false;
        }
        return true;
    }

    public ShadowType getShadow() {
        return this.shadow;
    }

    public Data getData() throws VisADException, RemoteException {
        if (this.renderer == null) {
            return null;
        }
        Data data_copy = this.data;
        if (data_copy == null) {
            data_copy = ((DataReference)this.ref).getData();
        }
        this.data = data_copy;
        return data_copy;
    }

    public void clearData() {
        this.data = null;
    }

    public MathType getType() throws VisADException, RemoteException {
        Data d = this.getData();
        return d == null ? null : d.getType();
    }

    public float[] getDefaultValues() {
        return this.defaultValues;
    }

    public DataReference getDataReference() {
        return (DataReference)this.getThingReference();
    }

    public Vector getConstantMaps() {
        return this.ConstantMapVector;
    }

    public Vector getScalarMaps() {
        return this.SelectedMapVector;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DataDisplayLink)) {
            return false;
        }
        DataDisplayLink ddl = (DataDisplayLink)o;
        if (!this.getDataReference().equals(ddl.getDataReference())) {
            return false;
        }
        return this.getDisplay().equals(ddl.getDisplay());
    }
}

