/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Vector;
import visad.ContourStrip;
import visad.Gridded3DSet;
import visad.PlotDigits;
import visad.VisADException;

class ContourStripSet {
    int mxsize;
    float[] levels;
    int n_levs;
    int nr;
    int nc;
    Gridded3DSet spatial_set;
    Vector[] vecArray;
    Vector vec;
    PlotDigits[] plot_s;
    float[][] plot_min_max;
    boolean[] swap;

    ContourStripSet(int size, float[] levels, boolean[] swap, double scale_ratio, double label_size, int nr, int nc, Gridded3DSet spatial_set) throws VisADException {
        this.mxsize = 40 * size;
        this.levels = levels;
        this.n_levs = levels.length;
        this.vecArray = new Vector[this.n_levs];
        this.plot_s = new PlotDigits[this.n_levs];
        this.plot_min_max = new float[this.n_levs][2];
        float fac = (float)(0.15 * (1.0 / scale_ratio) * label_size);
        this.nr = nr;
        this.nc = nc;
        this.swap = swap;
        this.spatial_set = spatial_set;
        int kk = 0;
        while (kk < this.n_levs) {
            this.vecArray[kk] = new Vector();
            PlotDigits plot = new PlotDigits();
            plot.Number = levels[kk];
            plot.plotdigits(levels[kk], 0.0f, 0.0f, fac * 1.0f, fac * 1.0f, 400, new boolean[]{false, false, false});
            float[][] tmp = new float[][]{plot.Vx, plot.Vy};
            plot.Vx = tmp[1];
            plot.Vy = tmp[0];
            tmp[0] = plot.VxB;
            tmp[1] = plot.VyB;
            plot.VxB = tmp[1];
            plot.VyB = tmp[0];
            float vx_min = Float.MAX_VALUE;
            float vy_min = Float.MAX_VALUE;
            float vx_max = -3.4028235E38f;
            float vy_max = -3.4028235E38f;
            float vxB_min = Float.MAX_VALUE;
            float vyB_min = Float.MAX_VALUE;
            float vxB_max = -3.4028235E38f;
            float vyB_max = -3.4028235E38f;
            int ii = 0;
            while (ii < plot.NumVerts) {
                if (plot.Vx[ii] < vx_min) {
                    vx_min = plot.Vx[ii];
                }
                if (plot.Vy[ii] < vy_min) {
                    vy_min = plot.Vy[ii];
                }
                if (plot.Vx[ii] > vx_max) {
                    vx_max = plot.Vx[ii];
                }
                if (plot.Vy[ii] > vy_max) {
                    vy_max = plot.Vy[ii];
                }
                if (plot.VxB[ii] < vxB_min) {
                    vxB_min = plot.VxB[ii];
                }
                if (plot.VyB[ii] < vyB_min) {
                    vyB_min = plot.VyB[ii];
                }
                if (plot.VxB[ii] > vxB_max) {
                    vxB_max = plot.VxB[ii];
                }
                if (plot.VyB[ii] > vyB_max) {
                    vyB_max = plot.VyB[ii];
                }
                ++ii;
            }
            float t_x = (vx_max - vx_min) / 2.0f + vx_min;
            float t_y = (vy_max - vy_min) / 2.0f + vy_min;
            float t_xB = (vxB_max - vxB_min) / 2.0f + vxB_min;
            float t_yB = (vyB_max - vyB_min) / 2.0f + vyB_min;
            int ii2 = 0;
            while (ii2 < plot.NumVerts) {
                int n = ii2;
                plot.Vx[n] = plot.Vx[n] - t_x;
                int n2 = ii2;
                plot.Vy[n2] = plot.Vy[n2] - t_y;
                int n3 = ii2;
                plot.VxB[n3] = plot.VxB[n3] - t_xB;
                int n4 = ii2++;
                plot.VyB[n4] = plot.VyB[n4] - t_yB;
            }
            this.plot_s[kk] = plot;
            if (!swap[0]) {
                this.plot_min_max[kk][0] = vy_min;
                this.plot_min_max[kk][1] = vy_max;
            } else {
                this.plot_min_max[kk][0] = vx_min;
                this.plot_min_max[kk][1] = vx_max;
            }
            this.plot_min_max[kk][0] = vx_min;
            this.plot_min_max[kk][1] = vx_max;
            ++kk;
        }
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, float level) {
        int lev_idx = 0;
        int kk = 0;
        while (kk < this.n_levs) {
            if (level == this.levels[kk]) {
                lev_idx = kk;
            }
            ++kk;
        }
        this.add(vx, vy, idx0, idx1, lev_idx);
    }

    void add(float[] vx, float[] vy, int idx0, int idx1, int lev_idx) {
        this.vec = this.vecArray[lev_idx];
        int n_strip = this.vec.size();
        if (n_strip == 0) {
            ContourStrip c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
            this.vec.addElement(c_strp);
        } else {
            ContourStrip c_strp;
            int[] found_array = new int[2];
            int found = 0;
            int kk = 0;
            while (kk < n_strip) {
                c_strp = (ContourStrip)this.vec.elementAt(kk);
                if (c_strp.addPair(vx, vy, idx0, idx1)) {
                    found_array[found] = kk;
                    ++found;
                }
                ++kk;
            }
            if (found == 2) {
                ContourStrip c_strpA = (ContourStrip)this.vec.elementAt(found_array[0]);
                ContourStrip c_strpB = (ContourStrip)this.vec.elementAt(found_array[1]);
                ContourStrip c_strp2 = c_strpA.merge(c_strpB);
                this.vec.addElement(c_strp2);
                this.vec.removeElement(c_strpA);
                this.vec.removeElement(c_strpB);
            } else if (found == 0) {
                c_strp = new ContourStrip(this.mxsize, lev_idx, idx0, idx1, this.plot_s[lev_idx], this);
                this.vec.addElement(c_strp);
            }
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, int lev_idx, float[][][] out_vv, byte[][][] out_bb, float[][][][] out_vvL, byte[][][][] out_bbL, float[][][] out_loc) {
        int mm;
        int mm2;
        int n_strips = this.vecArray[lev_idx].size();
        float[][][][] la = new float[n_strips][2][][];
        byte[][][][] ca = new byte[n_strips][2][][];
        float[][][][][] laL = new float[n_strips][4][][][];
        byte[][][][][] caL = new byte[n_strips][4][][][];
        float[][][][] locL = new float[n_strips][3][][];
        int kk = 0;
        while (kk < n_strips) {
            ContourStrip cs = (ContourStrip)this.vecArray[lev_idx].elementAt(kk);
            cs.getLabeledLineColorArray(vx, vy, colors, la[kk], ca[kk], laL[kk], caL[kk], locL[kk]);
            ++kk;
        }
        int tt = 0;
        while (tt < 2) {
            int len = 0;
            mm2 = 0;
            while (mm2 < n_strips) {
                if (la[mm2][tt] != null) {
                    len += la[mm2][tt][0].length;
                }
                ++mm2;
            }
            out_vv[tt] = new float[3][len];
            int cnt = 0;
            int mm3 = 0;
            while (mm3 < n_strips) {
                if (la[mm3][tt] != null) {
                    System.arraycopy(la[mm3][tt][0], 0, out_vv[tt][0], cnt, la[mm3][tt][0].length);
                    System.arraycopy(la[mm3][tt][1], 0, out_vv[tt][1], cnt, la[mm3][tt][1].length);
                    System.arraycopy(la[mm3][tt][2], 0, out_vv[tt][2], cnt, la[mm3][tt][1].length);
                    cnt += la[mm3][tt][0].length;
                }
                ++mm3;
            }
            int clr_dim = 0;
            if (colors != null) {
                clr_dim = colors.length;
                len = 0;
                mm = 0;
                while (mm < n_strips) {
                    if (ca[mm][tt] != null) {
                        len += ca[mm][tt][0].length;
                    }
                    ++mm;
                }
                out_bb[tt] = new byte[clr_dim][len];
                cnt = 0;
                int mm4 = 0;
                while (mm4 < n_strips) {
                    if (ca[mm4][tt] != null) {
                        int cc = 0;
                        while (cc < clr_dim) {
                            System.arraycopy(ca[mm4][tt][cc], 0, out_bb[tt][cc], cnt, ca[mm4][tt][cc].length);
                            ++cc;
                        }
                        cnt += ca[mm4][tt][0].length;
                    }
                    ++mm4;
                }
            }
            ++tt;
        }
        int n_lbl = 0;
        mm2 = 0;
        while (mm2 < n_strips) {
            if (laL[mm2][0] != null) {
                n_lbl += laL[mm2][0].length;
            }
            ++mm2;
        }
        out_vvL[0] = new float[n_lbl][][];
        out_vvL[1] = new float[n_lbl][][];
        out_vvL[2] = new float[n_lbl][][];
        out_vvL[3] = new float[n_lbl][][];
        out_bbL[0] = new byte[n_lbl][][];
        out_bbL[1] = new byte[n_lbl][][];
        out_bbL[2] = new byte[n_lbl][][];
        out_bbL[3] = new byte[n_lbl][][];
        out_loc[0] = new float[n_lbl][];
        out_loc[1] = new float[n_lbl][];
        out_loc[2] = new float[n_lbl][];
        int tt2 = 0;
        while (tt2 < 4) {
            n_lbl = 0;
            int kk2 = 0;
            while (kk2 < n_strips) {
                if (laL[kk2][tt2] != null) {
                    int mm5 = 0;
                    while (mm5 < laL[kk2][tt2].length) {
                        out_vvL[tt2][n_lbl] = laL[kk2][tt2][mm5];
                        if (caL[kk2][tt2] != null) {
                            out_bbL[tt2][n_lbl] = caL[kk2][tt2][mm5];
                        }
                        ++n_lbl;
                        ++mm5;
                    }
                }
                ++kk2;
            }
            ++tt2;
        }
        int tt3 = 0;
        while (tt3 < 3) {
            n_lbl = 0;
            int kk3 = 0;
            while (kk3 < n_strips) {
                if (locL[kk3][0] != null) {
                    mm = 0;
                    while (mm < locL[kk3][tt3].length) {
                        out_loc[tt3][n_lbl] = locL[kk3][tt3][mm];
                        ++n_lbl;
                        ++mm;
                    }
                }
                ++kk3;
            }
            ++tt3;
        }
    }

    void getLineColorArrays(float[] vx, float[] vy, byte[][] colors, float[][][] out_vv, byte[][][] out_bb, float[][][][] out_vvL, byte[][][][] out_bbL, float[][][] out_loc) {
        int ll;
        int kk;
        int cnt;
        float[][][][] tmp = new float[this.n_levs][2][][];
        byte[][][][] btmp = new byte[this.n_levs][2][][];
        float[][][][][] tmpL = new float[this.n_levs][4][][][];
        byte[][][][][] btmpL = new byte[this.n_levs][4][][][];
        float[][][][] tmpLoc = new float[this.n_levs][3][][];
        int n_lbl = 0;
        int kk2 = 0;
        while (kk2 < this.n_levs) {
            this.getLineColorArrays(vx, vy, colors, kk2, tmp[kk2], btmp[kk2], tmpL[kk2], btmpL[kk2], tmpLoc[kk2]);
            n_lbl += tmpL[kk2][0].length;
            ++kk2;
        }
        int tt = 0;
        while (tt < 2) {
            int len = 0;
            int kk3 = 0;
            while (kk3 < this.n_levs) {
                len += tmp[kk3][tt][0].length;
                ++kk3;
            }
            out_vv[tt] = new float[3][len];
            cnt = 0;
            kk = 0;
            while (kk < this.n_levs) {
                System.arraycopy(tmp[kk][tt][0], 0, out_vv[tt][0], cnt, tmp[kk][tt][0].length);
                System.arraycopy(tmp[kk][tt][1], 0, out_vv[tt][1], cnt, tmp[kk][tt][0].length);
                System.arraycopy(tmp[kk][tt][2], 0, out_vv[tt][2], cnt, tmp[kk][tt][0].length);
                cnt += tmp[kk][tt][0].length;
                ++kk;
            }
            int clr_dim = 0;
            if (colors != null) {
                clr_dim = colors.length;
                len = 0;
                int kk4 = 0;
                while (kk4 < this.n_levs) {
                    len += btmp[kk4][tt][0].length;
                    ++kk4;
                }
                out_bb[tt] = new byte[clr_dim][len];
                cnt = 0;
                int kk5 = 0;
                while (kk5 < this.n_levs) {
                    int cc = 0;
                    while (cc < clr_dim) {
                        System.arraycopy(btmp[kk5][tt][cc], 0, out_bb[tt][cc], cnt, btmp[kk5][tt][cc].length);
                        ++cc;
                    }
                    cnt += btmp[kk5][tt][0].length;
                    ++kk5;
                }
            }
            ++tt;
        }
        int tt2 = 0;
        while (tt2 < 4) {
            out_vvL[tt2] = new float[n_lbl][][];
            int cnt2 = 0;
            int kk6 = 0;
            while (kk6 < this.n_levs) {
                int ll2 = 0;
                while (ll2 < tmpL[kk6][tt2].length) {
                    out_vvL[tt2][cnt2] = tmpL[kk6][tt2][ll2];
                    ++cnt2;
                    ++ll2;
                }
                ++kk6;
            }
            out_bbL[tt2] = new byte[n_lbl][][];
            cnt2 = 0;
            kk = 0;
            while (kk < this.n_levs) {
                ll = 0;
                while (ll < tmpL[kk][tt2].length) {
                    out_bbL[tt2][cnt2] = btmpL[kk][tt2][ll];
                    ++cnt2;
                    ++ll;
                }
                ++kk;
            }
            ++tt2;
        }
        int tt3 = 0;
        while (tt3 < 3) {
            out_loc[tt3] = new float[n_lbl][];
            cnt = 0;
            kk = 0;
            while (kk < this.n_levs) {
                if (tmpLoc[kk][tt3] != null) {
                    ll = 0;
                    while (ll < tmpLoc[kk][tt3].length) {
                        out_loc[tt3][cnt] = tmpLoc[kk][tt3][ll];
                        ++cnt;
                        ++ll;
                    }
                }
                ++kk;
            }
            ++tt3;
        }
    }
}

