/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Arrays;
import visad.ContourStripSet;
import visad.Gridded3DSet;
import visad.PlotDigits;
import visad.SetException;
import visad.VisADException;

public class Contour2D {
    protected Contour2D con;
    protected int whichlabels = 0;
    protected boolean showgrid;
    protected int rows;
    protected int cols;
    protected int scale;
    protected int[] num1;
    protected int[] num2;
    protected int[] num3;
    protected int[] num4;
    protected float[][] vx1;
    protected float[][] vy1;
    protected float[][] vx2;
    protected float[][] vy2;
    protected float[][] vx3;
    protected float[][] vy3;
    protected float[][] vx4;
    protected float[][] vy4;

    public static void contour(float[] g, int nr, int nc, float interval, float lowlimit, float highlimit, float base, float[][] vx1, float[][] vy1, float[][] vz1, int maxv1, int[] numv1, float[][] vx2, float[][] vy2, float[][] vz2, int maxv2, int[] numv2, float[][] vx3, float[][] vy3, float[][] vz3, int maxv3, int[] numv3, float[][] vx4, float[][] vy4, float[][] vz4, int maxv4, int[] numv4, byte[][] auxValues, byte[][] auxLevels1, byte[][] auxLevels2, byte[][] auxLevels3, boolean[] swap, boolean fill, float[][] tri, byte[][] tri_color, float[][][] grd_normals, float[][] tri_normals, byte[][] interval_colors, float[][][][] lbl_vv, byte[][][][] lbl_cc, float[][][] lbl_loc, double scale_ratio, double label_size, Gridded3DSet spatial_set) throws VisADException {
        boolean[] dashes = new boolean[]{false};
        float[] intervals = Contour2D.intervalToLevels(interval, lowlimit, highlimit, base, dashes);
        boolean dash = dashes[0];
        Contour2D.contour(g, nr, nc, intervals, lowlimit, highlimit, base, dash, vx1, vy1, vz1, maxv1, numv1, vx2, vy2, vz2, maxv2, numv2, vx3, vy3, vz3, maxv3, numv3, vx4, vy4, vz4, maxv4, numv4, auxValues, auxLevels1, auxLevels2, auxLevels3, swap, fill, tri, tri_color, grd_normals, tri_normals, interval_colors, lbl_vv, lbl_cc, lbl_loc, scale_ratio, label_size, spatial_set);
    }

    public static float[] intervalToLevels(float interval, float low, float high, float ba, boolean[] dash) throws VisADException {
        float[] levs = null;
        if ((double)interval == 0.0) {
            throw new VisADException("Contour interval cannot be zero");
        }
        dash[0] = false;
        if (interval < 0.0f) {
            dash[0] = true;
            interval = -interval;
        }
        long nlo = Math.round(Math.ceil((low - ba) / Math.abs(interval)));
        long nhi = Math.round(Math.floor((high - ba) / Math.abs(interval)));
        int numc = (int)(nhi - nlo) + 1;
        if (numc < 1) {
            return levs;
        }
        if (numc > 4000) {
            throw new VisADException("Contour interval " + interval + " too small for range " + low + "," + high);
        }
        try {
            levs = new float[numc];
        }
        catch (OutOfMemoryError e) {
            throw new VisADException("Contour interval too small");
        }
        int i = 0;
        while (i < numc) {
            levs[i] = ba + (float)(nlo + (long)i) * interval;
            ++i;
        }
        return levs;
    }

    public static void contour(float[] g, int nr, int nc, float[] values, float lowlimit, float highlimit, float base, boolean dash, float[][] vx1, float[][] vy1, float[][] vz1, int maxv1, int[] numv1, float[][] vx2, float[][] vy2, float[][] vz2, int maxv2, int[] numv2, float[][] vx3, float[][] vy3, float[][] vz3, int maxv3, int[] numv3, float[][] vx4, float[][] vy4, float[][] vz4, int maxv4, int[] numv4, byte[][] auxValues, byte[][] auxLevels1, byte[][] auxLevels2, byte[][] auxLevels3, boolean[] swap, boolean fill, float[][] tri, byte[][] tri_color, float[][][] grd_normals, float[][] tri_normals, byte[][] interval_colors, float[][][][] lbl_vv, byte[][][][] lbl_cc, float[][][] lbl_loc, double scale_ratio, double label_size, Gridded3DSet spatial_set) throws VisADException {
        int ir;
        int lc;
        int lr;
        int naux;
        dash = fill ? false : dash;
        PlotDigits plot = new PlotDigits();
        int maxsize = maxv1 + maxv2;
        float[] vx = new float[maxsize];
        float[] vy = new float[maxsize];
        int[] ipnt = new int[nr * nc + 4];
        float[] myvals = null;
        if (values != null) {
            myvals = (float[])values.clone();
            Arrays.sort(myvals);
        }
        byte[][] auxLevels = null;
        int n = naux = auxValues != null ? auxValues.length : 0;
        if (naux > 0) {
            if (auxLevels1 == null || auxLevels1.length != naux || auxLevels2 == null || auxLevels2.length != naux || auxLevels3 == null || auxLevels3.length != naux) {
                throw new SetException("Contour2D.contour: auxLevels length doesn't match");
            }
            int i = 0;
            while (i < naux) {
                if (auxValues[i].length != g.length) {
                    throw new SetException("Contour2D.contour: auxValues lengths don't match");
                }
                ++i;
            }
            auxLevels = new byte[naux][maxsize];
        } else if (auxLevels1 != null || auxLevels2 != null || auxLevels3 != null) {
            throw new SetException("Contour2D.contour: auxValues null but auxLevels not null");
        }
        numv1[0] = 0;
        numv2[0] = 0;
        numv3[0] = 0;
        numv4[0] = 0;
        if (values == null) {
            return;
        }
        int nrm = nr - 1;
        int ncm = nc - 1;
        float xdd = ((float)(nr - 1) - 0.0f) / ((float)nr - 1.0f);
        float ydd = ((float)(nc - 1) - 0.0f) / ((float)nc - 1.0f);
        float xd = xdd - 2.0E-5f;
        float yd = ydd - 2.0E-5f;
        if (swap[0]) {
            lr = 1 + (nr - 2) / 10;
            lc = 1 + (nc - 2) / 50;
        } else {
            lr = 1 + (nr - 2) / 50;
            lc = 1 + (nc - 2) / 10;
        }
        int lc2 = lc / 2;
        int lr2 = lr / 2;
        int lrr = 1 + (nr - 2) / 8;
        int lcc = 1 + (nc - 2) / 8;
        char[] mark = new char[nr * nc];
        int i = 0;
        while (i < nr * nc) {
            mark[i] = '\u0000';
            ++i;
        }
        int ic = 0;
        while (ic < nc) {
            ir = 0;
            while (ir < lr) {
                mark[ic * nr + ir] = '\u0001';
                mark[ic * nr + (nr - ir - 2)] = '\u0001';
                ++ir;
            }
            ++ic;
        }
        ir = 0;
        while (ir < nr) {
            ic = 0;
            while (ic < lc) {
                mark[ic * nr + ir] = '\u0001';
                mark[(nc - ic - 2) * nr + ir] = '\u0001';
                ++ic;
            }
            ++ir;
        }
        int nump = 0;
        int numv = 0;
        byte[][] color_bin = interval_colors;
        byte[][][] o_flags = new byte[nrm][ncm][];
        short[][] n_lines = new short[nrm][ncm];
        short[][] ctrLow = new short[nrm][ncm];
        ContourStripSet ctrSet = new ContourStripSet(nrm, myvals, swap, scale_ratio, label_size, nr, nc, spatial_set);
        ir = 0;
        while (ir < nrm) {
            float xx = xdd * (float)ir + 0.0f;
            ic = 0;
            while (ic < ncm) {
                float gd;
                float gc;
                float gb;
                if (numv + 8 >= maxsize) {
                    maxsize = 2 * maxsize;
                    float[] tx = vx;
                    float[] ty = vy;
                    vx = new float[maxsize];
                    vy = new float[maxsize];
                    System.arraycopy(tx, 0, vx, 0, numv);
                    System.arraycopy(ty, 0, vy, 0, numv);
                    if (naux > 0) {
                        byte[][] ta = auxLevels;
                        auxLevels = new byte[naux][maxsize];
                        int i2 = 0;
                        while (i2 < naux) {
                            System.arraycopy(ta[i2], 0, auxLevels[i2], 0, numv);
                            ++i2;
                        }
                    }
                }
                ipnt[nump++] = numv;
                float yy = ydd * (float)ic + 0.0f;
                float ga = g[ic * nr + ir];
                if (ga == ga && (gb = g[ic * nr + (ir + 1)]) == gb && (gc = g[(ic + 1) * nr + ir]) == gc && (gd = g[(ic + 1) * nr + (ir + 1)]) == gd) {
                    int numc;
                    int i3;
                    byte[] auxa = null;
                    byte[] auxb = null;
                    byte[] auxc = null;
                    byte[] auxd = null;
                    if (naux > 0) {
                        auxa = new byte[naux];
                        auxb = new byte[naux];
                        auxc = new byte[naux];
                        auxd = new byte[naux];
                        i3 = 0;
                        while (i3 < naux) {
                            auxa[i3] = auxValues[i3][ic * nr + ir];
                            auxb[i3] = auxValues[i3][ic * nr + (ir + 1)];
                            auxc[i3] = auxValues[i3][(ic + 1) * nr + ir];
                            auxd[i3] = auxValues[i3][(ic + 1) * nr + (ir + 1)];
                            ++i3;
                        }
                    }
                    float gv = (ga + gb + gc + gd) / 4.0f;
                    float tmp1 = ga < gb ? ga : gb;
                    float tmp2 = gc < gd ? gc : gd;
                    float gn = tmp1 < tmp2 ? tmp1 : tmp2;
                    tmp1 = ga > gb ? ga : gb;
                    tmp2 = gc > gd ? gc : gd;
                    float gx = tmp1 > tmp2 ? tmp1 : tmp2;
                    int low = 0;
                    int hi = myvals.length - 1;
                    if (myvals[low] > gx || myvals[hi] < gn) {
                        numc = 1;
                    } else {
                        i3 = 0;
                        while (i3 < myvals.length) {
                            if (i3 == 0 && myvals[i3] >= gn) {
                                low = i3;
                            } else if (myvals[i3] >= gn && myvals[i3 - 1] < gn) {
                                low = i3;
                            } else if (myvals[i3] > gx && myvals[i3 - 1] < gn) {
                                hi = i3;
                            }
                            ++i3;
                        }
                        numc = hi - low + 1;
                    }
                    float gg = myvals[low];
                    o_flags[ir][ic] = new byte[2 * numc];
                    n_lines[ir][ic] = 0;
                    ctrLow[ir][ic] = (short)hi;
                    int il = 0;
                    while (il < numc) {
                        gg = myvals[low + il];
                        if (numv + 8 >= maxsize) {
                            maxsize = 2 * maxsize;
                            float[] tx = vx;
                            float[] ty = vy;
                            vx = new float[maxsize];
                            vy = new float[maxsize];
                            System.arraycopy(tx, 0, vx, 0, numv);
                            System.arraycopy(ty, 0, vy, 0, numv);
                            if (naux > 0) {
                                byte[][] ta = auxLevels;
                                auxLevels = new byte[naux][maxsize];
                                int i4 = 0;
                                while (i4 < naux) {
                                    System.arraycopy(ta[i4], 0, auxLevels[i4], 0, numv);
                                    ++i4;
                                }
                            }
                        }
                        if (!(gg < gn)) {
                            if (gg > gx) break;
                            if (!(gg < lowlimit)) {
                                if (gg > highlimit) break;
                                int ii = 0;
                                if (gg > ga) {
                                    ii = 1;
                                }
                                if (gg > gb) {
                                    ii += 2;
                                }
                                if (gg > gc) {
                                    ii += 4;
                                }
                                if (gg > gd) {
                                    ii += 8;
                                }
                                if (ii > 7) {
                                    ii = 15 - ii;
                                }
                                if (ii > 0) {
                                    if (low + il < ctrLow[ir][ic]) {
                                        ctrLow[ir][ic] = (short)(low + il);
                                    }
                                    if (mark[ic * nr + ir] == '\u0000') {
                                        float[][] ty;
                                        float[][] tx;
                                        int jr;
                                        int kc = ic - lc2 - lcc;
                                        int kr = ir - lr2 - lrr;
                                        int mc = kc + 2 * lcc + lc - 1;
                                        int mr = kr + 2 * lrr + lr - 1;
                                        int jc = kc;
                                        while (jc <= mc) {
                                            if (jc >= 0 && jc < nc) {
                                                jr = kr;
                                                while (jr <= mr) {
                                                    if (jr >= 0 && jr < nr && mark[jc * nr + jr] != '\u0002') {
                                                        mark[jc * nr + jr] = '\u0001';
                                                    }
                                                    ++jr;
                                                }
                                            }
                                            ++jc;
                                        }
                                        kc = ic - lc2;
                                        kr = ir - lr2;
                                        mc = kc + lc - 1;
                                        mr = kr + lr - 1;
                                        jc = kc;
                                        while (jc <= mc) {
                                            if (jc >= 0 && jc < nc) {
                                                jr = kr;
                                                while (jr <= mr) {
                                                    if (jr >= 0 && jr < nr) {
                                                        mark[jc * nr + jr] = 2;
                                                    }
                                                    ++jr;
                                                }
                                            }
                                            ++jc;
                                        }
                                        float xk = xdd * (float)kr + 0.0f;
                                        float yk = ydd * (float)kc + 0.0f;
                                        float xm = xdd * ((float)mr + 1.0f) + 0.0f;
                                        float ym = ydd * ((float)mc + 1.0f) + 0.0f;
                                        float value = gg;
                                        if (numv4[0] + 1000 >= maxv4) {
                                            maxv4 = 2 * (numv4[0] + 1000);
                                            tx = new float[][]{vx4[0]};
                                            ty = new float[][]{vy4[0]};
                                            vx4[0] = new float[maxv4];
                                            vy4[0] = new float[maxv4];
                                            System.arraycopy(tx[0], 0, vx4[0], 0, numv4[0]);
                                            System.arraycopy(ty[0], 0, vy4[0], 0, numv4[0]);
                                        }
                                        if (numv3[0] + 1000 >= maxv3) {
                                            maxv3 = 2 * (numv3[0] + 1000);
                                            tx = new float[][]{vx3[0]};
                                            ty = new float[][]{vy3[0]};
                                            vx3[0] = new float[maxv3];
                                            vy3[0] = new float[maxv3];
                                            System.arraycopy(tx[0], 0, vx3[0], 0, numv3[0]);
                                            System.arraycopy(ty[0], 0, vy3[0], 0, numv3[0]);
                                            if (naux > 0) {
                                                byte[][] ta = auxLevels3;
                                                int i5 = 0;
                                                while (i5 < naux) {
                                                    byte[] taa = auxLevels3[i5];
                                                    auxLevels3[i5] = new byte[maxv3];
                                                    System.arraycopy(taa, 0, auxLevels3[i5], 0, numv3[0]);
                                                    ++i5;
                                                }
                                            }
                                        }
                                        plot.plotdigits(value, xk, yk, xm, ym, maxsize, swap);
                                        System.arraycopy(plot.Vx, 0, vx3[0], numv3[0], plot.NumVerts);
                                        System.arraycopy(plot.Vy, 0, vy3[0], numv3[0], plot.NumVerts);
                                        if (naux > 0) {
                                            int i6 = 0;
                                            while (i6 < naux) {
                                                int j = numv3[0];
                                                while (j < numv3[0] + plot.NumVerts) {
                                                    auxLevels3[i6][j] = auxa[i6];
                                                    ++j;
                                                }
                                                ++i6;
                                            }
                                        }
                                        numv3[0] = numv3[0] + plot.NumVerts;
                                        System.arraycopy(plot.VxB, 0, vx4[0], numv4[0], plot.NumVerts);
                                        System.arraycopy(plot.VyB, 0, vy4[0], numv4[0], plot.NumVerts);
                                        numv4[0] = numv4[0] + plot.NumVerts;
                                    }
                                    switch (ii) {
                                        case 1: {
                                            int t;
                                            int i7;
                                            float gba = gb - ga;
                                            float gca = gc - ga;
                                            if (naux > 0) {
                                                float ratioba = (gg - ga) / gba;
                                                float ratioca = (gg - ga) / gca;
                                                i7 = 0;
                                                while (i7 < naux) {
                                                    t = (int)((1.0f - ratioba) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioba * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]));
                                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    t = (int)((1.0f - ratioca) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioca * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]));
                                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i7;
                                                }
                                            }
                                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                                            vy[numv] = yy;
                                            vy[++numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                            vx[numv] = xx;
                                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                            short[] sArray = n_lines[ir];
                                            int n2 = ic;
                                            sArray[n2] = (short)(sArray[n2] + 1);
                                            if (vx[++numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                                            int n3 = numv - 2;
                                            vx[n3] = vx[n3] + 1.0E-5f;
                                            int n4 = numv - 1;
                                            vy[n4] = vy[n4] + 1.0E-5f;
                                            break;
                                        }
                                        case 2: {
                                            int t;
                                            int i7;
                                            float gba = gb - ga;
                                            float gdb = gd - gb;
                                            if (naux > 0) {
                                                float ratioba = (gg - ga) / gba;
                                                float ratiodb = (gg - gb) / gdb;
                                                i7 = 0;
                                                while (i7 < naux) {
                                                    t = (int)((1.0f - ratioba) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioba * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]));
                                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    t = (int)((1.0f - ratiodb) * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]) + ratiodb * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i7;
                                                }
                                            }
                                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                                            vy[numv] = yy;
                                            vy[++numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                            vx[numv] = xx + xd;
                                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                            short[] sArray = n_lines[ir];
                                            int n5 = ic;
                                            sArray[n5] = (short)(sArray[n5] + 1);
                                            if (vx[++numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                                            int n6 = numv - 2;
                                            vx[n6] = vx[n6] - 1.0E-5f;
                                            int n7 = numv - 1;
                                            vy[n7] = vy[n7] + 1.0E-5f;
                                            break;
                                        }
                                        case 3: {
                                            int t;
                                            int i7;
                                            float gca = gc - ga;
                                            float gdb = gd - gb;
                                            if (naux > 0) {
                                                float ratioca = (gg - ga) / gca;
                                                float ratiodb = (gg - gb) / gdb;
                                                i7 = 0;
                                                while (i7 < naux) {
                                                    t = (int)((1.0f - ratioca) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioca * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]));
                                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    t = (int)((1.0f - ratiodb) * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]) + ratiodb * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i7;
                                                }
                                            }
                                            vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                            vx[numv] = xx;
                                            vy[++numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                            vx[numv] = xx + xd;
                                            ++numv;
                                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                            short[] sArray = n_lines[ir];
                                            int n8 = ic;
                                            sArray[n8] = (short)(sArray[n8] + 1);
                                            break;
                                        }
                                        case 4: {
                                            int t;
                                            int i7;
                                            float gca = gc - ga;
                                            float gdc = gd - gc;
                                            if (naux > 0) {
                                                float ratioca = (gg - ga) / gca;
                                                float ratiodc = (gg - gc) / gdc;
                                                i7 = 0;
                                                while (i7 < naux) {
                                                    t = (int)((1.0f - ratioca) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioca * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]));
                                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    t = (int)((1.0f - ratiodc) * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]) + ratiodc * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i7;
                                                }
                                            }
                                            vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                            vx[numv] = xx;
                                            vx[++numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                                            vy[numv] = yy + yd;
                                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                            short[] sArray = n_lines[ir];
                                            int n9 = ic;
                                            sArray[n9] = (short)(sArray[n9] + 1);
                                            if (vx[++numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                                            int n10 = numv - 1;
                                            vx[n10] = vx[n10] + 1.0E-5f;
                                            int n11 = numv - 2;
                                            vy[n11] = vy[n11] - 1.0E-5f;
                                            break;
                                        }
                                        case 5: {
                                            int t;
                                            int i7;
                                            float gba = gb - ga;
                                            float gdc = gd - gc;
                                            if (naux > 0) {
                                                float ratioba = (gg - ga) / gba;
                                                float ratiodc = (gg - gc) / gdc;
                                                i7 = 0;
                                                while (i7 < naux) {
                                                    t = (int)((1.0f - ratioba) * (auxa[i7] < 0 ? (float)auxa[i7] + 256.0f : (float)auxa[i7]) + ratioba * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]));
                                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    t = (int)((1.0f - ratiodc) * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]) + ratiodc * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i7;
                                                }
                                            }
                                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                                            vy[numv] = yy;
                                            vx[++numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                                            vy[numv] = yy + yd;
                                            ++numv;
                                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                            short[] sArray = n_lines[ir];
                                            int n12 = ic;
                                            sArray[n12] = (short)(sArray[n12] + 1);
                                            break;
                                        }
                                        case 6: {
                                            int t;
                                            float gba = gb - ga;
                                            float gdc = gd - gc;
                                            float gca = gc - ga;
                                            float gdb = gd - gb;
                                            if (naux > 0) {
                                                float ratioba = (gg - ga) / gba;
                                                float ratiodc = (gg - gc) / gdc;
                                                float ratioca = (gg - ga) / gca;
                                                float ratiodb = (gg - gb) / gdb;
                                                int i8 = 0;
                                                while (i8 < naux) {
                                                    t = (int)((1.0f - ratioba) * (auxa[i8] < 0 ? (float)auxa[i8] + 256.0f : (float)auxa[i8]) + ratioba * (auxb[i8] < 0 ? (float)auxb[i8] + 256.0f : (float)auxb[i8]));
                                                    auxLevels[i8][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    if (gg > gv ^ ga < gb) {
                                                        t = (int)((1.0f - ratioca) * (auxa[i8] < 0 ? (float)auxa[i8] + 256.0f : (float)auxa[i8]) + ratioca * (auxc[i8] < 0 ? (float)auxc[i8] + 256.0f : (float)auxc[i8]));
                                                        auxLevels[i8][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                        t = (int)((1.0f - ratiodb) * (auxb[i8] < 0 ? (float)auxb[i8] + 256.0f : (float)auxb[i8]) + ratiodb * (auxd[i8] < 0 ? (float)auxd[i8] + 256.0f : (float)auxd[i8]));
                                                        auxLevels[i8][numv + 2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    } else {
                                                        t = (int)((1.0f - ratiodb) * (auxb[i8] < 0 ? (float)auxb[i8] + 256.0f : (float)auxb[i8]) + ratiodb * (auxd[i8] < 0 ? (float)auxd[i8] + 256.0f : (float)auxd[i8]));
                                                        auxLevels[i8][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                        t = (int)((1.0f - ratioca) * (auxa[i8] < 0 ? (float)auxa[i8] + 256.0f : (float)auxa[i8]) + ratioca * (auxc[i8] < 0 ? (float)auxc[i8] + 256.0f : (float)auxc[i8]));
                                                        auxLevels[i8][numv + 2] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    }
                                                    t = (int)((1.0f - ratiodc) * (auxc[i8] < 0 ? (float)auxc[i8] + 256.0f : (float)auxc[i8]) + ratiodc * (auxd[i8] < 0 ? (float)auxd[i8] + 256.0f : (float)auxd[i8]));
                                                    auxLevels[i8][numv + 3] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i8;
                                                }
                                            }
                                            vx[numv] = (double)(gba < 0.0f ? -gba : gba) < 1.0E-7 ? xx : xx + xd * (gg - ga) / gba;
                                            vy[numv] = yy;
                                            ++numv;
                                            if (gg > gv ^ ga < gb) {
                                                vy[numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                                vx[numv] = xx;
                                                o_flags[ir][ic][n_lines[ir][ic]] = 33;
                                                short[] sArray = n_lines[ir];
                                                int n13 = ic;
                                                sArray[n13] = (short)(sArray[n13] + 1);
                                                vy[++numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                                vx[numv] = xx + xd;
                                                o_flags[ir][ic][n_lines[ir][ic]] = 39;
                                                short[] sArray2 = n_lines[ir];
                                                int n14 = ic;
                                                sArray2[n14] = (short)(sArray2[n14] + 1);
                                                ++numv;
                                            } else {
                                                vy[numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                                vx[numv] = xx + xd;
                                                o_flags[ir][ic][n_lines[ir][ic]] = 34;
                                                short[] sArray = n_lines[ir];
                                                int n15 = ic;
                                                sArray[n15] = (short)(sArray[n15] + 1);
                                                vy[++numv] = (double)(gca < 0.0f ? -gca : gca) < 1.0E-7 ? yy : yy + yd * (gg - ga) / gca;
                                                vx[numv] = xx;
                                                ++numv;
                                                o_flags[ir][ic][n_lines[ir][ic]] = 36;
                                                short[] sArray3 = n_lines[ir];
                                                int n16 = ic;
                                                sArray3[n16] = (short)(sArray3[n16] + 1);
                                            }
                                            vx[numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                                            vy[numv] = yy + yd;
                                            ++numv;
                                            break;
                                        }
                                        case 7: {
                                            int t;
                                            int i7;
                                            float gdb = gd - gb;
                                            float gdc = gd - gc;
                                            if (naux > 0) {
                                                float ratiodb = (gg - gb) / gdb;
                                                float ratiodc = (gg - gc) / gdc;
                                                i7 = 0;
                                                while (i7 < naux) {
                                                    t = (int)((1.0f - ratiodb) * (auxb[i7] < 0 ? (float)auxb[i7] + 256.0f : (float)auxb[i7]) + ratiodb * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                                    auxLevels[i7][numv] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    t = (int)((1.0f - ratiodc) * (auxc[i7] < 0 ? (float)auxc[i7] + 256.0f : (float)auxc[i7]) + ratiodc * (auxd[i7] < 0 ? (float)auxd[i7] + 256.0f : (float)auxd[i7]));
                                                    auxLevels[i7][numv + 1] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                                    ++i7;
                                                }
                                            }
                                            vy[numv] = (double)(gdb < 0.0f ? -gdb : gdb) < 1.0E-7 ? yy : yy + yd * (gg - gb) / gdb;
                                            vx[numv] = xx + xd;
                                            vx[++numv] = (double)(gdc < 0.0f ? -gdc : gdc) < 1.0E-7 ? xx : xx + xd * (gg - gc) / gdc;
                                            vy[numv] = yy + yd;
                                            o_flags[ir][ic][n_lines[ir][ic]] = (byte)ii;
                                            short[] sArray = n_lines[ir];
                                            int n17 = ic;
                                            sArray[n17] = (short)(sArray[n17] + 1);
                                            if (vx[++numv - 2] != vx[numv - 1] && vy[numv - 2] != vy[numv - 1]) break;
                                            int n18 = numv - 1;
                                            vx[n18] = vx[n18] - 1.0E-5f;
                                            int n19 = numv - 2;
                                            vy[n19] = vy[n19] - 1.0E-5f;
                                        }
                                    }
                                    if (gg < base && dash) {
                                        float vxa = vx[numv - 2];
                                        float vya = vy[numv - 2];
                                        float vxb = vx[numv - 1];
                                        float vyb = vy[numv - 1];
                                        vx[numv - 2] = (3.0f * vxa + vxb) * 0.25f;
                                        vy[numv - 2] = (3.0f * vya + vyb) * 0.25f;
                                        vx[numv - 1] = (vxa + 3.0f * vxb) * 0.25f;
                                        vy[numv - 1] = (vya + 3.0f * vyb) * 0.25f;
                                    }
                                    if (ii == 6) {
                                        ctrSet.add(vx, vy, numv - 4, numv - 3, low + il);
                                        ctrSet.add(vx, vy, numv - 2, numv - 1, low + il);
                                    } else {
                                        ctrSet.add(vx, vy, numv - 2, numv - 1, low + il);
                                    }
                                }
                            }
                        }
                        ++il;
                    }
                }
                ++ic;
            }
            ++ir;
        }
        if (fill) {
            Contour2D.fillGridBox(g, n_lines, vx, vy, xd, xdd, yd, ydd, nr, nrm, nc, ncm, ctrLow, tri, tri_color, o_flags, myvals, color_bin, grd_normals, tri_normals);
        }
        float[][][] vvv = new float[2][][];
        byte[][][] new_colors = new byte[2][][];
        ctrSet.getLineColorArrays(vx, vy, auxLevels, vvv, new_colors, lbl_vv, lbl_cc, lbl_loc);
        vx1[0] = vvv[0][0];
        vy1[0] = vvv[0][1];
        vz1[0] = vvv[0][2];
        vx2[0] = vvv[1][0];
        vy2[0] = vvv[1][1];
        vz2[0] = vvv[1][2];
        numv1[0] = vvv[0][0].length;
        numv2[0] = vvv[1][0].length;
        int n_lbls = lbl_vv[0].length;
        if (n_lbls > 0) {
            vx3[0] = lbl_vv[0][0][0];
            vy3[0] = lbl_vv[0][0][1];
            vz3[0] = lbl_vv[0][0][2];
            vx4[0] = lbl_vv[1][0][0];
            vy4[0] = lbl_vv[1][0][1];
            vz4[0] = lbl_vv[1][0][2];
            numv3[0] = lbl_vv[0][0][0].length;
            numv4[0] = lbl_vv[1][0][0].length;
        }
        if (auxLevels != null) {
            int clr_dim = auxValues.length;
            auxLevels1[0] = new_colors[0][0];
            auxLevels1[1] = new_colors[0][1];
            auxLevels1[2] = new_colors[0][2];
            if (clr_dim == 4) {
                auxLevels1[3] = new_colors[0][3];
            }
            auxLevels2[0] = new_colors[1][0];
            auxLevels2[1] = new_colors[1][1];
            auxLevels2[2] = new_colors[1][2];
            if (clr_dim == 4) {
                auxLevels2[3] = new_colors[1][3];
            }
            if (n_lbls > 0) {
                auxLevels3[0] = lbl_cc[0][0][0];
                auxLevels3[1] = lbl_cc[0][0][1];
                auxLevels3[2] = lbl_cc[0][0][2];
                if (clr_dim == 4) {
                    auxLevels3[3] = lbl_cc[0][0][3];
                }
            }
        }
    }

    private static void fillGridBox(float[] g, short[][] n_lines, float[] vx, float[] vy, float xd, float xdd, float yd, float ydd, int nr, int nrm, int nc, int ncm, short[][] ctrLow, float[][] tri, byte[][] tri_color, byte[][][] o_flags, float[] values, byte[][] color_bin, float[][][] grd_normals, float[][] tri_normals) {
        int[] numv = new int[]{0};
        int n_tri = 0;
        int ir = 0;
        while (ir < nrm) {
            int ic = 0;
            while (ic < ncm) {
                n_tri = n_lines[ir][ic] == 0 ? (n_tri += 2) : (n_tri += 4 + (n_lines[ir][ic] - 1) * 2);
                boolean any = false;
                if (o_flags[ir][ic] != null) {
                    int k = 0;
                    while (k < o_flags[ir][ic].length) {
                        if (o_flags[ir][ic][k] > 32) {
                            any = true;
                        }
                        ++k;
                    }
                    if (any) {
                        n_tri += 4;
                    }
                }
                ++ic;
            }
            ++ir;
        }
        tri[0] = new float[n_tri * 3];
        tri[1] = new float[n_tri * 3];
        int kk = 0;
        while (kk < color_bin.length) {
            tri_color[kk] = new byte[n_tri * 3];
            ++kk;
        }
        tri_normals[0] = new float[3 * n_tri * 3];
        int[] t_idx = new int[]{0};
        int[] n_idx = new int[]{0};
        int ir2 = 0;
        while (ir2 < nrm) {
            float xx = xdd * (float)ir2 + 0.0f;
            int ic = 0;
            while (ic < ncm) {
                float gd;
                float gc;
                float gb;
                float yy = ydd * (float)ic + 0.0f;
                float ga = g[ic * nr + ir2];
                if (ga == ga && (gb = g[ic * nr + (ir2 + 1)]) == gb && (gc = g[(ic + 1) * nr + ir2]) == gc && (gd = g[(ic + 1) * nr + (ir2 + 1)]) == gd) {
                    numv[0] = numv[0] + n_lines[ir2][ic] * 2;
                    Contour2D.fillGridBox(new float[]{ga, gb, gc, gd}, n_lines[ir2][ic], vx, vy, xx, yy, xd, yd, ic, ir2, ctrLow[ir2][ic], tri, t_idx, tri_color, numv[0], o_flags[ir2][ic], values, color_bin, grd_normals, n_idx, tri_normals);
                }
                ++ic;
            }
            ++ir2;
        }
    }

    private static void fillGridBox(float[] corners, int numc, float[] vx, float[] vy, float xx, float yy, float xd, float yd, int nc, int nr, short ctrLow, float[][] tri, int[] t_idx, byte[][] tri_color, int numv, byte[] o_flags, float[] values, byte[][] color_bin, float[][][] grd_normals, int[] n_idx, float[][] tri_normals_a) {
        int flag;
        float[] tri_normals = tri_normals_a[0];
        int n_tri = 4 + (numc - 1) * 2;
        int[] cnt_tri = new int[]{0};
        int il = 0;
        int color_length = color_bin.length;
        float[] vec = new float[2];
        float[] vec_last = new float[2];
        float[] vv1 = new float[2];
        float[] vv2 = new float[2];
        float[] vv1_last = new float[2];
        float[] vv2_last = new float[2];
        float[][] vv = new float[2][2];
        float[][] vv_last = new float[2][2];
        float[] vv3 = new float[2];
        int dir = 1;
        int start = numv - 2;
        int o_start = numc - 1;
        boolean x_min_idx = false;
        int o_idx = 0;
        byte o_flag = o_flags[o_idx];
        boolean ydir = true;
        boolean special = false;
        int[] closed = new int[]{0};
        float dist_sqrd = 0.0f;
        int v_idx = start + dir * il * 2;
        byte[][] crnr_color = new byte[4][color_length];
        boolean[] crnr_out = new boolean[]{true, true, true, true};
        boolean all_out = true;
        int tt = 0;
        while (tt < corners.length) {
            int cc = 0;
            int kk = 0;
            kk = 0;
            while (kk < values.length - 1) {
                if (corners[tt] >= values[kk] && corners[tt] < values[kk + 1]) {
                    cc = kk;
                    all_out = false;
                    crnr_out[tt] = false;
                }
                ++kk;
            }
            int ii = 0;
            while (ii < color_length) {
                crnr_color[tt][ii] = color_bin[ii][cc];
                ++ii;
            }
            ++tt;
        }
        int tt2 = t_idx[0];
        dir = 1;
        start = numv - numc * 2;
        o_start = 0;
        v_idx = start + dir * il * 2;
        boolean up = false;
        boolean right = false;
        float[] x_avg = new float[2];
        float[] y_avg = new float[2];
        if (numc > 1) {
            int idx = v_idx;
            x_avg[0] = (vx[idx] + vx[idx + 1]) / 2.0f;
            y_avg[0] = (vy[idx] + vy[idx + 1]) / 2.0f;
            idx = v_idx + 2;
            x_avg[1] = (vx[idx] + vx[idx + 1]) / 2.0f;
            y_avg[1] = (vy[idx] + vy[idx + 1]) / 2.0f;
            if (x_avg[1] - x_avg[0] > 0.0f) {
                up = true;
            }
            if (y_avg[1] - y_avg[0] > 0.0f) {
                right = true;
            }
        } else if (numc == 1) {
            x_avg[0] = 0.0f;
            y_avg[0] = 0.0f;
            x_avg[1] = 1.0f;
            y_avg[1] = 1.0f;
        } else if (numc == 0) {
            if (all_out) {
                return;
            }
            n_tri = 2;
            int n = n_idx[0];
            n_idx[0] = n + 1;
            tri_normals[n] = grd_normals[nc][nr][0];
            int n2 = n_idx[0];
            n_idx[0] = n2 + 1;
            tri_normals[n2] = grd_normals[nc][nr][1];
            int n3 = n_idx[0];
            n_idx[0] = n3 + 1;
            tri_normals[n3] = grd_normals[nc][nr][2];
            int ii = 0;
            while (ii < color_length) {
                tri_color[ii][tt2] = crnr_color[0][ii];
                ++ii;
            }
            tri[0][tt2] = xx;
            tri[1][tt2++] = yy;
            int n4 = n_idx[0];
            n_idx[0] = n4 + 1;
            tri_normals[n4] = grd_normals[nc][nr + 1][0];
            int n5 = n_idx[0];
            n_idx[0] = n5 + 1;
            tri_normals[n5] = grd_normals[nc][nr + 1][1];
            int n6 = n_idx[0];
            n_idx[0] = n6 + 1;
            tri_normals[n6] = grd_normals[nc][nr + 1][2];
            int ii2 = 0;
            while (ii2 < color_length) {
                tri_color[ii2][tt2] = crnr_color[0][ii2];
                ++ii2;
            }
            tri[0][tt2] = xx + xd;
            tri[1][tt2++] = yy;
            int n7 = n_idx[0];
            n_idx[0] = n7 + 1;
            tri_normals[n7] = grd_normals[nc + 1][nr + 1][0];
            int n8 = n_idx[0];
            n_idx[0] = n8 + 1;
            tri_normals[n8] = grd_normals[nc + 1][nr + 1][1];
            int n9 = n_idx[0];
            n_idx[0] = n9 + 1;
            tri_normals[n9] = grd_normals[nc + 1][nr + 1][2];
            int ii3 = 0;
            while (ii3 < color_length) {
                tri_color[ii3][tt2] = crnr_color[0][ii3];
                ++ii3;
            }
            tri[0][tt2] = xx + xd;
            tri[1][tt2++] = yy + yd;
            t_idx[0] = tt2;
            cnt_tri[0] = cnt_tri[0] + 1;
            int n10 = n_idx[0];
            n_idx[0] = n10 + 1;
            tri_normals[n10] = grd_normals[nc + 1][nr + 1][0];
            int n11 = n_idx[0];
            n_idx[0] = n11 + 1;
            tri_normals[n11] = grd_normals[nc + 1][nr + 1][1];
            int n12 = n_idx[0];
            n_idx[0] = n12 + 1;
            tri_normals[n12] = grd_normals[nc + 1][nr + 1][2];
            int ii4 = 0;
            while (ii4 < color_length) {
                tri_color[ii4][tt2] = crnr_color[0][ii4];
                ++ii4;
            }
            tri[0][tt2] = xx + xd;
            tri[1][tt2++] = yy + yd;
            int n13 = n_idx[0];
            n_idx[0] = n13 + 1;
            tri_normals[n13] = grd_normals[nc][nr][0];
            int n14 = n_idx[0];
            n_idx[0] = n14 + 1;
            tri_normals[n14] = grd_normals[nc][nr][1];
            int n15 = n_idx[0];
            n_idx[0] = n15 + 1;
            tri_normals[n15] = grd_normals[nc][nr][2];
            int ii5 = 0;
            while (ii5 < color_length) {
                tri_color[ii5][tt2] = crnr_color[0][ii5];
                ++ii5;
            }
            tri[0][tt2] = xx;
            tri[1][tt2++] = yy;
            int n16 = n_idx[0];
            n_idx[0] = n16 + 1;
            tri_normals[n16] = grd_normals[nc + 1][nr][0];
            int n17 = n_idx[0];
            n_idx[0] = n17 + 1;
            tri_normals[n17] = grd_normals[nc + 1][nr][1];
            int n18 = n_idx[0];
            n_idx[0] = n18 + 1;
            tri_normals[n18] = grd_normals[nc + 1][nr][2];
            int ii6 = 0;
            while (ii6 < color_length) {
                tri_color[ii6][tt2] = crnr_color[0][ii6];
                ++ii6;
            }
            tri[0][tt2] = xx;
            tri[1][tt2++] = yy + yd;
            t_idx[0] = tt2;
            cnt_tri[0] = cnt_tri[0] + 1;
            return;
        }
        int iii = 0;
        while (iii < o_flags.length) {
            if (o_flags[iii] > 32) {
                Contour2D.fillCaseSix(xx, yy, xd, yd, v_idx, dir, o_flags, ctrLow, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, color_bin, tri_color, color_length, grd_normals, n_idx, tri_normals, closed, cnt_tri);
                return;
            }
            ++iii;
        }
        if (o_flag == 1 || o_flag == 4 || o_flag == 2 || o_flag == 7) {
            boolean opp = false;
            float dy = 0.0f;
            float dx = 0.0f;
            float dist_0 = 0.0f;
            float dist_1 = 0.0f;
            if (o_flag == 1) {
                dy = y_avg[1] - yy;
                dx = x_avg[1] - xx;
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - yy;
                dx = x_avg[0] - xx;
                dist_0 = dy * dy + dx * dx;
            }
            if (o_flag == 2) {
                dy = y_avg[1] - yy;
                dx = x_avg[1] - (xx + xd);
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - yy;
                dx = x_avg[0] - (xx + xd);
                dist_0 = dy * dy + dx * dx;
            }
            if (o_flag == 4) {
                dy = y_avg[1] - (yy + yd);
                dx = x_avg[1] - xx;
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - (yy + yd);
                dx = x_avg[0] - xx;
                dist_0 = dy * dy + dx * dx;
            }
            if (o_flag == 7) {
                dy = y_avg[1] - (yy + yd);
                dx = x_avg[1] - (xx + xd);
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - (yy + yd);
                dx = x_avg[0] - (xx + xd);
                dist_0 = dy * dy + dx * dx;
            }
            if (dist_1 < dist_0) {
                opp = true;
            }
            if (opp) {
                Contour2D.fillToOppCorner(xx, yy, xd, yd, v_idx, o_flag, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
            } else {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, v_idx, o_flag, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
            }
        } else if (o_flags[o_idx] == 3) {
            flag = 1;
            if (right) {
                flag = -1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, o_flag, flag, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
        } else if (o_flags[o_idx] == 5) {
            flag = 1;
            if (!up) {
                flag = -1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, o_flag, flag, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
        }
        byte last_o = o_flags[o_idx];
        int cc_start = dir > 0 ? ctrLow - 1 : ctrLow + (numc - 1);
        ++il;
        il = 1;
        while (il < numc) {
            v_idx = start + dir * il * 2;
            o_idx = o_start + dir * il;
            int v_idx_last = v_idx - 2 * dir;
            int cc = cc_start + dir * il;
            if (o_flags[o_idx] != last_o) {
                byte[] side_s = new byte[2];
                byte[] last_side_s = new byte[2];
                byte[] b_arg = new byte[2];
                Contour2D.getBoxSide(vx, vy, xx, xd, yy, yd, v_idx, dir, o_flags[o_idx], b_arg);
                side_s[0] = b_arg[0];
                side_s[1] = b_arg[1];
                Contour2D.getBoxSide(vx, vy, xx, xd, yy, yd, v_idx_last, dir, last_o, b_arg);
                last_side_s[0] = b_arg[0];
                last_side_s[1] = b_arg[1];
                boolean flip = side_s[0] == last_side_s[0] ? false : (side_s[0] == last_side_s[1] ? true : (side_s[1] == last_side_s[0] ? true : (side_s[1] == last_side_s[1] ? false : (side_s[0] + last_side_s[0] & 1) != 1)));
                if (!flip) {
                    vv1[0] = vx[v_idx];
                    vv1[1] = vy[v_idx];
                    vv2[0] = vx[v_idx + dir];
                    vv2[1] = vy[v_idx + dir];
                    vv[0][0] = vx[v_idx];
                    vv[1][0] = vy[v_idx];
                    vv[0][1] = vx[v_idx + dir];
                    vv[1][1] = vy[v_idx + dir];
                } else {
                    vv1[0] = vx[v_idx + dir];
                    vv1[1] = vy[v_idx + dir];
                    vv2[0] = vx[v_idx];
                    vv2[1] = vy[v_idx];
                    vv[0][0] = vx[v_idx + dir];
                    vv[1][0] = vy[v_idx + dir];
                    vv[0][1] = vx[v_idx];
                    vv[1][1] = vy[v_idx];
                }
                vv1_last[0] = vx[v_idx_last];
                vv1_last[1] = vy[v_idx_last];
                vv2_last[0] = vx[v_idx_last + dir];
                vv2_last[1] = vy[v_idx_last + dir];
                vv_last[0][0] = vx[v_idx_last];
                vv_last[1][0] = vy[v_idx_last];
                vv_last[0][1] = vx[v_idx_last + dir];
                vv_last[1][1] = vy[v_idx_last + dir];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, tri, cnt_tri, t_idx, tri_color, color_bin, cc, color_length, grd_normals, n_idx, tri_normals);
                byte[] b_arg2 = new byte[2];
                Contour2D.getBoxSide(vv[0], vv[1], xx, xd, yy, yd, 0, dir, o_flags[o_idx], b_arg);
                Contour2D.getBoxSide(vv_last[0], vv_last[1], xx, xd, yy, yd, 0, dir, last_o, b_arg2);
                int kk = 0;
                while (kk < 2) {
                    float[] vvx = new float[2];
                    float[] vvy = new float[2];
                    byte side = 0;
                    byte last_s = 0;
                    side = b_arg[kk];
                    last_s = b_arg2[kk];
                    if (side != last_s) {
                        int flag2;
                        if (side == 0 && last_s == 3 || side == 3 && last_s == 0) {
                            Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)1, cnt_tri, 1, new float[]{vv[0][kk], vv_last[0][kk]}, new float[]{vv[1][kk], vv_last[1][kk]}, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                        }
                        if (side == 0 && last_s == 1 || side == 1 && last_s == 0) {
                            Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)2, cnt_tri, 1, new float[]{vv[0][kk], vv_last[0][kk]}, new float[]{vv[1][kk], vv_last[1][kk]}, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                        }
                        if (side == 2 && last_s == 3 || side == 3 && last_s == 2) {
                            Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)4, cnt_tri, 1, new float[]{vv[0][kk], vv_last[0][kk]}, new float[]{vv[1][kk], vv_last[1][kk]}, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                        }
                        if (side == 2 && last_s == 1 || side == 1 && last_s == 2) {
                            Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)7, cnt_tri, 1, new float[]{vv[0][kk], vv_last[0][kk]}, new float[]{vv[1][kk], vv_last[1][kk]}, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                        }
                        if (side == 2 && last_s == 0 || side == 0 && last_s == 2) {
                            if (side == 0) {
                                vvx[0] = vv[0][kk];
                                vvy[0] = vv[1][kk];
                                vvx[1] = vv_last[0][kk];
                                vvy[1] = vv_last[1][kk];
                            } else {
                                vvx[0] = vv_last[0][kk];
                                vvy[0] = vv_last[1][kk];
                                vvx[1] = vv[0][kk];
                                vvy[1] = vv[1][kk];
                            }
                            flag2 = -1;
                            if ((closed[0] & 4) == 0 && (closed[0] & 1) == 0) {
                                flag2 = 1;
                            }
                            Contour2D.fillToSide(xx, yy, xd, yd, 0, (byte)5, flag2, cnt_tri, 1, vvx, vvy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                        }
                        if (side == 1 && last_s == 3 || side == 3 && last_s == 1) {
                            if (side == 3) {
                                vvx[0] = vv[0][kk];
                                vvy[0] = vv[1][kk];
                                vvx[1] = vv_last[0][kk];
                                vvy[1] = vv_last[1][kk];
                            } else {
                                vvx[0] = vv_last[0][kk];
                                vvy[0] = vv_last[1][kk];
                                vvx[1] = vv[0][kk];
                                vvy[1] = vv[1][kk];
                            }
                            flag2 = -1;
                            if ((closed[0] & 4) == 0 && (closed[0] & 8) == 0) {
                                flag2 = 1;
                            }
                            Contour2D.fillToSide(xx, yy, xd, yd, 0, (byte)3, flag2, cnt_tri, 1, vvx, vvy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                        }
                    }
                    ++kk;
                }
            } else {
                vv1[0] = vx[v_idx];
                vv1[1] = vy[v_idx];
                vv2[0] = vx[v_idx + dir];
                vv2[1] = vy[v_idx + dir];
                vv1_last[0] = vx[v_idx_last];
                vv1_last[1] = vy[v_idx_last];
                vv2_last[0] = vx[v_idx_last + dir];
                vv2_last[1] = vy[v_idx_last + dir];
                Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vv1, vv2, vv1_last, vv2_last, tri, cnt_tri, t_idx, tri_color, color_bin, cc, color_length, grd_normals, n_idx, tri_normals);
            }
            last_o = o_flags[o_idx];
            ++il;
        }
        int flag_set = 0;
        if (last_o == 1 || last_o == 2 || last_o == 4 || last_o == 7) {
            if (last_o == 1) {
                flag_set = closed[0] & 1;
            }
            if (last_o == 2) {
                flag_set = closed[0] & 2;
            }
            if (last_o == 4) {
                flag_set = closed[0] & 4;
            }
            if (last_o == 7) {
                flag_set = closed[0] & 8;
            }
            if (flag_set > 0) {
                Contour2D.fillToOppCorner(xx, yy, xd, yd, v_idx, last_o, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
            } else {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, v_idx, last_o, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
            }
        } else if (last_o == 3) {
            int flag3 = -1;
            if (closed[0] == 3) {
                flag3 = 1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, last_o, flag3, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
        } else if (last_o == 5) {
            int flag4 = 1;
            if (closed[0] == 5) {
                flag4 = -1;
            }
            Contour2D.fillToSide(xx, yy, xd, yd, v_idx, last_o, flag4, cnt_tri, dir, vx, vy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
        }
    }

    private static void getBoxSide(float[] vx, float[] vy, float xx, float xd, float yy, float yd, int v_idx, int dir, byte o_flag, byte[] side) {
        int kk = 0;
        while (kk < 2) {
            int ii = v_idx + kk * dir;
            switch (o_flag) {
                case 1: {
                    side[kk] = 3;
                    if (vy[ii] != yy) break;
                    side[kk] = 0;
                    break;
                }
                case 2: {
                    side[kk] = 1;
                    if (vy[ii] != yy) break;
                    side[kk] = 0;
                    break;
                }
                case 4: {
                    side[kk] = 3;
                    if (vy[ii] != yy + yd) break;
                    side[kk] = 2;
                    break;
                }
                case 7: {
                    side[kk] = 1;
                    if (vy[ii] != yy + yd) break;
                    side[kk] = 2;
                    break;
                }
                case 3: {
                    side[kk] = 1;
                    if (vx[ii] != xx) break;
                    side[kk] = 3;
                    break;
                }
                case 5: {
                    side[kk] = 0;
                    if (vy[ii] != yy + yd) break;
                    side[kk] = 2;
                }
            }
            ++kk;
        }
    }

    private static void interpNormals(float vx, float vy, float xx, float yy, int nc, int nr, float xd, float yd, float[][][] grd_normals, int[] n_idx, float[] tri_normals) {
        int side = -1;
        float[] nn = new float[3];
        if (vy == yy) {
            side = 0;
        }
        if (vy == yy + yd) {
            side = 2;
        }
        if (vx == xx) {
            side = 3;
        }
        if (vx == xx + xd) {
            side = 1;
        }
        float dx = vx - xx;
        float dy = vy - yy;
        switch (side) {
            case 0: {
                nn[0] = (grd_normals[nc][nr + 1][0] - grd_normals[nc][nr][0]) / xd * dx + grd_normals[nc][nr][0];
                nn[1] = (grd_normals[nc][nr + 1][1] - grd_normals[nc][nr][1]) / xd * dx + grd_normals[nc][nr][1];
                nn[2] = (grd_normals[nc][nr + 1][2] - grd_normals[nc][nr][2]) / xd * dx + grd_normals[nc][nr][2];
                break;
            }
            case 3: {
                nn[0] = (grd_normals[nc + 1][nr][0] - grd_normals[nc][nr][0]) / yd * dy + grd_normals[nc][nr][0];
                nn[1] = (grd_normals[nc + 1][nr][1] - grd_normals[nc][nr][1]) / yd * dy + grd_normals[nc][nr][1];
                nn[2] = (grd_normals[nc + 1][nr][2] - grd_normals[nc][nr][2]) / yd * dy + grd_normals[nc][nr][2];
                break;
            }
            case 1: {
                nn[0] = (grd_normals[nc + 1][nr + 1][0] - grd_normals[nc][nr + 1][0]) / yd * dy + grd_normals[nc][nr + 1][0];
                nn[1] = (grd_normals[nc + 1][nr + 1][1] - grd_normals[nc][nr + 1][1]) / yd * dy + grd_normals[nc][nr + 1][1];
                nn[2] = (grd_normals[nc + 1][nr + 1][2] - grd_normals[nc][nr + 1][2]) / yd * dy + grd_normals[nc][nr + 1][2];
                break;
            }
            case 2: {
                nn[0] = (grd_normals[nc + 1][nr + 1][0] - grd_normals[nc + 1][nr][0]) / xd * dx + grd_normals[nc + 1][nr][0];
                nn[1] = (grd_normals[nc + 1][nr + 1][1] - grd_normals[nc + 1][nr][1]) / xd * dx + grd_normals[nc + 1][nr][1];
                nn[2] = (grd_normals[nc + 1][nr + 1][2] - grd_normals[nc + 1][nr][2]) / xd * dx + grd_normals[nc + 1][nr][2];
                break;
            }
            default: {
                System.out.println("interpNormals, bad side: " + side);
            }
        }
        float mag = (float)Math.sqrt(nn[0] * nn[0] + nn[1] * nn[1] + nn[2] * nn[2]);
        nn[0] = nn[0] / mag;
        nn[1] = nn[1] / mag;
        nn[2] = nn[2] / mag;
        int n = n_idx[0];
        n_idx[0] = n + 1;
        tri_normals[n] = nn[0];
        int n2 = n_idx[0];
        n_idx[0] = n2 + 1;
        tri_normals[n2] = nn[1];
        int n3 = n_idx[0];
        n_idx[0] = n3 + 1;
        tri_normals[n3] = nn[2];
    }

    private static void fillToLast(float xx, float yy, float xd, float yd, int nc, int nr, float[] vv1, float[] vv2, float[] vv1_last, float[] vv2_last, float[][] tri, int[] cnt_tri, int[] t_idx, byte[][] tri_color, byte[][] color_bin, int cc, int color_length, float[][][] grd_normals, int[] n_idx, float[] tri_normals) {
        int tt = t_idx[0];
        int ii = 0;
        while (ii < color_length) {
            tri_color[ii][tt] = color_bin[ii][cc];
            ++ii;
        }
        tri[0][tt] = vv1[0];
        tri[1][tt] = vv1[1];
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii2 = 0;
        while (ii2 < color_length) {
            tri_color[ii2][tt] = color_bin[ii2][cc];
            ++ii2;
        }
        tri[0][tt] = vv2[0];
        tri[1][tt] = vv2[1];
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii3 = 0;
        while (ii3 < color_length) {
            tri_color[ii3][tt] = color_bin[ii3][cc];
            ++ii3;
        }
        tri[0][tt] = vv1_last[0];
        tri[1][tt] = vv1_last[1];
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        cnt_tri[0] = cnt_tri[0] + 1;
        int ii4 = 0;
        while (ii4 < color_length) {
            tri_color[ii4][tt] = color_bin[ii4][cc];
            ++ii4;
        }
        tri[0][tt] = vv1_last[0];
        tri[1][tt] = vv1_last[1];
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii5 = 0;
        while (ii5 < color_length) {
            tri_color[ii5][tt] = color_bin[ii5][cc];
            ++ii5;
        }
        tri[0][tt] = vv2_last[0];
        tri[1][tt] = vv2_last[1];
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii6 = 0;
        while (ii6 < color_length) {
            tri_color[ii6][tt] = color_bin[ii6][cc];
            ++ii6;
        }
        tri[0][tt] = vv2[0];
        tri[1][tt] = vv2[1];
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        t_idx[0] = ++tt;
        cnt_tri[0] = cnt_tri[0] + 1;
    }

    private static void fillCaseSix(float xx, float yy, float xd, float yd, int v_idx, int dir, byte[] o_flags, short ctrLow, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, boolean[] crnr_out, float[][] tri, int[] t_idx, byte[][] color_bin, byte[][] tri_color, int color_length, float[][][] grd_normals, int[] n_idx, float[] tri_normals, int[] closed, int[] cnt_tri) {
        int n1 = 0;
        int n2 = 0;
        int n4 = 0;
        int n7 = 0;
        int kk = 0;
        while (kk < o_flags.length) {
            if (o_flags[kk] - 32 == 1 || o_flags[kk] == 1) {
                ++n1;
            }
            if (o_flags[kk] - 32 == 2 || o_flags[kk] == 2) {
                ++n2;
            }
            if (o_flags[kk] - 32 == 4 || o_flags[kk] == 4) {
                ++n4;
            }
            if (o_flags[kk] - 32 == 7 || o_flags[kk] == 7) {
                ++n7;
            }
            ++kk;
        }
        float[][] vv1 = new float[2][n1 * 2];
        float[][] vv2 = new float[2][n2 * 2];
        float[][] vv4 = new float[2][n4 * 2];
        float[][] vv7 = new float[2][n7 * 2];
        int[] clr_idx1 = new int[n1];
        int[] clr_idx2 = new int[n2];
        int[] clr_idx4 = new int[n4];
        int[] clr_idx7 = new int[n7];
        float[] vvv1 = new float[2];
        float[] vvv2 = new float[2];
        float[] vvv1_last = new float[2];
        float[] vvv2_last = new float[2];
        n1 = 0;
        n2 = 0;
        n4 = 0;
        n7 = 0;
        int ii = v_idx;
        int cc = ctrLow - 1;
        int cnt = 0;
        int[] cases = new int[]{1, 2, 7, 4};
        int kk2 = 0;
        while (kk2 < o_flags.length) {
            if (o_flags[kk2] > 32) {
                ++cnt;
            }
            if (o_flags[kk2] - 32 == 1 || o_flags[kk2] == 1) {
                clr_idx1[n1] = cc;
                vv1[0][2 * n1] = vx[ii];
                vv1[1][2 * n1] = vy[ii];
                vv1[0][2 * n1 + 1] = vx[ii + 1];
                vv1[1][2 * n1 + 1] = vy[ii + 1];
                ++n1;
            } else if (o_flags[kk2] - 32 == 2 || o_flags[kk2] == 2) {
                clr_idx2[n2] = cc;
                vv2[0][2 * n2] = vx[ii];
                vv2[1][2 * n2] = vy[ii];
                vv2[0][2 * n2 + 1] = vx[ii + 1];
                vv2[1][2 * n2 + 1] = vy[ii + 1];
                ++n2;
            } else if (o_flags[kk2] - 32 == 4 || o_flags[kk2] == 4) {
                clr_idx4[n4] = cc;
                vv4[0][2 * n4] = vx[ii];
                vv4[1][2 * n4] = vy[ii];
                vv4[0][2 * n4 + 1] = vx[ii + 1];
                vv4[1][2 * n4 + 1] = vy[ii + 1];
                ++n4;
            } else if (o_flags[kk2] - 32 == 7 || o_flags[kk2] == 7) {
                clr_idx7[n7] = cc;
                vv7[0][2 * n7] = vx[ii];
                vv7[1][2 * n7] = vy[ii];
                vv7[0][2 * n7 + 1] = vx[ii + 1];
                vv7[1][2 * n7 + 1] = vy[ii + 1];
                ++n7;
            }
            if (o_flags[kk2] < 32) {
                ++cc;
            } else if (cnt == 2) {
                cnt = 0;
                ++cc;
            }
            ii += 2;
            ++kk2;
        }
        int[] clr_idx = null;
        float[] vvx = null;
        float[] vvy = null;
        float[] x_avg = new float[2];
        float[] y_avg = new float[2];
        float dist_0 = 0.0f;
        float dist_1 = 0.0f;
        float xxx = 0.0f;
        float yyy = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        int nn = 0;
        int pt = 0;
        int n_pt = 0;
        int s_idx = 0;
        int ns_idx = 0;
        byte[] tmp = null;
        byte[] cntr_color = null;
        int cntr_clr = Integer.MIN_VALUE;
        float[][] edge_points = new float[2][8];
        boolean[] edge_point_a_corner = new boolean[]{false, false, false, false, false, false, false, false};
        boolean[] edge_point_out = new boolean[]{false, false, false, false, false, false, false, false};
        boolean this_crnr_out = false;
        int n_crnr_out = 0;
        int kk3 = 0;
        while (kk3 < cases.length) {
            switch (cases[kk3]) {
                case 1: {
                    nn = n1;
                    clr_idx = clr_idx1;
                    vvx = vv1[0];
                    vvy = vv1[1];
                    xxx = xx;
                    yyy = yy;
                    pt = 0;
                    n_pt = 7;
                    s_idx = 0;
                    ns_idx = 1;
                    tmp = crnr_color[0];
                    this_crnr_out = crnr_out[0];
                    break;
                }
                case 2: {
                    nn = n2;
                    clr_idx = clr_idx2;
                    vvx = vv2[0];
                    vvy = vv2[1];
                    xxx = xx + xd;
                    yyy = yy;
                    pt = 1;
                    n_pt = 2;
                    s_idx = 0;
                    ns_idx = 1;
                    tmp = crnr_color[1];
                    this_crnr_out = crnr_out[1];
                    break;
                }
                case 4: {
                    nn = n4;
                    clr_idx = clr_idx4;
                    vvx = vv4[0];
                    vvy = vv4[1];
                    xxx = xx;
                    yyy = yy + yd;
                    pt = 5;
                    n_pt = 6;
                    s_idx = 1;
                    ns_idx = 0;
                    tmp = crnr_color[2];
                    this_crnr_out = crnr_out[2];
                    break;
                }
                case 7: {
                    nn = n7;
                    clr_idx = clr_idx7;
                    vvx = vv7[0];
                    vvy = vv7[1];
                    xxx = xx + xd;
                    yyy = yy + yd;
                    pt = 3;
                    n_pt = 4;
                    s_idx = 0;
                    ns_idx = 1;
                    tmp = crnr_color[3];
                    this_crnr_out = crnr_out[3];
                }
            }
            if (nn == 0) {
                edge_points[0][pt] = xxx;
                edge_points[1][pt] = yyy;
                edge_points[0][n_pt] = xxx;
                edge_points[1][n_pt] = yyy;
                cntr_color = tmp;
                edge_point_a_corner[pt] = true;
                edge_point_a_corner[n_pt] = true;
                edge_point_out[pt] = this_crnr_out;
                edge_point_out[n_pt] = this_crnr_out;
                if (this_crnr_out) {
                    ++n_crnr_out;
                }
            } else if (nn == 1) {
                Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)cases[kk3], cnt_tri, dir, vvx, vvy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                edge_points[0][pt] = vvx[s_idx];
                edge_points[1][pt] = vvy[s_idx];
                edge_points[0][n_pt] = vvx[ns_idx];
                edge_points[1][n_pt] = vvy[ns_idx];
                if (clr_idx[0] > cntr_clr) {
                    cntr_clr = clr_idx[0];
                }
            } else {
                int il = 0;
                int idx = 0;
                x_avg[0] = (vvx[idx] + vvx[idx + 1]) / 2.0f;
                y_avg[0] = (vvy[idx] + vvy[idx + 1]) / 2.0f;
                x_avg[1] = (vvx[idx += 2] + vvx[idx + 1]) / 2.0f;
                y_avg[1] = (vvy[idx] + vvy[idx + 1]) / 2.0f;
                dy = y_avg[1] - yyy;
                dx = x_avg[1] - xxx;
                dist_1 = dy * dy + dx * dx;
                dy = y_avg[0] - yyy;
                dx = x_avg[0] - xxx;
                dist_0 = dy * dy + dx * dx;
                boolean cornerFirst = false;
                if (dist_1 > dist_0) {
                    cornerFirst = true;
                }
                if (cornerFirst) {
                    Contour2D.fillToNearCorner(xx, yy, xd, yd, 0, (byte)cases[kk3], cnt_tri, dir, vvx, vvy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                } else {
                    edge_points[0][pt] = vvx[s_idx];
                    edge_points[1][pt] = vvy[s_idx];
                    edge_points[0][n_pt] = vvx[ns_idx];
                    edge_points[1][n_pt] = vvy[ns_idx];
                    if (clr_idx[0] > cntr_clr) {
                        cntr_clr = clr_idx[0];
                    }
                }
                il = 1;
                while (il < nn) {
                    idx = dir * il * 2;
                    int idx_last = idx - 2 * dir;
                    vvv1[0] = vvx[idx];
                    vvv1[1] = vvy[idx];
                    vvv2[0] = vvx[idx + dir];
                    vvv2[1] = vvy[idx + dir];
                    vvv1_last[0] = vvx[idx_last];
                    vvv1_last[1] = vvy[idx_last];
                    vvv2_last[0] = vvx[idx_last + dir];
                    vvv2_last[1] = vvy[idx_last + dir];
                    Contour2D.fillToLast(xx, yy, xd, yd, nc, nr, vvv1, vvv2, vvv1_last, vvv2_last, tri, cnt_tri, t_idx, tri_color, color_bin, clr_idx[il], color_length, grd_normals, n_idx, tri_normals);
                    if (!cornerFirst && il == nn - 1) {
                        Contour2D.fillToNearCorner(xx, yy, xd, yd, idx, (byte)cases[kk3], cnt_tri, dir, vvx, vvy, nc, nr, crnr_color, crnr_out, tri, t_idx, tri_color, grd_normals, n_idx, tri_normals, closed);
                    }
                    if (cornerFirst && il == nn - 1) {
                        edge_points[0][pt] = vvx[idx + s_idx];
                        edge_points[1][pt] = vvy[idx + s_idx];
                        edge_points[0][n_pt] = vvx[idx + ns_idx];
                        edge_points[1][n_pt] = vvy[idx + ns_idx];
                        if (clr_idx[il] > cntr_clr) {
                            cntr_clr = clr_idx[il];
                        }
                    }
                    ++il;
                }
            }
            ++kk3;
        }
        if (n_crnr_out == 2) {
            return;
        }
        if (cntr_color == null) {
            cntr_color = new byte[color_length];
            int c = 0;
            while (c < color_length) {
                cntr_color[c] = color_bin[c][cntr_clr];
                ++c;
            }
        }
        int tt = t_idx[0];
        int kk4 = 0;
        while (kk4 < edge_points[0].length) {
            pt = kk4;
            n_pt = kk4 + 1;
            if (kk4 == edge_points[0].length - 1) {
                pt = 0;
                n_pt = 7;
            }
            if (!edge_point_a_corner[pt] && !edge_point_a_corner[n_pt] || !edge_point_out[pt] && !edge_point_out[n_pt]) {
                int c = 0;
                while (c < color_length) {
                    tri_color[c][tt] = cntr_color[c];
                    ++c;
                }
                tri[0][tt] = edge_points[0][pt];
                tri[1][tt] = edge_points[1][pt];
                Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
                ++tt;
                int c2 = 0;
                while (c2 < color_length) {
                    tri_color[c2][tt] = cntr_color[c2];
                    ++c2;
                }
                tri[0][tt] = edge_points[0][n_pt];
                tri[1][tt] = edge_points[1][n_pt];
                Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
                ++tt;
                int c3 = 0;
                while (c3 < color_length) {
                    tri_color[c3][tt] = cntr_color[c3];
                    ++c3;
                }
                tri[0][tt] = xx + xd * 0.5f;
                tri[1][tt] = yy + yd * 0.5f;
                float[] nrm = new float[]{0.0f, 0.0f, 0.0f};
                int ic = 0;
                while (ic < 2) {
                    int ir = 0;
                    while (ir < 2) {
                        nrm[0] = (float)((double)nrm[0] + 0.25 * (double)grd_normals[nc + ic][nr + ir][0]);
                        nrm[1] = (float)((double)nrm[1] + 0.25 * (double)grd_normals[nc + ic][nr + ir][1]);
                        nrm[2] = (float)((double)nrm[2] + 0.25 * (double)grd_normals[nc + ic][nr + ir][2]);
                        ++ir;
                    }
                    ++ic;
                }
                float mag = (float)Math.sqrt(nrm[0] * nrm[0] + nrm[1] * nrm[1] + nrm[2] * nrm[2]);
                nrm[0] = nrm[0] / mag;
                nrm[1] = nrm[1] / mag;
                nrm[2] = nrm[2] / mag;
                int n = n_idx[0];
                n_idx[0] = n + 1;
                tri_normals[n] = nrm[0];
                int n3 = n_idx[0];
                n_idx[0] = n3 + 1;
                tri_normals[n3] = nrm[1];
                int n5 = n_idx[0];
                n_idx[0] = n5 + 1;
                tri_normals[n5] = nrm[2];
                ++tt;
                cnt_tri[0] = cnt_tri[0] + 1;
            }
            ++kk4;
        }
        t_idx[0] = tt;
    }

    private static void fillToNearCorner(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int[] cnt, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, boolean[] crnr_out, float[][] tri, int[] t_idx, byte[][] tri_color, float[][][] grd_normals, int[] n_idx, float[] tri_normals, int[] closed) {
        float cx = 0.0f;
        float cy = 0.0f;
        int cc = 0;
        int color_length = crnr_color[0].length;
        int cnt_tri = cnt[0];
        int tt = t_idx[0];
        switch (o_flag) {
            case 1: {
                cc = 0;
                closed[0] = closed[0] | 1;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx;
                cy = yy;
                int n = n_idx[0];
                n_idx[0] = n + 1;
                tri_normals[n] = grd_normals[nc][nr][0];
                int n2 = n_idx[0];
                n_idx[0] = n2 + 1;
                tri_normals[n2] = grd_normals[nc][nr][1];
                int n3 = n_idx[0];
                n_idx[0] = n3 + 1;
                tri_normals[n3] = grd_normals[nc][nr][2];
                break;
            }
            case 4: {
                cc = 2;
                closed[0] = closed[0] | 4;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx;
                cy = yy + yd;
                int n = n_idx[0];
                n_idx[0] = n + 1;
                tri_normals[n] = grd_normals[nc + 1][nr][0];
                int n4 = n_idx[0];
                n_idx[0] = n4 + 1;
                tri_normals[n4] = grd_normals[nc + 1][nr][1];
                int n5 = n_idx[0];
                n_idx[0] = n5 + 1;
                tri_normals[n5] = grd_normals[nc + 1][nr][2];
                break;
            }
            case 2: {
                cc = 1;
                closed[0] = closed[0] | 2;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx + xd;
                cy = yy;
                int n = n_idx[0];
                n_idx[0] = n + 1;
                tri_normals[n] = grd_normals[nc][nr + 1][0];
                int n6 = n_idx[0];
                n_idx[0] = n6 + 1;
                tri_normals[n6] = grd_normals[nc][nr + 1][1];
                int n7 = n_idx[0];
                n_idx[0] = n7 + 1;
                tri_normals[n7] = grd_normals[nc][nr + 1][2];
                break;
            }
            case 7: {
                cc = 3;
                closed[0] = closed[0] | 8;
                if (crnr_out[cc]) {
                    return;
                }
                cx = xx + xd;
                cy = yy + yd;
                int n = n_idx[0];
                n_idx[0] = n + 1;
                tri_normals[n] = grd_normals[nc + 1][nr + 1][0];
                int n8 = n_idx[0];
                n_idx[0] = n8 + 1;
                tri_normals[n8] = grd_normals[nc + 1][nr + 1][1];
                int n9 = n_idx[0];
                n_idx[0] = n9 + 1;
                tri_normals[n9] = grd_normals[nc + 1][nr + 1][2];
            }
        }
        int ii = 0;
        while (ii < color_length) {
            tri_color[ii][tt] = crnr_color[cc][ii];
            ++ii;
        }
        tri[0][tt] = cx;
        tri[1][tt] = cy;
        ++tt;
        int ii2 = 0;
        while (ii2 < color_length) {
            tri_color[ii2][tt] = crnr_color[cc][ii2];
            ++ii2;
        }
        tri[0][tt] = vx[v_idx];
        tri[1][tt] = vy[v_idx];
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii3 = 0;
        while (ii3 < color_length) {
            tri_color[ii3][tt] = crnr_color[cc][ii3];
            ++ii3;
        }
        tri[0][tt] = vx[v_idx + dir];
        tri[1][tt] = vy[v_idx + dir];
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        cnt[0] = ++cnt_tri;
        t_idx[0] = ++tt;
    }

    private static void fillToOppCorner(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int[] cnt, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, boolean[] crnr_out, float[][] tri, int[] t_idx, byte[][] tri_color, float[][][] grd_normals, int[] n_idx, float[] tri_normals, int[] closed) {
        float cx1 = 0.0f;
        float cx2 = 0.0f;
        float cx3 = 0.0f;
        float cy1 = 0.0f;
        float cy2 = 0.0f;
        float cy3 = 0.0f;
        int cc = 0;
        int[][] grd = new int[3][2];
        int color_length = crnr_color[0].length;
        switch (o_flag) {
            case 1: {
                closed[0] = closed[0] | 0xE;
                if (crnr_out[1] || crnr_out[2] || crnr_out[3]) {
                    return;
                }
                cx1 = xx + xd;
                cy1 = yy;
                cx2 = xx + xd;
                cy2 = yy + yd;
                cx3 = xx;
                cy3 = yy + yd;
                cc = 3;
                grd[0][0] = 1;
                grd[0][1] = 0;
                grd[1][0] = 1;
                grd[1][1] = 1;
                grd[2][0] = 0;
                grd[2][1] = 1;
                break;
            }
            case 2: {
                closed[0] = closed[0] | 0xD;
                if (crnr_out[0] || crnr_out[2] || crnr_out[3]) {
                    return;
                }
                cx1 = xx;
                cy1 = yy;
                cx2 = xx;
                cy2 = yy + yd;
                cx3 = xx + xd;
                cy3 = yy + yd;
                cc = 2;
                grd[0][0] = 0;
                grd[0][1] = 0;
                grd[1][0] = 0;
                grd[1][1] = 1;
                grd[2][0] = 1;
                grd[2][1] = 1;
                break;
            }
            case 4: {
                closed[0] = closed[0] | 0xB;
                if (crnr_out[0] || crnr_out[1] || crnr_out[3]) {
                    return;
                }
                cx1 = xx;
                cy1 = yy;
                cx2 = xx + xd;
                cy2 = yy;
                cx3 = xx + xd;
                cy3 = yy + yd;
                cc = 1;
                grd[0][0] = 0;
                grd[0][1] = 0;
                grd[1][0] = 1;
                grd[1][1] = 0;
                grd[2][0] = 1;
                grd[2][1] = 1;
                break;
            }
            case 7: {
                closed[0] = closed[0] | 7;
                if (crnr_out[0] || crnr_out[1] || crnr_out[2]) {
                    return;
                }
                cx1 = xx + xd;
                cy1 = yy;
                cx2 = xx;
                cy2 = yy;
                cx3 = xx;
                cy3 = yy + yd;
                cc = 0;
                grd[0][0] = 1;
                grd[0][1] = 0;
                grd[1][0] = 0;
                grd[1][1] = 0;
                grd[2][0] = 0;
                grd[2][1] = 1;
            }
        }
        int cnt_tri = cnt[0];
        int tt = t_idx[0];
        int ii = 0;
        while (ii < color_length) {
            tri_color[ii][tt] = crnr_color[cc][ii];
            ++ii;
        }
        tri[0][tt] = cx1;
        tri[1][tt] = cy1;
        int n = n_idx[0];
        n_idx[0] = n + 1;
        tri_normals[n] = grd_normals[nc + grd[0][1]][nr + grd[0][0]][0];
        int n2 = n_idx[0];
        n_idx[0] = n2 + 1;
        tri_normals[n2] = grd_normals[nc + grd[0][1]][nr + grd[0][0]][1];
        int n3 = n_idx[0];
        n_idx[0] = n3 + 1;
        tri_normals[n3] = grd_normals[nc + grd[0][1]][nr + grd[0][0]][2];
        ++tt;
        int ii2 = 0;
        while (ii2 < color_length) {
            tri_color[ii2][tt] = crnr_color[cc][ii2];
            ++ii2;
        }
        tri[0][tt] = cx2;
        tri[1][tt] = cy2;
        int n4 = n_idx[0];
        n_idx[0] = n4 + 1;
        tri_normals[n4] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][0];
        int n5 = n_idx[0];
        n_idx[0] = n5 + 1;
        tri_normals[n5] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][1];
        int n6 = n_idx[0];
        n_idx[0] = n6 + 1;
        tri_normals[n6] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][2];
        ++tt;
        int ii3 = 0;
        while (ii3 < color_length) {
            tri_color[ii3][tt] = crnr_color[cc][ii3];
            ++ii3;
        }
        if (dir > 0) {
            tri[0][tt] = vx[v_idx];
            tri[1][tt] = vy[v_idx];
        } else {
            tri[0][tt] = vx[v_idx + dir];
            tri[1][tt] = vy[v_idx + dir];
        }
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        ++cnt_tri;
        int ii4 = 0;
        while (ii4 < color_length) {
            tri_color[ii4][tt] = crnr_color[cc][ii4];
            ++ii4;
        }
        tri[0][tt] = cx3;
        tri[1][tt] = cy3;
        int n7 = n_idx[0];
        n_idx[0] = n7 + 1;
        tri_normals[n7] = grd_normals[nc + grd[2][1]][nr + grd[2][0]][0];
        int n8 = n_idx[0];
        n_idx[0] = n8 + 1;
        tri_normals[n8] = grd_normals[nc + grd[2][1]][nr + grd[2][0]][1];
        int n9 = n_idx[0];
        n_idx[0] = n9 + 1;
        tri_normals[n9] = grd_normals[nc + grd[2][1]][nr + grd[2][0]][2];
        ++tt;
        int ii5 = 0;
        while (ii5 < color_length) {
            tri_color[ii5][tt] = crnr_color[cc][ii5];
            ++ii5;
        }
        tri[0][tt] = cx2;
        tri[1][tt] = cy2;
        int n10 = n_idx[0];
        n_idx[0] = n10 + 1;
        tri_normals[n10] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][0];
        int n11 = n_idx[0];
        n_idx[0] = n11 + 1;
        tri_normals[n11] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][1];
        int n12 = n_idx[0];
        n_idx[0] = n12 + 1;
        tri_normals[n12] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][2];
        ++tt;
        int ii6 = 0;
        while (ii6 < color_length) {
            tri_color[ii6][tt] = crnr_color[cc][ii6];
            ++ii6;
        }
        if (dir > 0) {
            tri[0][tt] = vx[v_idx + dir];
            tri[1][tt] = vy[v_idx + dir];
        } else {
            tri[0][tt] = vx[v_idx];
            tri[1][tt] = vy[v_idx];
        }
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        ++cnt_tri;
        int ii7 = 0;
        while (ii7 < color_length) {
            tri_color[ii7][tt] = crnr_color[cc][ii7];
            ++ii7;
        }
        tri[0][tt] = cx2;
        tri[1][tt] = cy2;
        int n13 = n_idx[0];
        n_idx[0] = n13 + 1;
        tri_normals[n13] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][0];
        int n14 = n_idx[0];
        n_idx[0] = n14 + 1;
        tri_normals[n14] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][1];
        int n15 = n_idx[0];
        n_idx[0] = n15 + 1;
        tri_normals[n15] = grd_normals[nc + grd[1][1]][nr + grd[1][0]][2];
        ++tt;
        int ii8 = 0;
        while (ii8 < color_length) {
            tri_color[ii8][tt] = crnr_color[cc][ii8];
            ++ii8;
        }
        tri[0][tt] = vx[v_idx];
        tri[1][tt] = vy[v_idx];
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii9 = 0;
        while (ii9 < color_length) {
            tri_color[ii9][tt] = crnr_color[cc][ii9];
            ++ii9;
        }
        tri[0][tt] = vx[v_idx + dir];
        tri[1][tt] = vy[v_idx + dir];
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        cnt[0] = ++cnt_tri;
        t_idx[0] = ++tt;
    }

    private static void fillToSide(float xx, float yy, float xd, float yd, int v_idx, byte o_flag, int flag, int[] cnt, int dir, float[] vx, float[] vy, int nc, int nr, byte[][] crnr_color, boolean[] crnr_out, float[][] tri, int[] t_idx, byte[][] tri_color, float[][][] grd_normals, int[] n_idx, float[] tri_normals, int[] closed) {
        int cnt_tri = cnt[0];
        int tt = t_idx[0];
        float cx1 = 0.0f;
        float cy1 = 0.0f;
        float cx2 = 0.0f;
        float cy2 = 0.0f;
        int cc = 0;
        int[][] grd = new int[2][2];
        int color_length = crnr_color[0].length;
        block0 : switch (o_flag) {
            case 3: {
                switch (flag) {
                    case 1: {
                        closed[0] = closed[0] | 0xC;
                        if (crnr_out[2] || crnr_out[3]) {
                            return;
                        }
                        cx1 = xx;
                        cy1 = yy + yd;
                        cx2 = xx + xd;
                        cy2 = yy + yd;
                        cc = 3;
                        grd[0][0] = 0;
                        grd[0][1] = 1;
                        grd[1][0] = 1;
                        grd[1][1] = 1;
                        break;
                    }
                    case -1: {
                        closed[0] = closed[0] | 3;
                        if (crnr_out[0] || crnr_out[1]) {
                            return;
                        }
                        cx1 = xx;
                        cy1 = yy;
                        cx2 = xx + xd;
                        cy2 = yy;
                        cc = 0;
                        grd[0][0] = 0;
                        grd[0][1] = 0;
                        grd[1][0] = 1;
                        grd[1][1] = 0;
                    }
                }
                break;
            }
            case 5: {
                switch (flag) {
                    case 1: {
                        closed[0] = closed[0] | 5;
                        if (crnr_out[0] || crnr_out[2]) {
                            return;
                        }
                        cx1 = xx;
                        cy1 = yy;
                        cx2 = xx;
                        cy2 = yy + yd;
                        cc = 0;
                        grd[0][0] = 0;
                        grd[0][1] = 0;
                        grd[1][0] = 0;
                        grd[1][1] = 1;
                        break block0;
                    }
                    case -1: {
                        closed[0] = closed[0] | 0xA;
                        if (crnr_out[1] || crnr_out[3]) {
                            return;
                        }
                        cx1 = xx + xd;
                        cy1 = yy;
                        cx2 = xx + xd;
                        cy2 = yy + yd;
                        grd[0][0] = 1;
                        grd[0][1] = 0;
                        grd[1][0] = 1;
                        grd[1][1] = 1;
                        cc = 3;
                    }
                }
            }
        }
        int ii = 0;
        while (ii < color_length) {
            tri_color[ii][tt] = crnr_color[cc][ii];
            ++ii;
        }
        tri[0][tt] = cx1;
        tri[1][tt] = cy1;
        int i = grd[0][0];
        int j = grd[0][1];
        int n = n_idx[0];
        n_idx[0] = n + 1;
        tri_normals[n] = grd_normals[nc + j][nr + i][0];
        int n2 = n_idx[0];
        n_idx[0] = n2 + 1;
        tri_normals[n2] = grd_normals[nc + j][nr + i][1];
        int n3 = n_idx[0];
        n_idx[0] = n3 + 1;
        tri_normals[n3] = grd_normals[nc + j][nr + i][2];
        ++tt;
        int ii2 = 0;
        while (ii2 < color_length) {
            tri_color[ii2][tt] = crnr_color[cc][ii2];
            ++ii2;
        }
        tri[0][tt] = vx[v_idx];
        tri[1][tt] = vy[v_idx];
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii3 = 0;
        while (ii3 < color_length) {
            tri_color[ii3][tt] = crnr_color[cc][ii3];
            ++ii3;
        }
        tri[0][tt] = vx[v_idx + dir];
        tri[1][tt] = vy[v_idx + dir];
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        ++cnt_tri;
        int ii4 = 0;
        while (ii4 < color_length) {
            tri_color[ii4][tt] = crnr_color[cc][ii4];
            ++ii4;
        }
        tri[0][tt] = cx1;
        tri[1][tt] = cy1;
        i = grd[0][0];
        j = grd[0][1];
        int n4 = n_idx[0];
        n_idx[0] = n4 + 1;
        tri_normals[n4] = grd_normals[nc + j][nr + i][0];
        int n5 = n_idx[0];
        n_idx[0] = n5 + 1;
        tri_normals[n5] = grd_normals[nc + j][nr + i][1];
        int n6 = n_idx[0];
        n_idx[0] = n6 + 1;
        tri_normals[n6] = grd_normals[nc + j][nr + i][2];
        ++tt;
        int ii5 = 0;
        while (ii5 < color_length) {
            tri_color[ii5][tt] = crnr_color[cc][ii5];
            ++ii5;
        }
        if (dir > 0) {
            tri[0][tt] = vx[v_idx + dir];
            tri[1][tt] = vy[v_idx + dir];
        } else {
            tri[0][tt] = vx[v_idx];
            tri[1][tt] = vy[v_idx];
        }
        t_idx[0] = tt;
        Contour2D.interpNormals(tri[0][tt], tri[1][tt], xx, yy, nc, nr, xd, yd, grd_normals, n_idx, tri_normals);
        ++tt;
        int ii6 = 0;
        while (ii6 < color_length) {
            tri_color[ii6][tt] = crnr_color[cc][ii6];
            ++ii6;
        }
        tri[0][tt] = cx2;
        tri[1][tt] = cy2;
        i = grd[1][0];
        j = grd[1][1];
        int n7 = n_idx[0];
        n_idx[0] = n7 + 1;
        tri_normals[n7] = grd_normals[nc + j][nr + i][0];
        int n8 = n_idx[0];
        n_idx[0] = n8 + 1;
        tri_normals[n8] = grd_normals[nc + j][nr + i][1];
        int n9 = n_idx[0];
        n_idx[0] = n9 + 1;
        tri_normals[n9] = grd_normals[nc + j][nr + i][2];
        cnt[0] = ++cnt_tri;
        t_idx[0] = ++tt;
    }
}

