/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.Vector;
import visad.DerivedUnit;
import visad.Unit;
import visad.UnitException;

public final class BaseUnit
extends Unit
implements Serializable {
    private final String unitName;
    private final String quantityName;
    final DerivedUnit derivedUnit;
    final boolean isDimless;
    private static final Vector baseUnits = new Vector(9);

    private BaseUnit(String unitName, String abbreviation, String quantityName, boolean isDimless) throws UnitException {
        super(abbreviation);
        if (unitName == null || abbreviation == null || quantityName == null) {
            throw new UnitException("Base unit name, abbreviation, or quantity name is null");
        }
        this.unitName = unitName;
        this.quantityName = quantityName;
        baseUnits.addElement(this);
        this.derivedUnit = new DerivedUnit(this);
        this.isDimless = isDimless;
    }

    public boolean isDimensionless() {
        return this.isDimless;
    }

    public Unit pow(int power) {
        return this.derivedUnit.pow(power);
    }

    public Unit root(int root) throws IllegalArgumentException {
        return this.derivedUnit.root(root);
    }

    public Unit pow(double power) throws IllegalArgumentException {
        return this.derivedUnit.pow(power);
    }

    public String unitName() {
        return this.unitName;
    }

    public String unitSymbol() {
        return this.getIdentifier();
    }

    public String quantityName() {
        return this.quantityName;
    }

    public static BaseUnit addBaseUnit(String quantityName, String unitName) throws UnitException {
        return BaseUnit.addBaseUnit(quantityName, unitName, unitName);
    }

    public static synchronized BaseUnit addBaseUnit(String quantityName, String unitName, String abbreviation) throws UnitException {
        return BaseUnit.addBaseUnit(quantityName, unitName, abbreviation, false);
    }

    public static synchronized BaseUnit addBaseUnit(String quantityName, String unitName, String abbreviation, boolean isDimless) throws UnitException {
        BaseUnit baseUnit = BaseUnit.quantityNameToUnit(quantityName);
        if (baseUnit == null) {
            return new BaseUnit(unitName, abbreviation, quantityName, isDimless);
        }
        if (baseUnit.unitName.equals(unitName) && baseUnit.getIdentifier().equals(abbreviation) && baseUnit.isDimless == isDimless) {
            return baseUnit;
        }
        throw new UnitException("Attempt to redefine quantity \"" + quantityName + "\" base unit from \"" + baseUnit.unitName + "(" + baseUnit.getIdentifier() + ")" + "\" to \"" + unitName + "(" + abbreviation + ")" + "\"");
    }

    public static synchronized BaseUnit unitNameToUnit(String unitName) {
        int i = 0;
        while (i < baseUnits.size()) {
            BaseUnit baseUnit = (BaseUnit)baseUnits.elementAt(i);
            if (baseUnit.unitName.equals(unitName)) {
                return baseUnit;
            }
            ++i;
        }
        return null;
    }

    public static synchronized BaseUnit quantityNameToUnit(String quantityName) {
        int i = 0;
        while (i < baseUnits.size()) {
            BaseUnit baseUnit = (BaseUnit)baseUnits.elementAt(i);
            if (baseUnit.quantityName.equals(quantityName)) {
                return baseUnit;
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) throws UnitException {
        BaseUnit meter = BaseUnit.addBaseUnit("Length", "meter", "m");
        System.out.println("meter=\"" + meter + "\"");
        System.out.println("(Unit)meter=\"" + meter + "\"");
        System.out.println("meter^2=\"" + meter.pow(2) + "\"");
        System.out.println("((Unit)meter)^2=\"" + ((Unit)meter).pow(2) + "\"");
        System.out.println("(meter^2).sqrt()=\"" + meter.pow(2).sqrt() + "\"");
        BaseUnit second = BaseUnit.addBaseUnit("Time", "second", "s");
        System.out.println("meter*second=\"" + meter.multiply(second) + "\"");
        System.out.println("meter/(Unit)second=\"" + meter.divide(second) + "\"");
        System.out.println("meter.toThis(5,meter)=" + meter.toThis(5.0, (Unit)meter));
        System.out.println("meter.toThat(5,meter)=" + meter.toThat(5.0, (Unit)meter));
        System.out.println("meter.toThis(5,(Unit)meter)=" + meter.toThis(5.0, (Unit)meter));
        System.out.println("meter.toThat(5,(Unit)meter)=" + meter.toThat(5.0, (Unit)meter));
        double[] values = meter.toThis(new double[]{1.0, 2.0}, meter);
        System.out.println("meter.toThis({1,2},meter)=" + values[0] + "," + values[1]);
        values = meter.toThat(new double[]{1.0, 2.0}, meter);
        System.out.println("meter.toThat({1,2},meter)=" + values[0] + "," + values[1]);
        values = meter.toThis(new double[]{1.0, 2.0}, (Unit)meter);
        System.out.println("meter.toThis({1,2},(Unit)meter)=" + values[0] + "," + values[1]);
        values = meter.toThat(new double[]{1.0, 2.0}, (Unit)meter);
        System.out.println("meter.toThat({1,2},(Unit)meter)=" + values[0] + "," + values[1]);
        System.out.println("Checking exceptions:");
        try {
            meter.toThis(5.0, (Unit)second);
            System.err.println("ERROR: second -> meter");
            System.exit(1);
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
        }
        try {
            meter.toThat(5.0, (Unit)second);
            System.err.println("ERROR: meter -> second");
            System.exit(1);
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
        }
        try {
            BaseUnit foo = BaseUnit.addBaseUnit("Length", "foot", "ft");
            System.err.println("ERROR: \"foot\" added");
            System.exit(1);
        }
        catch (UnitException e) {
            System.out.println(e.getMessage());
        }
    }

    double[] toThis(double[] values, BaseUnit that) throws UnitException {
        if (this.equals(that)) {
            double[] newValues = new double[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = values[i];
                ++i;
            }
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
    }

    float[] toThis(float[] values, BaseUnit that) throws UnitException {
        if (this.equals(that)) {
            float[] newValues = new float[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = values[i];
                ++i;
            }
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + that + "\" to unit \"" + this + "\"");
    }

    public double[] toThis(double[] values, Unit that) throws UnitException {
        return that.toThat(values, (Unit)this.derivedUnit);
    }

    public float[] toThis(float[] values, Unit that) throws UnitException {
        return that.toThat(values, (Unit)this.derivedUnit);
    }

    double[] toThat(double[] values, BaseUnit that) throws UnitException {
        if (this.equals(that)) {
            double[] newValues = new double[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = values[i];
                ++i;
            }
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + this + "\" to unit \"" + that + "\"");
    }

    float[] toThat(float[] values, BaseUnit that) throws UnitException {
        if (this.equals(that)) {
            float[] newValues = new float[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = values[i];
                ++i;
            }
            return newValues;
        }
        throw new UnitException("Attempt to convert from unit \"" + this + "\" to unit \"" + that + "\"");
    }

    public double[] toThat(double[] values, Unit that) throws UnitException {
        return that.toThis(values, (Unit)this.derivedUnit);
    }

    public float[] toThat(float[] values, Unit that) throws UnitException {
        return that.toThis(values, (Unit)this.derivedUnit);
    }

    public String getDefinition() {
        return this.getIdentifier();
    }

    protected Unit protectedClone(String identifier) throws UnitException {
        throw new UnitException("Base units may not be cloned");
    }

    public boolean equals(Unit unit) {
        return unit instanceof BaseUnit && this.unitName.equals(((BaseUnit)unit).unitName) && this.quantityName.equals(((BaseUnit)unit).quantityName) && this.isDimless == ((BaseUnit)unit).isDimless;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode ^= this.unitName.hashCode() ^ this.quantityName.hashCode() ^ new Boolean(this.isDimless).hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Unit multiply(Unit that) throws UnitException {
        return this.derivedUnit.multiply(that);
    }

    public Unit divide(Unit that) throws UnitException {
        return this.derivedUnit.divide(that);
    }

    protected Unit divideInto(Unit that) throws UnitException {
        return this.derivedUnit.divideInto(that);
    }

    public boolean isConvertible(Unit unit) {
        return unit == null ? false : this.derivedUnit.isConvertible(unit);
    }
}

