/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Action;
import visad.ReferenceActionLink;
import visad.ReferenceException;
import visad.RemoteThingReference;
import visad.RemoteVisADException;
import visad.ThingChangedEvent;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADError;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.util.ThreadPool;

public abstract class ActionImpl
implements Action,
Runnable {
    private static transient ThreadPool pool = null;
    private static Object poolLock = new Object();
    private boolean enabled = true;
    private Object lockEnabled = new Object();
    private boolean peek = false;
    private Thread currentActionThread = null;
    private String Name;
    private Enumeration run_links = null;
    private transient Vector LinkVector = new Vector();
    private long link_id;
    private boolean requeue = false;

    public ActionImpl(String name) {
        if (pool == null) {
            ActionImpl.startThreadPool();
        }
        this.Name = name;
        this.link_id = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startThreadPool() {
        Object object = poolLock;
        synchronized (object) {
            if (pool == null) {
                try {
                    pool = new ThreadPool("ActionThread");
                }
                catch (Exception e) {
                    System.err.println(e.getClass().getName() + ": " + e.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    public static void stopThreadPool() {
        if (pool != null) {
            pool.stopThreads();
            pool = null;
        }
    }

    public static void setThreadPoolMaximum(int num) throws Exception {
        if (pool == null) {
            ActionImpl.startThreadPool();
        }
        pool.setThreadMaximum(num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.LinkVector == null) {
            return;
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration links = this.LinkVector.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                try {
                    link.getThingReference().removeThingChangedListener(link.getAction());
                }
                catch (RemoteException e) {
                }
                catch (VisADException e) {
                    // empty catch block
                }
            }
            this.LinkVector.removeAllElements();
        }
        if (pool != null) {
            pool.queue(this);
        }
        this.run_links = null;
    }

    synchronized long getLinkId() {
        long i = this.link_id++;
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTicks() {
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration links = this.LinkVector.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                link.setTicks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkTicks() {
        boolean doIt = false;
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration links = this.LinkVector.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                doIt |= link.checkTicks();
            }
        }
        return doIt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTicks() {
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration links = this.LinkVector.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                link.resetTicks();
            }
        }
    }

    public void enableAction() {
        if (!this.enabled) {
            this.peek = true;
        }
        this.enabled = true;
        this.notifyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableAction() {
        this.enabled = false;
        Object object = this.lockEnabled;
        synchronized (object) {
            this.enabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setEnabled(boolean enable) {
        boolean wasEnabled;
        Object object = this.lockEnabled;
        synchronized (object) {
            wasEnabled = this.enabled;
            if (enable && !wasEnabled) {
                this.enableAction();
            } else if (!enable && wasEnabled) {
                this.disableAction();
            }
        }
        return wasEnabled;
    }

    public Thread getCurrentActionThread() {
        return this.currentActionThread;
    }

    void handleRunDisconnectException(ReferenceActionLink link) {
        this.LinkVector.removeElement(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.currentActionThread = Thread.currentThread();
        Object object = this.lockEnabled;
        synchronized (object) {
            if (this.enabled) {
                try {
                    Vector vector;
                    if (this.peek) {
                        vector = this.LinkVector;
                        synchronized (vector) {
                            this.run_links = ((Vector)this.LinkVector.clone()).elements();
                        }
                        while (true) {
                            if (!this.run_links.hasMoreElements()) {
                                this.run_links = null;
                                this.peek = false;
                                break;
                            }
                            ReferenceActionLink link = (ReferenceActionLink)this.run_links.nextElement();
                            try {
                                link.peekThingChangedEvent();
                            }
                            catch (RemoteException re) {
                                if (!CollabUtil.isDisconnectException(re)) {
                                    throw re;
                                }
                                this.handleRunDisconnectException(link);
                            }
                        }
                    }
                    this.setTicks();
                    if (this.checkTicks()) {
                        this.doAction();
                    }
                    vector = this.LinkVector;
                    synchronized (vector) {
                        this.run_links = ((Vector)this.LinkVector.clone()).elements();
                    }
                    while (true) {
                        ThingChangedEvent e;
                        if (!this.run_links.hasMoreElements()) {
                            this.run_links = null;
                            this.resetTicks();
                            break;
                        }
                        ReferenceActionLink link = (ReferenceActionLink)this.run_links.nextElement();
                        try {
                            e = link.getThingChangedEvent();
                        }
                        catch (RemoteException re) {
                            if (!CollabUtil.isDisconnectException(re)) {
                                throw re;
                            }
                            this.handleRunDisconnectException(link);
                            e = null;
                        }
                        if (e == null) continue;
                        this.thingChanged(e);
                    }
                }
                catch (VisADException v) {
                    v.printStackTrace();
                    throw new VisADError("Action.run: " + v.toString());
                }
                catch (RemoteException v) {
                    v.printStackTrace();
                    throw new VisADError("Action.run: " + v.toString());
                }
            }
            if (this.requeue) {
                if (pool != null) {
                    pool.queue(this);
                }
                this.requeue = false;
            }
        }
        this.currentActionThread = null;
    }

    public abstract void doAction() throws VisADException, RemoteException;

    public boolean thingChanged(ThingChangedEvent e) throws VisADException, RemoteException {
        long id = e.getId();
        ReferenceActionLink link = this.findLink(id);
        boolean changed = true;
        if (link != null) {
            link.acknowledgeThingChangedEvent(e.getTick());
            this.notifyAction();
            changed = false;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLink(ReferenceActionLink link) throws VisADException, RemoteException {
        ThingReference ref = link.getThingReference();
        if (this.findReference(ref) != null) {
            throw new ReferenceException("Action.addLink: link to ThingReference already exists");
        }
        ref.addThingChangedListener(link.getAction(), link.getId());
        if (this.LinkVector == null) {
            this.LinkVector = new Vector();
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            this.LinkVector.addElement(link);
        }
    }

    void notifyAction() {
        this.requeue = true;
        if (pool == null) {
            ActionImpl.startThreadPool();
        }
        pool.queue(this);
    }

    public void waitForTasks() {
        if (pool != null) {
            pool.waitForTasks();
        }
    }

    public void addReference(ThingReference ref) throws ReferenceException, RemoteVisADException, VisADException, RemoteException {
        if (!(ref instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ActionImpl.addReference: requires ThingReferenceImpl");
        }
        if (this.findReference(ref) != null) {
            throw new ReferenceException("ActionImpl.addReference: link already exists");
        }
        this.addLink(new ReferenceActionLink(ref, this, this, this.getLinkId()));
        this.notifyAction();
    }

    void adaptedAddReference(RemoteThingReference ref, Action action) throws VisADException, RemoteException {
        if (this.findReference(ref) != null) {
            throw new ReferenceException("ActionImpl.adaptedAddReference: link already exists");
        }
        this.addLink(new ReferenceActionLink(ref, this, action, this.getLinkId()));
        this.notifyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(ThingReference ref) throws VisADException, RemoteException {
        ReferenceActionLink link = null;
        if (!(ref instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ActionImpl.removeReference: requires ThingReferenceImpl");
        }
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                link = this.findReference(ref);
                if (link == null) {
                    throw new ReferenceException("ActionImpl.removeReference: ThingReference not linked");
                }
                this.LinkVector.removeElement(link);
            }
        }
        if (link != null) {
            ref.removeThingChangedListener(link.getAction());
        }
        this.notifyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adaptedRemoveReference(RemoteThingReference ref) throws VisADException, RemoteException {
        ReferenceActionLink link = null;
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                link = this.findReference(ref);
                if (link == null) {
                    throw new ReferenceException("ActionImpl.adaptedRemoveReference: ThingReference not linked");
                }
                this.LinkVector.removeElement(link);
            }
        }
        if (link != null) {
            ref.removeThingChangedListener(link.getAction());
        }
        this.notifyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllReferences() throws VisADException, RemoteException {
        Vector cloneLink = null;
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                cloneLink = (Vector)this.LinkVector.clone();
                this.LinkVector.removeAllElements();
            }
        }
        if (cloneLink != null) {
            Enumeration links = cloneLink.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                ThingReference ref = link.getThingReference();
                ref.removeThingChangedListener(link.getAction());
            }
        }
        this.notifyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLinks(ReferenceActionLink[] links) throws VisADException, RemoteException {
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                int i = 0;
                while (i < links.length) {
                    if (!this.LinkVector.removeElement(links[i])) {
                        links[i] = null;
                    }
                    ++i;
                }
            }
        }
        int i = 0;
        while (i < links.length) {
            block10: {
                if (links[i] != null) {
                    ThingReference ref = links[i].getThingReference();
                    try {
                        ref.removeThingChangedListener(links[i].getAction());
                    }
                    catch (RemoteException re) {
                        if (CollabUtil.isDisconnectException(re)) break block10;
                        throw re;
                    }
                }
            }
            ++i;
        }
        this.notifyAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceActionLink findLink(long id) throws VisADException {
        if (this.LinkVector == null) {
            return null;
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration links = this.LinkVector.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                if (id != link.getId()) continue;
                return link;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferenceActionLink findReference(ThingReference ref) throws VisADException {
        if (ref == null) {
            throw new ReferenceException("ActionImpl.findReference: ThingReference cannot be null");
        }
        if (this.LinkVector == null) {
            return null;
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration links = this.LinkVector.elements();
            while (links.hasMoreElements()) {
                ReferenceActionLink link = (ReferenceActionLink)links.nextElement();
                if (!ref.equals(link.getThingReference())) continue;
                return link;
            }
        }
        return null;
    }

    public Vector getLinks() {
        return (Vector)this.LinkVector.clone();
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }
}

