/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import ucar.multiarray.AbstractAccessor;
import ucar.multiarray.IndexIterator;
import ucar.multiarray.MultiArray;

public class MultiArrayImpl
implements MultiArray,
Cloneable,
Serializable {
    public final Object storage;
    private final int[] products;
    private final int[] lengths;

    public static int numberOfElements(int[] dimensions) {
        int product = 1;
        int ii = dimensions.length - 1;
        while (ii >= 0) {
            product *= dimensions[ii];
            --ii;
        }
        return product;
    }

    public static int numberOfElements(int[] dimensions, int[] products) {
        int product = 1;
        int ii = dimensions.length - 1;
        while (ii >= 0) {
            int thisDim = dimensions[ii];
            if (thisDim < 0) {
                throw new NegativeArraySizeException();
            }
            products[ii] = product;
            product *= thisDim;
            --ii;
        }
        return product;
    }

    public MultiArrayImpl(Class componentType, int[] dimensions) {
        this.lengths = (int[])dimensions.clone();
        this.products = new int[dimensions.length];
        int product = MultiArrayImpl.numberOfElements(dimensions, this.products);
        if (product == 0) {
            product = 1;
        }
        this.storage = Array.newInstance(componentType, product);
    }

    public MultiArrayImpl(MultiArray ma) throws IOException {
        this.lengths = (int[])ma.getLengths().clone();
        this.products = new int[this.lengths.length];
        int product = MultiArrayImpl.numberOfElements(this.lengths, this.products);
        if (product == 0) {
            product = 1;
        }
        this.storage = Array.newInstance(ma.getComponentType(), product);
        IndexIterator odo = new IndexIterator(this.lengths);
        while (odo.notDone()) {
            int[] index = odo.value();
            this.set(index, ma.get(index));
            odo.incr();
        }
    }

    public MultiArrayImpl(int[] lengths, Object storage) {
        this.lengths = lengths;
        this.products = new int[lengths.length];
        int length = MultiArrayImpl.numberOfElements(this.lengths, this.products);
        if (length > Array.getLength(storage)) {
            throw new IllegalArgumentException("Inadequate storage");
        }
        this.storage = storage;
    }

    public MultiArrayImpl(int[] lengths, int[] products, Object storage) {
        this.lengths = lengths;
        this.products = products;
        this.storage = storage;
    }

    public Class getComponentType() {
        return this.storage.getClass().getComponentType();
    }

    public int getRank() {
        return this.lengths.length;
    }

    public int[] getLengths() {
        return (int[])this.lengths.clone();
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isScalar() {
        return 0 == this.getRank();
    }

    public Object get(int[] index) {
        return Array.get(this.storage, this.indexMap(index));
    }

    public boolean getBoolean(int[] index) {
        return Array.getBoolean(this.storage, this.indexMap(index));
    }

    public char getChar(int[] index) {
        return Array.getChar(this.storage, this.indexMap(index));
    }

    public byte getByte(int[] index) {
        return Array.getByte(this.storage, this.indexMap(index));
    }

    public short getShort(int[] index) {
        return Array.getShort(this.storage, this.indexMap(index));
    }

    public int getInt(int[] index) {
        return Array.getInt(this.storage, this.indexMap(index));
    }

    public long getLong(int[] index) {
        return Array.getLong(this.storage, this.indexMap(index));
    }

    public float getFloat(int[] index) {
        return Array.getFloat(this.storage, this.indexMap(index));
    }

    public double getDouble(int[] index) {
        return Array.getDouble(this.storage, this.indexMap(index));
    }

    public void set(int[] index, Object value) {
        Array.set(this.storage, this.indexMap(index), value);
    }

    public void setBoolean(int[] index, boolean value) {
        Array.setBoolean(this.storage, this.indexMap(index), value);
    }

    public void setChar(int[] index, char value) {
        Array.setChar(this.storage, this.indexMap(index), value);
    }

    public void setByte(int[] index, byte value) {
        Array.setByte(this.storage, this.indexMap(index), value);
    }

    public void setShort(int[] index, short value) {
        Array.setShort(this.storage, this.indexMap(index), value);
    }

    public void setInt(int[] index, int value) {
        Array.setInt(this.storage, this.indexMap(index), value);
    }

    public void setLong(int[] index, long value) {
        Array.setLong(this.storage, this.indexMap(index), value);
    }

    public void setFloat(int[] index, float value) {
        Array.setFloat(this.storage, this.indexMap(index), value);
    }

    public void setDouble(int[] index, double value) {
        Array.setDouble(this.storage, this.indexMap(index), value);
    }

    public MultiArray copyout(int[] origin, int[] shape) {
        if (origin.length != this.lengths.length || shape.length != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int ji = this.lengths.length - 1;
        while (ji >= 0) {
            if (origin[ji] != 0 || shape[ji] != this.lengths[ji]) break;
            --ji;
        }
        if (ji < 0) {
            return (MultiArrayImpl)this.clone();
        }
        int[] shp = (int[])shape.clone();
        int[] pducts = new int[shp.length];
        int product = MultiArrayImpl.numberOfElements(shp, pducts);
        Object dst = Array.newInstance(this.getComponentType(), product);
        int src_pos = this.indexMap(origin);
        if (ji == 0) {
            System.arraycopy(this.storage, src_pos, dst, 0, product);
        } else {
            int step = this.products[--ji];
            int contig = pducts[ji];
            int dst_pos = 0;
            while (dst_pos < product) {
                System.arraycopy(this.storage, src_pos, dst, dst_pos, contig);
                src_pos += step;
                dst_pos += contig;
            }
        }
        return new MultiArrayImpl(shp, pducts, dst);
    }

    public void copyin(int[] origin, MultiArrayImpl src) {
        if (origin.length != this.lengths.length || src.getRank() != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int ji = this.lengths.length - 1;
        while (ji >= 0) {
            if (origin[ji] != 0 || src.lengths[ji] != this.lengths[ji]) break;
            --ji;
        }
        if (ji < 0) {
            System.arraycopy(src.storage, 0, this.storage, 0, Array.getLength(this.storage));
            return;
        }
        int dst_pos = this.indexMap(origin);
        if (ji == 0) {
            System.arraycopy(src.storage, 0, this.storage, dst_pos, Array.getLength(this.storage) - dst_pos);
            return;
        }
        int step = this.products[--ji];
        int contig = src.products[ji];
        int src_length = Array.getLength(src.storage);
        int src_pos = 0;
        while (src_pos < src_length) {
            System.arraycopy(src.storage, src_pos, this.storage, dst_pos, contig);
            dst_pos += step;
            src_pos += contig;
        }
    }

    public void copyin(int[] origin, MultiArray data) throws IOException {
        if (data instanceof MultiArrayImpl) {
            this.copyin(origin, (MultiArrayImpl)data);
            return;
        }
        if (origin.length != this.lengths.length || data.getRank() != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        if (data.getComponentType() != this.getComponentType()) {
            throw new ArrayStoreException();
        }
        AbstractAccessor.copy(data, data.getLengths(), this, origin);
    }

    public static Object fixDest(Object dst, int lengthNeeded, Class defaultComponentType) {
        if (dst == null || Array.getLength(dst) < lengthNeeded) {
            Class<?> ct = dst == null ? defaultComponentType : dst.getClass().getComponentType();
            dst = Array.newInstance(ct, lengthNeeded);
        }
        return dst;
    }

    public Object getStorage() {
        return this.storage;
    }

    public Object toArray() {
        int length = Array.getLength(this.storage);
        Object dst = Array.newInstance(this.getComponentType(), length);
        System.arraycopy(this.storage, 0, dst, 0, length);
        return dst;
    }

    public Object toArray(Object dst, int[] origin, int[] shape) {
        if (origin.length != this.lengths.length || shape.length != this.lengths.length) {
            throw new IllegalArgumentException("Rank Mismatch");
        }
        int ji = this.lengths.length - 1;
        while (ji >= 0) {
            if (origin[ji] != 0 || shape[ji] != this.lengths[ji]) break;
            --ji;
        }
        if (ji < 0) {
            int length = Array.getLength(this.storage);
            dst = MultiArrayImpl.fixDest(dst, length, this.getComponentType());
            System.arraycopy(this.storage, 0, dst, 0, length);
            return dst;
        }
        int[] shp = (int[])shape.clone();
        int[] pducts = new int[shp.length];
        int product = MultiArrayImpl.numberOfElements(shp, pducts);
        dst = MultiArrayImpl.fixDest(dst, product, this.getComponentType());
        int src_pos = this.indexMap(origin);
        if (ji == 0) {
            System.arraycopy(this.storage, src_pos, dst, 0, product);
            return dst;
        }
        int step = this.products[--ji];
        int contig = pducts[ji];
        int dst_pos = 0;
        while (dst_pos < product) {
            System.arraycopy(this.storage, src_pos, dst, dst_pos, contig);
            src_pos += step;
            dst_pos += contig;
        }
        return dst;
    }

    public Object clone() {
        return new MultiArrayImpl((int[])this.lengths.clone(), (int[])this.products.clone(), this.toArray());
    }

    public int indexMap(int[] index) {
        int value = 0;
        int ii = 0;
        while (ii < this.lengths.length) {
            int thisIndex = index[ii];
            if (thisIndex < 0 || thisIndex >= this.lengths[ii]) {
                throw new ArrayIndexOutOfBoundsException();
            }
            value += thisIndex * this.products[ii];
            ++ii;
        }
        return value;
    }

    public static void main(String[] args) {
        int[] lengths;
        int[] shape = new int[]{48, 64};
        MultiArrayImpl src = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(src.storage, ii, ii);
            ++ii;
        }
        int[] clip = new int[]{32, 64};
        int[] origin = new int[]{8, 0};
        MultiArray ma = src.copyout(origin, clip);
        try {
            System.out.println("Rank  " + ma.getRank());
            lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{0, 0}));
            System.out.println(ma.getInt(new int[]{1, 0}));
            System.out.println(ma.getInt(new int[]{lengths[0] - 1, lengths[1] - 1}));
        }
        catch (IOException ee) {
            // empty catch block
        }
        clip = new int[]{48, 48};
        origin = new int[]{0, 8};
        ma = src.copyout(origin, clip);
        try {
            System.out.println("Rank  " + ma.getRank());
            lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{0, 0}));
            System.out.println(ma.getInt(new int[]{1, 0}));
            System.out.println(ma.getInt(new int[]{lengths[0] - 1, lengths[1] - 1}));
        }
        catch (IOException ee) {
            // empty catch block
        }
        MultiArrayImpl dest = new MultiArrayImpl(Integer.TYPE, shape);
        try {
            dest.copyin(origin, ma);
            System.out.println("***Rank  " + dest.getRank());
            int[] lengths2 = dest.getLengths();
            System.out.println("Shape { " + lengths2[0] + ", " + lengths2[1] + " }");
            System.out.println(dest.getInt(new int[]{0, 0}));
            System.out.println(dest.getInt(new int[]{0, 7}));
            System.out.println(dest.getInt(new int[]{0, 8}));
            System.out.println(dest.getInt(new int[]{47, 55}));
            System.out.println(dest.getInt(new int[]{47, 56}));
            System.out.println(dest.getInt(new int[]{47, 63}));
        }
        catch (IOException ee) {}
    }
}

