/*
 * Decompiled with CFR 0.152.
 */
package ucar.multiarray;

import java.io.IOException;
import java.lang.reflect.Array;
import ucar.multiarray.ConcreteIndexMap;
import ucar.multiarray.MultiArrayImpl;
import ucar.multiarray.MultiArrayProxy;

public class DecimateMap
extends ConcreteIndexMap {
    private int position_;
    private boolean[] pattern_;
    private int nset_;

    public DecimateMap(int position, boolean[] pattern) {
        this.init(new IMap(), new LengthsMap());
        this.position_ = position;
        this.pattern_ = (boolean[])pattern.clone();
        this.nset_ = DecimateMap.nbset(this.pattern_, this.pattern_.length);
    }

    public DecimateMap(ConcreteIndexMap prev, int position, boolean[] pattern) {
        this.link(prev, new IMap(), new LengthsMap());
        this.position_ = position;
        this.pattern_ = (boolean[])pattern.clone();
        this.nset_ = DecimateMap.nbset(this.pattern_, this.pattern_.length);
    }

    private static int nbset(boolean[] apattern, int len) {
        int nhits = 0;
        int ii = 0;
        while (ii < len) {
            if (apattern[ii]) {
                ++nhits;
            }
            ++ii;
        }
        return nhits;
    }

    public static void main(String[] args) {
        int[] shape = new int[]{48, 64};
        MultiArrayImpl delegate = new MultiArrayImpl(Integer.TYPE, shape);
        int size = MultiArrayImpl.numberOfElements(shape);
        int ii = 0;
        while (ii < size) {
            Array.setInt(delegate.storage, ii, ii);
            ++ii;
        }
        boolean[] pattern = new boolean[]{true, false, true};
        DecimateMap im = new DecimateMap(0, pattern);
        MultiArrayProxy ma = new MultiArrayProxy(delegate, im);
        try {
            System.out.println("Rank  " + ma.getRank());
            int[] lengths = ma.getLengths();
            System.out.println("Shape { " + lengths[0] + ", " + lengths[1] + " }");
            System.out.println(ma.getInt(new int[]{1, 0}));
        }
        catch (IOException ee) {}
    }

    private class LengthsMap
    extends ConcreteIndexMap.ZZMap {
        private LengthsMap() {
        }

        public synchronized int get(int key) {
            int plen = super.get(key);
            if (key != DecimateMap.this.position_) {
                return plen;
            }
            int len = plen / DecimateMap.this.pattern_.length * DecimateMap.this.nset_;
            int rem = plen % DecimateMap.this.pattern_.length;
            if (rem == 0) {
                return len;
            }
            return len + DecimateMap.nbset(DecimateMap.this.pattern_, rem);
        }
    }

    private class IMap
    extends ConcreteIndexMap.ZZMap {
        private IMap() {
        }

        public synchronized int get(int key) {
            if (key == DecimateMap.this.position_) {
                int input = super.get(key);
                int nstrides = input / DecimateMap.this.nset_;
                int which = DecimateMap.this.nset_ > 1 ? input % DecimateMap.this.nset_ : 0;
                int offset = 0;
                int nhits = 0;
                while (offset < DecimateMap.this.pattern_.length) {
                    if (DecimateMap.this.pattern_[offset] && ++nhits > which) break;
                    ++offset;
                }
                return nstrides * DecimateMap.this.pattern_.length + offset;
            }
            return super.get(key);
        }
    }
}

