/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BadHeaderException;
import nom.tam.fits.Data;
import nom.tam.fits.ExtensionHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.ImageData;
import nom.tam.fits.PrimaryHDU;
import nom.tam.util.ArrayFuncs;

public class ImageHDU
extends ExtensionHDU {
    public ImageHDU(Header header) throws FitsException {
        super(header);
        if (!this.isHeader()) {
            throw new BadHeaderException("Not a valid image header");
        }
    }

    public ImageHDU(PrimaryHDU primary) throws FitsException {
        super(primary.myHeader);
        if (this.myHeader != null && !this.myHeader.primaryToImage()) {
            throw new FitsException("Couldn't create ImageHDU from PrimaryHDU");
        }
        if (!this.isHeader()) {
            throw new FitsException("Header was not converted to a valid image header");
        }
        this.myData = primary.myData;
    }

    public ImageHDU(Object obj) throws FitsException {
        super(new Header());
        this.myData = new ImageData(obj);
        this.myHeader.pointToData(this.myData);
        if (!this.myHeader.primaryToImage()) {
            throw new FitsException("Default header was not converted to a valid image header");
        }
    }

    public static boolean isHeader(Header header) {
        String card0 = header.getCard(0);
        return card0 != null && card0.startsWith("XTENSION= 'IMAGE   '");
    }

    public boolean isHeader() {
        return ImageHDU.isHeader(this.myHeader);
    }

    public Data manufactureData() throws FitsException {
        return new ImageData(this.myHeader);
    }

    public void info() {
        if (this.isHeader()) {
            System.out.println("  Image Extension");
        } else {
            System.out.println("  Image Extension (bad header)");
        }
        System.out.println("      Header Information:");
        System.out.println("         BITPIX=" + this.myHeader.getIntValue("BITPIX", -1));
        int naxis = this.myHeader.getIntValue("NAXIS", -1);
        System.out.println("         NAXIS=" + naxis);
        int i = 1;
        while (i <= naxis) {
            System.out.println("         NAXIS" + i + "=" + this.myHeader.getIntValue("NAXIS" + i, -1));
            ++i;
        }
        System.out.println("      Data information:");
        if (this.myData.getData() == null) {
            System.out.println("        No Data");
        } else {
            System.out.println("         " + ArrayFuncs.arrayDescription(this.myData.getData()));
        }
    }
}

