/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import nom.tam.fits.FitsException;
import nom.tam.util.ArrayFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;

public abstract class Data {
    protected Object dataArray;

    public void write(BufferedDataOutputStream o) throws FitsException {
        this.writeTrueData(o);
        byte[] padding = new byte[this.getPadding()];
        try {
            o.writePrimitiveArray(padding);
        }
        catch (IOException e) {
            throw new FitsException("Error writing padding: " + e);
        }
    }

    public void read(BufferedDataInputStream i) throws FitsException {
        this.readTrueData(i);
        int pad = this.getPadding();
        try {
            byte[] buf = new byte[pad];
            while (pad > 0) {
                int len = i.read(buf, 0, pad);
                if (len == 0) {
                    throw new FitsException("Data Padding EOF");
                }
                pad -= len;
            }
        }
        catch (EOFException e) {
        }
        catch (IOException e) {
            throw new FitsException("Error skipping padding:" + e);
        }
    }

    protected void writeTrueData(BufferedDataOutputStream o) throws FitsException {
        try {
            o.writePrimitiveArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("FITS Output Error: " + e);
        }
    }

    protected void readTrueData(BufferedDataInputStream i) throws FitsException {
        try {
            i.readPrimitiveArray(this.dataArray);
        }
        catch (IOException e) {
            throw new FitsException("FITS Input Error: " + e);
        }
    }

    public int getPadding() {
        int len = this.getTrueSize() % 2880;
        if (len == 0) {
            return 0;
        }
        return 2880 - len;
    }

    public int getTrueSize() {
        int len = ArrayFuncs.computeSize(this.dataArray);
        return len;
    }

    public int getPaddedSize() {
        return this.getTrueSize() + this.getPadding();
    }

    public Object getData() {
        return this.dataArray;
    }
}

