/*
 * Decompiled with CFR 0.152.
 */
package gnu.regexp;

import gnu.regexp.CharIndexed;
import gnu.regexp.REMatch;
import gnu.regexp.REToken;

class RETokenPOSIX
extends REToken {
    int m_type;
    boolean m_insens;
    boolean m_negated;
    static final int ALNUM = 0;
    static final int ALPHA = 1;
    static final int BLANK = 2;
    static final int CNTRL = 3;
    static final int DIGIT = 4;
    static final int GRAPH = 5;
    static final int LOWER = 6;
    static final int PRINT = 7;
    static final int PUNCT = 8;
    static final int SPACE = 9;
    static final int UPPER = 10;
    static final int XDIGIT = 11;
    static final String[] s_nameTable = new String[]{"alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit"};

    static int intValue(String key) {
        int i = 0;
        while (i < s_nameTable.length) {
            if (s_nameTable[i].equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    RETokenPOSIX(int f_subIndex, int f_type, boolean f_insens, boolean f_negated) {
        super(f_subIndex);
        this.m_type = f_type;
        this.m_insens = f_insens;
        this.m_negated = f_negated;
    }

    int getMinimumLength() {
        return 1;
    }

    int[] match(CharIndexed input, int index, int eflags, REMatch mymatch) {
        char ch = input.charAt(index);
        if (ch == '\uffff') {
            return null;
        }
        boolean retval = false;
        switch (this.m_type) {
            case 0: {
                retval = Character.isLetterOrDigit(ch);
                break;
            }
            case 1: {
                retval = Character.isLetter(ch);
                break;
            }
            case 2: {
                retval = ch == ' ' || ch == '\t';
                break;
            }
            case 3: {
                retval = Character.isISOControl(ch);
                break;
            }
            case 4: {
                retval = Character.isDigit(ch);
                break;
            }
            case 5: {
                retval = !Character.isWhitespace(ch) && !Character.isISOControl(ch);
                break;
            }
            case 6: {
                retval = this.m_insens && Character.isLetter(ch) || Character.isLowerCase(ch);
                break;
            }
            case 7: {
                retval = Character.isLetterOrDigit(ch);
                break;
            }
            case 8: {
                retval = "`~!@#$%^&*()-_=+[]{}\\|;:'\"/?,.<>".indexOf(ch) != -1;
                break;
            }
            case 9: {
                retval = Character.isWhitespace(ch);
                break;
            }
            case 10: {
                retval = this.m_insens && Character.isLetter(ch) || Character.isUpperCase(ch);
                break;
            }
            case 11: {
                boolean bl = retval = Character.isDigit(ch) || "abcdefABCDEF".indexOf(ch) != -1;
            }
        }
        if (this.m_negated) {
            boolean bl = retval = !retval;
        }
        if (retval) {
            return this.next(input, index + 1, eflags, mymatch);
        }
        return null;
    }

    void dump(StringBuffer os) {
        if (this.m_negated) {
            os.append('^');
        }
        os.append("[:" + s_nameTable[this.m_type] + ":]");
    }
}

