/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import HTTPClient.UncompressInputStream;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;

public class AddeURLConnection
extends URLConnection {
    private InputStream is = null;
    private DataInputStream dis = null;
    private DataOutputStream dos = null;
    private URL url;
    private static final int DEFAULT_LINES = 480;
    private static final int DEFAULT_ELEMS = 640;
    private static final int TRAILER_SIZE = 92;
    private static final int REQUEST_SIZE = 120;
    private static final int ERRMSG_SIZE = 72;
    private static final int ERRMSG_OFFS = 8;
    private static final int PORT = 500;
    private static final int COMPRESS_PORT = 503;
    private static final int GZIP_PORT = 112;
    private static final int VERSION_1 = 1;
    public static final int AGET = 0;
    public static final int ADIR = 1;
    public static final int LWPR = 2;
    public static final int GDIR = 3;
    public static final int GGET = 4;
    public static final int MDKS = 5;
    public static final int TXTG = 6;
    public static final int WTXG = 7;
    public static final int OBTG = 8;
    private static final int IMAGE = 100;
    private static final int GRID = 101;
    private static final int POINT = 102;
    private static final int TEXT = 103;
    private static final int WXTEXT = 104;
    private static final int OBTEXT = 105;
    private int numBytes = 0;
    private int dataType = 100;
    private byte[] binaryData = null;
    private int reqType = 0;
    private boolean debug = false;
    private int portToUse = 500;
    private int compressionType = 500;
    private static String[] replaceWith = new String[]{"&", "<", ">", "'", "\"", "\r", "\n", " "};
    private static String[] replaceString = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;", "&#13;", "&#10;", "%20"};

    AddeURLConnection(URL url) throws IOException {
        super(url);
        this.url = this.normalizeURL(url);
    }

    public synchronized void connect() throws IOException, AddeURLException {
        int i;
        Socket t;
        int proj;
        String projStr;
        String userStr;
        int endIdx;
        int test;
        String uCmd;
        String requestOriginal = this.url.getFile().substring(1);
        String request = requestOriginal.toLowerCase();
        boolean bl = this.debug = this.debug || request.indexOf("debug=true") >= 0;
        if (this.debug) {
            System.out.println("host from URL: " + this.url.getHost());
        }
        if (this.debug) {
            System.out.println("file from URL: " + this.url.getFile());
        }
        if (!(request.startsWith("image") || request.startsWith("datasetinfo") || request.startsWith("text") || request.startsWith("wxtext") || request.startsWith("obtext") || request.startsWith("grid") || request.startsWith("point"))) {
            throw new AddeURLException("Request for unknown data");
        }
        byte[] svc = null;
        if (request.startsWith("imagedir")) {
            svc = "adir".getBytes();
            this.reqType = 1;
        } else if (request.startsWith("datasetinfo")) {
            svc = "lwpr".getBytes();
            this.reqType = 2;
        } else if (request.startsWith("text")) {
            svc = "txtg".getBytes();
            this.reqType = 6;
        } else if (request.startsWith("wxtext")) {
            svc = "wtxg".getBytes();
            this.reqType = 7;
        } else if (request.startsWith("obtext")) {
            svc = "obtg".getBytes();
            this.reqType = 8;
        } else if (request.startsWith("image")) {
            svc = "aget".getBytes();
            this.reqType = 0;
        } else if (request.startsWith("griddir")) {
            svc = "gdir".getBytes();
            this.reqType = 3;
        } else if (request.startsWith("grid")) {
            svc = "gget".getBytes();
            this.reqType = 4;
        } else if (request.startsWith("point")) {
            svc = "mdks".getBytes();
            this.reqType = 5;
        } else {
            throw new AddeURLException("Invalid or unsupported ADDE service= " + svc.toString());
        }
        if (this.debug) {
            System.out.println("Service = " + new String(svc));
        }
        String string = uCmd = (test = request.indexOf("?")) >= 0 ? request.substring(test + 1) : request;
        if (this.debug) {
            System.out.println("uCmd=" + uCmd);
        }
        StringBuffer sb = new StringBuffer();
        switch (this.reqType) {
            case 0: {
                sb = this.decodeAGETString(uCmd);
                break;
            }
            case 1: {
                sb = this.decodeADIRString(uCmd);
                break;
            }
            case 2: {
                sb = this.decodeLWPRString(uCmd);
                break;
            }
            case 3: {
                sb = this.decodeGDIRString(uCmd);
                break;
            }
            case 4: {
                sb = this.decodeGDIRString(uCmd);
                break;
            }
            case 5: {
                sb = this.decodeMDKSString(uCmd);
                break;
            }
            case 6: {
                sb = this.decodeTXTGString(uCmd);
                break;
            }
            case 7: {
                sb = this.decodeWTXGString(uCmd);
                break;
            }
            case 8: {
                sb = this.decodeOBTGString(uCmd);
            }
        }
        sb.append(" version=");
        sb.append(this.reqType == 4 || this.reqType == 7 ? "A" : "1");
        String cmd = new String(sb);
        cmd = cmd.toUpperCase();
        if (this.debug) {
            System.out.println(cmd);
        }
        byte[] ob = cmd.getBytes();
        int startIdx = request.indexOf("user=");
        if (startIdx > 0) {
            endIdx = request.indexOf(38, startIdx);
            if (endIdx == -1) {
                endIdx = request.length();
            }
            userStr = requestOriginal.substring(startIdx + 5, endIdx);
        } else {
            userStr = "XXXX";
        }
        byte[] usr = userStr.getBytes();
        startIdx = uCmd.indexOf("proj=");
        if (startIdx > 0) {
            endIdx = uCmd.indexOf(38, startIdx);
            if (endIdx == -1) {
                endIdx = uCmd.length();
            }
            projStr = uCmd.substring(startIdx + 5, endIdx);
        } else {
            projStr = "0";
        }
        try {
            proj = Integer.parseInt(projStr);
        }
        catch (NumberFormatException e) {
            throw new AddeURLException("Invalid project number: " + projStr);
        }
        startIdx = uCmd.indexOf("compress=");
        String compType = "";
        if (startIdx > 0) {
            endIdx = uCmd.indexOf(38, startIdx);
            if (endIdx == -1) {
                endIdx = uCmd.length();
            }
            compType = uCmd.substring(startIdx + 9, endIdx);
        }
        if (compType.equalsIgnoreCase("gzip")) {
            this.compressionType = 112;
        } else if (compType.equalsIgnoreCase("compress") || compType.equalsIgnoreCase("true")) {
            try {
                Class<?> c = Class.forName("HTTPClient.UncompressInputStream");
                this.compressionType = 503;
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("Uncompression code not found, turning compression off");
            }
        }
        this.portToUse = this.url.getPort() == -1 ? this.compressionType : this.url.getPort();
        try {
            t = new Socket(this.url.getHost(), this.portToUse);
        }
        catch (UnknownHostException e) {
            throw new AddeURLException(e.toString());
        }
        this.dos = new DataOutputStream(t.getOutputStream());
        this.dos.writeInt(1);
        byte[] ipa = new byte[4];
        InetAddress ia = InetAddress.getByName(this.url.getHost());
        ipa = ia.getAddress();
        this.dos.write(ipa, 0, ipa.length);
        this.dos.writeInt(this.compressionType);
        this.dos.write(svc, 0, svc.length);
        this.dos.write(ipa, 0, ipa.length);
        this.dos.writeInt(this.compressionType);
        InetAddress lh = InetAddress.getLocalHost();
        ipa = lh.getAddress();
        this.dos.write(ipa, 0, ipa.length);
        if (usr.length <= 4) {
            this.dos.write(usr, 0, usr.length);
            int i2 = 0;
            while (i2 < 4 - usr.length) {
                this.dos.writeByte(32);
                ++i2;
            }
        } else {
            throw new AddeURLException("Invalid user id: " + userStr);
        }
        this.dos.writeInt(proj);
        byte[] pwd = new byte[12];
        this.dos.write(pwd, 0, pwd.length);
        this.dos.write(svc, 0, svc.length);
        int numBinaryBytes = 0;
        if (this.binaryData != null) {
            numBinaryBytes = this.binaryData.length;
        }
        if (ob.length > 120) {
            this.dos.writeInt(ob.length + numBinaryBytes);
            this.dos.writeInt(ob.length);
            i = 0;
            while (i < 116) {
                this.dos.writeByte(0);
                ++i;
            }
            this.dos.write(ob, 0, ob.length);
        } else {
            if (this.debug) {
                System.out.println("numBinaryBytes= " + numBinaryBytes);
            }
            this.dos.writeInt(numBinaryBytes);
            this.dos.write(ob, 0, ob.length);
            i = 0;
            while (i < 120 - ob.length) {
                this.dos.writeByte(32);
                ++i;
            }
        }
        if (numBinaryBytes > 0) {
            this.dos.write(this.binaryData, 0, numBinaryBytes);
        }
        this.is = this.compressionType == 112 ? new GZIPInputStream(t.getInputStream()) : (this.compressionType == 503 ? new UncompressInputStream(t.getInputStream()) : t.getInputStream());
        this.dis = new DataInputStream(this.is);
        if (this.debug && this.compressionType != 500) {
            System.out.println("Compression is turned ON using " + (this.compressionType == 112 ? "GZIP" : "compress"));
        }
        this.numBytes = this.dis.readInt();
        if (this.debug) {
            System.out.println("server is sending: " + this.numBytes + " bytes");
        }
        if (this.numBytes == 0) {
            byte[] trailer = new byte[92];
            this.dis.readFully(trailer, 0, trailer.length);
            String errMsg = new String(trailer, 8, 72);
            throw new AddeURLException(errMsg);
        }
        this.connected = true;
    }

    public int getRequestType() {
        return this.reqType;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.is;
    }

    public synchronized DataInputStream getDataInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.dis;
    }

    public int getInitialRecordSize() {
        return this.numBytes;
    }

    private StringBuffer decodeAGETString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        boolean latFlag = false;
        boolean lonFlag = false;
        boolean linFlag = false;
        boolean eleFlag = false;
        String latString = null;
        String lonString = null;
        String linString = null;
        String eleString = null;
        String tempString = null;
        String testString = null;
        String groupString = null;
        String descrString = "all";
        String posString = "0";
        String numlinString = Integer.toString(480);
        String numeleString = Integer.toString(640);
        String magString = "x";
        String traceString = "trace=0";
        String spaceString = "spac=x";
        String unitString = "unit=brit";
        String auxString = "aux=yes";
        String calString = "cal=x";
        String docString = "doc=no";
        String timeString = "time=x x i";
        String lineleType = "a";
        String placement = "c";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            int i;
            StringTokenizer tok;
            testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("pos")) {
                posString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("lat")) {
                latString = testString.substring(testString.indexOf("=") + 1).trim();
                latFlag = true;
                if (latString.indexOf(" ") <= 0) continue;
                tok = new StringTokenizer(latString);
                if (tok.countTokens() < 2) break;
                i = 0;
                while (i < 2) {
                    tempString = tok.nextToken();
                    if (i == 0) {
                        latString = tempString;
                    } else {
                        lonString = this.negateLongitude(tempString);
                        lonFlag = true;
                    }
                    ++i;
                }
                continue;
            }
            if (testString.startsWith("lon")) {
                lonFlag = true;
                lonString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("lin")) {
                tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.indexOf(" ") > 0) {
                    tok = new StringTokenizer(tempString);
                    if (tok.countTokens() < 2) break;
                    i = 0;
                    while (i < 2) {
                        tempString = tok.nextToken();
                        if (i == 0) {
                            linString = tempString;
                            linFlag = true;
                        } else {
                            eleString = tempString;
                            eleFlag = true;
                        }
                        ++i;
                    }
                    if (!tok.hasMoreTokens() || !(tempString = tok.nextToken().toLowerCase()).startsWith("i")) continue;
                    lineleType = "i";
                    continue;
                }
                numlinString = tempString;
                continue;
            }
            if (testString.startsWith("ele")) {
                numeleString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("pla")) {
                if (!testString.substring(testString.indexOf("=") + 1).toLowerCase().startsWith("u")) continue;
                placement = "u";
                continue;
            }
            if (testString.startsWith("mag")) {
                tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.indexOf(" ") > 0) {
                    tok = new StringTokenizer(tempString);
                    if (tok.countTokens() < 2) break;
                    i = 0;
                    while (i < 2) {
                        buf.append(" ");
                        tempString = tok.nextToken();
                        if (i == 0) {
                            buf.append("lmag=" + tempString);
                        } else {
                            buf.append("emag=" + tempString);
                        }
                        ++i;
                    }
                    continue;
                }
                magString = tempString;
                continue;
            }
            if (testString.startsWith("size")) {
                tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.trim().equalsIgnoreCase("all")) {
                    numlinString = "99999";
                    numeleString = "99999";
                    continue;
                }
                if (tempString.indexOf(" ") <= 0) continue;
                tok = new StringTokenizer(tempString);
                if (tok.countTokens() < 2) break;
                i = 0;
                while (i < 2) {
                    tempString = tok.nextToken();
                    if (i == 0) {
                        numlinString = tempString;
                    } else {
                        numeleString = tempString;
                    }
                    ++i;
                }
                continue;
            }
            if (testString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (testString.startsWith("spa")) {
                spaceString = testString;
                continue;
            }
            if (testString.startsWith("aux")) {
                auxString = testString;
                continue;
            }
            if (testString.startsWith("uni")) {
                unitString = testString;
                continue;
            }
            if (testString.startsWith("cal")) {
                calString = testString;
                continue;
            }
            if (testString.startsWith("doc")) {
                docString = testString;
                continue;
            }
            if (testString.startsWith("tim")) {
                timeString = testString;
                continue;
            }
            if (testString.startsWith("ban")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("id")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("lmag")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (!testString.startsWith("emag")) continue;
            buf.append(" ");
            buf.append(testString);
        }
        buf.append(" ");
        buf.append(traceString);
        buf.append(" ");
        buf.append(spaceString);
        buf.append(" ");
        buf.append(unitString);
        buf.append(" ");
        buf.append(auxString);
        buf.append(" ");
        buf.append(docString);
        buf.append(" ");
        buf.append(timeString);
        buf.append(" ");
        buf.append(calString);
        StringBuffer posParams = new StringBuffer(groupString + " " + descrString + " " + posString + " ");
        if (latFlag && lonFlag) {
            posParams.append("ec " + latString + " " + lonString + " ");
        } else if (linFlag && eleFlag) {
            posParams.append(lineleType + placement + "  " + linString + " " + eleString + " ");
        } else {
            posParams.append("x x x ");
        }
        posParams.append(magString + " " + numlinString + " " + numeleString + " ");
        try {
            buf.insert(0, (Object)posParams);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e.toString());
            buf = new StringBuffer("");
        }
        return buf;
    }

    private StringBuffer decodeGDIRString(String uCmd) {
        StringBuffer subBuf;
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String descrString = "all";
        String sizeString = " 999999 ";
        String traceString = "trace=0";
        String numString = "num=1";
        String subsetString = null;
        String latString = null;
        String lonString = null;
        String rowString = null;
        String colString = null;
        Object srcString = null;
        String skip = null;
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("num")) {
                numString = testString;
                continue;
            }
            if (testString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (testString.startsWith("pos")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("par")) {
                buf.append(" ");
                buf.append("parm=");
                buf.append(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (testString.startsWith("fho")) {
                buf.append(" ");
                buf.append("vt=");
                String iHMS = testString.substring(testString.indexOf("=") + 1).trim();
                buf.append(iHMS);
                if (iHMS.length() >= 5) continue;
                buf.append("0000");
                continue;
            }
            if (testString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("time")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("lev")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("fday")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("ftime")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("vt")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("lat")) {
                latString = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (testString.startsWith("lon")) {
                lonString = this.adjustLongitudes(this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1)));
                continue;
            }
            if (testString.startsWith("row")) {
                rowString = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (testString.startsWith("col")) {
                colString = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (testString.startsWith("skip")) {
                skip = this.ensureTwoValues(testString.substring(testString.indexOf("=") + 1));
                continue;
            }
            if (testString.startsWith("src")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("gpro")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("trang")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("frang")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (!testString.startsWith("drang")) continue;
            buf.append(" ");
            buf.append(testString);
        }
        buf.append(" ");
        buf.append(numString);
        buf.append(" ");
        buf.append(traceString);
        buf.append(" ");
        if (latString != null && lonString != null) {
            subBuf = new StringBuffer();
            subBuf.append("subset=");
            subBuf.append(latString);
            subBuf.append(" ");
            subBuf.append(lonString);
            subBuf.append(" ");
            subBuf.append(skip == null ? "1 1" : skip);
            subBuf.append(" LATLON");
            subsetString = subBuf.toString();
            if (this.debug) {
                System.out.println(subsetString);
            }
        } else if (rowString != null && colString != null) {
            subBuf = new StringBuffer();
            subBuf.append("subset=");
            subBuf.append(rowString);
            subBuf.append(" ");
            subBuf.append(colString);
            subBuf.append(" ");
            subBuf.append(skip == null ? "1 1" : skip);
            subBuf.append(" ROWCOL");
            subsetString = subBuf.toString();
            if (this.debug) {
                System.out.println(subsetString);
            }
        } else if (skip != null) {
            subBuf = new StringBuffer();
            subBuf.append("subset=1 99999 1 99999");
            subBuf.append(" ");
            subBuf.append(skip);
            subBuf.append(" ROWCOL");
            subsetString = subBuf.toString();
            if (this.debug) {
                System.out.println(subsetString);
            }
        }
        if (subsetString != null) {
            buf.append(subsetString);
        }
        String posParams = groupString + " " + descrString + " " + sizeString + " ";
        try {
            buf.insert(0, posParams);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e);
            buf = new StringBuffer("");
        }
        return buf;
    }

    private StringBuffer decodeADIRString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String descrString = "all";
        String posString = "0";
        String traceString = "trace=0";
        String bandString = "band=all x";
        String auxString = "aux=yes";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("pos")) {
                String tempString = testString.substring(testString.indexOf("=") + 1);
                if (tempString.equals("")) {
                    posString = "0";
                    continue;
                }
                StringTokenizer stp = new StringTokenizer(tempString, " ");
                if (stp.countTokens() == 1) {
                    if (tempString.equals("all")) {
                        posString = "1095519264";
                        continue;
                    }
                    if (tempString.equals("x")) {
                        posString = tempString;
                        continue;
                    }
                    int posval = Integer.parseInt(stp.nextToken().trim());
                    if (posval < 0) {
                        posString = tempString + " 0";
                        continue;
                    }
                    posString = tempString;
                    continue;
                }
                posString = tempString;
                continue;
            }
            if (testString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (testString.startsWith("aux")) {
                auxString = testString;
                continue;
            }
            if (testString.startsWith("ban")) {
                bandString = testString;
                continue;
            }
            if (testString.startsWith("tim")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (!testString.startsWith("id")) continue;
            buf.append(" ");
            buf.append(testString);
        }
        buf.append(" ");
        buf.append(traceString);
        buf.append(" ");
        buf.append(bandString);
        buf.append(" ");
        buf.append(auxString);
        String posParams = groupString + " " + descrString + " " + posString + " ";
        try {
            buf.insert(0, posParams);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e.toString());
            buf = new StringBuffer("");
        }
        return buf;
    }

    public StringBuffer decodeTXTGString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String filenameString = null;
        String descrString = null;
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            if (testString.startsWith("desc")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
            }
            if (testString.startsWith("file")) {
                filenameString = "FILE=" + testString.substring(testString.indexOf("=") + 1);
            }
            if (!testString.startsWith("grou")) continue;
            groupString = testString.substring(testString.indexOf("=") + 1);
        }
        buf.append(groupString);
        buf.append(" ");
        buf.append(descrString);
        buf.append(" ");
        buf.append(filenameString);
        return buf;
    }

    public StringBuffer decodeWTXGString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String numString = "NUM=1";
        String dTimeString = "DTIME=96.0000";
        String traceString = "TRACE=0";
        String groupString = "RTWXTEXT";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("apro")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("astn")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("day")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("mat")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("prod")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("sour")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("wmo")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("wstn")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (testString.startsWith("num")) {
                numString = testString;
                continue;
            }
            if (!testString.startsWith("dtim")) continue;
            dTimeString = testString;
        }
        buf.append(" ");
        buf.append(dTimeString);
        buf.append(" ");
        buf.append(numString);
        buf.append(" ");
        buf.append(traceString);
        String posParams = groupString + " ";
        try {
            buf.insert(0, posParams);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e.toString());
            buf = new StringBuffer("");
        }
        return buf;
    }

    public StringBuffer decodeOBTGString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String numString = "NUM=1";
        String traceString = "TRACE=0";
        String groupString = "RTWXTEXT";
        String descrString = "SFCHOURLY";
        String idreqString = "IDREQ=LIST";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("desc")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("id")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("co")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("reg")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("nhou")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("new")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("old")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("type")) {
                buf.append(" ");
                buf.append(testString);
                continue;
            }
            if (testString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (!testString.startsWith("num")) continue;
            numString = testString;
        }
        buf.append(" ");
        buf.append(numString);
        buf.append(" ");
        buf.append(traceString);
        String posParams = groupString + " " + descrString + " " + idreqString;
        try {
            buf.insert(0, posParams);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e.toString());
            buf = new StringBuffer("");
        }
        return buf;
    }

    public StringBuffer decodeLWPRString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String groupString = null;
        String typeString = "ala.";
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            String testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
            }
            if (!testString.startsWith("type")) continue;
            String tempString = testString.substring(testString.indexOf("=") + 1);
            if (tempString.startsWith("i")) {
                typeString = "ala.";
            }
            if (tempString.startsWith("g")) {
                typeString = "alg.";
                continue;
            }
            if (tempString.startsWith("p")) {
                typeString = "alm.";
                continue;
            }
            if (tempString.startsWith("t")) {
                typeString = "alt.";
                continue;
            }
            if (tempString.startsWith("n")) {
                typeString = "aln.";
                continue;
            }
            if (!tempString.startsWith("s")) continue;
            typeString = "aln.";
        }
        buf.append(typeString);
        buf.append(groupString);
        return buf;
    }

    private StringBuffer decodeMDKSString(String uCmd) {
        StringBuffer buf = new StringBuffer();
        String testString = null;
        String groupString = null;
        String descrString = null;
        String maxString = "max=1";
        String numString = "";
        String posString = "pos=0";
        String traceString = "trace=0";
        String selectString = "";
        String parmString = "";
        String justTheParametersString = "";
        String justTheSelectString = "";
        String sBinaryData = "";
        boolean posInDescriptor = false;
        StringTokenizer cmdTokens = new StringTokenizer(uCmd, "&");
        while (cmdTokens.hasMoreTokens()) {
            testString = cmdTokens.nextToken();
            if (testString.startsWith("grou")) {
                groupString = testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("des")) {
                descrString = testString.substring(testString.indexOf("=") + 1);
                int pos = descrString.indexOf(".");
                if (pos < 0) continue;
                posString = "pos=" + descrString.substring(pos + 1);
                descrString = descrString.substring(0, pos);
                posInDescriptor = true;
                continue;
            }
            if (testString.startsWith("par")) {
                justTheParametersString = testString.substring(testString.indexOf("=") + 1);
                parmString = "parm=" + justTheParametersString;
                if (this.debug) {
                    System.out.println("paramString = " + parmString);
                }
                sBinaryData = new String(this.decodePARAMString(justTheParametersString));
                sBinaryData = sBinaryData.toUpperCase();
                this.binaryData = sBinaryData.getBytes();
                continue;
            }
            if (testString.startsWith("select")) {
                justTheSelectString = testString.substring(testString.indexOf("=") + 1);
                selectString = "select=" + new String(this.decodeSELECTString(justTheSelectString));
                if (!this.debug) continue;
                System.out.println("Server selectString = " + selectString);
                continue;
            }
            if (testString.startsWith("num")) {
                maxString = "max=" + testString.substring(testString.indexOf("=") + 1);
                continue;
            }
            if (testString.startsWith("max")) {
                maxString = testString;
                continue;
            }
            if (testString.startsWith("tra")) {
                traceString = testString;
                continue;
            }
            if (!testString.startsWith("pos") || posInDescriptor) continue;
            posString = testString;
        }
        if (maxString.trim().equalsIgnoreCase("max=all")) {
            maxString = "max=99999";
        }
        StringBuffer posParams = new StringBuffer();
        posParams.append(groupString);
        posParams.append(" ");
        posParams.append(descrString);
        posParams.append(" ");
        posParams.append(parmString);
        posParams.append(" ");
        posParams.append(selectString);
        posParams.append(" ");
        posParams.append(posString);
        posParams.append(" ");
        posParams.append(traceString);
        posParams.append(" ");
        posParams.append(maxString);
        if (this.debug) {
            System.out.println("String passed to server = " + posParams);
        }
        try {
            buf.insert(0, posParams.toString());
            if (this.debug) {
                System.out.println("buf = " + buf);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println(e.toString());
            buf = new StringBuffer("");
        }
        return buf;
    }

    private String decodePARAMString(String justTheParametersString) {
        String testString = null;
        String thisParam = null;
        String thisUnit = null;
        StringBuffer buf = new StringBuffer();
        StringTokenizer paramTokens = new StringTokenizer(justTheParametersString, " ");
        while (paramTokens.hasMoreTokens()) {
            testString = paramTokens.nextToken().trim();
            StringTokenizer thisParamToken = new StringTokenizer(testString, "[]");
            thisParam = new String(thisParamToken.nextToken().trim());
            buf.append(thisParam);
            int i = thisParam.length();
            while (i < 4) {
                buf.append(" ");
                ++i;
            }
            if (!thisParamToken.hasMoreTokens()) continue;
            thisUnit = thisParamToken.nextToken().trim();
            if (!this.debug) continue;
            System.out.println("This Unit = " + thisUnit);
        }
        return buf.toString();
    }

    private String decodeSELECTString(String justTheSelectString) {
        Object testString = null;
        String entireSelectString = null;
        String thisSelect = null;
        String thisUnit = null;
        StringBuffer buf = new StringBuffer();
        StringTokenizer entireSelectToken = new StringTokenizer(justTheSelectString, "'");
        entireSelectString = entireSelectToken.nextToken().trim();
        StringTokenizer selectTokens = new StringTokenizer(entireSelectString, ";");
        while (selectTokens.hasMoreTokens()) {
            thisSelect = selectTokens.nextToken().trim();
            if (this.debug) {
                System.out.println(" this Select = " + thisSelect);
            }
            StringTokenizer thisSelectToken = new StringTokenizer(thisSelect, " ");
            int tokenCount = thisSelectToken.countTokens();
            thisSelect = new String(thisSelectToken.nextToken());
            if (this.debug) {
                System.out.println("this Select = " + thisSelect);
            }
            if (thisSelect.indexOf("[") > 0) {
                StringTokenizer thisUnitToken = new StringTokenizer(thisSelect, "[]");
                if (thisUnitToken.hasMoreTokens()) {
                    thisSelect = new String(thisUnitToken.nextToken().trim());
                    buf.append("'" + thisSelect);
                    if (thisUnitToken.hasMoreTokens()) {
                        thisUnit = new String(thisUnitToken.nextToken().trim());
                    }
                }
            } else {
                buf.append("'" + thisSelect);
            }
            if (thisSelectToken.hasMoreTokens()) {
                thisSelect = thisSelectToken.nextToken();
                if (this.debug) {
                    System.out.println("this Select = " + thisSelect);
                }
                buf.append(" " + thisSelect);
            }
            if (thisSelectToken.hasMoreTokens()) {
                thisSelect = thisSelectToken.nextToken();
                buf.append(" TO " + thisSelect);
                if (this.debug) {
                    System.out.println("this Select = " + thisSelect);
                }
            }
            if (thisUnit != null) {
                buf.append(" " + thisUnit);
                thisUnit = null;
            }
            buf.append("' ");
        }
        return buf.toString();
    }

    private String ensureTwoValues(String s) {
        String retVal = null;
        if (s.trim().indexOf(" ") > 0) {
            StringTokenizer tok = new StringTokenizer(s);
            if (tok.countTokens() == 2) {
                retVal = s;
            }
        } else {
            retVal = s + " " + s;
        }
        return retVal;
    }

    private String adjustLongitudes(String input) {
        input = input.trim();
        String lon1 = this.negateLongitude(input.substring(0, input.trim().indexOf(" ")).trim());
        String lon2 = this.negateLongitude(input.substring(input.trim().indexOf(" ")).trim());
        return lon2 + " " + lon1;
    }

    private String negateLongitude(String eastLong) {
        if (eastLong.indexOf("-") >= 0) {
            return eastLong.substring(eastLong.indexOf("-") + 1);
        }
        return "-" + eastLong;
    }

    private URL normalizeURL(URL url) {
        String x;
        try {
            x = URLDecoder.decode(url.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        boolean ok = true;
        int i = 0;
        while (i < replaceString.length) {
            int pos = x.indexOf(replaceString[i]);
            ok &= pos < 0;
            ++i;
        }
        if (!ok) {
            int i2 = 0;
            while (i2 < replaceString.length) {
                int pos = -1;
                while ((pos = x.indexOf(replaceString[i2])) >= 0) {
                    if (this.debug) {
                        System.out.println("found " + replaceString[i2] + " at " + pos);
                    }
                    StringBuffer buf = new StringBuffer(x);
                    buf.replace(pos, pos + replaceString[i2].length(), replaceWith[i2]);
                    x = buf.toString();
                }
                ++i2;
            }
        }
        if (this.debug) {
            System.out.println("normalized url = " + x);
        }
        try {
            return new URL(x);
        }
        catch (Exception e) {
            return url;
        }
    }
}

