/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.GRIDnav;
import edu.wisc.ssec.mcidas.McIDASException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import java.util.Arrays;
import java.util.Date;

public class GridDirectory {
    public static final int DIRSIZE = 64;
    private static final int GRIDSIZE_INDEX = 0;
    public static final int ROWS_INDEX = 1;
    public static final int COLS_INDEX = 2;
    public static final int REFDATE_INDEX = 3;
    public static final int REFTIME_INDEX = 4;
    public static final int FTIME_INDEX = 5;
    public static final int PARAM_NAME_INDEX = 6;
    public static final int PARAM_SCALE_INDEX = 7;
    public static final int PARAM_UNITS_INDEX = 8;
    public static final int LEVEL_VALUE_INDEX = 9;
    public static final int LEVEL_SCALE_INDEX = 10;
    public static final int LEVEL_UNITS_INDEX = 11;
    public static final int PARAM_TYPE_INDEX = 12;
    public static final int SECOND_FTIME_INDEX = 13;
    public static final int SECOND_LEVEL_VALUE_INDEX = 14;
    public static final int NAV_BLOCK_INDEX = 33;
    public static final int NAV_BLOCK_LENGTH = 8;
    public static final int GRID_DESCR_INDEX = 52;
    public static final int GRID_DESCR_LENGTH = 12;
    private int[] dir = new int[64];
    private String paramName;
    private String gridDescription;
    private String paramUnitName;
    private int forecastHour;
    private Date referenceTime;
    private Date validTime;
    private Date secondTime = null;
    private double paramScale;
    private double levelValue;
    private String levelUnitName;
    private double secondLevelValue;
    private int rows;
    private int columns;
    private int paramType;
    private int[] navBlock;
    private GRIDnav gridNav = null;

    public GridDirectory(int[] dirblock) throws McIDASException {
        if (dirblock.length != 64) {
            throw new McIDASException("Directory is not the right size");
        }
        System.arraycopy(dirblock, 0, this.dir, 0, 64);
        this.rows = dirblock[1];
        this.columns = dirblock[2];
        int refDay = dirblock[3];
        int refHMS = dirblock[4];
        this.referenceTime = new Date(McIDASUtil.mcDayTimeToSecs(refDay, refHMS) * 1000L);
        this.forecastHour = dirblock[5];
        this.validTime = new Date((McIDASUtil.mcDayTimeToSecs(refDay, refHMS) + (long)(this.forecastHour * 3600)) * 1000L);
        this.paramName = McIDASUtil.intBitsToString(dirblock[6]).trim();
        this.paramScale = Math.pow(10.0, dirblock[7]);
        this.paramUnitName = McIDASUtil.intBitsToString(dirblock[8]).trim();
        this.paramType = dirblock[12];
        this.levelValue = (double)dirblock[9] * Math.pow(10.0, dirblock[10]);
        this.levelUnitName = McIDASUtil.intBitsToString(dirblock[11]).trim();
        if (Math.abs(this.levelValue) > 10000.0 && this.levelUnitName.equals("")) {
            this.levelUnitName = McIDASUtil.intBitsToString(dirblock[9]).trim();
            this.levelValue = 999.0;
        }
        if (this.paramType == 4 || this.paramType == 8) {
            this.secondLevelValue = (double)dirblock[14] * Math.pow(10.0, dirblock[10]);
        }
        if (this.paramType == 1 || this.paramType == 2) {
            this.secondTime = new Date((McIDASUtil.mcDayTimeToSecs(refDay, refHMS) + (long)(dirblock[13] / 10000 * 3600)) * 1000L);
        }
        this.navBlock = new int[8];
        System.arraycopy(dirblock, 33, this.navBlock, 0, 8);
        int[] nameBits = new int[12];
        System.arraycopy(dirblock, 52, nameBits, 0, nameBits.length);
        this.gridDescription = McIDASUtil.intBitsToString(nameBits).trim();
    }

    public int[] getDirBlock() {
        return this.getDirectoryBlock();
    }

    public int[] getDirectoryBlock() {
        return this.dir;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getGridDescription() {
        return this.gridDescription;
    }

    public double getParamScale() {
        return this.paramScale;
    }

    public String getParamUnitName() {
        return this.paramUnitName;
    }

    public Date getReferenceTime() {
        return this.referenceTime;
    }

    public Date getValidTime() {
        return this.validTime;
    }

    public int getForecastHour() {
        return this.forecastHour;
    }

    public Date getSecondTime() {
        return this.secondTime;
    }

    public double getLevelValue() {
        return this.levelValue;
    }

    public String getLevelUnitName() {
        return this.levelUnitName;
    }

    public double getSecondLevelValue() {
        return this.secondLevelValue;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int[] getNavBlock() {
        return this.navBlock;
    }

    public GRIDnav getNavigation() {
        block2: {
            if (this.gridNav != null) break block2;
            try {
                this.gridNav = new GRIDnav(this.getDirectoryBlock());
            }
            catch (McIDASException excp) {
                this.gridNav = null;
            }
        }
        return this.gridNav;
    }

    public int getNavType() {
        return this.navBlock[0];
    }

    public boolean equals(Object o) {
        if (!(o instanceof GridDirectory)) {
            return false;
        }
        GridDirectory that = (GridDirectory)o;
        return this == that || Arrays.equals(this.getDirectoryBlock(), that.getDirectoryBlock());
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Grid Directory:");
        buff.append("\n");
        buff.append("\tParameter = ");
        buff.append(this.paramName + " [" + this.paramUnitName + "] (");
        buff.append(this.gridDescription + ")");
        buff.append("\n");
        buff.append("\trefTime: ");
        buff.append(this.referenceTime.toGMTString());
        buff.append(" valid: " + this.validTime.toGMTString());
        buff.append("\n");
        buff.append("\tsecond Time: ");
        buff.append(this.secondTime != null ? this.secondTime.toGMTString() : "none");
        buff.append("\n");
        buff.append("\tLevel: ");
        buff.append(this.levelValue + " [" + this.levelUnitName + "] second: " + this.secondLevelValue);
        buff.append("\n");
        buff.append("\tNav Type: ");
        buff.append(this.getNavType());
        buff.append(" rows: " + this.rows);
        buff.append(" cols: " + this.columns);
        buff.append("\n");
        return buff.toString();
    }
}

