/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFileException;
import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;

public class AreaDirectoryList {
    private boolean flipwords;
    private DataInputStream inputStream;
    private int status;
    private URLConnection urlc;
    private boolean isADDE;
    private int[] dir;
    private Date[] nominalTimes;
    private int[] bands;
    private int[] lines;
    private int[] elements;
    private ArrayList dirs;
    private int numDirs;

    public AreaDirectoryList(String imageSource) throws AreaFileException {
        block4: {
            this.flipwords = false;
            this.status = 0;
            this.isADDE = false;
            this.numDirs = 0;
            try {
                this.inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(imageSource), 2048));
            }
            catch (IOException eIO) {
                URL url;
                try {
                    url = new URL(imageSource);
                    this.urlc = url.openConnection();
                    InputStream is = this.urlc.getInputStream();
                    this.inputStream = new DataInputStream(new BufferedInputStream(is));
                }
                catch (Exception e) {
                    throw new AreaFileException("Error opening AreaFile: " + e);
                }
                if (!url.getProtocol().equalsIgnoreCase("adde")) break block4;
                this.isADDE = true;
            }
        }
        this.readDirectory();
    }

    public AreaDirectoryList(URL url) throws AreaFileException {
        this.flipwords = false;
        this.status = 0;
        this.isADDE = false;
        this.numDirs = 0;
        try {
            this.inputStream = new DataInputStream(new BufferedInputStream(url.openStream()));
        }
        catch (IOException e) {
            throw new AreaFileException("Error opening URL for AreaFile:" + e);
        }
        this.readDirectory();
    }

    private void readDirectory() throws AreaFileException {
        double resolutionLat = Double.NaN;
        double resolutionLon = Double.NaN;
        double centerLat = Double.NaN;
        double centerLon = Double.NaN;
        int band = 0;
        String calname = " ";
        String caldesc = " ";
        this.dirs = new ArrayList();
        int numBytes = this.isADDE ? ((AddeURLConnection)this.urlc).getInitialRecordSize() : 64;
        while (numBytes > 0) {
            try {
                int areaNumber;
                this.dir = new int[64];
                if (this.isADDE && (areaNumber = this.inputStream.readInt()) == 0) break;
                int i = 0;
                while (i < 64) {
                    this.dir[i] = this.inputStream.readInt();
                    ++i;
                }
                if (!this.isADDE) {
                    this.dir[0] = 0;
                }
                if (this.dir[1] > 255 || this.flipwords) {
                    this.flipwords = true;
                    McIDASUtil.flip(this.dir, 0, 19);
                    if ((this.dir[20] & 0xFFFF) == 0) {
                        McIDASUtil.flip(this.dir, 20, 20);
                    }
                    McIDASUtil.flip(this.dir, 21, 23);
                    McIDASUtil.flip(this.dir, 32, 50);
                    McIDASUtil.flip(this.dir, 53, 55);
                    McIDASUtil.flip(this.dir, 57, 63);
                }
                AreaDirectory ad = new AreaDirectory(this.dir);
                int[] bands = ad.getBands();
                int numBands = ad.getNumberOfBands();
                Vector[] calInfo = new Vector[numBands];
                int k = 0;
                while (k < numBands) {
                    calInfo[k] = new Vector();
                    ++k;
                }
                if (!this.isADDE) {
                    numBytes = 0;
                } else {
                    int numCards = this.dir[63];
                    int i2 = 0;
                    while (i2 < numCards) {
                        int m;
                        byte[] card = new byte[80];
                        int count = 0;
                        boolean prevBlank = true;
                        int j = 0;
                        while (j < 80) {
                            byte b = this.inputStream.readByte();
                            if (b == 32) {
                                if (!prevBlank) {
                                    card[count++] = b;
                                    prevBlank = false;
                                }
                                prevBlank = true;
                            } else {
                                card[count++] = b;
                                prevBlank = false;
                            }
                            ++j;
                        }
                        String cd = new String(card, 0, count);
                        if (cd.indexOf("Center latitude") > -1) {
                            m = cd.indexOf("=");
                            centerLat = m > 0 ? Double.valueOf(cd.substring(m + 1).trim()) : Double.NaN;
                        } else if (cd.indexOf("Center longitude") > -1) {
                            m = cd.indexOf("=");
                            centerLon = m > 0 ? -Double.valueOf(cd.substring(m + 1).trim()).doubleValue() : Double.NaN;
                        } else if (cd.indexOf("Computed Latitude") > -1) {
                            m = cd.indexOf("=");
                            resolutionLat = m > 0 ? Double.valueOf(cd.substring(m + 1).trim()) : Double.NaN;
                        } else if (cd.indexOf("Computed Longitude") > -1) {
                            m = cd.indexOf("=");
                            resolutionLon = m > 0 ? Double.valueOf(cd.substring(m + 1).trim()) : Double.NaN;
                        } else if (cd.indexOf("Valid calibration unit") > -1 && (m = cd.indexOf("=")) > 0) {
                            String cdd = cd.replace('\"', ' ');
                            StringTokenizer st = new StringTokenizer(cdd, " ");
                            int n = st.countTokens();
                            band = 0;
                            calname = " ";
                            caldesc = " ";
                            boolean gotit = false;
                            int k2 = 0;
                            while (k2 < n) {
                                if (st.nextToken().trim().equals("band")) {
                                    gotit = true;
                                    break;
                                }
                                ++k2;
                            }
                            if (gotit) {
                                band = Integer.parseInt(st.nextToken().trim());
                                st.nextToken();
                                caldesc = calname = st.nextToken();
                                if (st.hasMoreTokens()) {
                                    StringBuffer buf = new StringBuffer();
                                    while (st.hasMoreTokens()) {
                                        buf.append(st.nextToken());
                                        buf.append(" ");
                                    }
                                    caldesc = buf.toString().trim();
                                }
                                int k3 = 0;
                                while (k3 < numBands) {
                                    if (band == bands[k3]) {
                                        calInfo[k3].addElement(calname);
                                        calInfo[k3].addElement(caldesc);
                                    }
                                    ++k3;
                                }
                            }
                        }
                        ++i2;
                    }
                    ad.setCenterLatitude(centerLat);
                    ad.setCenterLongitude(centerLon);
                    ad.setCenterLatitudeResolution(resolutionLat);
                    ad.setCenterLongitudeResolution(resolutionLon);
                    ad.setCalInfo(calInfo);
                    numBytes = this.inputStream.readInt();
                }
                this.dirs.add(ad);
            }
            catch (IOException e) {
                this.status = -1;
                throw new AreaFileException("Error reading Area directory:" + e);
            }
            this.status = 1;
            ++this.numDirs;
        }
    }

    public AreaDirectory[][] getSortedDirs() throws AreaFileException {
        int num;
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new AreaFileException("Error reading directory information");
        }
        Date[] dtg = new Date[this.numDirs];
        int[] pos = new int[this.numDirs];
        int[] insitu = new int[this.numDirs];
        ArrayList al = new ArrayList();
        ArrayList alt = null;
        int i = 0;
        while (i < this.numDirs) {
            AreaDirectory ad = (AreaDirectory)this.dirs.get(i);
            dtg[i] = ad.getNominalTime();
            pos[i] = ad.getValue(0);
            insitu[i] = i;
            ++i;
        }
        Date ddd = null;
        int i2 = 0;
        while (i2 < this.numDirs) {
            int swap = i2;
            int k = i2 + 1;
            while (k < this.numDirs) {
                if (dtg[swap].compareTo(dtg[k]) > 0) {
                    swap = k;
                }
                ++k;
            }
            if (swap != i2) {
                Date dtgt = dtg[i2];
                dtg[i2] = dtg[swap];
                dtg[swap] = dtgt;
                int intt = pos[i2];
                pos[i2] = pos[swap];
                pos[swap] = intt;
                intt = insitu[i2];
                insitu[i2] = insitu[swap];
                insitu[swap] = intt;
            }
            if (ddd == null || ddd.compareTo(dtg[i2]) != 0) {
                if (ddd != null) {
                    al.add(alt);
                }
                ddd = dtg[i2];
                alt = new ArrayList();
            }
            alt.add(this.dirs.get(insitu[i2]));
            ++i2;
        }
        if (alt != null && alt.size() > 0) {
            al.add(alt);
        }
        if ((num = al.size()) == 0) {
            return null;
        }
        AreaDirectory[][] ada = new AreaDirectory[num][];
        int i3 = 0;
        while (i3 < num) {
            alt = (ArrayList)al.get(i3);
            int knum = alt.size();
            ada[i3] = new AreaDirectory[knum];
            int k = 0;
            while (k < knum) {
                ada[i3][k] = (AreaDirectory)alt.get(k);
                ++k;
            }
            ++i3;
        }
        return ada;
    }

    public ArrayList getDirs() throws AreaFileException {
        if (this.status <= 0 || this.dirs.size() <= 0) {
            throw new AreaFileException("Error reading directory information");
        }
        return this.dirs;
    }

    public String toString() {
        if (this.status <= 0 || this.numDirs <= 0) {
            return new String("No directory information available");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("    Date         Time    Lin  Ele  Bands \n");
        sb.append("  -------       -------  ---  ---  --------\n");
        int i = 0;
        while (i < this.dirs.size()) {
            sb.append(((AreaDirectory)this.dirs.get(i)).toString());
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Must supply a path or ADDE request to images");
            System.exit(1);
        }
        AreaDirectoryList adl = new AreaDirectoryList(args[0]);
        System.out.println(adl.toString());
        AreaDirectory[][] ada = adl.getSortedDirs();
        int i = 0;
        while (i < ada.length) {
            Date dd = ada[i][0].getNominalTime();
            System.out.print(dd + " ");
            int k = 0;
            while (k < ada[i].length) {
                int[] bands = ada[i][k].getBands();
                int b = 0;
                while (b < bands.length) {
                    System.out.print(" " + bands[b]);
                    ++b;
                }
                ++k;
            }
            System.out.println(" ");
            ++i;
        }
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

