/*
 * Decompiled with CFR 0.152.
 */
package dods.dap;

import dods.dap.BaseType;
import dods.dap.DataReadException;
import dods.dap.PrimitiveVector;
import dods.dap.ServerVersion;
import dods.dap.StatusUI;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class Int16PrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private short[] vals;

    public Int16PrimitiveVector(BaseType var) {
        super(var);
    }

    public Object clone() {
        Int16PrimitiveVector v = (Int16PrimitiveVector)super.clone();
        if (this.vals != null) {
            v.vals = new short[this.vals.length];
            System.arraycopy(this.vals, 0, v.vals, 0, this.vals.length);
        }
        return v;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int len) {
        this.vals = new short[len];
    }

    public final short getValue(int i) {
        return this.vals[i];
    }

    public final void setValue(int i, short newVal) {
        this.vals[i] = newVal;
    }

    public void printVal(PrintWriter os, String space) {
        int len = this.vals.length;
        int i = 0;
        while (i < len - 1) {
            os.print(this.vals[i]);
            os.print(", ");
            ++i;
        }
        if (len > 0) {
            os.print(this.vals[len - 1]);
        }
    }

    public void printSingleVal(PrintWriter os, int index) {
        os.print(this.vals[index]);
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int i = 0;
        while (i < this.vals.length) {
            this.vals[i] = (short)source.readInt();
            if (statusUI != null) {
                statusUI.incrementByteCount(4);
                if (statusUI.userCancelled()) {
                    throw new DataReadException("User cancelled");
                }
            }
            ++i;
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        int i = 0;
        while (i < this.vals.length) {
            sink.writeInt(this.vals[i]);
            ++i;
        }
    }

    public void externalize(DataOutputStream sink, int start, int stop, int stride) throws IOException {
        int i = start;
        while (i <= stop) {
            sink.writeInt(this.vals[i]);
            i += stride;
        }
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public void setInternalStorage(Object o) {
        this.vals = (short[])o;
    }

    public PrimitiveVector subset(int start, int stop, int stride) {
        Int16PrimitiveVector n = new Int16PrimitiveVector(this.getTemplate());
        stride = Math.max(stride, 1);
        stop = Math.max(start, stop);
        int length = 1 + (stop - start) / stride;
        n.setLength(length);
        int count = 0;
        int i = start;
        while (i <= stop) {
            n.setValue(count, this.vals[i]);
            ++count;
            i += stride;
        }
        return n;
    }
}

