/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.unidata.io.RandomAccessFile;

public class Grib2ProductDefinitionSection {
    protected int length;
    protected int section;
    protected int coordinates;
    protected int productDefinition;
    protected int parameterCategory;
    protected int parameterNumber;
    protected int typeGenProcess;
    protected int backGenProcess;
    protected int analysisGenProcess;
    protected int hoursAfter;
    protected int minutesAfter;
    protected int timeRangeUnit;
    protected int forecastTime;
    protected int typeFirstFixedSurface;
    protected float FirstFixedSurfaceValue;
    protected int typeSecondFixedSurface;
    protected float SecondFixedSurfaceValue;

    public Grib2ProductDefinitionSection(RandomAccessFile raf) throws NoValidGribException, NotSupportedException, IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        this.coordinates = GribNumbers.int2(raf);
        this.productDefinition = GribNumbers.int2(raf);
        switch (this.productDefinition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                this.analysisGenProcess = raf.read();
                this.hoursAfter = GribNumbers.int2(raf);
                this.minutesAfter = raf.read();
                this.timeRangeUnit = raf.read();
                this.forecastTime = GribNumbers.int4(raf);
                this.typeFirstFixedSurface = raf.read();
                int scaleFirstFixedSurface = raf.read();
                int valueFirstFixedSurface = GribNumbers.int4(raf);
                this.FirstFixedSurfaceValue = (float)(scaleFirstFixedSurface == 0 || valueFirstFixedSurface == 0 ? (double)valueFirstFixedSurface : Math.pow(valueFirstFixedSurface, -scaleFirstFixedSurface));
                this.typeSecondFixedSurface = raf.read();
                int scaleSecondFixedSurface = raf.read();
                int valueSecondFixedSurface = GribNumbers.int4(raf);
                this.SecondFixedSurfaceValue = (float)(scaleSecondFixedSurface == 0 || valueSecondFixedSurface == 0 ? (double)valueSecondFixedSurface : Math.pow(valueSecondFixedSurface, -scaleSecondFixedSurface));
                if (this.productDefinition == 1) {
                    System.out.println("PDS productDefinition == 1 not done");
                    break;
                }
                if (this.productDefinition == 2) {
                    System.out.println("PDS productDefinition == 2 not done");
                    break;
                }
                if (this.productDefinition == 3) {
                    System.out.println("PDS productDefinition == 3 not done");
                    break;
                }
                if (this.productDefinition == 4) {
                    System.out.println("PDS productDefinition == 4 not done");
                    break;
                }
                if (this.productDefinition == 5) {
                    System.out.println("PDS productDefinition == 5 not done");
                    break;
                }
                if (this.productDefinition == 6) {
                    System.out.println("PDS productDefinition == 6 not done");
                    break;
                }
                if (this.productDefinition == 7) {
                    System.out.println("PDS productDefinition == 7 not done");
                    break;
                }
                if (this.productDefinition != 8) break;
                int year = GribNumbers.int2(raf);
                int month = raf.read() - 1;
                int day = raf.read();
                int hour = raf.read();
                int minute = raf.read();
                int second = raf.read();
                int timeRanges = raf.read();
                int missingDataValues = GribNumbers.int4(raf);
                int outmostTimeRange = raf.read();
                int missing = raf.read();
                int statisticalProcess = raf.read();
                int timeIncrement = GribNumbers.int4(raf);
                int indicatorTR = raf.read();
                int lengthTR = GribNumbers.int4(raf);
                break;
            }
            case 20: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                this.hoursAfter = GribNumbers.int2(raf);
                this.minutesAfter = raf.read();
                this.timeRangeUnit = raf.read();
                this.forecastTime = GribNumbers.int4(raf);
                break;
            }
            case 30: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                this.typeGenProcess = raf.read();
                this.backGenProcess = raf.read();
                break;
            }
            case 254: {
                this.parameterCategory = raf.read();
                this.parameterNumber = raf.read();
                break;
            }
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getSection() {
        return this.section;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    public int getProductDefinition() {
        return this.productDefinition;
    }

    public String getProductDefinitionName() {
        return Grib2ProductDefinitionSection.getProductDefinitionName(this.productDefinition);
    }

    public static String getProductDefinitionName(int productDefinition) {
        switch (productDefinition) {
            case 0: {
                return "Analysis/forecast at horizontal level/layer";
            }
            case 1: {
                return "Individual ensemble forecast, control and perturbed";
            }
            case 2: {
                return "Derived forecast on all ensemble members";
            }
            case 3: {
                return "Derived forecasts on cluster of ensemble members over rectangular area";
            }
            case 4: {
                return "Derived forecasts on cluster of ensemble members over circular area";
            }
            case 5: {
                return "Probability forecasts at a horizontal level";
            }
            case 6: {
                return "Percentile forecasts at a horizontal level";
            }
            case 7: {
                return "Analysis or forecast error at a horizontal level";
            }
            case 8: {
                return "Average, accumulation, extreme values or other statistically processed value at a horizontal level";
            }
            case 20: {
                return "Radar product";
            }
            case 30: {
                return "Satellite product";
            }
            case 254: {
                return "CCITTIA5 character string";
            }
        }
        return "Unknown";
    }

    public int getParameterCategory() {
        return this.parameterCategory;
    }

    public int getParameterNumber() {
        return this.parameterNumber;
    }

    public int getTypeGenProcess() {
        return this.typeGenProcess;
    }

    public int getBackGenProcess() {
        return this.backGenProcess;
    }

    public int getAnalysisGenProcess() {
        return this.analysisGenProcess;
    }

    public int getHoursAfter() {
        return this.hoursAfter;
    }

    public int getMinutesAfter() {
        return this.minutesAfter;
    }

    public int getTimeRangeUnit() {
        return this.timeRangeUnit;
    }

    public String getTimeRangeUnitName() {
        return Grib2ProductDefinitionSection.getTimeRangeUnitName(this.timeRangeUnit);
    }

    public static String getTimeRangeUnitName(int timeRangeUnit) {
        switch (timeRangeUnit) {
            case 0: {
                return "minutes";
            }
            case 1: {
                return "hours";
            }
            case 2: {
                return "days";
            }
            case 3: {
                return "months";
            }
            case 4: {
                return "years";
            }
            case 5: {
                return "decade";
            }
            case 6: {
                return "normal";
            }
            case 7: {
                return "century";
            }
            case 10: {
                return "3hours";
            }
            case 11: {
                return "6hours";
            }
            case 12: {
                return "12hours";
            }
            case 13: {
                return "secs";
            }
        }
        return "unknown";
    }

    public int getForecastTime() {
        return this.forecastTime;
    }

    public static String getTypeSurfaceName(int id) {
        switch (id) {
            case 0: {
                return "Reserved";
            }
            case 1: {
                return "Ground or water surface";
            }
            case 2: {
                return "Cloud base level";
            }
            case 3: {
                return "Level of cloud tops";
            }
            case 4: {
                return "Level of 0o C isotherm";
            }
            case 5: {
                return "Level of adiabatic condensation lifted from the surface";
            }
            case 6: {
                return "Maximum wind level";
            }
            case 7: {
                return "Tropopause";
            }
            case 8: {
                return "Nominal top of the atmosphere";
            }
            case 9: {
                return "Sea bottom";
            }
            case 20: {
                return "Isothermal level";
            }
            case 100: {
                return "Isobaric surface";
            }
            case 101: {
                return "Mean sea level";
            }
            case 102: {
                return "Specific altitude above mean sea level";
            }
            case 103: {
                return "Specified height level above ground";
            }
            case 104: {
                return "Sigma level 'sigma' value";
            }
            case 105: {
                return "Hybrid level";
            }
            case 106: {
                return "Depth below land surface";
            }
            case 107: {
                return "Isentropic (theta) level";
            }
            case 108: {
                return "Level at specified pressure difference from ground to level";
            }
            case 109: {
                return "Potential vorticity surface";
            }
            case 111: {
                return "Eta* level";
            }
            case 117: {
                return "Mixed layer depth";
            }
            case 160: {
                return "Depth below sea level";
            }
            case 255: {
                return "Missing";
            }
        }
        return "Unknown=" + id;
    }

    public static String getTypeSurfaceNameShort(int id) {
        switch (id) {
            case 1: {
                return "surface";
            }
            case 2: {
                return "cloud_base";
            }
            case 3: {
                return "cloud_tops";
            }
            case 4: {
                return "zeroDegC_isotherm";
            }
            case 5: {
                return "adiabatic_condensation_lifted";
            }
            case 6: {
                return "maximum_wind";
            }
            case 7: {
                return "tropopause";
            }
            case 8: {
                return "atmosphere_top";
            }
            case 9: {
                return "sea_bottom";
            }
            case 20: {
                return "isotherm";
            }
            case 100: {
                return "pressure";
            }
            case 101: {
                return "msl";
            }
            case 102: {
                return "altitude_above_msl";
            }
            case 103: {
                return "height_above_ground";
            }
            case 104: {
                return "sigma";
            }
            case 105: {
                return "hybrid";
            }
            case 106: {
                return "depth_below_surface";
            }
            case 107: {
                return "isentrope";
            }
            case 108: {
                return "pressure_difference";
            }
            case 109: {
                return "potential_vorticity_surface";
            }
            case 111: {
                return "eta";
            }
            case 117: {
                return "mixed_layer_depth";
            }
            case 160: {
                return "depth_below_sea";
            }
            case 255: {
                return "";
            }
        }
        return "Unknown" + id;
    }

    public static String getTypeSurfaceUnit(int id) {
        switch (id) {
            case 20: {
                return "K";
            }
            case 100: {
                return "Pa";
            }
            case 102: {
                return "m";
            }
            case 103: {
                return "m";
            }
            case 106: {
                return "m";
            }
            case 107: {
                return "K";
            }
            case 108: {
                return "Pa";
            }
            case 109: {
                return "K m2 kg-1 s-1";
            }
            case 117: {
                return "m";
            }
            case 160: {
                return "m";
            }
        }
        return "";
    }

    public int getTypeFirstFixedSurface() {
        return this.typeFirstFixedSurface;
    }

    public String getTypeFirstFixedSurfaceName() {
        return Grib2ProductDefinitionSection.getTypeSurfaceName(this.typeFirstFixedSurface);
    }

    public float getValueFirstFixedSurface() {
        return this.FirstFixedSurfaceValue;
    }

    public int getTypeSecondFixedSurface() {
        return this.typeSecondFixedSurface;
    }

    public String getTypeSecondFixedSurfaceName() {
        return Grib2ProductDefinitionSection.getTypeSurfaceName(this.typeSecondFixedSurface);
    }

    public float getValueSecondFixedSurface() {
        return this.SecondFixedSurfaceValue;
    }

    public String toString() {
        return "";
    }
}

