/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.util.Date;
import ucar.grib.Index;
import ucar.grib.Parameter;
import ucar.grib.TableLookup;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.grib.grib2.ParameterTable;

public class Grib2Lookup
implements TableLookup {
    private Grib2ProductDefinitionSection firstPDS;
    private Grib2IdentificationSection firstID;
    private Grib2DataRepresentationSection firstDRS;

    public Grib2Lookup(Grib2Record firstRecord) {
        this.firstPDS = firstRecord.getPDS();
        this.firstID = firstRecord.getId();
        this.firstDRS = firstRecord.getDRS();
    }

    public String getGridName(Index.GdsRecord gds) {
        return Grib2GridDefinitionSection.getGridName(gds.grid_type);
    }

    public String getShapeName(Index.GdsRecord gds) {
        return Grib2GridDefinitionSection.getShapeName(gds.grid_shape_code);
    }

    public Parameter getParameter(Index.GribRecord gr) {
        return ParameterTable.getParameter(gr.discipline, gr.category, gr.paramNumber);
    }

    public String getDisciplineName(Index.GribRecord gr) {
        return ParameterTable.getDisciplineName(gr.discipline);
    }

    public String getCategoryName(Index.GribRecord gr) {
        return ParameterTable.getCategoryName(gr.discipline, gr.category);
    }

    public String getProductDefinitionName(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getProductDefinitionName(gr.productType);
    }

    public String getLevelName(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeSurfaceName(gr.levelType1);
    }

    public String getLevelNameShort(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeSurfaceNameShort(gr.levelType1);
    }

    public String getLevelUnit(Index.GribRecord gr) {
        return Grib2ProductDefinitionSection.getTypeSurfaceUnit(gr.levelType1);
    }

    public String getFirstTimeRangeUnitName() {
        return Grib2ProductDefinitionSection.getTimeRangeUnitName(this.firstPDS.timeRangeUnit);
    }

    public String getFirstCenterName() {
        return this.firstID.getCenter_idName();
    }

    public int getFirstSubcenterId() {
        return this.firstID.getSubcenter_id();
    }

    public String getFirstProductStatusName() {
        return this.firstID.getProductStatusName();
    }

    public String getFirstProductTypeName() {
        return this.firstID.getProductTypeName();
    }

    public String getFirstSignificanceOfRTName() {
        return this.firstID.getSignificanceOfRTName();
    }

    public Date getFirstBaseTime() {
        return this.firstID.getBaseTime().getTime();
    }

    public boolean isLatLon(Index.GdsRecord gds) {
        return gds.grid_type < 4;
    }

    public int getProjectionType(Index.GdsRecord gds) {
        switch (gds.grid_type) {
            case 20: {
                return 1;
            }
            case 30: {
                return 2;
            }
        }
        return -1;
    }

    public boolean isVerticalCoordinate(Index.GribRecord gr) {
        String units = this.getLevelUnit(gr);
        if (units == null || units.length() == 0) {
            return false;
        }
        if (gr.levelType1 == 104) {
            return false;
        }
        return gr.levelType1 != 105;
    }

    public boolean isPositiveUp(Index.GribRecord gr) {
        return gr.levelType1 != 20 && gr.levelType1 != 100 && gr.levelType1 != 106 && gr.levelType1 != 160;
    }

    public float getFirstMissingValue() {
        return this.firstDRS.getPrimaryMissingValue();
    }
}

