/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import ucar.grib.GribNumbers;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2DataSection;
import ucar.grib.grib2.Grib2EndSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.Grib2Record;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Input {
    protected RandomAccessFile raf = null;
    protected int count = 0;
    protected String header = "GRIB";
    protected ArrayList records = new ArrayList();
    protected ArrayList products = new ArrayList();
    protected HashMap gdsHM = new HashMap();

    public Grib2Input(RandomAccessFile raf) throws NotSupportedException, NoValidGribException, IOException {
        this.raf = raf;
    }

    public boolean scan(boolean getData, boolean getProductsOnly, boolean oneRecord) throws NotSupportedException, NoValidGribException, IOException {
        long start = System.currentTimeMillis();
        Grib2IndicatorSection is = null;
        Grib2IdentificationSection id = null;
        Grib2GridDefinitionSection gds = null;
        long fileOffset = 0L;
        long gribLength = 0L;
        long GdsOffset = 0L;
        boolean startAtHeader = true;
        boolean processGDS = true;
        while (this.raf.getFilePointer() < this.raf.length()) {
            if (startAtHeader) {
                if (!this.seekHeader(this.raf, this.raf.length())) {
                    return false;
                }
                this.count -= 4;
                fileOffset += (long)this.count;
                is = new Grib2IndicatorSection(this.raf);
                fileOffset += (long)is.getLength();
                gribLength = is.getGribLength();
                gribLength -= (long)is.getLength();
                id = new Grib2IdentificationSection(this.raf);
                fileOffset += (long)id.getLength();
                gribLength -= (long)id.getLength();
            }
            if (processGDS) {
                GdsOffset = fileOffset;
                gds = new Grib2GridDefinitionSection(this.raf, getProductsOnly);
                fileOffset += (long)gds.getLength();
                gribLength -= (long)gds.getLength();
            }
            long PdsOffset = fileOffset;
            Grib2ProductDefinitionSection pds = new Grib2ProductDefinitionSection(this.raf);
            fileOffset += (long)pds.getLength();
            gribLength -= (long)pds.getLength();
            Grib2DataRepresentationSection drs = null;
            Grib2BitMapSection bms = null;
            Grib2DataSection ds = null;
            drs = new Grib2DataRepresentationSection(this.raf);
            fileOffset += (long)drs.getLength();
            gribLength -= (long)drs.getLength();
            bms = new Grib2BitMapSection(this.raf);
            fileOffset += (long)bms.getLength();
            gribLength -= (long)bms.getLength();
            ds = new Grib2DataSection(getData, this.raf, gds, drs);
            fileOffset += (long)ds.getLength();
            gribLength -= (long)ds.getLength();
            if (getProductsOnly) {
                Grib2Product gp = new Grib2Product(this.header, is, id, this.getGDSkey(gds), pds, GdsOffset, PdsOffset);
                this.products.add(gp);
            } else {
                Grib2Record gr = new Grib2Record(this.header, is, id, gds, pds, drs, bms, GdsOffset, PdsOffset);
                this.records.add(gr);
            }
            if (oneRecord) {
                return true;
            }
            int ending = GribNumbers.int4(this.raf);
            if (ending == 0x37373737) {
                fileOffset += 4L;
                startAtHeader = true;
                processGDS = true;
                continue;
            }
            int section = this.raf.read();
            this.raf.seek(this.raf.getFilePointer() - 5L);
            if (section == 3) {
                startAtHeader = false;
                processGDS = true;
                continue;
            }
            if (section == 4) {
                startAtHeader = false;
                processGDS = false;
                continue;
            }
            Grib2EndSection es = new Grib2EndSection(this.raf);
            if (es.getEndFound()) {
                fileOffset += (long)es.getLength();
                startAtHeader = true;
                processGDS = true;
                continue;
            }
            System.err.println("Grib2Input: possible file corruption");
            return false;
        }
        return true;
    }

    public int getEdition() throws IOException, NoValidGribException, NotSupportedException {
        long length;
        boolean check = false;
        long l = length = this.raf.length() < 4000L ? this.raf.length() : 4000L;
        if (!this.seekHeader(this.raf, length)) {
            return 0;
        }
        Grib2IndicatorSection is = new Grib2IndicatorSection(this.raf);
        return is.getGribEdition();
    }

    private boolean seekHeader(RandomAccessFile raf, long stop) throws IOException, EOFException {
        this.count = 0;
        StringBuffer hdr = new StringBuffer();
        int match = 0;
        while (raf.getFilePointer() < stop) {
            byte c = raf.readByte();
            if (c < 0) {
                return false;
            }
            ++this.count;
            hdr.append((char)c);
            if (c == 71) {
                match = 1;
                continue;
            }
            if (c == 82 && match == 1) {
                match = 2;
                continue;
            }
            if (c == 73 && match == 2) {
                match = 3;
                continue;
            }
            if (c == 66 && match == 3) {
                match = 4;
                if (hdr.length() > 25) {
                    char chr = hdr.charAt(hdr.length() - 25);
                    this.header = chr == '\n' || chr == '\r' ? hdr.substring(hdr.length() - 24, hdr.length() - 5) : hdr.substring(hdr.length() - 25, hdr.length() - 6);
                }
                return true;
            }
            match = 0;
        }
        return false;
    }

    private String getGDSkey(Grib2GridDefinitionSection gds) {
        String key = gds.getCheckSum();
        if (!this.gdsHM.containsKey(key)) {
            this.gdsHM.put(key, gds);
        }
        return key;
    }

    public ArrayList getProducts() {
        return this.products;
    }

    public ArrayList getRecords() {
        return this.records;
    }

    public HashMap getGDSs() {
        return this.gdsHM;
    }

    public String toString() {
        return "GRIB file ( info)";
    }
}

