/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TimeZone;
import ucar.grib.Index;
import ucar.grib.NoValidGribException;
import ucar.grib.NotSupportedException;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.grib.grib2.Grib2IdentificationSection;
import ucar.grib.grib2.Grib2IndicatorSection;
import ucar.grib.grib2.Grib2Input;
import ucar.grib.grib2.Grib2Product;
import ucar.grib.grib2.Grib2ProductDefinitionSection;
import ucar.grib.grib2.ParameterTable;
import ucar.unidata.io.RandomAccessFile;

public class Grib2Indexer {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public Index writeFileIndex(RandomAccessFile inputRaf, PrintStream ps, boolean makeIndex) throws IOException {
        Date now = Calendar.getInstance().getTime();
        long start = System.currentTimeMillis();
        int count = 0;
        Index index = makeIndex ? new Index() : null;
        try {
            inputRaf.seek(0L);
            Grib2Input g2i = new Grib2Input(inputRaf);
            g2i.scan(false, true, false);
            ps.println("index_version = " + Index.current_index_version);
            ps.println("grid_edition = 2");
            ps.println("location = " + inputRaf.getLocation());
            ps.println("created = " + dateFormat.format(now));
            ps.println("version = 1.0");
            if (makeIndex) {
                index.addGlobalAttribute("location", inputRaf.getLocation());
                index.addGlobalAttribute("created", dateFormat.format(now));
                index.addGlobalAttribute("version", "1.0");
            }
            ArrayList products = g2i.getProducts();
            for (int i = 0; i < products.size(); ++i) {
                Grib2Product product = (Grib2Product)products.get(i);
                Grib2ProductDefinitionSection pds = product.getPDS();
                Grib2IdentificationSection id = product.getID();
                if (i == 0) {
                    ps.println("center = " + id.getCenter_id());
                    ps.println("sub_center = " + id.getSubcenter_id());
                    ps.println("table_version = " + id.getLocal_table_version());
                    ps.println("--------------------------------------------------------------------");
                }
                ps.println(pds.getProductDefinition() + " " + product.getDiscipline() + " " + pds.getParameterCategory() + " " + pds.getParameterNumber() + " " + pds.getTypeFirstFixedSurface() + " " + pds.getValueFirstFixedSurface() + " " + pds.getTypeSecondFixedSurface() + " " + pds.getValueSecondFixedSurface() + " " + product.getReferenceTime() + " " + pds.getForecastTime() + " " + product.getGDSkey() + " " + product.getGdsOffset() + " " + product.getPdsOffset());
                if (makeIndex) {
                    index.addGribRecord(this.makeGribRecord(product));
                }
                ++count;
            }
            HashMap gdsHM = g2i.getGDSs();
            Iterator it = gdsHM.keySet().iterator();
            while (it.hasNext()) {
                ps.println("--------------------------------------------------------------------");
                String key = (String)it.next();
                ps.println("GDSkey = " + key);
                Grib2GridDefinitionSection gds = (Grib2GridDefinitionSection)gdsHM.get(key);
                Grib2Indexer.printGDS(gds, ps);
                if (!makeIndex) continue;
                index.addHorizCoordSys(this.makeGdsRecord(gds));
            }
        }
        catch (NoValidGribException noGrib) {
            System.err.println("NoValidGribException : " + noGrib);
        }
        catch (NotSupportedException noSupport) {
            System.err.println("NotSupportedException : " + noSupport);
        }
        ps.close();
        System.out.println(" " + count + " products took " + (System.currentTimeMillis() - start) + " msec");
        return index;
    }

    private Index.GribRecord makeGribRecord(Grib2Product product) {
        Index.GribRecord gr = new Index.GribRecord();
        Grib2ProductDefinitionSection pds = product.getPDS();
        gr.productType = pds.getProductDefinition();
        gr.discipline = product.getDiscipline();
        gr.category = pds.getParameterCategory();
        gr.paramNumber = pds.getParameterNumber();
        gr.levelType1 = pds.getTypeFirstFixedSurface();
        gr.levelValue1 = pds.getValueFirstFixedSurface();
        gr.levelType2 = pds.getTypeSecondFixedSurface();
        gr.levelValue2 = pds.getValueSecondFixedSurface();
        gr.refTime = product.getReferenceTime().toString();
        gr.forecastTime = pds.getForecastTime();
        gr.gdsKey = product.getGDSkey().trim();
        gr.offset1 = product.getGdsOffset();
        gr.offset2 = product.getPdsOffset();
        return gr;
    }

    private Index.GdsRecord makeGdsRecord(Grib2GridDefinitionSection gds) {
        Index.GdsRecord igds = new Index.GdsRecord();
        igds.gdsKey = gds.getCheckSum();
        igds.grid_shape_code = gds.getShape();
        igds.grid_type = gds.getGdtn();
        if (gds.getShape() == 1) {
            igds.radius_spherical_earth = gds.getEarthRadius();
        } else if (gds.getShape() == 3) {
            igds.major_axis_earth = gds.getMajorAxis();
            igds.minor_axis_earth = gds.getMinorAxis();
        }
        igds.nx = gds.getNx();
        igds.ny = gds.getNy();
        igds.La1 = gds.getLa1();
        igds.Lo1 = gds.getLo1();
        igds.resolution = gds.getResolution();
        igds.LaD = gds.getLad();
        igds.LoV = gds.getLov();
        igds.dx = gds.getDx();
        igds.dy = gds.getDy();
        igds.latin1 = gds.getLatin1();
        igds.latin2 = gds.getLatin2();
        return igds;
    }

    public static void printGDS(Grib2GridDefinitionSection gds, PrintStream ps) {
        ps.println("grid_type = " + gds.getGdtn());
        ps.println("grid_name = " + gds.getName());
        switch (gds.getGdtn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                ps.println("                     Grid Shape = " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ScanningMode = " + gds.getScanMode());
                if (gds.getGdtn() == 1) {
                    ps.println("SpLat = " + gds.getSpLat());
                    ps.println("SpLon = " + gds.getSpLon());
                    ps.println("                Rotation angle  = " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 2) {
                    ps.println("pLat = " + gds.getPoleLat());
                    ps.println("pLon = " + gds.getPoleLon());
                    ps.println("             Stretching factor  = " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 3) break;
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                ps.println("                Rotation angle  = " + gds.getRotationangle());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("             Stretching factor  = " + gds.getFactor());
                break;
            }
            case 10: {
                ps.println("                     Grid Shape = " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("                   Basic angle  = " + gds.getAngle());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                break;
            }
            case 20: {
                ps.println("grid_shape_code = " + gds.getShape());
                ps.println("grid_shape = " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("LaD = " + gds.getLad());
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            case 30: {
                ps.println("grid_shape_code = " + gds.getShape());
                ps.println("grid_shape = " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("LaD = " + gds.getLad());
                ps.println("LoV = " + gds.getLov());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("Latin1 = " + gds.getLatin1());
                ps.println("Latin2 = " + gds.getLatin2());
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                ps.println("                     Grid Shape: " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("La2 = " + gds.getLa2());
                ps.println("Lo2 = " + gds.getLo2());
                ps.println("Dx = " + gds.getDx());
                ps.println("             Stretching factor = " + gds.getFactor());
                ps.println("           Number of parallels = " + gds.getN());
                ps.println("ScanningMode = " + gds.getScanMode());
                if (gds.getGdtn() == 41) {
                    ps.println("SpLat = " + gds.getSpLat());
                    ps.println("SpLon = " + gds.getSpLon());
                    ps.println("                Rotation angle = " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 42) {
                    ps.println("pLat = " + gds.getPoleLat());
                    ps.println("pLon = " + gds.getPoleLon());
                    ps.println("             Stretching factor = " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 43) break;
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                ps.println("                Rotation angle = " + gds.getRotationangle());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("             Stretching factor = " + gds.getFactor());
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                ps.println("     J - pentagonal resolution = " + gds.getJ());
                ps.println("     K - pentagonal resolution = " + gds.getK());
                ps.println("     M - pentagonal resolution = " + gds.getM());
                ps.println("Method used to define the norm = " + gds.getMethod());
                ps.println("     Mode indicating the order = " + gds.getMode());
                if (gds.getGdtn() == 51) {
                    ps.println("SpLat = " + gds.getSpLat());
                    ps.println("SpLon = " + gds.getSpLon());
                    ps.println("                Rotation angle = " + gds.getRotationangle());
                    break;
                }
                if (gds.getGdtn() == 52) {
                    ps.println("pLat = " + gds.getPoleLat());
                    ps.println("pLon = " + gds.getPoleLon());
                    ps.println("             Stretching factor = " + gds.getFactor());
                    break;
                }
                if (gds.getGdtn() != 53) break;
                ps.println("SpLat = " + gds.getSpLat());
                ps.println("SpLon = " + gds.getSpLon());
                ps.println("                Rotation angle = " + gds.getRotationangle());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("             Stretching factor = " + gds.getFactor());
                break;
            }
            case 90: {
                ps.println("                     Grid Shape = " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Number of points along parallel = " + gds.getNx());
                ps.println("Number of points along meridian = " + gds.getNy());
                ps.println("Latitude of sub-satellite point = " + gds.getLap());
                ps.println("  Longitude of sub-satellite pt = " + gds.getLop());
                ps.println("  Resolution & Component flags = " + gds.getResolution());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println(" X-coordinate of sub-satellite = " + gds.getXp());
                ps.println(" Y-coordinate of sub-satellite = " + gds.getYp());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("                   Basic angle = " + gds.getAngle());
                ps.println("        Altitude of the camera = " + gds.getAltitude());
                ps.println("        X-coordinate of origin = " + gds.getXo());
                ps.println("        Y-coordinate of origin = " + gds.getYo());
                break;
            }
            case 100: {
                ps.println("   Exponent of 2 for intervals = " + gds.getN2());
                ps.println("   Exponent of 3 for intervals = " + gds.getN3());
                ps.println("           Number of intervals = " + gds.getNi());
                ps.println("            Number of diamonds = " + gds.getNd());
                ps.println("pLat = " + gds.getPoleLat());
                ps.println("pLon = " + gds.getPoleLon());
                ps.println("           Grid point position = " + gds.getPosition());
                ps.println("      Number order of diamonds = " + gds.getOrder());
                ps.println("ScanningMode = " + gds.getScanMode());
                ps.println("           Number of parallels = " + gds.getN());
                break;
            }
            case 110: {
                ps.println("                     Grid Shape = " + gds.getShape() + " " + gds.getShapeName());
                if (gds.getShape() == 1) {
                    ps.println("radius_spherical_earth = " + gds.getEarthRadius());
                } else if (gds.getShape() == 3) {
                    ps.println("major_axis_earth = " + gds.getMajorAxis());
                    ps.println("minor_axis_earth = " + gds.getMinorAxis());
                }
                ps.println("Nx = " + gds.getNx());
                ps.println("Ny = " + gds.getNy());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("ResCompFlag = " + gds.getResolution());
                ps.println("Dx = " + gds.getDx());
                ps.println("Dy = " + gds.getDy());
                ps.println("ProjFlag = " + gds.getProjectionCenter());
                ps.println("ScanningMode = " + gds.getScanMode());
                break;
            }
            case 120: {
                ps.println("           Number of data bins = " + gds.getNb());
                ps.println("             Number of radials = " + gds.getNr());
                ps.println("Number of points along parallel = " + gds.getNx());
                ps.println("La1 = " + gds.getLa1());
                ps.println("Lo1 = " + gds.getLo1());
                ps.println("Dx = " + gds.getDx());
                ps.println("            Offset from origin = " + gds.getDstart());
                ps.println("need code to get azi and adelta");
                break;
            }
            default: {
                ps.println("Unknown Grid Type");
            }
        }
    }

    public static void printPDS(Grib2IndicatorSection is, Grib2ProductDefinitionSection pds, PrintStream ps) {
        ps.println("ParameterCategory = \"" + pds.getParameterCategory() + " " + ParameterTable.getCategoryName(is.getDiscipline(), pds.getParameterCategory()) + "\";");
        ps.println("ParameterName = \"" + pds.getParameterNumber() + " " + ParameterTable.getParameterName(is.getDiscipline(), pds.getParameterCategory(), pds.getParameterNumber()) + "\";");
        ps.println("ParameterUnits = \"" + ParameterTable.getParameterUnit(is.getDiscipline(), pds.getParameterCategory(), pds.getParameterNumber()) + "\";");
        ps.println("valtime_offset = " + pds.getForecastTime());
    }

    public static void usage(String className) {
        System.out.println();
        System.out.println("Usage of " + className + ":");
        System.out.println("Parameters:");
        System.out.println("<GribFileToRead> reads/scans for index");
        System.out.println("<IndexFile.idx> where to write index, default STDOUT");
        System.out.println();
        System.out.println("java " + className + " <GribFileToRead> <IndexFile>");
        System.exit(0);
    }

    public static void main(String[] args) throws IOException {
        Grib2Indexer indexer = new Grib2Indexer();
        if (args.length < 1) {
            Class<?> cl = indexer.getClass();
            Grib2Indexer.usage(cl.getName());
            System.exit(0);
        }
        RandomAccessFile raf = null;
        PrintStream ps = System.out;
        String infile = args[0];
        raf = new RandomAccessFile(infile, "r");
        raf.order(0);
        if (args.length == 2) {
            String outfile = args[1].endsWith(".gbx") ? args[1] : args[1].concat(".gbx");
            ps = new PrintStream(new FilterOutputStream(new FileOutputStream(outfile, false)));
        } else if (args.length == 1) {
            ps = System.out;
        }
        indexer.writeFileIndex(raf, ps, false);
    }

    static {
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

